/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components.fields;

import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.JBUI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.TextUI;
import org.jetbrains.annotations.NotNull;

public class ExtendableTextField
extends JBTextField {
    public static final String VARIANT = "extendable";
    private List<Extension> extensions = Collections.emptyList();

    public ExtendableTextField() {
        this(null);
    }

    public ExtendableTextField(int columns) {
        this(null, columns);
    }

    public ExtendableTextField(String text) {
        this(text, 20);
    }

    public ExtendableTextField(String text, int columns) {
        super(text, columns);
    }

    public List<Extension> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(Extension ... extensions) {
        this.setExtensions(Arrays.asList(extensions));
    }

    public void setExtensions(Collection<Extension> extensions) {
        this.setExtensions((List<Extension>)new ArrayList<Extension>(extensions));
    }

    private void setExtensions(List<Extension> extensions) {
        this.putClientProperty("JTextField.variant", null);
        this.extensions = Collections.unmodifiableList(extensions);
        this.putClientProperty("JTextField.variant", VARIANT);
    }

    public void addExtension(@NotNull Extension extension) {
        ArrayList<Extension> extensions;
        if (extension == null) {
            ExtendableTextField.$$$reportNull$$$0(0);
        }
        if ((extensions = new ArrayList<Extension>(this.getExtensions())).add(extension)) {
            this.setExtensions((List<Extension>)extensions);
        }
    }

    public void removeExtension(@NotNull Extension extension) {
        ArrayList<Extension> extensions;
        if (extension == null) {
            ExtendableTextField.$$$reportNull$$$0(1);
        }
        if ((extensions = new ArrayList<Extension>(this.getExtensions())).remove(extension)) {
            this.setExtensions((List<Extension>)extensions);
        }
    }

    @Override
    @Deprecated
    public void setUI(TextUI ui) {
        TextUI suggested = ui;
        try {
            if (ui == null || !Class.forName("com.intellij.ide.ui.laf.darcula.ui.TextFieldWithPopupHandlerUI").isAssignableFrom(ui.getClass())) {
                ui = (TextUI)Class.forName("com.intellij.ide.ui.laf.darcula.ui.DarculaTextFieldUI").getDeclaredMethod("createUI", JComponent.class).invoke(null, this);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.setUI(ui);
        if (ui != suggested) {
            try {
                this.setBorder((Border)Class.forName("com.intellij.ide.ui.laf.darcula.ui.DarculaTextBorder").newInstance());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "extension";
        objectArray2[1] = "com/intellij/ui/components/fields/ExtendableTextField";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addExtension";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "removeExtension";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface Extension {
        public Icon getIcon(boolean var1);

        default public int getIconGap() {
            return JBUI.scale((int)5);
        }

        default public int getPreferredSpace() {
            Icon icon1 = this.getIcon(true);
            Icon icon2 = this.getIcon(false);
            if (icon1 == null && icon2 == null) {
                return 0;
            }
            if (icon1 == null) {
                return this.getIconGap() + icon2.getIconWidth();
            }
            if (icon2 == null) {
                return this.getIconGap() + icon1.getIconWidth();
            }
            return this.getIconGap() + Math.max(icon1.getIconWidth(), icon2.getIconWidth());
        }

        default public boolean isIconBeforeText() {
            return false;
        }

        default public Runnable getActionOnClick() {
            return null;
        }

        default public String getTooltip() {
            return null;
        }
    }
}

