/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.application.ApplicationManager;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PopupHandler
extends MouseAdapter {
    public abstract void invokePopup(Component var1, int var2, int var3);

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.invokePopup(e.getComponent(), e.getX(), e.getY());
            e.consume();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.invokePopup(e.getComponent(), e.getX(), e.getY());
            e.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.invokePopup(e.getComponent(), e.getX(), e.getY());
            e.consume();
        }
    }

    public static void installPopupHandler(JComponent component, @NonNls String groupId, String place) {
        ActionManager actionManager = ActionManager.getInstance();
        ActionGroup group = (ActionGroup)actionManager.getAction(groupId);
        PopupHandler.installPopupHandler(component, group, place, actionManager);
    }

    @NotNull
    public static MouseListener installPopupHandler(JComponent component, @NotNull ActionGroup group, String place, ActionManager actionManager) {
        if (group == null) {
            PopupHandler.$$$reportNull$$$0(0);
        }
        MouseListener mouseListener = PopupHandler.installPopupHandler(component, group, place, actionManager, null);
        if (mouseListener == null) {
            PopupHandler.$$$reportNull$$$0(1);
        }
        return mouseListener;
    }

    @NotNull
    public static MouseListener installPopupHandler(final @NotNull JComponent component, final @NotNull ActionGroup group, final String place, final @NotNull ActionManager actionManager, final @Nullable PopupMenuListener menuListener) {
        if (component == null) {
            PopupHandler.$$$reportNull$$$0(2);
        }
        if (group == null) {
            PopupHandler.$$$reportNull$$$0(3);
        }
        if (actionManager == null) {
            PopupHandler.$$$reportNull$$$0(4);
        }
        if (ApplicationManager.getApplication() == null) {
            MouseAdapter mouseAdapter = new MouseAdapter(){};
            if (mouseAdapter == null) {
                PopupHandler.$$$reportNull$$$0(5);
            }
            return mouseAdapter;
        }
        PopupHandler popupHandler = new PopupHandler(){

            @Override
            public void invokePopup(Component comp, int x, int y) {
                ActionPopupMenu popupMenu = actionManager.createActionPopupMenu(place, group);
                popupMenu.setTargetComponent(component);
                JPopupMenu menu = popupMenu.getComponent();
                if (menuListener != null) {
                    menu.addPopupMenuListener(menuListener);
                }
                menu.show(comp, x, y);
            }
        };
        component.addMouseListener(popupHandler);
        PopupHandler popupHandler2 = popupHandler;
        if (popupHandler2 == null) {
            PopupHandler.$$$reportNull$$$0(6);
        }
        return popupHandler2;
    }

    @NotNull
    public static MouseListener installFollowingSelectionTreePopup(@NotNull JTree tree, @NotNull ActionGroup group, String place, @NotNull ActionManager actionManager) {
        if (tree == null) {
            PopupHandler.$$$reportNull$$$0(7);
        }
        if (group == null) {
            PopupHandler.$$$reportNull$$$0(8);
        }
        if (actionManager == null) {
            PopupHandler.$$$reportNull$$$0(9);
        }
        MouseListener mouseListener = PopupHandler.installConditionalPopup(tree, group, place, actionManager, (comp, x, y) -> {
            if (tree == null) {
                PopupHandler.$$$reportNull$$$0(22);
            }
            return tree.getPathForLocation(x, y) != null && Arrays.binarySearch(Objects.requireNonNull(tree.getSelectionRows()), tree.getRowForLocation(x, y)) > -1;
        });
        if (mouseListener == null) {
            PopupHandler.$$$reportNull$$$0(10);
        }
        return mouseListener;
    }

    @NotNull
    public static MouseListener installRowSelectionTablePopup(@NotNull JTable table, @NotNull ActionGroup group, String place, @NotNull ActionManager actionManager) {
        if (table == null) {
            PopupHandler.$$$reportNull$$$0(11);
        }
        if (group == null) {
            PopupHandler.$$$reportNull$$$0(12);
        }
        if (actionManager == null) {
            PopupHandler.$$$reportNull$$$0(13);
        }
        MouseListener mouseListener = PopupHandler.installConditionalPopup(table, group, place, actionManager, (comp, x, y) -> {
            if (table == null) {
                PopupHandler.$$$reportNull$$$0(21);
            }
            return Arrays.binarySearch(table.getSelectedRows(), table.rowAtPoint(new Point(x, y))) > -1;
        });
        if (mouseListener == null) {
            PopupHandler.$$$reportNull$$$0(14);
        }
        return mouseListener;
    }

    @NotNull
    private static MouseListener installConditionalPopup(@NotNull JComponent component, final @NotNull ActionGroup group, final String place, final @NotNull ActionManager actionManager, final @NotNull ShowPopupPredicate condition) {
        if (component == null) {
            PopupHandler.$$$reportNull$$$0(15);
        }
        if (group == null) {
            PopupHandler.$$$reportNull$$$0(16);
        }
        if (actionManager == null) {
            PopupHandler.$$$reportNull$$$0(17);
        }
        if (condition == null) {
            PopupHandler.$$$reportNull$$$0(18);
        }
        if (ApplicationManager.getApplication() == null) {
            MouseAdapter mouseAdapter = new MouseAdapter(){};
            if (mouseAdapter == null) {
                PopupHandler.$$$reportNull$$$0(19);
            }
            return mouseAdapter;
        }
        PopupHandler handler = new PopupHandler(){

            @Override
            public void invokePopup(Component comp, int x, int y) {
                if (condition.shouldShowPopup(comp, x, y)) {
                    ActionPopupMenu popupMenu = actionManager.createActionPopupMenu(place, group);
                    popupMenu.getComponent().show(comp, x, y);
                }
            }
        };
        component.addMouseListener(handler);
        PopupHandler popupHandler = handler;
        if (popupHandler == null) {
            PopupHandler.$$$reportNull$$$0(20);
        }
        return popupHandler;
    }

    public static MouseListener installUnknownPopupHandler(JComponent component, ActionGroup group, ActionManager actionManager) {
        return PopupHandler.installPopupHandler(component, group, "unknown", actionManager);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 10: 
            case 14: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 10: 
            case 14: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 10: 
            case 14: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/PopupHandler";
                break;
            }
            case 2: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: 
            case 9: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionManager";
                break;
            }
            case 7: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 11: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/PopupHandler";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "installPopupHandler";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "installFollowingSelectionTreePopup";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "installRowSelectionTablePopup";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "installConditionalPopup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "installPopupHandler";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 10: 
            case 14: 
            case 19: 
            case 20: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "installFollowingSelectionTreePopup";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "installRowSelectionTablePopup";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "installConditionalPopup";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$installRowSelectionTablePopup$1";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$installFollowingSelectionTreePopup$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 10: 
            case 14: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    private static interface ShowPopupPredicate {
        public boolean shouldShowPopup(Component var1, int var2, int var3);
    }
}

