/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope.packageSet;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class PatternBasedPackageSet
extends PackageSetBase {
    protected final Pattern myModulePattern;
    protected final Pattern myModuleGroupPattern;
    protected final String myModulePatternText;

    public PatternBasedPackageSet(@NonNls String modulePatternText) {
        this.myModulePatternText = modulePatternText;
        Pattern moduleGroupPattern = null;
        Pattern modulePattern = null;
        if (modulePatternText == null || modulePatternText.isEmpty()) {
            modulePattern = null;
        } else if (modulePatternText.startsWith("group:")) {
            int index = modulePatternText.indexOf(58, 6);
            if (index == -1) {
                index = modulePatternText.length();
            }
            moduleGroupPattern = PatternBasedPackageSet.convertToPattern(modulePatternText.substring(6, index));
            if (index < modulePatternText.length() - 1) {
                modulePattern = PatternBasedPackageSet.convertToPattern(modulePatternText.substring(index + 1));
            }
        } else {
            modulePattern = PatternBasedPackageSet.convertToPattern(modulePatternText);
        }
        this.myModulePattern = modulePattern;
        this.myModuleGroupPattern = moduleGroupPattern;
    }

    protected boolean matchesModule(VirtualFile file, ProjectFileIndex fileIndex) {
        Module module = fileIndex.getModuleForFile(file);
        if (module != null) {
            String[] groupPath;
            if (this.myModulePattern != null && this.myModulePattern.matcher(module.getName()).matches()) {
                return true;
            }
            if (this.myModuleGroupPattern != null && (groupPath = ModuleManager.getInstance(module.getProject()).getModuleGroupPath(module)) != null) {
                for (String node : groupPath) {
                    if (!this.myModuleGroupPattern.matcher(node).matches()) continue;
                    return true;
                }
            }
        }
        return this.myModulePattern == null && this.myModuleGroupPattern == null;
    }

    public abstract String getPattern();

    public abstract boolean isOn(String var1);

    @NotNull
    public abstract PatternBasedPackageSet updatePattern(@NotNull String var1, @NotNull String var2);

    @NotNull
    public abstract PatternBasedPackageSet updateModulePattern(@NotNull String var1, @NotNull String var2);

    public String getModulePattern() {
        return this.myModulePatternText;
    }

    @NotNull
    private static Pattern convertToPattern(String text) {
        StringBuilder builder = new StringBuilder(text.length());
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == ' ' || Character.isLetter(c) || Character.isDigit(c) || c == '_') {
                builder.append(c);
                continue;
            }
            if (c == '*') {
                builder.append(".*");
                continue;
            }
            builder.append('\\').append(c);
        }
        Pattern pattern = Pattern.compile(builder.toString());
        if (pattern == null) {
            PatternBasedPackageSet.$$$reportNull$$$0(0);
        }
        return pattern;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/scope/packageSet/PatternBasedPackageSet", "convertToPattern"));
    }
}

