/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Weighted;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.ui.ClickListener;
import com.intellij.ui.UIBundle;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThreeComponentsSplitter
extends JPanel
implements Disposable {
    private int myDividerWidth;
    private boolean myVerticalSplit;
    private boolean myHonorMinimumSize = false;
    private final Divider myFirstDivider;
    private final Divider myLastDivider;
    @Nullable
    private JComponent myFirstComponent;
    @Nullable
    private JComponent myInnerComponent;
    @Nullable
    private JComponent myLastComponent;
    private int myFirstSize = 0;
    private int myLastSize = 0;
    private int myMinSize = 0;
    private boolean myShowDividerControls;
    private int myDividerZone;

    public ThreeComponentsSplitter() {
        this(false);
    }

    public ThreeComponentsSplitter(boolean vertical) {
        this(vertical, false);
    }

    public ThreeComponentsSplitter(boolean vertical, boolean onePixelDividers) {
        this.myVerticalSplit = vertical;
        this.myShowDividerControls = false;
        this.myFirstDivider = new Divider(true, onePixelDividers);
        Disposer.register((Disposable)this, (Disposable)this.myFirstDivider);
        this.myLastDivider = new Divider(false, onePixelDividers);
        Disposer.register((Disposable)this, (Disposable)this.myLastDivider);
        int n = this.myDividerWidth = onePixelDividers ? 1 : 7;
        if (onePixelDividers) {
            Color bg = UIUtil.CONTRAST_BORDER_COLOR;
            this.myFirstDivider.setBackground(bg);
            this.myLastDivider.setBackground(bg);
        }
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new MyFocusTraversalPolicy());
        this.setOpaque(false);
        this.add(this.myFirstDivider);
        this.add(this.myLastDivider);
    }

    public void setShowDividerControls(boolean showDividerControls) {
        this.myShowDividerControls = showDividerControls;
        this.setOrientation(this.myVerticalSplit);
    }

    public void setDividerMouseZoneSize(int size) {
        this.myDividerZone = JBUI.scale((int)size);
    }

    public boolean isHonorMinimumSize() {
        return this.myHonorMinimumSize;
    }

    public void setHonorComponentsMinimumSize(boolean honorMinimumSize) {
        this.myHonorMinimumSize = honorMinimumSize;
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && (this.firstVisible() || this.innerVisible() || this.lastVisible());
    }

    private boolean lastVisible() {
        return !Splitter.isNull((Component)this.myLastComponent) && this.myLastComponent.isVisible();
    }

    private boolean innerVisible() {
        return !Splitter.isNull((Component)this.myInnerComponent) && this.myInnerComponent.isVisible();
    }

    private boolean firstVisible() {
        return !Splitter.isNull((Component)this.myFirstComponent) && this.myFirstComponent.isVisible();
    }

    private int visibleDividersCount() {
        int count = 0;
        if (this.firstDividerVisible()) {
            ++count;
        }
        if (this.lastDividerVisible()) {
            ++count;
        }
        return count;
    }

    private boolean firstDividerVisible() {
        return this.firstVisible() && this.innerVisible() || this.firstVisible() && this.lastVisible() && !this.innerVisible();
    }

    private boolean lastDividerVisible() {
        return this.innerVisible() && this.lastVisible();
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.isHonorMinimumSize()) {
            JBDimension innerSize;
            int dividerWidth = this.getDividerWidth();
            JBDimension firstSize = this.myFirstComponent != null ? this.myFirstComponent.getMinimumSize() : JBUI.emptySize();
            JBDimension lastSize = this.myLastComponent != null ? this.myLastComponent.getMinimumSize() : JBUI.emptySize();
            Object object = innerSize = this.myInnerComponent != null ? this.myInnerComponent.getMinimumSize() : JBUI.emptySize();
            if (this.getOrientation()) {
                int width = Math.max(firstSize.width, Math.max(lastSize.width, innerSize.width));
                int height = this.visibleDividersCount() * dividerWidth;
                height += firstSize.height;
                height += lastSize.height;
                return new Dimension(width, height += innerSize.height);
            }
            int heigth = Math.max(firstSize.height, Math.max(lastSize.height, innerSize.height));
            int width = this.visibleDividersCount() * dividerWidth;
            width += firstSize.width;
            width += lastSize.width;
            return new Dimension(width += innerSize.width, heigth);
        }
        return super.getMinimumSize();
    }

    @Override
    public void doLayout() {
        int space;
        int innerComponentSize;
        int lastComponentSize;
        int firstCompontSize;
        int width = this.getWidth();
        int height = this.getHeight();
        Rectangle firstRect = new Rectangle();
        Rectangle firstDividerRect = new Rectangle();
        Rectangle lastDividerRect = new Rectangle();
        Rectangle lastRect = new Rectangle();
        Rectangle innerRect = new Rectangle();
        int componentSize = this.getOrientation() ? height : width;
        int dividerWidth = this.getDividerWidth();
        int dividersCount = this.visibleDividersCount();
        if (componentSize <= dividersCount * dividerWidth) {
            firstCompontSize = 0;
            lastComponentSize = 0;
            innerComponentSize = 0;
            dividerWidth = componentSize;
        } else {
            firstCompontSize = this.getFirstSize();
            int sizeLack = firstCompontSize + (lastComponentSize = this.getLastSize()) - (componentSize - dividersCount * dividerWidth - this.myMinSize);
            if (sizeLack > 0) {
                double firstSizeRatio = (double)firstCompontSize / (double)(firstCompontSize + lastComponentSize);
                if (firstCompontSize > 0) {
                    firstCompontSize = (int)((double)firstCompontSize - (double)sizeLack * firstSizeRatio);
                    firstCompontSize = Math.max(this.myMinSize, firstCompontSize);
                }
                if (lastComponentSize > 0) {
                    lastComponentSize = (int)((double)lastComponentSize - (double)sizeLack * (1.0 - firstSizeRatio));
                    lastComponentSize = Math.max(this.myMinSize, lastComponentSize);
                }
                innerComponentSize = this.getMinSize(this.myInnerComponent);
            } else {
                innerComponentSize = Math.max(this.getMinSize(this.myInnerComponent), componentSize - dividersCount * dividerWidth - this.getFirstSize() - this.getLastSize());
            }
            if (!this.innerVisible()) {
                lastComponentSize += innerComponentSize;
                innerComponentSize = 0;
                if (!this.lastVisible()) {
                    firstCompontSize = componentSize;
                }
            }
        }
        if (this.getOrientation()) {
            space = firstCompontSize;
            firstRect.setBounds(0, 0, width, firstCompontSize);
            if (this.firstDividerVisible()) {
                firstDividerRect.setBounds(0, space, width, dividerWidth);
                space += dividerWidth;
            }
            innerRect.setBounds(0, space, width, innerComponentSize);
            space += innerComponentSize;
            if (this.lastDividerVisible()) {
                lastDividerRect.setBounds(0, space, width, dividerWidth);
                space += dividerWidth;
            }
            lastRect.setBounds(0, space, width, lastComponentSize);
        } else {
            space = firstCompontSize;
            firstRect.setBounds(0, 0, firstCompontSize, height);
            if (this.firstDividerVisible()) {
                firstDividerRect.setBounds(space, 0, dividerWidth, height);
                space += dividerWidth;
            }
            innerRect.setBounds(space, 0, innerComponentSize, height);
            space += innerComponentSize;
            if (this.lastDividerVisible()) {
                lastDividerRect.setBounds(space, 0, dividerWidth, height);
                space += dividerWidth;
            }
            lastRect.setBounds(space, 0, lastComponentSize, height);
        }
        this.myFirstDivider.setVisible(this.firstDividerVisible());
        this.myFirstDivider.setBounds(firstDividerRect);
        this.myFirstDivider.doLayout();
        this.myLastDivider.setVisible(this.lastDividerVisible());
        this.myLastDivider.setBounds(lastDividerRect);
        this.myLastDivider.doLayout();
        ThreeComponentsSplitter.validateIfNeeded(this.myFirstComponent, firstRect);
        ThreeComponentsSplitter.validateIfNeeded(this.myInnerComponent, innerRect);
        ThreeComponentsSplitter.validateIfNeeded(this.myLastComponent, lastRect);
    }

    private static void validateIfNeeded(JComponent c, Rectangle rect) {
        if (!Splitter.isNull((Component)c)) {
            if (!c.getBounds().equals(rect)) {
                c.setBounds(rect);
                c.revalidate();
            }
        } else {
            Splitter.hideNull((Component)c);
        }
    }

    public int getDividerWidth() {
        return this.myDividerWidth;
    }

    public void setDividerWidth(int width) {
        if (width < 0) {
            throw new IllegalArgumentException("Wrong divider width: " + width);
        }
        if (this.myDividerWidth != width) {
            this.myDividerWidth = width;
            this.doLayout();
            this.repaint();
        }
    }

    public boolean getOrientation() {
        return this.myVerticalSplit;
    }

    public void setOrientation(boolean verticalSplit) {
        this.myVerticalSplit = verticalSplit;
        this.myFirstDivider.setOrientation(verticalSplit);
        this.myLastDivider.setOrientation(verticalSplit);
        this.doLayout();
        this.repaint();
    }

    @Nullable
    public JComponent getFirstComponent() {
        return this.myFirstComponent;
    }

    public void setFirstComponent(@Nullable JComponent component) {
        if (this.myFirstComponent != component) {
            if (this.myFirstComponent != null) {
                this.remove(this.myFirstComponent);
            }
            this.myFirstComponent = component;
            if (this.myFirstComponent != null) {
                this.add(this.myFirstComponent);
                this.myFirstComponent.invalidate();
            }
        }
    }

    @Nullable
    public JComponent getLastComponent() {
        return this.myLastComponent;
    }

    public void setLastComponent(@Nullable JComponent component) {
        if (this.myLastComponent != component) {
            if (this.myLastComponent != null) {
                this.remove(this.myLastComponent);
            }
            this.myLastComponent = component;
            if (this.myLastComponent != null) {
                this.add(this.myLastComponent);
                this.myLastComponent.invalidate();
            }
        }
    }

    @Nullable
    public JComponent getInnerComponent() {
        return this.myInnerComponent;
    }

    public void setInnerComponent(@Nullable JComponent component) {
        if (this.myInnerComponent != component) {
            if (this.myInnerComponent != null) {
                this.remove(this.myInnerComponent);
            }
            this.myInnerComponent = component;
            if (this.myInnerComponent != null) {
                this.add(this.myInnerComponent);
                this.myInnerComponent.invalidate();
            }
        }
    }

    public void setMinSize(int minSize) {
        this.myMinSize = Math.max(0, minSize);
        this.doLayout();
        this.repaint();
    }

    public void setFirstSize(int size) {
        this.myFirstSize = Math.max(this.getMinSize(true), size);
        this.doLayout();
        this.repaint();
    }

    public void setLastSize(int size) {
        this.myLastSize = Math.max(this.getMinSize(false), size);
        this.doLayout();
        this.repaint();
    }

    public int getFirstSize() {
        return this.firstVisible() ? this.myFirstSize : 0;
    }

    public int getLastSize() {
        return this.lastVisible() ? this.myLastSize : 0;
    }

    public int getMinSize(boolean first) {
        return this.getMinSize(first ? this.myFirstComponent : this.myLastComponent);
    }

    public int getMaxSize(boolean first) {
        int size = this.getOrientation() ? this.getHeight() : this.getWidth();
        return size - (first ? this.myLastSize : this.myFirstSize) - this.myMinSize;
    }

    private int getMinSize(JComponent component) {
        if (this.isHonorMinimumSize() && component != null && this.myFirstComponent != null && this.myFirstComponent.isVisible() && this.myLastComponent != null && this.myLastComponent.isVisible()) {
            if (this.getOrientation()) {
                return component.getMinimumSize().height;
            }
            return component.getMinimumSize().width;
        }
        return this.myMinSize;
    }

    public void dispose() {
        this.myLastComponent = null;
        this.myFirstComponent = null;
        this.myInnerComponent = null;
        this.removeAll();
        Container container = this.getParent();
        if (container != null) {
            container.remove(this);
        }
    }

    private class Divider
    extends JPanel
    implements Disposable {
        private final boolean myIsOnePixel;
        protected boolean myDragging;
        protected Point myPoint;
        private final boolean myIsFirst;
        private IdeGlassPane myGlassPane;
        private final MouseAdapter myListener;
        private boolean myWasPressedOnMe;

        private MouseEvent getTargetEvent(MouseEvent e) {
            return SwingUtilities.convertMouseEvent(e.getComponent(), e, this);
        }

        public Divider(boolean isFirst, boolean isOnePixel) {
            super(new GridBagLayout());
            this.myListener = new MyMouseAdapter();
            this.myIsOnePixel = isOnePixel;
            this.setFocusable(false);
            this.enableEvents(48L);
            this.myIsFirst = isFirst;
            this.setOrientation(ThreeComponentsSplitter.this.myVerticalSplit);
            new UiNotifyConnector.Once(this, new Activatable.Adapter(){

                @Override
                public void showNotify() {
                    Divider.this.init();
                }
            });
        }

        private boolean isInside(Point p) {
            int dndOff;
            if (!this.isVisible()) {
                return false;
            }
            Window window = UIUtil.getWindow((Component)this);
            if (window != null) {
                List<Component> components;
                Point point = SwingUtilities.convertPoint(this, p, window);
                Component component = UIUtil.getDeepestComponentAt((Component)window, (int)point.x, (int)point.y);
                if (UIUtil.findParentByCondition((Component)component, arg_0 -> Divider.lambda$isInside$0(components = Arrays.asList(ThreeComponentsSplitter.this.myFirstComponent, ThreeComponentsSplitter.this.myFirstDivider, ThreeComponentsSplitter.this.myInnerComponent, ThreeComponentsSplitter.this.myLastDivider, ThreeComponentsSplitter.this.myLastComponent), arg_0)) == null) {
                    return false;
                }
            }
            int n = dndOff = this.myIsOnePixel ? JBUI.scale((int)Registry.intValue((String)"ide.splitter.mouseZone")) / 2 : 0;
            if (ThreeComponentsSplitter.this.myVerticalSplit) {
                if (p.x >= 0 && p.x < this.getWidth()) {
                    if (this.getHeight() > 0) {
                        return p.y >= -dndOff && p.y < this.getHeight() + dndOff;
                    }
                    return p.y >= -ThreeComponentsSplitter.this.myDividerZone / 2 && p.y <= ThreeComponentsSplitter.this.myDividerZone / 2;
                }
            } else if (p.y >= 0 && p.y < this.getHeight()) {
                if (this.getWidth() > 0) {
                    return p.x >= -dndOff && p.x < this.getWidth() + dndOff;
                }
                return p.x >= -ThreeComponentsSplitter.this.myDividerZone / 2 && p.x <= ThreeComponentsSplitter.this.myDividerZone / 2;
            }
            return false;
        }

        private void init() {
            this.myGlassPane = IdeGlassPaneUtil.find(this);
            this.myGlassPane.addMouseMotionPreprocessor(this.myListener, this);
            this.myGlassPane.addMousePreprocessor(this.myListener, this);
        }

        public void dispose() {
        }

        private void setOrientation(boolean isVerticalSplit) {
            this.removeAll();
            if (!ThreeComponentsSplitter.this.myShowDividerControls) {
                return;
            }
            int xMask = isVerticalSplit ? 1 : 0;
            int yMask = isVerticalSplit ? 0 : 1;
            Icon glueIcon = isVerticalSplit ? AllIcons.General.SplitGlueV : AllIcons.General.SplitCenterH;
            int glueFill = isVerticalSplit ? 3 : 2;
            this.add((Component)new JLabel(glueIcon), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, isVerticalSplit ? 13 : 11, glueFill, new Insets(0, 0, 0, 0), 0, 0));
            JLabel splitDownlabel = new JLabel(isVerticalSplit ? AllIcons.General.SplitDown : AllIcons.General.SplitRight);
            splitDownlabel.setCursor(Cursor.getPredefinedCursor(12));
            splitDownlabel.setToolTipText(isVerticalSplit ? UIBundle.message((String)"splitter.down.tooltip.text", (Object[])new Object[0]) : UIBundle.message((String)"splitter.right.tooltip.text", (Object[])new Object[0]));
            new ClickListener(){

                public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (ThreeComponentsSplitter.this.myInnerComponent != null) {
                        int income;
                        int n = income = ThreeComponentsSplitter.this.myVerticalSplit ? ThreeComponentsSplitter.this.myInnerComponent.getHeight() : ThreeComponentsSplitter.this.myInnerComponent.getWidth();
                        if (Divider.this.myIsFirst) {
                            ThreeComponentsSplitter.this.setFirstSize(ThreeComponentsSplitter.this.myFirstSize + income);
                        } else {
                            ThreeComponentsSplitter.this.setLastSize(ThreeComponentsSplitter.this.myLastSize + income);
                        }
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/ui/ThreeComponentsSplitter$Divider$2", "onClick"));
                }
            }.installOn((Component)splitDownlabel);
            this.add((Component)splitDownlabel, new GridBagConstraints(isVerticalSplit ? 1 : 0, isVerticalSplit ? 0 : 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)new JLabel(glueIcon), new GridBagConstraints(2 * xMask, 2 * yMask, 1, 1, 0.0, 0.0, 10, glueFill, new Insets(0, 0, 0, 0), 0, 0));
            JLabel splitCenterlabel = new JLabel(isVerticalSplit ? AllIcons.General.SplitCenterV : AllIcons.General.SplitCenterH);
            splitCenterlabel.setCursor(Cursor.getPredefinedCursor(12));
            splitCenterlabel.setToolTipText(UIBundle.message((String)"splitter.center.tooltip.text", (Object[])new Object[0]));
            new ClickListener(){

                public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                    if (e == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    Divider.this.center();
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/ui/ThreeComponentsSplitter$Divider$3", "onClick"));
                }
            }.installOn((Component)splitCenterlabel);
            this.add((Component)splitCenterlabel, new GridBagConstraints(3 * xMask, 3 * yMask, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)new JLabel(glueIcon), new GridBagConstraints(4 * xMask, 4 * yMask, 1, 1, 0.0, 0.0, 10, glueFill, new Insets(0, 0, 0, 0), 0, 0));
            JLabel splitUpLabel = new JLabel(isVerticalSplit ? AllIcons.General.SplitUp : AllIcons.General.SplitLeft);
            splitUpLabel.setCursor(Cursor.getPredefinedCursor(12));
            splitUpLabel.setToolTipText(isVerticalSplit ? UIBundle.message((String)"splitter.up.tooltip.text", (Object[])new Object[0]) : UIBundle.message((String)"splitter.left.tooltip.text", (Object[])new Object[0]));
            new ClickListener(){

                public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                    if (e == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    if (ThreeComponentsSplitter.this.myInnerComponent != null) {
                        int income;
                        int n = income = ThreeComponentsSplitter.this.myVerticalSplit ? ThreeComponentsSplitter.this.myInnerComponent.getHeight() : ThreeComponentsSplitter.this.myInnerComponent.getWidth();
                        if (Divider.this.myIsFirst) {
                            ThreeComponentsSplitter.this.setFirstSize(ThreeComponentsSplitter.this.myFirstSize + income);
                        } else {
                            ThreeComponentsSplitter.this.setLastSize(ThreeComponentsSplitter.this.myLastSize + income);
                        }
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/ui/ThreeComponentsSplitter$Divider$4", "onClick"));
                }
            }.installOn((Component)splitUpLabel);
            this.add((Component)splitUpLabel, new GridBagConstraints(isVerticalSplit ? 5 : 0, isVerticalSplit ? 0 : 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)new JLabel(glueIcon), new GridBagConstraints(6 * xMask, 6 * yMask, 1, 1, 0.0, 0.0, isVerticalSplit ? 17 : 15, glueFill, new Insets(0, 0, 0, 0), 0, 0));
        }

        private void center() {
            if (ThreeComponentsSplitter.this.myInnerComponent != null) {
                int total = ThreeComponentsSplitter.this.myFirstSize + (ThreeComponentsSplitter.this.myVerticalSplit ? ThreeComponentsSplitter.this.myInnerComponent.getHeight() : ThreeComponentsSplitter.this.myInnerComponent.getWidth());
                if (this.myIsFirst) {
                    ThreeComponentsSplitter.this.setFirstSize(total / 2);
                } else {
                    ThreeComponentsSplitter.this.setLastSize(total / 2);
                }
            }
        }

        @Override
        protected void processMouseMotionEvent(MouseEvent e) {
            super.processMouseMotionEvent(e);
            if (!this.isShowing()) {
                return;
            }
            if (506 == e.getID() && this.myWasPressedOnMe) {
                int size;
                this.myDragging = true;
                this.setCursor(this.getResizeCursor());
                if (this.myGlassPane != null) {
                    this.myGlassPane.setCursor(this.getResizeCursor(), this.myListener);
                }
                this.myPoint = SwingUtilities.convertPoint(this, e.getPoint(), ThreeComponentsSplitter.this);
                int n = size = ThreeComponentsSplitter.this.getOrientation() ? ThreeComponentsSplitter.this.getHeight() : ThreeComponentsSplitter.this.getWidth();
                if (ThreeComponentsSplitter.this.getOrientation()) {
                    if (size > 0 || ThreeComponentsSplitter.this.myDividerZone > 0) {
                        if (this.myIsFirst) {
                            ThreeComponentsSplitter.this.setFirstSize(Math.min(size - ThreeComponentsSplitter.this.myLastSize - ThreeComponentsSplitter.this.getMinSize(ThreeComponentsSplitter.this.myInnerComponent) - ThreeComponentsSplitter.this.getDividerWidth() * ThreeComponentsSplitter.this.visibleDividersCount(), Math.max(ThreeComponentsSplitter.this.getMinSize(ThreeComponentsSplitter.this.myFirstComponent), this.myPoint.y)));
                        } else {
                            ThreeComponentsSplitter.this.setLastSize(Math.min(size - ThreeComponentsSplitter.this.myFirstSize - ThreeComponentsSplitter.this.getMinSize(ThreeComponentsSplitter.this.myInnerComponent) - ThreeComponentsSplitter.this.getDividerWidth() * ThreeComponentsSplitter.this.visibleDividersCount(), Math.max(ThreeComponentsSplitter.this.getMinSize(ThreeComponentsSplitter.this.myLastComponent), size - this.myPoint.y - ThreeComponentsSplitter.this.getDividerWidth())));
                        }
                    }
                } else if (size > 0 || ThreeComponentsSplitter.this.myDividerZone > 0) {
                    if (this.myIsFirst) {
                        ThreeComponentsSplitter.this.setFirstSize(Math.min(size - ThreeComponentsSplitter.this.myLastSize - ThreeComponentsSplitter.this.getMinSize(ThreeComponentsSplitter.this.myInnerComponent) - ThreeComponentsSplitter.this.getDividerWidth() * ThreeComponentsSplitter.this.visibleDividersCount(), Math.max(ThreeComponentsSplitter.this.getMinSize(ThreeComponentsSplitter.this.myFirstComponent), this.myPoint.x)));
                    } else {
                        ThreeComponentsSplitter.this.setLastSize(Math.min(size - ThreeComponentsSplitter.this.myFirstSize - ThreeComponentsSplitter.this.getMinSize(ThreeComponentsSplitter.this.myInnerComponent) - ThreeComponentsSplitter.this.getDividerWidth() * ThreeComponentsSplitter.this.visibleDividersCount(), Math.max(ThreeComponentsSplitter.this.getMinSize(ThreeComponentsSplitter.this.myLastComponent), size - this.myPoint.x - ThreeComponentsSplitter.this.getDividerWidth())));
                    }
                }
                ThreeComponentsSplitter.this.doLayout();
            } else if (503 == e.getID() && this.myGlassPane != null) {
                if (this.isInside(e.getPoint())) {
                    this.myGlassPane.setCursor(this.getResizeCursor(), this.myListener);
                    e.consume();
                } else {
                    this.myGlassPane.setCursor(null, this.myListener);
                }
            }
            if (this.myWasPressedOnMe) {
                e.consume();
            }
        }

        @Override
        protected void processMouseEvent(MouseEvent e) {
            super.processMouseEvent(e);
            if (!this.isShowing()) {
                return;
            }
            switch (e.getID()) {
                case 504: {
                    this.setCursor(this.getResizeCursor());
                    break;
                }
                case 505: {
                    if (this.myDragging) break;
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    break;
                }
                case 501: {
                    if (this.isInside(e.getPoint())) {
                        this.myWasPressedOnMe = true;
                        if (this.myGlassPane != null) {
                            this.myGlassPane.setCursor(this.getResizeCursor(), this.myListener);
                        }
                        e.consume();
                        break;
                    }
                    this.myWasPressedOnMe = false;
                    break;
                }
                case 502: {
                    if (this.myWasPressedOnMe) {
                        e.consume();
                    }
                    if (this.isInside(e.getPoint()) && this.myGlassPane != null) {
                        this.myGlassPane.setCursor(this.getResizeCursor(), this.myListener);
                    }
                    this.myWasPressedOnMe = false;
                    this.myDragging = false;
                    this.myPoint = null;
                    break;
                }
                case 500: {
                    if (e.getClickCount() != 2) break;
                    this.center();
                }
            }
        }

        private Cursor getResizeCursor() {
            return ThreeComponentsSplitter.this.getOrientation() ? Cursor.getPredefinedCursor(this.myIsFirst ? 9 : 8) : Cursor.getPredefinedCursor(this.myIsFirst ? 10 : 11);
        }

        private static /* synthetic */ boolean lambda$isInside$0(List components, Component c) {
            return c != null && components.contains(c);
        }

        private class MyMouseAdapter
        extends MouseAdapter
        implements Weighted {
            private MyMouseAdapter() {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this._processMouseEvent(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this._processMouseEvent(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                this._processMouseMotionEvent(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                this._processMouseMotionEvent(e);
            }

            @Override
            public double getWeight() {
                return 1.0;
            }

            private void _processMouseMotionEvent(MouseEvent e) {
                MouseEvent event = Divider.this.getTargetEvent(e);
                if (event == null) {
                    Divider.this.myGlassPane.setCursor(null, Divider.this.myListener);
                    return;
                }
                Divider.this.processMouseMotionEvent(event);
                if (event.isConsumed()) {
                    e.consume();
                }
            }

            private void _processMouseEvent(MouseEvent e) {
                MouseEvent event = Divider.this.getTargetEvent(e);
                if (event == null) {
                    Divider.this.myGlassPane.setCursor(null, Divider.this.myListener);
                    return;
                }
                Divider.this.processMouseEvent(event);
                if (event.isConsumed()) {
                    e.consume();
                }
            }
        }
    }

    private class MyFocusTraversalPolicy
    extends FocusTraversalPolicy {
        private MyFocusTraversalPolicy() {
        }

        @Override
        public Component getComponentAfter(Container aContainer, Component aComponent) {
            if (aComponent == ThreeComponentsSplitter.this.myFirstComponent) {
                return this.findChildToFocus(ThreeComponentsSplitter.this.myInnerComponent);
            }
            if (aComponent == ThreeComponentsSplitter.this.myInnerComponent) {
                return this.findChildToFocus(ThreeComponentsSplitter.this.myLastComponent);
            }
            return this.findChildToFocus(ThreeComponentsSplitter.this.myFirstComponent);
        }

        @Override
        public Component getComponentBefore(Container aContainer, Component aComponent) {
            if (aComponent == ThreeComponentsSplitter.this.myInnerComponent) {
                return this.findChildToFocus(ThreeComponentsSplitter.this.myFirstComponent);
            }
            if (aComponent == ThreeComponentsSplitter.this.myLastComponent) {
                return this.findChildToFocus(ThreeComponentsSplitter.this.myInnerComponent);
            }
            return this.findChildToFocus(ThreeComponentsSplitter.this.myFirstComponent);
        }

        @Override
        public Component getFirstComponent(Container aContainer) {
            return this.findChildToFocus(ThreeComponentsSplitter.this.myFirstComponent);
        }

        @Override
        public Component getLastComponent(Container aContainer) {
            return this.findChildToFocus(ThreeComponentsSplitter.this.myLastComponent);
        }

        @Override
        public Component getDefaultComponent(Container aContainer) {
            return this.findChildToFocus(ThreeComponentsSplitter.this.myInnerComponent);
        }

        Component findChildToFocus(Component component) {
            Component mostRecentFocusOwner;
            Window ancestor = SwingUtilities.getWindowAncestor(ThreeComponentsSplitter.this);
            if (ancestor != null && (mostRecentFocusOwner = ancestor.getMostRecentFocusOwner()) != null && mostRecentFocusOwner.isShowing()) {
                return mostRecentFocusOwner;
            }
            if (component instanceof JPanel) {
                JPanel container = (JPanel)component;
                FocusTraversalPolicy policy = container.getFocusTraversalPolicy();
                if (policy == null) {
                    return container;
                }
                Component defaultComponent = policy.getDefaultComponent(container);
                if (defaultComponent == null) {
                    return container;
                }
                return policy.getDefaultComponent(container);
            }
            return component;
        }
    }
}

