/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.CommonBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.DialogWrapperPeer;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.ui.TestDialog;
import com.intellij.openapi.ui.TestInputDialog;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.InsertPathAction;
import com.intellij.ui.MessageException;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.mac.MacMessages;
import com.intellij.ui.mac.foundation.MacUtil;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import com.intellij.util.PairFunction;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.ui.UI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Messages {
    public static final int OK = 0;
    public static final int YES = 0;
    public static final int NO = 1;
    public static final int CANCEL = 2;
    public static final String OK_BUTTON = CommonBundle.getOkButtonText();
    public static final String YES_BUTTON = CommonBundle.getYesButtonText();
    public static final String NO_BUTTON = CommonBundle.getNoButtonText();
    public static final String CANCEL_BUTTON = CommonBundle.getCancelButtonText();
    private static TestDialog ourTestImplementation = TestDialog.DEFAULT;
    private static TestInputDialog ourTestInputImplementation = TestInputDialog.DEFAULT;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.ui.Messages");

    public static TestDialog setTestDialog(TestDialog newValue) {
        Application application = ApplicationManager.getApplication();
        if (application != null) {
            LOG.assertTrue(application.isUnitTestMode(), (Object)"This method is available for tests only");
        }
        TestDialog oldValue = ourTestImplementation;
        ourTestImplementation = newValue;
        return oldValue;
    }

    public static TestInputDialog setTestInputDialog(TestInputDialog newValue) {
        Application application = ApplicationManager.getApplication();
        if (application != null) {
            LOG.assertTrue(application.isUnitTestMode(), (Object)"This method is available for tests only");
        }
        TestInputDialog oldValue = ourTestInputImplementation;
        ourTestInputImplementation = newValue;
        return oldValue;
    }

    @NotNull
    public static Icon getErrorIcon() {
        Icon icon = UIUtil.getErrorIcon();
        if (icon == null) {
            Messages.$$$reportNull$$$0(0);
        }
        return icon;
    }

    @NotNull
    public static Icon getInformationIcon() {
        Icon icon = UIUtil.getInformationIcon();
        if (icon == null) {
            Messages.$$$reportNull$$$0(1);
        }
        return icon;
    }

    @NotNull
    public static Icon getWarningIcon() {
        Icon icon = UIUtil.getWarningIcon();
        if (icon == null) {
            Messages.$$$reportNull$$$0(2);
        }
        return icon;
    }

    @NotNull
    public static Icon getQuestionIcon() {
        Icon icon = UIUtil.getQuestionIcon();
        if (icon == null) {
            Messages.$$$reportNull$$$0(3);
        }
        return icon;
    }

    @NotNull
    public static Runnable createMessageDialogRemover(@Nullable Project project) {
        Window projectWindow = project == null ? null : WindowManager.getInstance().suggestParentWindow(project);
        Runnable runnable = () -> UIUtil.invokeLaterIfNeeded(() -> Messages.makeCurrentMessageDialogGoAway(projectWindow != null ? projectWindow.getOwnedWindows() : Window.getWindows()));
        if (runnable == null) {
            Messages.$$$reportNull$$$0(4);
        }
        return runnable;
    }

    private static void makeCurrentMessageDialogGoAway(@NotNull Window[] checkWindows) {
        if (checkWindows == null) {
            Messages.$$$reportNull$$$0(5);
        }
        for (Window w : checkWindows) {
            JButton cancelButton;
            JDialog dialog;
            JDialog jDialog = dialog = w instanceof JDialog ? (JDialog)w : null;
            if (dialog == null || !dialog.isModal() || (cancelButton = (JButton)UIUtil.uiTraverser((Component)dialog.getRootPane()).filter(JButton.class).filter(b -> CommonBundle.getCancelButtonText().equals(b.getText())).first()) == null) continue;
            cancelButton.doClick();
        }
    }

    public static int showDialog(@Nullable Project project, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String[] options, int defaultOptionIndex, @Nullable Icon icon) {
        if (options == null) {
            Messages.$$$reportNull$$$0(6);
        }
        return Messages.showDialog(project, message, title, options, defaultOptionIndex, icon, null);
    }

    public static int showDialog(@Nullable Project project, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String[] options, int defaultOptionIndex, @Nullable Icon icon, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        if (title == null) {
            Messages.$$$reportNull$$$0(7);
        }
        if (options == null) {
            Messages.$$$reportNull$$$0(8);
        }
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return ourTestImplementation.show(message);
        }
        try {
            WindowManager windowManager;
            if (Messages.canShowMacSheetPanel() && (windowManager = WindowManager.getInstance()) != null) {
                Window parentWindow = windowManager.suggestParentWindow(project);
                return MacMessages.getInstance().showMessageDialog(title, message, options, false, parentWindow, defaultOptionIndex, defaultOptionIndex, doNotAskOption);
            }
        }
        catch (MessageException windowManager) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        return Messages.showIdeaMessageDialog(project, message, title, options, defaultOptionIndex, icon, doNotAskOption);
    }

    public static int showIdeaMessageDialog(@Nullable Project project, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String[] options, int defaultOptionIndex, @Nullable Icon icon, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        if (options == null) {
            Messages.$$$reportNull$$$0(9);
        }
        MessageDialog dialog = new MessageDialog(project, message, title, options, defaultOptionIndex, -1, icon, doNotAskOption, false);
        dialog.show();
        return dialog.getExitCode();
    }

    public static boolean canShowMacSheetPanel() {
        return SystemInfo.isMac && !Messages.isApplicationInUnitTestOrHeadless() && Registry.is((String)"ide.mac.message.dialogs.as.sheets");
    }

    public static boolean isMacSheetEmulation() {
        return SystemInfo.isMac && Registry.is((String)"ide.mac.message.dialogs.as.sheets") && Registry.is((String)"ide.mac.message.sheets.java.emulation");
    }

    public static int showDialog(Project project, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable String moreInfo, @NotNull String[] options, int defaultOptionIndex, int focusedOptionIndex, Icon icon) {
        if (title == null) {
            Messages.$$$reportNull$$$0(10);
        }
        if (options == null) {
            Messages.$$$reportNull$$$0(11);
        }
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return ourTestImplementation.show(message);
        }
        try {
            if (Messages.canShowMacSheetPanel() && moreInfo == null) {
                return MacMessages.getInstance().showMessageDialog(title, message, options, false, WindowManager.getInstance().suggestParentWindow(project), defaultOptionIndex, focusedOptionIndex, null);
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        MoreInfoMessageDialog dialog = new MoreInfoMessageDialog(project, message, title, moreInfo, options, defaultOptionIndex, focusedOptionIndex, icon);
        dialog.show();
        return dialog.getExitCode();
    }

    static boolean isApplicationInUnitTestOrHeadless() {
        Application application = ApplicationManager.getApplication();
        return application != null && (application.isUnitTestMode() || application.isHeadlessEnvironment());
    }

    public static int showDialog(@NotNull Component parent, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String[] options, int defaultOptionIndex, @Nullable Icon icon) {
        if (parent == null) {
            Messages.$$$reportNull$$$0(12);
        }
        if (title == null) {
            Messages.$$$reportNull$$$0(13);
        }
        if (options == null) {
            Messages.$$$reportNull$$$0(14);
        }
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return ourTestImplementation.show(message);
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                return MacMessages.getInstance().showMessageDialog(title, message, options, false, SwingUtilities.getWindowAncestor(parent), defaultOptionIndex, defaultOptionIndex, null);
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        MessageDialog dialog = new MessageDialog(parent, message, title, options, defaultOptionIndex, defaultOptionIndex, icon, false);
        dialog.show();
        return dialog.getExitCode();
    }

    public static int showDialog(String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String[] options, int defaultOptionIndex, int focusedOptionIndex, @Nullable Icon icon, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        if (title == null) {
            Messages.$$$reportNull$$$0(15);
        }
        if (options == null) {
            Messages.$$$reportNull$$$0(16);
        }
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return ourTestImplementation.show(message);
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                return MacMessages.getInstance().showMessageDialog(title, message, options, false, null, defaultOptionIndex, focusedOptionIndex, doNotAskOption);
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        MessageDialog dialog = new MessageDialog(message, title, options, defaultOptionIndex, focusedOptionIndex, icon, doNotAskOption);
        dialog.show();
        return dialog.getExitCode();
    }

    public static int showDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String[] options, int defaultOptionIndex, @Nullable Icon icon, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        if (options == null) {
            Messages.$$$reportNull$$$0(17);
        }
        return Messages.showDialog(message, title, options, defaultOptionIndex, defaultOptionIndex, icon, doNotAskOption);
    }

    public static int showDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String[] options, int defaultOptionIndex, @Nullable Icon icon) {
        if (options == null) {
            Messages.$$$reportNull$$$0(18);
        }
        return Messages.showDialog(message, title, options, defaultOptionIndex, icon, null);
    }

    public static void showMessageDialog(@Nullable Project project, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon) {
        if (title == null) {
            Messages.$$$reportNull$$$0(19);
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                MacMessages.getInstance().showOkMessageDialog(title, message, OK_BUTTON, WindowManager.getInstance().suggestParentWindow(project));
                return;
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        Messages.showDialog(project, message, title, new String[]{OK_BUTTON}, 0, icon);
    }

    public static void showMessageDialog(@NotNull Component parent, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon) {
        if (parent == null) {
            Messages.$$$reportNull$$$0(20);
        }
        if (title == null) {
            Messages.$$$reportNull$$$0(21);
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                MacMessages.getInstance().showOkMessageDialog(title, message, OK_BUTTON, SwingUtilities.getWindowAncestor(parent));
                return;
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        Messages.showDialog(parent, message, title, new String[]{OK_BUTTON}, 0, icon);
    }

    public static void showMessageDialog(String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon) {
        if (title == null) {
            Messages.$$$reportNull$$$0(22);
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                MacMessages.getInstance().showOkMessageDialog(title, message, OK_BUTTON);
                return;
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        Messages.showDialog(message, title, new String[]{OK_BUTTON}, 0, icon);
    }

    @YesNoResult
    public static int showYesNoDialog(@Nullable Project project, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String yesText, @NotNull String noText, @Nullable Icon icon) {
        if (title == null) {
            Messages.$$$reportNull$$$0(23);
        }
        if (yesText == null) {
            Messages.$$$reportNull$$$0(24);
        }
        if (noText == null) {
            Messages.$$$reportNull$$$0(25);
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                return MacMessages.getInstance().showYesNoDialog(title, message, yesText, noText, WindowManager.getInstance().suggestParentWindow(project));
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        int result2 = Messages.showDialog(project, message, title, new String[]{yesText, noText}, 0, icon) == 0 ? 0 : 1;
        LOG.assertTrue(result2 == 0 || result2 == 1, (Object)result2);
        return result2;
    }

    @YesNoResult
    public static int showYesNoDialog(@Nullable Project project, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String yesText, @NotNull String noText, @Nullable Icon icon, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        if (title == null) {
            Messages.$$$reportNull$$$0(26);
        }
        if (yesText == null) {
            Messages.$$$reportNull$$$0(27);
        }
        if (noText == null) {
            Messages.$$$reportNull$$$0(28);
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                return MacMessages.getInstance().showYesNoDialog(title, message, yesText, noText, WindowManager.getInstance().suggestParentWindow(project), doNotAskOption);
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        int result2 = Messages.showDialog(project, message, title, new String[]{yesText, noText}, 0, icon, doNotAskOption) == 0 ? 0 : 1;
        LOG.assertTrue(result2 == 0 || result2 == 1, (Object)result2);
        return result2;
    }

    @YesNoResult
    public static int showYesNoDialog(@Nullable Project project, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon) {
        if (title == null) {
            Messages.$$$reportNull$$$0(29);
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                return MacMessages.getInstance().showYesNoDialog(title, message, YES_BUTTON, NO_BUTTON, WindowManager.getInstance().suggestParentWindow(project));
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        int result2 = Messages.showYesNoDialog(project, message, title, YES_BUTTON, NO_BUTTON, icon);
        LOG.assertTrue(result2 == 0 || result2 == 1, (Object)result2);
        return result2;
    }

    @YesNoResult
    public static int showYesNoDialog(@Nullable Project project, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        if (title == null) {
            Messages.$$$reportNull$$$0(30);
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                return MacMessages.getInstance().showYesNoDialog(title, message, YES_BUTTON, NO_BUTTON, WindowManager.getInstance().suggestParentWindow(project), doNotAskOption);
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        int result2 = Messages.showYesNoDialog(project, message, title, YES_BUTTON, NO_BUTTON, icon, doNotAskOption);
        LOG.assertTrue(result2 == 0 || result2 == 1, (Object)result2);
        return result2;
    }

    @YesNoResult
    public static int showYesNoDialog(@NotNull Component parent, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon) {
        if (parent == null) {
            Messages.$$$reportNull$$$0(31);
        }
        if (title == null) {
            Messages.$$$reportNull$$$0(32);
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                return MacMessages.getInstance().showYesNoDialog(title, message, YES_BUTTON, NO_BUTTON, SwingUtilities.getWindowAncestor(parent));
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        int result2 = Messages.showDialog(parent, message, title, new String[]{YES_BUTTON, NO_BUTTON}, 0, icon) == 0 ? 0 : 1;
        LOG.assertTrue(result2 == 0 || result2 == 1, (Object)result2);
        return result2;
    }

    @YesNoResult
    public static int showYesNoDialog(String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String yesText, @NotNull String noText, @Nullable Icon icon, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        if (title == null) {
            Messages.$$$reportNull$$$0(33);
        }
        if (yesText == null) {
            Messages.$$$reportNull$$$0(34);
        }
        if (noText == null) {
            Messages.$$$reportNull$$$0(35);
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                return MacMessages.getInstance().showYesNoDialog(title, message, yesText, noText, null, doNotAskOption);
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception exception) {
            LOG.error((Throwable)exception);
        }
        int result2 = Messages.showDialog(message, title, new String[]{yesText, noText}, 0, icon, doNotAskOption) == 0 ? 0 : 1;
        LOG.assertTrue(result2 == 0 || result2 == 1, (Object)result2);
        return result2;
    }

    @YesNoResult
    public static int showYesNoDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, String yesText, String noText, @Nullable Icon icon) {
        return Messages.showYesNoDialog(message, title, yesText, noText, icon, null);
    }

    @YesNoResult
    public static int showYesNoDialog(String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon) {
        if (title == null) {
            Messages.$$$reportNull$$$0(36);
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                return MacMessages.getInstance().showYesNoDialog(title, message, YES_BUTTON, NO_BUTTON, null);
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        int result2 = Messages.showYesNoDialog(message, title, YES_BUTTON, NO_BUTTON, icon);
        LOG.assertTrue(result2 == 0 || result2 == 1, (Object)result2);
        return result2;
    }

    @OkCancelResult
    public static int showOkCancelDialog(Project project, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String okText, @NotNull String cancelText, Icon icon, DialogWrapper.DoNotAskOption doNotAskOption) {
        if (title == null) {
            Messages.$$$reportNull$$$0(37);
        }
        if (okText == null) {
            Messages.$$$reportNull$$$0(38);
        }
        if (cancelText == null) {
            Messages.$$$reportNull$$$0(39);
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                int result2 = MacMessages.getInstance().showYesNoDialog(title, message, okText, cancelText, WindowManager.getInstance().suggestParentWindow(project), doNotAskOption);
                return result2 == 0 ? 0 : 2;
            }
        }
        catch (MessageException result2) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        return Messages.showDialog(project, message, title, new String[]{okText, cancelText}, 0, icon, doNotAskOption) == 0 ? 0 : 2;
    }

    @OkCancelResult
    public static int showOkCancelDialog(Project project, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String okText, @NotNull String cancelText, Icon icon) {
        if (title == null) {
            Messages.$$$reportNull$$$0(40);
        }
        if (okText == null) {
            Messages.$$$reportNull$$$0(41);
        }
        if (cancelText == null) {
            Messages.$$$reportNull$$$0(42);
        }
        return Messages.showOkCancelDialog(project, message, title, okText, cancelText, icon, null);
    }

    @OkCancelResult
    public static int showOkCancelDialog(Project project, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, Icon icon) {
        return Messages.showOkCancelDialog(project, message, title, OK_BUTTON, CANCEL_BUTTON, icon);
    }

    @OkCancelResult
    public static int showOkCancelDialog(@NotNull Component parent, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String okText, @NotNull String cancelText, Icon icon) {
        if (parent == null) {
            Messages.$$$reportNull$$$0(43);
        }
        if (title == null) {
            Messages.$$$reportNull$$$0(44);
        }
        if (okText == null) {
            Messages.$$$reportNull$$$0(45);
        }
        if (cancelText == null) {
            Messages.$$$reportNull$$$0(46);
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                int result2 = MacMessages.getInstance().showYesNoDialog(title, message, okText, cancelText, SwingUtilities.getWindowAncestor(parent));
                return result2 == 0 ? 0 : 2;
            }
        }
        catch (MessageException result2) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        return Messages.showDialog(parent, message, title, new String[]{okText, cancelText}, 0, icon) == 0 ? 0 : 2;
    }

    @OkCancelResult
    public static int showOkCancelDialog(@NotNull Component parent, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, Icon icon) {
        if (parent == null) {
            Messages.$$$reportNull$$$0(47);
        }
        return Messages.showOkCancelDialog(parent, message, title, OK_BUTTON, CANCEL_BUTTON, icon);
    }

    @OkCancelResult
    public static int showOkCancelDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, Icon icon) {
        return Messages.showOkCancelDialog(message, title, OK_BUTTON, CANCEL_BUTTON, icon, null);
    }

    @OkCancelResult
    public static int showOkCancelDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, String okText, String cancelText, Icon icon) {
        return Messages.showOkCancelDialog(message, title, okText, cancelText, icon, null);
    }

    @OkCancelResult
    public static int showOkCancelDialog(String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String okText, @NotNull String cancelText, Icon icon, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        if (title == null) {
            Messages.$$$reportNull$$$0(48);
        }
        if (okText == null) {
            Messages.$$$reportNull$$$0(49);
        }
        if (cancelText == null) {
            Messages.$$$reportNull$$$0(50);
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                int result2 = MacMessages.getInstance().showYesNoDialog(title, message, okText, cancelText, null, doNotAskOption);
                return result2 == 0 ? 0 : 2;
            }
        }
        catch (MessageException result2) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        return Messages.showDialog(message, title, new String[]{okText, cancelText}, 0, icon, doNotAskOption) == 0 ? 0 : 2;
    }

    public static int showCheckboxOkCancelDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, String checkboxText, boolean checked, int defaultOptionIndex, int focusedOptionIndex, Icon icon) {
        return Messages.showCheckboxMessageDialog(message, title, new String[]{OK_BUTTON, CANCEL_BUTTON}, checkboxText, checked, defaultOptionIndex, focusedOptionIndex, icon, (PairFunction<Integer, JCheckBox, Integer>)((PairFunction)(exitCode, cb) -> exitCode == -1 ? 2 : exitCode + (cb.isSelected() ? 1 : 0)));
    }

    public static int showCheckboxMessageDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String[] options, String checkboxText, boolean checked, int defaultOptionIndex, int focusedOptionIndex, Icon icon, @Nullable PairFunction<Integer, JCheckBox, Integer> exitFunc) {
        if (options == null) {
            Messages.$$$reportNull$$$0(51);
        }
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return ourTestImplementation.show(message);
        }
        TwoStepConfirmationDialog dialog = new TwoStepConfirmationDialog(message, title, options, checkboxText, checked, defaultOptionIndex, focusedOptionIndex, icon, exitFunc);
        dialog.show();
        return dialog.getExitCode();
    }

    public static int showTwoStepConfirmationDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, String checkboxText, Icon icon) {
        return Messages.showCheckboxMessageDialog(message, title, new String[]{OK_BUTTON}, checkboxText, true, -1, -1, icon, null);
    }

    public static void showErrorDialog(@Nullable Project project, @Nls String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title) {
        if (title == null) {
            Messages.$$$reportNull$$$0(52);
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                MacMessages.getInstance().showErrorDialog(title, message, OK_BUTTON, WindowManager.getInstance().suggestParentWindow(project));
                return;
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        Messages.showDialog(project, message, title, new String[]{OK_BUTTON}, 0, Messages.getErrorIcon());
    }

    public static void showErrorDialog(@NotNull Component component, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title) {
        if (component == null) {
            Messages.$$$reportNull$$$0(53);
        }
        if (title == null) {
            Messages.$$$reportNull$$$0(54);
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                MacMessages.getInstance().showErrorDialog(title, message, OK_BUTTON, UIUtil.getWindow((Component)component));
                return;
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        Messages.showDialog(component, message, title, new String[]{OK_BUTTON}, 0, Messages.getErrorIcon());
    }

    public static void showErrorDialog(@NotNull Component component, String message) {
        if (component == null) {
            Messages.$$$reportNull$$$0(55);
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                MacMessages.getInstance().showErrorDialog(CommonBundle.getErrorTitle(), message, OK_BUTTON, SwingUtilities.getWindowAncestor(component));
                return;
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        Messages.showDialog(component, message, CommonBundle.getErrorTitle(), new String[]{OK_BUTTON}, 0, Messages.getErrorIcon());
    }

    public static void showErrorDialog(String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title) {
        if (title == null) {
            Messages.$$$reportNull$$$0(56);
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                MacMessages.getInstance().showErrorDialog(title, message, OK_BUTTON, null);
                return;
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        Messages.showDialog(message, title, new String[]{OK_BUTTON}, 0, Messages.getErrorIcon());
    }

    public static void showWarningDialog(@Nullable Project project, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title) {
        if (title == null) {
            Messages.$$$reportNull$$$0(57);
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                MacMessages.getInstance().showErrorDialog(title, message, OK_BUTTON, WindowManager.getInstance().suggestParentWindow(project));
                return;
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        Messages.showDialog(project, message, title, new String[]{OK_BUTTON}, 0, Messages.getWarningIcon());
    }

    public static void showWarningDialog(@NotNull Component component, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title) {
        if (component == null) {
            Messages.$$$reportNull$$$0(58);
        }
        if (title == null) {
            Messages.$$$reportNull$$$0(59);
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                MacMessages.getInstance().showErrorDialog(title, message, OK_BUTTON, SwingUtilities.getWindowAncestor(component));
                return;
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        Messages.showDialog(component, message, title, new String[]{OK_BUTTON}, 0, Messages.getWarningIcon());
    }

    public static void showWarningDialog(String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title) {
        if (title == null) {
            Messages.$$$reportNull$$$0(60);
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                MacMessages.getInstance().showErrorDialog(title, message, OK_BUTTON, null);
                return;
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        Messages.showDialog(message, title, new String[]{OK_BUTTON}, 0, Messages.getWarningIcon());
    }

    @YesNoCancelResult
    public static int showYesNoCancelDialog(Project project, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String yes, @NotNull String no, @NotNull String cancel, @Nullable Icon icon) {
        if (title == null) {
            Messages.$$$reportNull$$$0(61);
        }
        if (yes == null) {
            Messages.$$$reportNull$$$0(62);
        }
        if (no == null) {
            Messages.$$$reportNull$$$0(63);
        }
        if (cancel == null) {
            Messages.$$$reportNull$$$0(64);
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                return MacMessages.getInstance().showYesNoCancelDialog(title, message, yes, no, cancel, WindowManager.getInstance().suggestParentWindow(project), null);
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        int buttonNumber = Messages.showDialog(project, message, title, new String[]{yes, no, cancel}, 0, icon);
        return buttonNumber == 0 ? 0 : (buttonNumber == 1 ? 1 : 2);
    }

    @YesNoCancelResult
    public static int showYesNoCancelDialog(Project project, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, Icon icon) {
        return Messages.showYesNoCancelDialog(project, message, title, YES_BUTTON, NO_BUTTON, CANCEL_BUTTON, icon);
    }

    @YesNoCancelResult
    public static int showYesNoCancelDialog(@NotNull Component parent, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String yes, @NotNull String no, @NotNull String cancel, Icon icon) {
        if (parent == null) {
            Messages.$$$reportNull$$$0(65);
        }
        if (title == null) {
            Messages.$$$reportNull$$$0(66);
        }
        if (yes == null) {
            Messages.$$$reportNull$$$0(67);
        }
        if (no == null) {
            Messages.$$$reportNull$$$0(68);
        }
        if (cancel == null) {
            Messages.$$$reportNull$$$0(69);
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                return MacMessages.getInstance().showYesNoCancelDialog(title, message, yes, no, cancel, SwingUtilities.getWindowAncestor(parent), null);
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        int buttonNumber = Messages.showDialog(parent, message, title, new String[]{yes, no, cancel}, 0, icon);
        return buttonNumber == 0 ? 0 : (buttonNumber == 1 ? 1 : 2);
    }

    @YesNoCancelResult
    public static int showYesNoCancelDialog(@NotNull Component parent, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, Icon icon) {
        if (parent == null) {
            Messages.$$$reportNull$$$0(70);
        }
        return Messages.showYesNoCancelDialog(parent, message, title, YES_BUTTON, NO_BUTTON, CANCEL_BUTTON, icon);
    }

    @YesNoCancelResult
    public static int showYesNoCancelDialog(String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String yes, @NotNull String no, @NotNull String cancel, Icon icon, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        if (title == null) {
            Messages.$$$reportNull$$$0(71);
        }
        if (yes == null) {
            Messages.$$$reportNull$$$0(72);
        }
        if (no == null) {
            Messages.$$$reportNull$$$0(73);
        }
        if (cancel == null) {
            Messages.$$$reportNull$$$0(74);
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                return MacMessages.getInstance().showYesNoCancelDialog(title, message, yes, no, cancel, null, doNotAskOption);
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        int buttonNumber = Messages.showDialog(message, title, new String[]{yes, no, cancel}, 0, icon, doNotAskOption);
        return buttonNumber == 0 ? 0 : (buttonNumber == 1 ? 1 : 2);
    }

    @YesNoCancelResult
    public static int showYesNoCancelDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, String yes, String no, String cancel, Icon icon) {
        return Messages.showYesNoCancelDialog(message, title, yes, no, cancel, icon, null);
    }

    @YesNoCancelResult
    public static int showYesNoCancelDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, Icon icon) {
        return Messages.showYesNoCancelDialog(message, title, YES_BUTTON, NO_BUTTON, CANCEL_BUTTON, icon);
    }

    @Nullable
    public static String showPasswordDialog(@Nls String message, @Nls(capitalization=Nls.Capitalization.Title) String title) {
        return Messages.showPasswordDialog(null, message, title, null, null);
    }

    @Nullable
    public static String showPasswordDialog(Project project, @Nls String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon) {
        return Messages.showPasswordDialog(project, message, title, icon, null);
    }

    @Nullable
    public static String showPasswordDialog(@Nullable Project project, @Nls String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon, @Nullable InputValidator validator) {
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return ourTestInputImplementation.show(message, validator);
        }
        PasswordInputDialog dialog = project != null ? new PasswordInputDialog(project, message, title, icon, validator) : new PasswordInputDialog(message, title, icon, validator);
        dialog.show();
        return dialog.getInputString();
    }

    @Nullable
    public static String showInputDialog(@Nullable Project project, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon) {
        return Messages.showInputDialog(project, message, title, icon, null, null);
    }

    @Nullable
    public static String showInputDialog(@NotNull Component parent, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon) {
        if (parent == null) {
            Messages.$$$reportNull$$$0(75);
        }
        return Messages.showInputDialog(parent, message, title, icon, null, null);
    }

    @Nullable
    public static String showInputDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon) {
        return Messages.showInputDialog(message, title, icon, null, null);
    }

    @Nullable
    public static String showInputDialog(@Nullable Project project, @Nls String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon, @Nullable String initialValue, @Nullable InputValidator validator) {
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return ourTestInputImplementation.show(message, validator);
        }
        InputDialog dialog = new InputDialog(project, message, title, icon, initialValue, validator);
        dialog.show();
        return dialog.getInputString();
    }

    @Nullable
    public static String showInputDialog(Project project, @Nls String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon, @Nullable String initialValue, @Nullable InputValidator validator, @Nullable TextRange selection) {
        return Messages.showInputDialog(project, message, title, icon, initialValue, validator, selection, null);
    }

    @Nullable
    public static String showInputDialog(Project project, @Nls String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon, @Nullable String initialValue, @Nullable InputValidator validator, @Nullable TextRange selection, @Nullable String comment) {
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return ourTestInputImplementation.show(message, validator);
        }
        InputDialog dialog = new InputDialog(project, message, title, icon, initialValue, validator, new String[]{OK_BUTTON, CANCEL_BUTTON}, 0, comment);
        JTextComponent field = dialog.getTextField();
        if (selection != null) {
            field.select(selection.getStartOffset(), selection.getEndOffset());
        } else {
            int length = field.getDocument().getLength();
            field.select(length, length);
        }
        field.putClientProperty(DialogWrapperPeer.HAVE_INITIAL_SELECTION, true);
        dialog.show();
        return dialog.getInputString();
    }

    @Nullable
    public static String showInputDialog(@NotNull Component parent, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon, @Nullable String initialValue, @Nullable InputValidator validator) {
        if (parent == null) {
            Messages.$$$reportNull$$$0(76);
        }
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return ourTestInputImplementation.show(message, validator);
        }
        InputDialog dialog = new InputDialog(parent, message, title, icon, initialValue, validator);
        dialog.show();
        return dialog.getInputString();
    }

    @Nullable
    public static String showInputDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon, @Nullable String initialValue, @Nullable InputValidator validator) {
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return ourTestInputImplementation.show(message, validator);
        }
        InputDialog dialog = new InputDialog(message, title, icon, initialValue, validator);
        dialog.show();
        return dialog.getInputString();
    }

    @Nullable
    public static String showMultilineInputDialog(Project project, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable String initialValue, @Nullable Icon icon, @Nullable InputValidator validator) {
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return ourTestInputImplementation.show(message, validator);
        }
        MultilineInputDialog dialog = new MultilineInputDialog(project, message, title, icon, initialValue, validator, new String[]{OK_BUTTON, CANCEL_BUTTON}, 0);
        dialog.show();
        return dialog.getInputString();
    }

    @NotNull
    public static Pair<String, Boolean> showInputDialogWithCheckBox(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, String checkboxText, boolean checked, boolean checkboxEnabled, @Nullable Icon icon, @NonNls String initialValue, @Nullable InputValidator validator) {
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            Pair pair = new Pair((Object)ourTestInputImplementation.show(message, validator), (Object)checked);
            if (pair == null) {
                Messages.$$$reportNull$$$0(77);
            }
            return pair;
        }
        InputDialogWithCheckbox dialog = new InputDialogWithCheckbox(message, title, checkboxText, checked, checkboxEnabled, icon, initialValue, validator);
        dialog.show();
        Pair pair = Pair.create((Object)dialog.getInputString(), (Object)dialog.isChecked());
        if (pair == null) {
            Messages.$$$reportNull$$$0(78);
        }
        return pair;
    }

    @Nullable
    public static String showEditableChooseDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon, String[] values, String initialValue, @Nullable InputValidator validator) {
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return ourTestInputImplementation.show(message, validator);
        }
        ChooseDialog dialog = new ChooseDialog(message, title, icon, values, initialValue);
        dialog.setValidator(validator);
        dialog.getComboBox().setEditable(true);
        dialog.getComboBox().getEditor().setItem(initialValue);
        dialog.getComboBox().setSelectedItem(initialValue);
        dialog.show();
        return dialog.getInputString();
    }

    @Deprecated
    public static int showChooseDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, String[] values, String initialValue, @Nullable Icon icon) {
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return ourTestImplementation.show(message);
        }
        ChooseDialog dialog = new ChooseDialog(message, title, icon, values, initialValue);
        dialog.show();
        return dialog.getSelectedIndex();
    }

    @Deprecated
    public static int showChooseDialog(@NotNull Component parent, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, String[] values, String initialValue, Icon icon) {
        if (parent == null) {
            Messages.$$$reportNull$$$0(79);
        }
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return ourTestImplementation.show(message);
        }
        ChooseDialog dialog = new ChooseDialog(parent, message, title, icon, values, initialValue);
        dialog.show();
        return dialog.getSelectedIndex();
    }

    @Deprecated
    public static int showChooseDialog(Project project, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, Icon icon, String[] values, String initialValue) {
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return ourTestImplementation.show(message);
        }
        ChooseDialog dialog = new ChooseDialog(project, message, title, icon, values, initialValue);
        dialog.show();
        return dialog.getSelectedIndex();
    }

    public static void showInfoMessage(Component component, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title) {
        if (title == null) {
            Messages.$$$reportNull$$$0(80);
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                MacMessages.getInstance().showOkMessageDialog(title, message, OK_BUTTON, SwingUtilities.getWindowAncestor(component));
                return;
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        Messages.showMessageDialog(component, message, title, Messages.getInformationIcon());
    }

    public static void showInfoMessage(@Nullable Project project, @Nls String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title) {
        if (title == null) {
            Messages.$$$reportNull$$$0(81);
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                MacMessages.getInstance().showOkMessageDialog(title, message, OK_BUTTON, WindowManager.getInstance().suggestParentWindow(project));
                return;
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        Messages.showMessageDialog(project, message, title, Messages.getInformationIcon());
    }

    public static void showInfoMessage(String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title) {
        if (title == null) {
            Messages.$$$reportNull$$$0(82);
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                MacMessages.getInstance().showOkMessageDialog(title, message, OK_BUTTON, null);
                return;
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        Messages.showMessageDialog(message, title, Messages.getInformationIcon());
    }

    public static void showTextAreaDialog(JTextField textField, @Nls(capitalization=Nls.Capitalization.Title) String title, @NonNls String dimensionServiceKey, Function<String, List<String>> parser, Function<List<String>, String> lineJoiner) {
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            ourTestImplementation.show(title);
        } else {
            JTextArea textArea = new JTextArea(10, 50);
            UIUtil.addUndoRedoActions((JTextComponent)textArea);
            textArea.setWrapStyleWord(true);
            textArea.setLineWrap(true);
            List lines = (List)parser.fun((Object)textField.getText());
            textArea.setText(StringUtil.join((Collection)lines, (String)"\n"));
            InsertPathAction.copyFromTo(textField, textArea);
            DialogBuilder builder = new DialogBuilder(textField);
            builder.setDimensionServiceKey(dimensionServiceKey);
            builder.setCenterPanel(ScrollPaneFactory.createScrollPane(textArea));
            builder.setPreferredFocusComponent(textArea);
            String rawText = title;
            if (StringUtil.endsWithChar((CharSequence)rawText, (char)':')) {
                rawText = rawText.substring(0, rawText.length() - 1);
            }
            builder.setTitle(rawText);
            builder.addOkAction();
            builder.addCancelAction();
            builder.setOkOperation(() -> {
                textField.setText((String)lineJoiner.fun(Arrays.asList(StringUtil.splitByLines((String)textArea.getText()))));
                builder.getDialogWrapper().close(0);
            });
            builder.show();
        }
    }

    public static void showTextAreaDialog(JTextField textField, @Nls(capitalization=Nls.Capitalization.Title) String title, @NonNls String dimensionServiceKey) {
        Messages.showTextAreaDialog(textField, title, dimensionServiceKey, (Function<String, List<String>>)ParametersListUtil.DEFAULT_LINE_PARSER, (Function<List<String>, String>)ParametersListUtil.DEFAULT_LINE_JOINER);
    }

    public static void installHyperlinkSupport(JTextPane messageComponent) {
        Messages.configureMessagePaneUi(messageComponent, "<html></html>");
    }

    @NotNull
    public static JTextPane configureMessagePaneUi(JTextPane messageComponent, String message) {
        JTextPane pane = Messages.configureMessagePaneUi(messageComponent, message, null);
        if ("text/html".equals(pane.getContentType())) {
            pane.addHyperlinkListener(BrowserHyperlinkListener.INSTANCE);
        }
        JTextPane jTextPane = pane;
        if (jTextPane == null) {
            Messages.$$$reportNull$$$0(83);
        }
        return jTextPane;
    }

    @NotNull
    public static JTextPane configureMessagePaneUi(@NotNull JTextPane messageComponent, @Nullable String message, @Nullable UIUtil.FontSize fontSize) {
        if (messageComponent == null) {
            Messages.$$$reportNull$$$0(84);
        }
        UIUtil.FontSize fixedFontSize = fontSize == null ? UIUtil.FontSize.NORMAL : fontSize;
        messageComponent.setFont(UIUtil.getLabelFont((UIUtil.FontSize)fixedFontSize));
        if (BasicHTML.isHTMLString(message)) {
            messageComponent.setEditorKit(UIUtil.getHTMLEditorKit());
        }
        messageComponent.setText(message);
        messageComponent.setEditable(false);
        if (messageComponent.getCaret() != null) {
            messageComponent.setCaretPosition(0);
        }
        messageComponent.setBackground(UIUtil.getOptionPaneBackground());
        messageComponent.setForeground(UIUtil.getLabelForeground());
        JTextPane jTextPane = messageComponent;
        if (jTextPane == null) {
            Messages.$$$reportNull$$$0(85);
        }
        return jTextPane;
    }

    @NotNull
    public static JComponent wrapToScrollPaneIfNeeded(@NotNull JComponent comp, int columns, int lines) {
        if (comp == null) {
            Messages.$$$reportNull$$$0(86);
        }
        float fontSize = comp.getFont().getSize2D();
        Dimension maxDim = new Dimension((int)(fontSize * (float)columns), (int)(fontSize * (float)lines));
        Dimension prefDim = comp.getPreferredSize();
        if (prefDim.width <= maxDim.width && prefDim.height <= maxDim.height) {
            JComponent jComponent = comp;
            if (jComponent == null) {
                Messages.$$$reportNull$$$0(87);
            }
            return jComponent;
        }
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane(comp);
        scrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(30);
        int barWidth = UIUtil.getScrollBarWidth();
        Dimension preferredSize = new Dimension(Math.min(prefDim.width, maxDim.width) + barWidth, Math.min(prefDim.height, maxDim.height) + barWidth);
        if (prefDim.width > maxDim.width) {
            preferredSize.height = Math.max(preferredSize.height, (int)(4.0f * fontSize) + barWidth);
        }
        scrollPane.setPreferredSize(preferredSize);
        JScrollPane jScrollPane = scrollPane;
        if (jScrollPane == null) {
            Messages.$$$reportNull$$$0(88);
        }
        return jScrollPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 84: 
            case 86: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 84: 
            case 86: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/ui/Messages";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkWindows";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 7: 
            case 10: 
            case 13: 
            case 15: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 40: 
            case 44: 
            case 48: 
            case 52: 
            case 54: 
            case 56: 
            case 57: 
            case 59: 
            case 60: 
            case 61: 
            case 66: 
            case 71: 
            case 80: 
            case 81: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 12: 
            case 20: 
            case 31: 
            case 43: 
            case 47: 
            case 65: 
            case 70: 
            case 75: 
            case 76: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 24: 
            case 27: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "yesText";
                break;
            }
            case 25: 
            case 28: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "noText";
                break;
            }
            case 38: 
            case 41: 
            case 45: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "okText";
                break;
            }
            case 39: 
            case 42: 
            case 46: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancelText";
                break;
            }
            case 53: 
            case 55: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 62: 
            case 67: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "yes";
                break;
            }
            case 63: 
            case 68: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "no";
                break;
            }
            case 64: 
            case 69: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancel";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageComponent";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInformationIcon";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getWarningIcon";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuestionIcon";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createMessageDialogRemover";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 84: 
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/ui/Messages";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "showInputDialogWithCheckBox";
                break;
            }
            case 83: 
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "configureMessagePaneUi";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapToScrollPaneIfNeeded";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "makeCurrentMessageDialogGoAway";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "showDialog";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "showIdeaMessageDialog";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "showMessageDialog";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "showYesNoDialog";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "showOkCancelDialog";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "showCheckboxMessageDialog";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "showErrorDialog";
                break;
            }
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "showWarningDialog";
                break;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "showYesNoCancelDialog";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "showInputDialog";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "showChooseDialog";
                break;
            }
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "showInfoMessage";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "configureMessagePaneUi";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "wrapToScrollPaneIfNeeded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 84: 
            case 86: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Deprecated
    protected static class ChooseDialog
    extends MessageDialog {
        private ComboBox<String> myComboBox;
        private InputValidator myValidator;

        public ChooseDialog(Project project, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon, @NotNull String[] values, String initialValue, @NotNull String[] options, int defaultOption) {
            if (values == null) {
                ChooseDialog.$$$reportNull$$$0(0);
            }
            if (options == null) {
                ChooseDialog.$$$reportNull$$$0(1);
            }
            super(project, message, title, options, defaultOption, icon, true);
            this.myComboBox.setModel(new DefaultComboBoxModel<String>(values));
            this.myComboBox.setSelectedItem(initialValue);
        }

        public ChooseDialog(Project project, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon, String[] values, String initialValue) {
            this(project, message, title, icon, values, initialValue, new String[]{OK_BUTTON, CANCEL_BUTTON}, 0);
        }

        public ChooseDialog(@NotNull Component parent, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon, @NotNull String[] values, String initialValue) {
            if (parent == null) {
                ChooseDialog.$$$reportNull$$$0(2);
            }
            if (values == null) {
                ChooseDialog.$$$reportNull$$$0(3);
            }
            super(parent, message, title, new String[]{OK_BUTTON, CANCEL_BUTTON}, 0, icon);
            this.myComboBox.setModel(new DefaultComboBoxModel<String>(values));
            this.myComboBox.setSelectedItem(initialValue);
        }

        public ChooseDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon, @NotNull String[] values, String initialValue) {
            if (values == null) {
                ChooseDialog.$$$reportNull$$$0(4);
            }
            super(message, title, new String[]{OK_BUTTON, CANCEL_BUTTON}, 0, icon);
            this.myComboBox.setModel(new DefaultComboBoxModel<String>(values));
            this.myComboBox.setSelectedItem(initialValue);
        }

        @Override
        @NotNull
        protected Action[] createActions() {
            final Action[] actions = new Action[this.myOptions.length];
            for (int i = 0; i < this.myOptions.length; ++i) {
                String option = this.myOptions[i];
                final int exitCode = i;
                if (i == this.myDefaultOptionIndex) {
                    actions[i] = new AbstractAction(option){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (myValidator == null || myValidator.checkInput(myComboBox.getSelectedItem().toString().trim())) {
                                this.close(exitCode);
                            }
                        }
                    };
                    actions[i].putValue("DefaultAction", Boolean.TRUE);
                    this.myComboBox.addItemListener(e -> actions[exitCode].setEnabled(this.myValidator == null || this.myValidator.checkInput(this.myComboBox.getSelectedItem().toString().trim())));
                    final JTextField textField = (JTextField)this.myComboBox.getEditor().getEditorComponent();
                    textField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                        public void textChanged(DocumentEvent event) {
                            actions[exitCode].setEnabled(myValidator == null || myValidator.checkInput(textField.getText().trim()));
                        }
                    });
                    continue;
                }
                actions[i] = new AbstractAction(option){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.close(exitCode);
                    }
                };
            }
            if (actions == null) {
                ChooseDialog.$$$reportNull$$$0(5);
            }
            return actions;
        }

        @Override
        protected JComponent createCenterPanel() {
            return null;
        }

        @Override
        protected JComponent createNorthPanel() {
            JPanel panel = this.createIconPanel();
            JPanel messagePanel = this.createMessagePanel();
            this.myComboBox = new ComboBox(220);
            messagePanel.add(this.myComboBox, "South");
            panel.add((Component)messagePanel, "Center");
            return panel;
        }

        @Override
        protected void doOKAction() {
            String inputString = this.myComboBox.getSelectedItem().toString().trim();
            if (this.myValidator == null || this.myValidator.checkInput(inputString) && this.myValidator.canClose(inputString)) {
                super.doOKAction();
            }
        }

        @Override
        public JComponent getPreferredFocusedComponent() {
            return this.myComboBox;
        }

        @Nullable
        public String getInputString() {
            if (this.getExitCode() == 0) {
                return this.myComboBox.getSelectedItem().toString();
            }
            return null;
        }

        public int getSelectedIndex() {
            if (this.getExitCode() == 0) {
                return this.myComboBox.getSelectedIndex();
            }
            return -1;
        }

        public JComboBox getComboBox() {
            return this.myComboBox;
        }

        public void setValidator(@Nullable InputValidator validator) {
            this.myValidator = validator;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "options";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/ui/Messages$ChooseDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/ui/Messages$ChooseDialog";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static class InputDialogWithCheckbox
    extends InputDialog {
        private JCheckBox myCheckBox;

        public InputDialogWithCheckbox(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, String checkboxText, boolean checked, boolean checkboxEnabled, @Nullable Icon icon, @Nullable String initialValue, @Nullable InputValidator validator) {
            super(message, title, icon, initialValue, validator);
            this.myCheckBox.setText(checkboxText);
            this.myCheckBox.setSelected(checked);
            this.myCheckBox.setEnabled(checkboxEnabled);
        }

        @Override
        @NotNull
        protected JPanel createMessagePanel() {
            JPanel messagePanel = new JPanel(new BorderLayout());
            if (this.myMessage != null) {
                JComponent textComponent = this.createTextComponent();
                messagePanel.add((Component)textComponent, "North");
            }
            this.myField = this.createTextFieldComponent();
            messagePanel.add((Component)this.createScrollableTextComponent(), "Center");
            this.myCheckBox = new JCheckBox();
            messagePanel.add((Component)this.myCheckBox, "South");
            JPanel jPanel = messagePanel;
            if (jPanel == null) {
                InputDialogWithCheckbox.$$$reportNull$$$0(0);
            }
            return jPanel;
        }

        public Boolean isChecked() {
            return this.myCheckBox.isSelected();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/Messages$InputDialogWithCheckbox", "createMessagePanel"));
        }
    }

    protected static class PasswordInputDialog
    extends InputDialog {
        public PasswordInputDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon, @Nullable InputValidator validator) {
            super(message, title, icon, null, validator);
        }

        public PasswordInputDialog(Project project, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon, @Nullable InputValidator validator) {
            super(project, message, title, icon, null, validator);
        }

        @Override
        protected JTextComponent createTextFieldComponent() {
            return new JPasswordField(30);
        }
    }

    protected static class MultilineInputDialog
    extends InputDialog {
        public MultilineInputDialog(Project project, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon, @Nullable String initialValue, @Nullable InputValidator validator, @NotNull String[] options, int defaultOption) {
            if (options == null) {
                MultilineInputDialog.$$$reportNull$$$0(0);
            }
            super(project, message, title, icon, initialValue, validator, options, defaultOption);
        }

        @Override
        protected JTextComponent createTextFieldComponent() {
            return new JTextArea(7, 50);
        }

        @Override
        protected JComponent createScrollableTextComponent() {
            return new JBScrollPane(this.myField);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/openapi/ui/Messages$MultilineInputDialog", "<init>"));
        }
    }

    public static class InputDialog
    extends MessageDialog {
        protected JTextComponent myField;
        private final InputValidator myValidator;
        private final String myComment;

        public InputDialog(@Nullable Project project, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon, @Nullable String initialValue, @Nullable InputValidator validator, @NotNull String[] options, int defaultOption, @Nullable String comment) {
            if (options == null) {
                InputDialog.$$$reportNull$$$0(0);
            }
            super(project, true);
            this.myComment = comment;
            this.myValidator = validator;
            this._init(title, message, options, defaultOption, -1, icon, null);
            this.myField.setText(initialValue);
            this.enableOkAction();
        }

        public InputDialog(@Nullable Project project, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon, @Nullable String initialValue, @Nullable InputValidator validator, @NotNull String[] options, int defaultOption) {
            if (options == null) {
                InputDialog.$$$reportNull$$$0(1);
            }
            this(project, message, title, icon, initialValue, validator, options, defaultOption, null);
        }

        public InputDialog(@Nullable Project project, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon, @Nullable String initialValue, @Nullable InputValidator validator) {
            this(project, message, title, icon, initialValue, validator, new String[]{OK_BUTTON, CANCEL_BUTTON}, 0);
        }

        public InputDialog(@NotNull Component parent, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon, @Nullable String initialValue, @Nullable InputValidator validator) {
            if (parent == null) {
                InputDialog.$$$reportNull$$$0(2);
            }
            super(parent, message, title, new String[]{OK_BUTTON, CANCEL_BUTTON}, 0, icon, true);
            this.myValidator = validator;
            this.myComment = null;
            this.myField.setText(initialValue);
            this.enableOkAction();
        }

        public InputDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon, @Nullable String initialValue, @Nullable InputValidator validator) {
            super(message, title, new String[]{OK_BUTTON, CANCEL_BUTTON}, 0, icon, true);
            this.myValidator = validator;
            this.myComment = null;
            this.myField.setText(initialValue);
            this.enableOkAction();
        }

        private void enableOkAction() {
            this.getOKAction().setEnabled(this.myValidator == null || this.myValidator.checkInput(this.myField.getText().trim()));
        }

        @Override
        @NotNull
        protected Action[] createActions() {
            final Action[] actions = new Action[this.myOptions.length];
            for (int i = 0; i < this.myOptions.length; ++i) {
                String option = this.myOptions[i];
                final int exitCode = i;
                if (i == 0) {
                    actions[0] = this.getOKAction();
                    actions[0].putValue("DefaultAction", Boolean.TRUE);
                    this.myField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                        public void textChanged(DocumentEvent event) {
                            String text = myField.getText().trim();
                            actions[exitCode].setEnabled(myValidator == null || myValidator.checkInput(text));
                            if (myValidator instanceof InputValidatorEx) {
                                this.setErrorText(((InputValidatorEx)myValidator).getErrorText(text), myField);
                            }
                        }
                    });
                    continue;
                }
                actions[i] = new AbstractAction(option){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.close(exitCode);
                    }
                };
            }
            if (actions == null) {
                InputDialog.$$$reportNull$$$0(3);
            }
            return actions;
        }

        @Override
        protected void doOKAction() {
            String inputString = this.myField.getText().trim();
            if (this.myValidator == null || this.myValidator.checkInput(inputString) && this.myValidator.canClose(inputString)) {
                this.close(0);
            }
        }

        @Override
        protected JComponent createCenterPanel() {
            return null;
        }

        @Override
        protected JComponent createNorthPanel() {
            JPanel panel = this.createIconPanel();
            JPanel messagePanel = this.createMessagePanel();
            panel.add((Component)messagePanel, "Center");
            if (this.myComment != null) {
                return UI.PanelFactory.panel(panel).withComment(this.myComment).createPanel();
            }
            return panel;
        }

        @Override
        @NotNull
        protected JPanel createMessagePanel() {
            JPanel messagePanel = new JPanel(new BorderLayout());
            if (this.myMessage != null) {
                JComponent textComponent = this.createTextComponent();
                messagePanel.add((Component)textComponent, "North");
            }
            this.myField = this.createTextFieldComponent();
            messagePanel.add((Component)this.createScrollableTextComponent(), "South");
            JPanel jPanel = messagePanel;
            if (jPanel == null) {
                InputDialog.$$$reportNull$$$0(4);
            }
            return jPanel;
        }

        protected JComponent createScrollableTextComponent() {
            return this.myField;
        }

        protected JComponent createTextComponent() {
            JComponent textComponent;
            if (BasicHTML.isHTMLString(this.myMessage)) {
                textComponent = InputDialog.createMessageComponent(this.myMessage);
            } else {
                JLabel textLabel = new JLabel(this.myMessage);
                textLabel.setUI(new MultiLineLabelUI());
                textComponent = textLabel;
            }
            textComponent.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 20));
            return textComponent;
        }

        public JTextComponent getTextField() {
            return this.myField;
        }

        protected JTextComponent createTextFieldComponent() {
            return new JTextField(30);
        }

        @Override
        public JComponent getPreferredFocusedComponent() {
            return this.myField;
        }

        @Nullable
        public String getInputString() {
            if (this.getExitCode() == 0) {
                return this.myField.getText().trim();
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "options";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/ui/Messages$InputDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/ui/Messages$InputDialog";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createActions";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createMessagePanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static class TwoStepConfirmationDialog
    extends MessageDialog {
        private JCheckBox myCheckBox;
        private final String myCheckboxText;
        private final boolean myChecked;
        private final PairFunction<Integer, JCheckBox, Integer> myExitFunc;

        public TwoStepConfirmationDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String[] options, String checkboxText, boolean checked, int defaultOptionIndexed, int focusedOptionIndex, Icon icon, @Nullable PairFunction<Integer, JCheckBox, Integer> exitFunc) {
            if (options == null) {
                TwoStepConfirmationDialog.$$$reportNull$$$0(0);
            }
            this.myCheckboxText = checkboxText;
            this.myChecked = checked;
            this.myExitFunc = exitFunc;
            this._init(title, message, options, defaultOptionIndexed, focusedOptionIndex, icon, null);
        }

        @Override
        protected JComponent createNorthPanel() {
            JPanel panel = this.createIconPanel();
            JPanel messagePanel = this.createMessagePanel();
            messagePanel.add((Component)this.createCheckComponent(), "South");
            panel.add((Component)messagePanel, "Center");
            return panel;
        }

        @NotNull
        protected JComponent createCheckComponent() {
            this.myCheckBox = new JCheckBox(this.myCheckboxText);
            this.myCheckBox.setSelected(this.myChecked);
            JCheckBox jCheckBox = this.myCheckBox;
            if (jCheckBox == null) {
                TwoStepConfirmationDialog.$$$reportNull$$$0(1);
            }
            return jCheckBox;
        }

        @Override
        public int getExitCode() {
            int exitCode = super.getExitCode();
            if (this.myExitFunc != null) {
                return (Integer)this.myExitFunc.fun((Object)exitCode, (Object)this.myCheckBox);
            }
            boolean checkBoxSelected = this.myCheckBox != null && this.myCheckBox.isSelected();
            boolean okExitCode = exitCode == 0;
            return checkBoxSelected && okExitCode ? 0 : 1;
        }

        @Override
        public JComponent getPreferredFocusedComponent() {
            return this.myDefaultOptionIndex == -1 ? this.myCheckBox : super.getPreferredFocusedComponent();
        }

        @Override
        protected JComponent createCenterPanel() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "options";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/ui/Messages$TwoStepConfirmationDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/ui/Messages$TwoStepConfirmationDialog";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createCheckComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyBorderLayout
    extends BorderLayout {
        private double myPhase;

        private MyBorderLayout() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container target) {
            Dimension realSize = target.getSize();
            target.setSize(target.getPreferredSize());
            super.layoutContainer(target);
            target.setSize(realSize);
            Object object = target.getTreeLock();
            synchronized (object) {
                Component[] components;
                int yShift = (int)((1.0 - this.myPhase) * (double)target.getPreferredSize().height);
                for (Component component : components = target.getComponents()) {
                    Point point = component.getLocation();
                    point.y -= yShift;
                    component.setLocation(point);
                }
            }
        }
    }

    private static class MessageDialog
    extends DialogWrapper {
        protected String myMessage;
        protected String[] myOptions;
        protected int myDefaultOptionIndex;
        protected int myFocusedOptionIndex;
        protected Icon myIcon;
        private MyBorderLayout myLayout;

        MessageDialog(@Nullable Project project, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String[] options, int defaultOptionIndex, @Nullable Icon icon, boolean canBeParent) {
            if (options == null) {
                MessageDialog.$$$reportNull$$$0(0);
            }
            this(project, message, title, options, defaultOptionIndex, -1, icon, canBeParent);
        }

        MessageDialog(@Nullable Project project, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String[] options, int defaultOptionIndex, int focusedOptionIndex, @Nullable Icon icon, @Nullable DialogWrapper.DoNotAskOption doNotAskOption, boolean canBeParent) {
            if (options == null) {
                MessageDialog.$$$reportNull$$$0(1);
            }
            super(project, canBeParent);
            this._init(title, message, options, defaultOptionIndex, focusedOptionIndex, icon, doNotAskOption);
        }

        MessageDialog(@Nullable Project project, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String[] options, int defaultOptionIndex, int focusedOptionIndex, @Nullable Icon icon, boolean canBeParent) {
            if (options == null) {
                MessageDialog.$$$reportNull$$$0(2);
            }
            super(project, canBeParent);
            this._init(title, message, options, defaultOptionIndex, focusedOptionIndex, icon, null);
        }

        MessageDialog(@NotNull Component parent, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String[] options, int defaultOptionIndex, @Nullable Icon icon) {
            if (parent == null) {
                MessageDialog.$$$reportNull$$$0(3);
            }
            if (options == null) {
                MessageDialog.$$$reportNull$$$0(4);
            }
            this(parent, message, title, options, defaultOptionIndex, icon, false);
        }

        MessageDialog(@NotNull Component parent, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String[] options, int defaultOptionIndex, @Nullable Icon icon, boolean canBeParent) {
            if (parent == null) {
                MessageDialog.$$$reportNull$$$0(5);
            }
            if (options == null) {
                MessageDialog.$$$reportNull$$$0(6);
            }
            this(parent, message, title, options, defaultOptionIndex, -1, icon, canBeParent);
        }

        MessageDialog(@NotNull Component parent, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String[] options, int defaultOptionIndex, int focusedOptionIndex, @Nullable Icon icon, boolean canBeParent) {
            if (parent == null) {
                MessageDialog.$$$reportNull$$$0(7);
            }
            if (options == null) {
                MessageDialog.$$$reportNull$$$0(8);
            }
            super(parent, canBeParent);
            this._init(title, message, options, defaultOptionIndex, focusedOptionIndex, icon, null);
        }

        MessageDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String[] options, int defaultOptionIndex, @Nullable Icon icon) {
            if (options == null) {
                MessageDialog.$$$reportNull$$$0(9);
            }
            this(message, title, options, defaultOptionIndex, icon, false);
        }

        MessageDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String[] options, int defaultOptionIndex, @Nullable Icon icon, boolean canBeParent) {
            if (options == null) {
                MessageDialog.$$$reportNull$$$0(10);
            }
            super(canBeParent);
            this._init(title, message, options, defaultOptionIndex, -1, icon, null);
        }

        MessageDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String[] options, int defaultOptionIndex, int focusedOptionIndex, @Nullable Icon icon, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
            if (options == null) {
                MessageDialog.$$$reportNull$$$0(11);
            }
            super(false);
            this._init(title, message, options, defaultOptionIndex, focusedOptionIndex, icon, doNotAskOption);
        }

        MessageDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String[] options, int defaultOptionIndex, Icon icon, DialogWrapper.DoNotAskOption doNotAskOption) {
            if (options == null) {
                MessageDialog.$$$reportNull$$$0(12);
            }
            this(message, title, options, defaultOptionIndex, -1, icon, doNotAskOption);
        }

        MessageDialog() {
            super(false);
        }

        MessageDialog(Project project) {
            super(project, false);
        }

        MessageDialog(Project project, boolean canBeParent) {
            super(project, canBeParent);
        }

        protected void _init(@Nls(capitalization=Nls.Capitalization.Title) String title, String message, @NotNull String[] options, int defaultOptionIndex, int focusedOptionIndex, @Nullable Icon icon, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
            if (options == null) {
                MessageDialog.$$$reportNull$$$0(13);
            }
            this.setTitle(title);
            if (Messages.isMacSheetEmulation()) {
                this.setUndecorated(true);
            }
            this.myMessage = message;
            this.myOptions = options;
            this.myDefaultOptionIndex = defaultOptionIndex;
            this.myFocusedOptionIndex = focusedOptionIndex;
            this.myIcon = icon;
            if (!SystemInfo.isMac) {
                this.setButtonsAlignment(0);
            }
            this.setDoNotAskOption(doNotAskOption);
            this.init();
            if (Messages.isMacSheetEmulation()) {
                MacUtil.adjustFocusTraversal((Disposable)this.myDisposable);
            }
        }

        @Override
        @NotNull
        protected Action[] createActions() {
            Action[] actions = new Action[this.myOptions.length];
            for (int i = 0; i < this.myOptions.length; ++i) {
                String option = this.myOptions[i];
                final int exitCode = i;
                actions[i] = new AbstractAction(UIUtil.replaceMnemonicAmpersand((String)option)){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.close(exitCode, true);
                    }
                };
                if (i == this.myDefaultOptionIndex) {
                    actions[i].putValue("DefaultAction", Boolean.TRUE);
                }
                if (i == this.myFocusedOptionIndex) {
                    actions[i].putValue("FocusedAction", Boolean.TRUE);
                }
                UIUtil.assignMnemonic((String)option, (Action)actions[i]);
            }
            if (actions == null) {
                MessageDialog.$$$reportNull$$$0(14);
            }
            return actions;
        }

        @Override
        public void doCancelAction() {
            this.close(-1);
        }

        @Override
        protected JComponent createCenterPanel() {
            return this.doCreateCenterPanel();
        }

        @Override
        @NotNull
        LayoutManager createRootLayout() {
            LayoutManager layoutManager;
            if (Messages.isMacSheetEmulation()) {
                this.myLayout = new MyBorderLayout();
                layoutManager = this.myLayout;
            } else {
                layoutManager = super.createRootLayout();
            }
            if (layoutManager == null) {
                MessageDialog.$$$reportNull$$$0(15);
            }
            return layoutManager;
        }

        @Override
        protected void dispose() {
            if (Messages.isMacSheetEmulation()) {
                this.animate();
            } else {
                super.dispose();
            }
        }

        @Override
        public void show() {
            if (Messages.isMacSheetEmulation()) {
                this.setInitialLocationCallback((Computable<Point>)((Computable)() -> {
                    JRootPane rootPane = SwingUtilities.getRootPane(this.getWindow().getParent());
                    if (rootPane == null) {
                        rootPane = SwingUtilities.getRootPane(this.getWindow().getOwner());
                    }
                    Point p = rootPane.getLocationOnScreen();
                    p.x += (rootPane.getWidth() - this.getWindow().getWidth()) / 2;
                    return p;
                }));
                this.animate();
                try {
                    Class.forName("java.awt.Window").getDeclaredMethod("setOpacity", Float.TYPE).invoke((Object)this.getPeer().getWindow(), Float.valueOf(0.8f));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.setAutoAdjustable(false);
                this.setSize(this.getPreferredSize().width, 0);
            }
            super.show();
        }

        private void animate() {
            final int height = this.getPreferredSize().height;
            int frameCount = 10;
            final boolean toClose = this.isShowing();
            final AtomicInteger i = new AtomicInteger(-1);
            final Alarm animator = new Alarm(this.myDisposable);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    int state = i.addAndGet(1);
                    double linearProgress = (double)state / 10.0;
                    if (toClose) {
                        linearProgress = 1.0 - linearProgress;
                    }
                    myLayout.myPhase = (1.0 - Math.cos(Math.PI * linearProgress)) / 2.0;
                    Window window = this.getPeer().getWindow();
                    Rectangle bounds = window.getBounds();
                    bounds.height = (int)((double)height * myLayout.myPhase);
                    window.setBounds(bounds);
                    if (state == 0 && !toClose && window.getOwner() instanceof IdeFrame) {
                        WindowManager.getInstance().requestUserAttention((IdeFrame)((Object)window.getOwner()), true);
                    }
                    if (state < 10) {
                        animator.addRequest((Runnable)this, 10);
                    } else if (toClose) {
                        MessageDialog.super.dispose();
                    }
                }
            };
            animator.addRequest(runnable, 10, ModalityState.stateForComponent(this.getRootPane()));
        }

        protected JComponent doCreateCenterPanel() {
            JPanel panel = this.createIconPanel();
            if (this.myMessage != null) {
                JTextPane messageComponent = MessageDialog.createMessageComponent(this.myMessage);
                panel.add((Component)Messages.wrapToScrollPaneIfNeeded(messageComponent, 100, 10), "Center");
            }
            return panel;
        }

        @NotNull
        protected JPanel createIconPanel() {
            JPanel panel = new JPanel(new BorderLayout(15, 0));
            if (this.myIcon != null) {
                JLabel iconLabel = new JLabel(this.myIcon);
                Container container = new Container();
                container.setLayout(new BorderLayout());
                container.add((Component)iconLabel, "North");
                panel.add((Component)container, "West");
            }
            JPanel jPanel = panel;
            if (jPanel == null) {
                MessageDialog.$$$reportNull$$$0(16);
            }
            return jPanel;
        }

        @NotNull
        protected JPanel createMessagePanel() {
            JPanel messagePanel = new JPanel(new BorderLayout());
            if (this.myMessage != null) {
                JLabel textLabel = new JLabel(this.myMessage);
                textLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
                textLabel.setUI(new MultiLineLabelUI());
                messagePanel.add((Component)textLabel, "North");
            }
            JPanel jPanel = messagePanel;
            if (jPanel == null) {
                MessageDialog.$$$reportNull$$$0(17);
            }
            return jPanel;
        }

        protected static JTextPane createMessageComponent(String message) {
            JTextPane messageComponent = new JTextPane();
            return Messages.configureMessagePaneUi(messageComponent, message);
        }

        @Override
        protected void doHelpAction() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "options";
                    break;
                }
                case 3: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/ui/Messages$MessageDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/ui/Messages$MessageDialog";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createActions";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createRootLayout";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createIconPanel";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createMessagePanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "_init";
                    break;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MoreInfoMessageDialog
    extends MessageDialog {
        @Nullable
        private final String myInfoText;

        MoreInfoMessageDialog(Project project, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable String moreInfo, @NotNull String[] options, int defaultOptionIndex, int focusedOptionIndex, Icon icon) {
            if (options == null) {
                MoreInfoMessageDialog.$$$reportNull$$$0(0);
            }
            super(project);
            this.myInfoText = moreInfo;
            this._init(title, message, options, defaultOptionIndex, focusedOptionIndex, icon, null);
        }

        @Override
        protected JComponent createNorthPanel() {
            return this.doCreateCenterPanel();
        }

        @Override
        protected JComponent createCenterPanel() {
            if (this.myInfoText == null) {
                return null;
            }
            JPanel panel = new JPanel(new BorderLayout());
            JTextArea area = new JTextArea(this.myInfoText);
            area.setEditable(false);
            JBScrollPane scrollPane = new JBScrollPane(area){

                @Override
                public Dimension getPreferredSize() {
                    Dimension preferredSize = super.getPreferredSize();
                    Container parent = this.getParent();
                    if (parent != null) {
                        return new Dimension(preferredSize.width, Math.min(150, preferredSize.height));
                    }
                    return preferredSize;
                }
            };
            panel.add(scrollPane);
            return panel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/openapi/ui/Messages$MoreInfoMessageDialog", "<init>"));
        }
    }

    public static @interface YesNoCancelResult {
    }

    public static @interface OkCancelResult {
    }

    public static @interface YesNoResult {
    }
}

