/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.actions.layout;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.anim.AnimationFactory;
import com.intellij.openapi.graph.anim.AnimationPlayer;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.actions.AbstractGraphAction;
import com.intellij.openapi.graph.builder.actions.AbstractGraphToggleAction;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.layout.GraphLayout;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.settings.GraphSettings;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.LayoutMorpher;
import com.intellij.openapi.project.Project;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractLayoutAction
extends AbstractGraphToggleAction {
    protected AbstractLayoutAction() {
        super((Icon)null);
    }

    protected AbstractLayoutAction(Graph2D graph) {
        super(graph, null);
    }

    @Override
    protected boolean isSelected(Graph2D graph, Project project, AnActionEvent event) {
        GraphBuilder builder = this.getBuilder(event);
        if (builder == null) {
            return false;
        }
        return builder.getGraphPresentationModel().getSettings().getCurrentLayouter() == this.getLayouter(project);
    }

    @Override
    protected void setSelected(Graph2D graph, boolean state, Project project, AnActionEvent e) {
        Graph2DView view = AbstractGraphAction.getGraph2DView(graph);
        Layouter layouter = this.getLayouter(project);
        GraphBuilder builder = this.getBuilder(e);
        if (builder != null) {
            GraphSettings settings = builder.getGraphPresentationModel().getSettings();
            settings.setCurrentLayouter(layouter);
            AbstractLayoutAction.doLayout(view, layouter, project, settings);
        }
    }

    @Override
    protected String getText(@NotNull Graph2D graph) {
        if (graph == null) {
            AbstractLayoutAction.$$$reportNull$$$0(0);
        }
        return this.getLayoutName();
    }

    public static void doLayout(Graph2DView view, Layouter layouter, Project project, @NotNull GraphSettings settings) {
        if (settings == null) {
            AbstractLayoutAction.$$$reportNull$$$0(1);
        }
        if (settings.isFitContentAfterLayout()) {
            GraphManager.getGraphManager().createBufferedLayouter(layouter).doLayout(view.getGraph2D());
            view.fitContent();
        } else {
            GraphLayout layout = GraphManager.getGraphManager().createBufferedLayouter(layouter).calcLayout(view.getGraph2D());
            LayoutMorpher morpher = GraphManager.getGraphManager().createLayoutMorpher(view, layout);
            morpher.setPreferredDuration(800L);
            morpher.setKeepZoomFactor(true);
            AnimationPlayer player = GraphManager.getGraphManager().createAnimationPlayer();
            player.addAnimationListener(view);
            player.setFps(1200);
            player.animate(AnimationFactory.Statics.createEasedAnimation(morpher));
            GraphViewUtil.updateWorldRect(view);
        }
        view.getGraph2D().updateViews();
    }

    @Override
    protected boolean isEnabled(Graph2D graph, Project project, AnActionEvent event) {
        return graph.getNodeArray().length > 0 && this.getLayouter(project).canLayout(graph);
    }

    protected abstract Layouter getLayouter(Project var1);

    protected abstract String getLayoutName();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/graph/builder/actions/layout/AbstractLayoutAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "doLayout";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

