/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.util;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.PathExecLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecUtil {
    private static final NotNullLazyValue<Boolean> hasGkSudo = new PathExecLazyValue("gksudo");
    private static final NotNullLazyValue<Boolean> hasKdeSudo = new PathExecLazyValue("kdesudo");
    private static final NotNullLazyValue<Boolean> hasPkExec = new PathExecLazyValue("pkexec");
    private static final NotNullLazyValue<Boolean> hasGnomeTerminal = new PathExecLazyValue("gnome-terminal");
    private static final NotNullLazyValue<Boolean> hasKdeTerminal = new PathExecLazyValue("konsole");
    private static final NotNullLazyValue<Boolean> hasXTerm = new PathExecLazyValue("xterm");

    private ExecUtil() {
    }

    @NotNull
    public static String loadTemplate(@NotNull ClassLoader loader, @NotNull String templateName, @Nullable Map<String, String> variables) throws IOException {
        InputStream stream;
        if (loader == null) {
            ExecUtil.$$$reportNull$$$0(0);
        }
        if (templateName == null) {
            ExecUtil.$$$reportNull$$$0(1);
        }
        if ((stream = loader.getResourceAsStream(templateName)) == null) {
            throw new IOException("Template '" + templateName + "' not found by " + loader);
        }
        String template = FileUtil.loadTextAndClose((Reader)new InputStreamReader(stream, "UTF-8"));
        if (variables == null || variables.size() == 0) {
            String string = template;
            if (string == null) {
                ExecUtil.$$$reportNull$$$0(2);
            }
            return string;
        }
        StringBuilder buffer = new StringBuilder(template);
        for (Map.Entry<String, String> var : variables.entrySet()) {
            String name = var.getKey();
            int pos = buffer.indexOf(name);
            if (pos < 0) continue;
            buffer.replace(pos, pos + name.length(), var.getValue());
        }
        String string = buffer.toString();
        if (string == null) {
            ExecUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static File createTempExecutableScript(@NotNull String prefix, @NotNull String suffix, @NotNull String content) throws IOException, ExecutionException {
        if (prefix == null) {
            ExecUtil.$$$reportNull$$$0(4);
        }
        if (suffix == null) {
            ExecUtil.$$$reportNull$$$0(5);
        }
        if (content == null) {
            ExecUtil.$$$reportNull$$$0(6);
        }
        File tempDir = new File(PathManager.getTempPath());
        File tempFile = FileUtil.createTempFile((File)tempDir, (String)prefix, (String)suffix, (boolean)true, (boolean)true);
        FileUtil.writeToFile((File)tempFile, (byte[])content.getBytes("UTF-8"));
        if (!tempFile.setExecutable(true, true)) {
            throw new ExecutionException("Failed to make temp file executable: " + tempFile);
        }
        File file = tempFile;
        if (file == null) {
            ExecUtil.$$$reportNull$$$0(7);
        }
        return file;
    }

    @NotNull
    public static String getOsascriptPath() {
        if ("/usr/bin/osascript" == null) {
            ExecUtil.$$$reportNull$$$0(8);
        }
        return "/usr/bin/osascript";
    }

    @NotNull
    public static String getOpenCommandPath() {
        if ("/usr/bin/open" == null) {
            ExecUtil.$$$reportNull$$$0(9);
        }
        return "/usr/bin/open";
    }

    @NotNull
    public static String getWindowsShellName() {
        String string = CommandLineUtil.getWinShellName();
        if (string == null) {
            ExecUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public static ProcessOutput execAndGetOutput(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            ExecUtil.$$$reportNull$$$0(11);
        }
        ProcessOutput processOutput = new CapturingProcessHandler(commandLine).runProcess();
        if (processOutput == null) {
            ExecUtil.$$$reportNull$$$0(12);
        }
        return processOutput;
    }

    @NotNull
    public static ProcessOutput execAndGetOutput(@NotNull GeneralCommandLine commandLine, int timeoutInMilliseconds) throws ExecutionException {
        if (commandLine == null) {
            ExecUtil.$$$reportNull$$$0(13);
        }
        ProcessOutput processOutput = new CapturingProcessHandler(commandLine).runProcess(timeoutInMilliseconds);
        if (processOutput == null) {
            ExecUtil.$$$reportNull$$$0(14);
        }
        return processOutput;
    }

    @Nullable
    public static String execAndReadLine(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            ExecUtil.$$$reportNull$$$0(15);
        }
        try {
            return ExecUtil.readFirstLine(commandLine.createProcess().getInputStream(), commandLine.getCharset());
        }
        catch (ExecutionException e) {
            Logger.getInstance(ExecUtil.class).debug((Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static String readFirstLine(@NotNull InputStream stream, @Nullable Charset cs) {
        if (stream == null) {
            ExecUtil.$$$reportNull$$$0(16);
        }
        try (BufferedReader reader = new BufferedReader(cs == null ? new InputStreamReader(stream) : new InputStreamReader(stream, cs));){
            String string = reader.readLine();
            return string;
        }
        catch (IOException e) {
            Logger.getInstance(ExecUtil.class).debug((Throwable)e);
            return null;
        }
    }

    @NotNull
    public static Process sudo(@NotNull GeneralCommandLine commandLine, @NotNull String prompt) throws ExecutionException, IOException {
        if (commandLine == null) {
            ExecUtil.$$$reportNull$$$0(17);
        }
        if (prompt == null) {
            ExecUtil.$$$reportNull$$$0(18);
        }
        Process process = ExecUtil.sudoCommand(commandLine, prompt).createProcess();
        if (process == null) {
            ExecUtil.$$$reportNull$$$0(19);
        }
        return process;
    }

    @NotNull
    private static GeneralCommandLine sudoCommand(@NotNull GeneralCommandLine commandLine, @NotNull String prompt) throws ExecutionException, IOException {
        GeneralCommandLine sudoCommandLine;
        if (commandLine == null) {
            ExecUtil.$$$reportNull$$$0(20);
        }
        if (prompt == null) {
            ExecUtil.$$$reportNull$$$0(21);
        }
        if (SystemInfo.isUnix && "root".equals(System.getenv("USER"))) {
            GeneralCommandLine generalCommandLine = commandLine;
            if (generalCommandLine == null) {
                ExecUtil.$$$reportNull$$$0(22);
            }
            return generalCommandLine;
        }
        ArrayList command = ContainerUtil.newArrayList();
        command.add(commandLine.getExePath());
        command.addAll(commandLine.getParametersList().getList());
        if (SystemInfo.isWinVistaOrNewer) {
            File launcherExe = PathManager.findBinFileWithException((String)"launcher.exe");
            sudoCommandLine = new GeneralCommandLine(launcherExe.getPath());
            sudoCommandLine.setWorkDirectory(commandLine.getWorkDirectory());
            sudoCommandLine.addParameter(commandLine.getExePath());
            sudoCommandLine.addParameters(commandLine.getParametersList().getParameters());
            sudoCommandLine.getEnvironment().putAll(commandLine.getEffectiveEnvironment());
        } else if (SystemInfo.isMac) {
            String escapedCommandLine = StringUtil.join((Collection)command, ExecUtil::escapeAppleScriptArgument, (String)" & \" \" & ");
            String escapedScript = "tell current application\n   activate\n   do shell script " + escapedCommandLine + " with administrator privileges without altering line endings\nend tell";
            sudoCommandLine = new GeneralCommandLine(ExecUtil.getOsascriptPath(), "-e", escapedScript);
        } else if (((Boolean)hasGkSudo.getValue()).booleanValue()) {
            ArrayList sudoCommand = ContainerUtil.newArrayList();
            sudoCommand.addAll(Arrays.asList("gksudo", "--message", prompt, "--"));
            sudoCommand.addAll(command);
            sudoCommandLine = new GeneralCommandLine(sudoCommand);
        } else if (((Boolean)hasKdeSudo.getValue()).booleanValue()) {
            ArrayList sudoCommand = ContainerUtil.newArrayList();
            sudoCommand.addAll(Arrays.asList("kdesudo", "--comment", prompt, "--"));
            sudoCommand.addAll(command);
            sudoCommandLine = new GeneralCommandLine(sudoCommand);
        } else if (((Boolean)hasPkExec.getValue()).booleanValue()) {
            command.add(0, "pkexec");
            sudoCommandLine = new GeneralCommandLine(command);
        } else if (SystemInfo.isUnix && ExecUtil.hasTerminalApp()) {
            String escapedCommandLine = StringUtil.join((Collection)command, ExecUtil::escapeUnixShellArgument, (String)" ");
            File script = ExecUtil.createTempExecutableScript("sudo", ".sh", "#!/bin/sh\necho " + ExecUtil.escapeUnixShellArgument(prompt) + "\necho\nsudo -- " + escapedCommandLine + "\nSTATUS=$?\necho\nread -p \"Press Enter to close this window...\" TEMP\nexit $STATUS\n");
            sudoCommandLine = new GeneralCommandLine(ExecUtil.getTerminalCommand("Install", script.getAbsolutePath()));
        } else {
            throw new UnsupportedOperationException("Unsupported OS/desktop: " + SystemInfo.OS_NAME + '/' + SystemInfo.SUN_DESKTOP);
        }
        GeneralCommandLine generalCommandLine = sudoCommandLine.withWorkDirectory(commandLine.getWorkDirectory()).withEnvironment(commandLine.getEnvironment()).withParentEnvironmentType(commandLine.getParentEnvironmentType()).withRedirectErrorStream(commandLine.isRedirectErrorStream());
        if (generalCommandLine == null) {
            ExecUtil.$$$reportNull$$$0(23);
        }
        return generalCommandLine;
    }

    @NotNull
    public static ProcessOutput sudoAndGetOutput(@NotNull GeneralCommandLine commandLine, @NotNull String prompt) throws IOException, ExecutionException {
        if (commandLine == null) {
            ExecUtil.$$$reportNull$$$0(24);
        }
        if (prompt == null) {
            ExecUtil.$$$reportNull$$$0(25);
        }
        ProcessOutput processOutput = ExecUtil.execAndGetOutput(ExecUtil.sudoCommand(commandLine, prompt));
        if (processOutput == null) {
            ExecUtil.$$$reportNull$$$0(26);
        }
        return processOutput;
    }

    @NotNull
    private static String escapeAppleScriptArgument(@NotNull String arg) {
        if (arg == null) {
            ExecUtil.$$$reportNull$$$0(27);
        }
        String string = "quoted form of \"" + arg.replace("\"", "\\\"") + "\"";
        if (string == null) {
            ExecUtil.$$$reportNull$$$0(28);
        }
        return string;
    }

    @NotNull
    public static String escapeUnixShellArgument(@NotNull String arg) {
        if (arg == null) {
            ExecUtil.$$$reportNull$$$0(29);
        }
        String string = "'" + arg.replace("'", "'\"'\"'") + "'";
        if (string == null) {
            ExecUtil.$$$reportNull$$$0(30);
        }
        return string;
    }

    public static boolean hasTerminalApp() {
        return SystemInfo.isWindows || SystemInfo.isMac || (Boolean)hasKdeTerminal.getValue() != false || (Boolean)hasGnomeTerminal.getValue() != false || (Boolean)hasXTerm.getValue() != false;
    }

    @NotNull
    public static List<String> getTerminalCommand(@Nullable String title, @NotNull String command) {
        if (command == null) {
            ExecUtil.$$$reportNull$$$0(31);
        }
        if (SystemInfo.isWindows) {
            title = title != null ? title.replace('\"', '\'') : "";
            List<String> list = Arrays.asList(ExecUtil.getWindowsShellName(), "/c", "start", GeneralCommandLine.inescapableQuote(title), command);
            if (list == null) {
                ExecUtil.$$$reportNull$$$0(32);
            }
            return list;
        }
        if (SystemInfo.isMac) {
            List<String> list = Arrays.asList(ExecUtil.getOpenCommandPath(), "-a", "Terminal", command);
            if (list == null) {
                ExecUtil.$$$reportNull$$$0(33);
            }
            return list;
        }
        if (((Boolean)hasKdeTerminal.getValue()).booleanValue()) {
            List<String> list = title != null ? Arrays.asList("konsole", "-p", "tabtitle=\"" + title.replace('\"', '\'') + "\"", "-e", command) : Arrays.asList("konsole", "-e", command);
            if (list == null) {
                ExecUtil.$$$reportNull$$$0(34);
            }
            return list;
        }
        if (((Boolean)hasGnomeTerminal.getValue()).booleanValue()) {
            List<String> list = title != null ? Arrays.asList("gnome-terminal", "-t", title, "-x", command) : Arrays.asList("gnome-terminal", "-x", command);
            if (list == null) {
                ExecUtil.$$$reportNull$$$0(35);
            }
            return list;
        }
        if (((Boolean)hasXTerm.getValue()).booleanValue()) {
            List<String> list = title != null ? Arrays.asList("xterm", "-T", title, "-e", command) : Arrays.asList("xterm", "-e", command);
            if (list == null) {
                ExecUtil.$$$reportNull$$$0(36);
            }
            return list;
        }
        throw new UnsupportedOperationException("Unsupported OS/desktop: " + SystemInfo.OS_NAME + '/' + SystemInfo.SUN_DESKTOP);
    }

    public static int execAndGetResult(String ... command) throws ExecutionException, InterruptedException {
        assert (command != null && command.length > 0);
        return new GeneralCommandLine(command).createProcess().waitFor();
    }

    public static int execAndGetResult(@NotNull List<String> command) throws ExecutionException, InterruptedException {
        if (command == null) {
            ExecUtil.$$$reportNull$$$0(37);
        }
        return new GeneralCommandLine(command).createProcess().waitFor();
    }

    public static ProcessOutput execAndGetOutput(@NotNull List<String> command, @Nullable String workDir) throws ExecutionException {
        if (command == null) {
            ExecUtil.$$$reportNull$$$0(38);
        }
        GeneralCommandLine commandLine = new GeneralCommandLine(command).withWorkDirectory(workDir);
        return new CapturingProcessHandler(commandLine).runProcess();
    }

    public static String execAndReadLine(String ... command) {
        return ExecUtil.execAndReadLine(new GeneralCommandLine(command));
    }

    public static String execAndReadLine(@Nullable Charset charset, String ... command) {
        GeneralCommandLine commandLine = new GeneralCommandLine(command);
        if (charset != null) {
            commandLine = commandLine.withCharset(charset);
        }
        return ExecUtil.execAndReadLine(commandLine);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 19: 
            case 22: 
            case 23: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 19: 
            case 22: 
            case 23: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateName";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 19: 
            case 22: 
            case 23: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/util/ExecUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 18: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prompt";
                break;
            }
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg";
                break;
            }
            case 31: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/util/ExecUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "loadTemplate";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempExecutableScript";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOsascriptPath";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpenCommandPath";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getWindowsShellName";
                break;
            }
            case 12: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "execAndGetOutput";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "sudo";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "sudoCommand";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "sudoAndGetOutput";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeAppleScriptArgument";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeUnixShellArgument";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getTerminalCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadTemplate";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 19: 
            case 22: 
            case 23: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createTempExecutableScript";
                break;
            }
            case 11: 
            case 13: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "execAndGetOutput";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "execAndReadLine";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "readFirstLine";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "sudo";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "sudoCommand";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "sudoAndGetOutput";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "escapeAppleScriptArgument";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "escapeUnixShellArgument";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getTerminalCommand";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "execAndGetResult";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 19: 
            case 22: 
            case 23: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

