/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Platform;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneralCommandLine
implements UserDataHolder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.configurations.GeneralCommandLine");
    private String myExePath;
    private File myWorkDirectory;
    private final Map<String, String> myEnvParams;
    private ParentEnvironmentType myParentEnvironmentType;
    private final ParametersList myProgramParams;
    private Charset myCharset;
    private boolean myRedirectErrorStream;
    private File myInputFile;
    private Map<Object, Object> myUserData;

    public GeneralCommandLine() {
        this.myEnvParams = new MyTHashMap();
        this.myParentEnvironmentType = ParentEnvironmentType.CONSOLE;
        this.myProgramParams = new ParametersList();
        this.myCharset = CharsetToolkit.getDefaultSystemCharset();
        this.myRedirectErrorStream = false;
    }

    public GeneralCommandLine(String ... command) {
        if (command == null) {
            GeneralCommandLine.$$$reportNull$$$0(0);
        }
        this(Arrays.asList(command));
    }

    public GeneralCommandLine(@NotNull List<String> command) {
        if (command == null) {
            GeneralCommandLine.$$$reportNull$$$0(1);
        }
        this.myEnvParams = new MyTHashMap();
        this.myParentEnvironmentType = ParentEnvironmentType.CONSOLE;
        this.myProgramParams = new ParametersList();
        this.myCharset = CharsetToolkit.getDefaultSystemCharset();
        this.myRedirectErrorStream = false;
        int size = command.size();
        if (size > 0) {
            this.setExePath(command.get(0));
            if (size > 1) {
                this.addParameters(command.subList(1, size));
            }
        }
    }

    @NotNull
    public String getExePath() {
        String string = this.myExePath;
        if (string == null) {
            GeneralCommandLine.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public GeneralCommandLine withExePath(@NotNull String exePath) {
        if (exePath == null) {
            GeneralCommandLine.$$$reportNull$$$0(3);
        }
        this.myExePath = exePath.trim();
        GeneralCommandLine generalCommandLine = this;
        if (generalCommandLine == null) {
            GeneralCommandLine.$$$reportNull$$$0(4);
        }
        return generalCommandLine;
    }

    public void setExePath(@NotNull String exePath) {
        if (exePath == null) {
            GeneralCommandLine.$$$reportNull$$$0(5);
        }
        this.withExePath(exePath);
    }

    public File getWorkDirectory() {
        return this.myWorkDirectory;
    }

    @NotNull
    public GeneralCommandLine withWorkDirectory(@Nullable String path2) {
        GeneralCommandLine generalCommandLine = this.withWorkDirectory(path2 != null ? new File(path2) : null);
        if (generalCommandLine == null) {
            GeneralCommandLine.$$$reportNull$$$0(6);
        }
        return generalCommandLine;
    }

    @NotNull
    public GeneralCommandLine withWorkDirectory(@Nullable File workDirectory) {
        this.myWorkDirectory = workDirectory;
        GeneralCommandLine generalCommandLine = this;
        if (generalCommandLine == null) {
            GeneralCommandLine.$$$reportNull$$$0(7);
        }
        return generalCommandLine;
    }

    public void setWorkDirectory(@Nullable String path2) {
        this.withWorkDirectory(path2);
    }

    public void setWorkDirectory(@Nullable File workDirectory) {
        this.withWorkDirectory(workDirectory);
    }

    @NotNull
    public Map<String, String> getEnvironment() {
        Map<String, String> map = this.myEnvParams;
        if (map == null) {
            GeneralCommandLine.$$$reportNull$$$0(8);
        }
        return map;
    }

    @NotNull
    public GeneralCommandLine withEnvironment(@Nullable Map<String, String> environment) {
        if (environment != null) {
            this.getEnvironment().putAll(environment);
        }
        GeneralCommandLine generalCommandLine = this;
        if (generalCommandLine == null) {
            GeneralCommandLine.$$$reportNull$$$0(9);
        }
        return generalCommandLine;
    }

    @NotNull
    public GeneralCommandLine withEnvironment(@NotNull String key, @NotNull String value) {
        if (key == null) {
            GeneralCommandLine.$$$reportNull$$$0(10);
        }
        if (value == null) {
            GeneralCommandLine.$$$reportNull$$$0(11);
        }
        this.getEnvironment().put(key, value);
        GeneralCommandLine generalCommandLine = this;
        if (generalCommandLine == null) {
            GeneralCommandLine.$$$reportNull$$$0(12);
        }
        return generalCommandLine;
    }

    public boolean isPassParentEnvironment() {
        return this.myParentEnvironmentType != ParentEnvironmentType.NONE;
    }

    public void setPassParentEnvironment(boolean passParentEnvironment) {
        this.withParentEnvironmentType(passParentEnvironment ? ParentEnvironmentType.CONSOLE : ParentEnvironmentType.NONE);
    }

    @NotNull
    public ParentEnvironmentType getParentEnvironmentType() {
        ParentEnvironmentType parentEnvironmentType = this.myParentEnvironmentType;
        if (parentEnvironmentType == null) {
            GeneralCommandLine.$$$reportNull$$$0(13);
        }
        return parentEnvironmentType;
    }

    @NotNull
    public GeneralCommandLine withParentEnvironmentType(@NotNull ParentEnvironmentType type) {
        if (type == null) {
            GeneralCommandLine.$$$reportNull$$$0(14);
        }
        this.myParentEnvironmentType = type;
        GeneralCommandLine generalCommandLine = this;
        if (generalCommandLine == null) {
            GeneralCommandLine.$$$reportNull$$$0(15);
        }
        return generalCommandLine;
    }

    @NotNull
    public Map<String, String> getParentEnvironment() {
        switch (this.myParentEnvironmentType) {
            case SYSTEM: {
                Map<String, String> map = System.getenv();
                if (map == null) {
                    GeneralCommandLine.$$$reportNull$$$0(16);
                }
                return map;
            }
            case CONSOLE: {
                Map map = EnvironmentUtil.getEnvironmentMap();
                if (map == null) {
                    GeneralCommandLine.$$$reportNull$$$0(17);
                }
                return map;
            }
        }
        Map<String, String> map = Collections.emptyMap();
        if (map == null) {
            GeneralCommandLine.$$$reportNull$$$0(18);
        }
        return map;
    }

    @NotNull
    public Map<String, String> getEffectiveEnvironment() {
        MyTHashMap env = new MyTHashMap();
        this.setupEnvironment((Map<String, String>)((Object)env));
        MyTHashMap myTHashMap = env;
        if (myTHashMap == null) {
            GeneralCommandLine.$$$reportNull$$$0(19);
        }
        return myTHashMap;
    }

    public void addParameters(String ... parameters) {
        if (parameters == null) {
            GeneralCommandLine.$$$reportNull$$$0(20);
        }
        this.withParameters(parameters);
    }

    public void addParameters(@NotNull List<String> parameters) {
        if (parameters == null) {
            GeneralCommandLine.$$$reportNull$$$0(21);
        }
        this.withParameters(parameters);
    }

    @NotNull
    public GeneralCommandLine withParameters(String ... parameters) {
        if (parameters == null) {
            GeneralCommandLine.$$$reportNull$$$0(22);
        }
        for (String parameter : parameters) {
            this.addParameter(parameter);
        }
        GeneralCommandLine generalCommandLine = this;
        if (generalCommandLine == null) {
            GeneralCommandLine.$$$reportNull$$$0(23);
        }
        return generalCommandLine;
    }

    @NotNull
    public GeneralCommandLine withParameters(@NotNull List<String> parameters) {
        if (parameters == null) {
            GeneralCommandLine.$$$reportNull$$$0(24);
        }
        for (String parameter : parameters) {
            this.addParameter(parameter);
        }
        GeneralCommandLine generalCommandLine = this;
        if (generalCommandLine == null) {
            GeneralCommandLine.$$$reportNull$$$0(25);
        }
        return generalCommandLine;
    }

    public void addParameter(@NotNull String parameter) {
        if (parameter == null) {
            GeneralCommandLine.$$$reportNull$$$0(26);
        }
        this.myProgramParams.add(parameter);
    }

    @NotNull
    public ParametersList getParametersList() {
        ParametersList parametersList = this.myProgramParams;
        if (parametersList == null) {
            GeneralCommandLine.$$$reportNull$$$0(27);
        }
        return parametersList;
    }

    @NotNull
    public Charset getCharset() {
        Charset charset = this.myCharset;
        if (charset == null) {
            GeneralCommandLine.$$$reportNull$$$0(28);
        }
        return charset;
    }

    @NotNull
    public GeneralCommandLine withCharset(@NotNull Charset charset) {
        if (charset == null) {
            GeneralCommandLine.$$$reportNull$$$0(29);
        }
        this.myCharset = charset;
        GeneralCommandLine generalCommandLine = this;
        if (generalCommandLine == null) {
            GeneralCommandLine.$$$reportNull$$$0(30);
        }
        return generalCommandLine;
    }

    public void setCharset(@NotNull Charset charset) {
        if (charset == null) {
            GeneralCommandLine.$$$reportNull$$$0(31);
        }
        this.withCharset(charset);
    }

    public boolean isRedirectErrorStream() {
        return this.myRedirectErrorStream;
    }

    @NotNull
    public GeneralCommandLine withRedirectErrorStream(boolean redirectErrorStream) {
        this.myRedirectErrorStream = redirectErrorStream;
        GeneralCommandLine generalCommandLine = this;
        if (generalCommandLine == null) {
            GeneralCommandLine.$$$reportNull$$$0(32);
        }
        return generalCommandLine;
    }

    public void setRedirectErrorStream(boolean redirectErrorStream) {
        this.withRedirectErrorStream(redirectErrorStream);
    }

    @NotNull
    public GeneralCommandLine withInput(@Nullable File file) {
        this.myInputFile = file;
        GeneralCommandLine generalCommandLine = this;
        if (generalCommandLine == null) {
            GeneralCommandLine.$$$reportNull$$$0(33);
        }
        return generalCommandLine;
    }

    @NotNull
    public String getCommandLineString() {
        String string = this.getCommandLineString(null);
        if (string == null) {
            GeneralCommandLine.$$$reportNull$$$0(34);
        }
        return string;
    }

    @NotNull
    public String getCommandLineString(@Nullable String exeName) {
        String string = ParametersList.join(this.getCommandLineList(exeName));
        if (string == null) {
            GeneralCommandLine.$$$reportNull$$$0(35);
        }
        return string;
    }

    @NotNull
    public List<String> getCommandLineList(@Nullable String exeName) {
        ArrayList<String> commands = new ArrayList<String>();
        if (exeName != null) {
            commands.add(exeName);
        } else if (this.myExePath != null) {
            commands.add(this.myExePath);
        } else {
            commands.add("<null>");
        }
        commands.addAll(this.myProgramParams.getList());
        ArrayList<String> arrayList = commands;
        if (arrayList == null) {
            GeneralCommandLine.$$$reportNull$$$0(36);
        }
        return arrayList;
    }

    @NotNull
    public String getPreparedCommandLine() {
        String string = this.getPreparedCommandLine(Platform.current());
        if (string == null) {
            GeneralCommandLine.$$$reportNull$$$0(37);
        }
        return string;
    }

    @NotNull
    public String getPreparedCommandLine(@NotNull Platform platform) {
        if (platform == null) {
            GeneralCommandLine.$$$reportNull$$$0(38);
        }
        String exePath = this.myExePath != null ? this.myExePath : "";
        String string = StringUtil.join(this.prepareCommandLine(exePath, this.myProgramParams.getList(), platform), (String)"\n");
        if (string == null) {
            GeneralCommandLine.$$$reportNull$$$0(39);
        }
        return string;
    }

    @NotNull
    protected List<String> prepareCommandLine(@NotNull String command, @NotNull List<String> parameters, @NotNull Platform platform) {
        if (command == null) {
            GeneralCommandLine.$$$reportNull$$$0(40);
        }
        if (parameters == null) {
            GeneralCommandLine.$$$reportNull$$$0(41);
        }
        if (platform == null) {
            GeneralCommandLine.$$$reportNull$$$0(42);
        }
        List list = CommandLineUtil.toCommandLine((String)command, parameters, (Platform)platform);
        if (list == null) {
            GeneralCommandLine.$$$reportNull$$$0(43);
        }
        return list;
    }

    @NotNull
    public Process createProcess() throws ExecutionException {
        Process process;
        File exeFile;
        String shellPath;
        String systemPath;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing [" + this.getCommandLineString() + "]");
            LOG.debug("  environment: " + this.myEnvParams + " (+" + (Object)((Object)this.myParentEnvironmentType) + ")");
            LOG.debug("  charset: " + this.myCharset);
        }
        try {
            if (this.myWorkDirectory != null) {
                if (!this.myWorkDirectory.exists()) {
                    throw new ExecutionException(IdeBundle.message("run.configuration.error.working.directory.does.not.exist", this.myWorkDirectory));
                }
                if (!this.myWorkDirectory.isDirectory()) {
                    throw new ExecutionException(IdeBundle.message("run.configuration.error.working.directory.not.directory", this.myWorkDirectory));
                }
            }
            if (StringUtil.isEmptyOrSpaces((String)this.myExePath)) {
                throw new ExecutionException(IdeBundle.message("run.configuration.error.executable.not.specified", new Object[0]));
            }
        }
        catch (ExecutionException e) {
            LOG.debug((Throwable)e);
            throw e;
        }
        String exePath = this.myExePath;
        if (SystemInfo.isMac && this.myParentEnvironmentType == ParentEnvironmentType.CONSOLE && exePath.indexOf(File.pathSeparatorChar) == -1 && !Objects.equals(systemPath = System.getenv("PATH"), shellPath = EnvironmentUtil.getValue((String)"PATH")) && (exeFile = PathEnvironmentVariableUtil.findInPath(this.myExePath, systemPath, null)) == null && (exeFile = PathEnvironmentVariableUtil.findInPath(this.myExePath, shellPath, null)) != null) {
            LOG.debug(exePath + " => " + exeFile);
            exePath = exeFile.getPath();
        }
        List<String> commands = this.prepareCommandLine(exePath, this.myProgramParams.getList(), Platform.current());
        try {
            process = this.startProcess(commands);
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
            throw new ProcessNotCreatedException(e.getMessage(), e, this);
        }
        if (process == null) {
            GeneralCommandLine.$$$reportNull$$$0(44);
        }
        return process;
    }

    @NotNull
    protected Process startProcess(@NotNull List<String> escapedCommands) throws IOException {
        if (escapedCommands == null) {
            GeneralCommandLine.$$$reportNull$$$0(45);
        }
        ProcessBuilder builder = new ProcessBuilder(escapedCommands);
        this.setupEnvironment(builder.environment());
        builder.directory(this.myWorkDirectory);
        builder.redirectErrorStream(this.myRedirectErrorStream);
        if (this.myInputFile != null) {
            builder.redirectInput(ProcessBuilder.Redirect.from(this.myInputFile));
        }
        Process process = builder.start();
        if (process == null) {
            GeneralCommandLine.$$$reportNull$$$0(46);
        }
        return process;
    }

    protected void setupEnvironment(@NotNull Map<String, String> environment) {
        File workDirectory;
        if (environment == null) {
            GeneralCommandLine.$$$reportNull$$$0(47);
        }
        environment.clear();
        if (this.myParentEnvironmentType != ParentEnvironmentType.NONE) {
            environment.putAll(this.getParentEnvironment());
        }
        if (SystemInfo.isUnix && (workDirectory = this.getWorkDirectory()) != null) {
            environment.put("PWD", FileUtil.toSystemDependentName((String)workDirectory.getAbsolutePath()));
        }
        if (!this.myEnvParams.isEmpty()) {
            if (SystemInfo.isWindows) {
                THashMap envVars = new THashMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
                envVars.putAll(environment);
                envVars.putAll(this.myEnvParams);
                environment.clear();
                environment.putAll((Map<String, String>)envVars);
            } else {
                environment.putAll(this.myEnvParams);
            }
        }
    }

    @NotNull
    public static String inescapableQuote(@NotNull String parameter) {
        if (parameter == null) {
            GeneralCommandLine.$$$reportNull$$$0(48);
        }
        String string = CommandLineUtil.specialQuote((String)parameter);
        if (string == null) {
            GeneralCommandLine.$$$reportNull$$$0(49);
        }
        return string;
    }

    public String toString() {
        return this.myExePath + " " + this.myProgramParams;
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            GeneralCommandLine.$$$reportNull$$$0(50);
        }
        if (this.myUserData != null) {
            Object t = this.myUserData.get(key);
            return (T)t;
        }
        return null;
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            GeneralCommandLine.$$$reportNull$$$0(51);
        }
        if (this.myUserData == null) {
            if (value == null) {
                return;
            }
            this.myUserData = ContainerUtil.newHashMap();
        }
        this.myUserData.put(key, value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 43: 
            case 44: 
            case 46: 
            case 49: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 43: 
            case 44: 
            case 46: 
            case 49: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 43: 
            case 44: 
            case 46: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/configurations/GeneralCommandLine";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exePath";
                break;
            }
            case 10: 
            case 50: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 26: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 38: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "platform";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "escapedCommands";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/configurations/GeneralCommandLine";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getExePath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "withExePath";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "withWorkDirectory";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvironment";
                break;
            }
            case 9: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "withEnvironment";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentEnvironmentType";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "withParentEnvironmentType";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentEnvironment";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveEnvironment";
                break;
            }
            case 23: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "withParameters";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getParametersList";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharset";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "withCharset";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "withRedirectErrorStream";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "withInput";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandLineString";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandLineList";
                break;
            }
            case 37: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreparedCommandLine";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareCommandLine";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcess";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "inescapableQuote";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 43: 
            case 44: 
            case 46: 
            case 49: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "withExePath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setExePath";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "withEnvironment";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "withParentEnvironmentType";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addParameters";
                break;
            }
            case 22: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "withParameters";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addParameter";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "withCharset";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "setCharset";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getPreparedCommandLine";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "prepareCommandLine";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "startProcess";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "setupEnvironment";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "inescapableQuote";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 43: 
            case 44: 
            case 46: 
            case 49: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyTHashMap
    extends THashMap<String, String> {
        private MyTHashMap() {
            super((TObjectHashingStrategy)(SystemInfo.isWindows ? CaseInsensitiveStringHashingStrategy.INSTANCE : ContainerUtil.canonicalStrategy()));
        }

        public String put(String key, String value) {
            if (key == null || value == null) {
                LOG.error((Throwable)new Exception("Nulls are not allowed"));
                return null;
            }
            if (key.isEmpty()) {
                LOG.warn("Skipping environment variable with empty name, value: " + value);
                return null;
            }
            return (String)super.put((Object)key, (Object)value);
        }

        public void putAll(Map<? extends String, ? extends String> map) {
            if (map != null) {
                super.putAll(map);
            }
        }
    }

    public static enum ParentEnvironmentType {
        NONE,
        SYSTEM,
        CONSOLE;

    }
}

