/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class Executor {
    public static final ExtensionPointName<Executor> EXECUTOR_EXTENSION_NAME = ExtensionPointName.create((String)"com.intellij.executor");

    public abstract String getToolWindowId();

    public abstract Icon getToolWindowIcon();

    @NotNull
    public abstract Icon getIcon();

    public abstract Icon getDisabledIcon();

    public abstract String getDescription();

    @NotNull
    public abstract String getActionName();

    @NotNull
    @NonNls
    public abstract String getId();

    @NotNull
    public abstract String getStartActionText();

    @NonNls
    public abstract String getContextActionId();

    @NonNls
    public abstract String getHelpId();

    public String getStartActionText(String configurationName) {
        return this.getStartActionText() + (StringUtil.isEmpty((String)configurationName) ? "" : " '" + Executor.shortenNameIfNeed(configurationName) + "'");
    }

    public boolean isApplicable(@NotNull Project project) {
        if (project == null) {
            Executor.$$$reportNull$$$0(0);
        }
        return true;
    }

    public static String shortenNameIfNeed(@NotNull String name) {
        if (name == null) {
            Executor.$$$reportNull$$$0(1);
        }
        return StringUtil.trimMiddle((String)name, (int)Registry.intValue((String)"run.configuration.max.name.length", (int)80));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/Executor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "shortenNameIfNeed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

