/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiUtilCore;
import gnu.trove.THashSet;
import java.awt.Color;
import java.util.Collections;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LookupElementBuilder
extends LookupElement {
    @NotNull
    private final String myLookupString;
    @NotNull
    private final Object myObject;
    @Nullable
    private final SmartPsiElementPointer<?> myPsiElement;
    private final boolean myCaseSensitive;
    @Nullable
    private final InsertHandler<LookupElement> myInsertHandler;
    @Nullable
    private final LookupElementRenderer<LookupElement> myRenderer;
    @Nullable
    private final LookupElementPresentation myHardcodedPresentation;
    @NotNull
    private final Set<String> myAllLookupStrings;

    private LookupElementBuilder(@NotNull String lookupString, @NotNull Object object, @Nullable InsertHandler<LookupElement> insertHandler, @Nullable LookupElementRenderer<LookupElement> renderer, @Nullable LookupElementPresentation hardcodedPresentation, @Nullable SmartPsiElementPointer<?> psiElement, @NotNull Set<String> allLookupStrings, boolean caseSensitive) {
        if (lookupString == null) {
            LookupElementBuilder.$$$reportNull$$$0(0);
        }
        if (object == null) {
            LookupElementBuilder.$$$reportNull$$$0(1);
        }
        if (allLookupStrings == null) {
            LookupElementBuilder.$$$reportNull$$$0(2);
        }
        this.myLookupString = lookupString;
        this.myObject = object;
        this.myInsertHandler = insertHandler;
        this.myRenderer = renderer;
        this.myHardcodedPresentation = hardcodedPresentation;
        this.myPsiElement = psiElement;
        this.myAllLookupStrings = Collections.unmodifiableSet(allLookupStrings);
        this.myCaseSensitive = caseSensitive;
    }

    private LookupElementBuilder(@NotNull String lookupString, @NotNull Object object) {
        if (lookupString == null) {
            LookupElementBuilder.$$$reportNull$$$0(3);
        }
        if (object == null) {
            LookupElementBuilder.$$$reportNull$$$0(4);
        }
        this(lookupString, object, null, null, null, null, Collections.singleton(lookupString), true);
    }

    @NotNull
    public static LookupElementBuilder create(@NotNull String lookupString) {
        if (lookupString == null) {
            LookupElementBuilder.$$$reportNull$$$0(5);
        }
        LookupElementBuilder lookupElementBuilder = new LookupElementBuilder(lookupString, lookupString);
        if (lookupElementBuilder == null) {
            LookupElementBuilder.$$$reportNull$$$0(6);
        }
        return lookupElementBuilder;
    }

    public static LookupElementBuilder create(@NotNull Object object) {
        if (object == null) {
            LookupElementBuilder.$$$reportNull$$$0(7);
        }
        return new LookupElementBuilder(object.toString(), object);
    }

    public static LookupElementBuilder createWithSmartPointer(@NotNull String lookupString, @NotNull PsiElement element) {
        if (lookupString == null) {
            LookupElementBuilder.$$$reportNull$$$0(8);
        }
        if (element == null) {
            LookupElementBuilder.$$$reportNull$$$0(9);
        }
        PsiUtilCore.ensureValid(element);
        return new LookupElementBuilder(lookupString, SmartPointerManager.getInstance(element.getProject()).createSmartPsiElementPointer(element));
    }

    public static LookupElementBuilder create(@NotNull PsiNamedElement element) {
        if (element == null) {
            LookupElementBuilder.$$$reportNull$$$0(10);
        }
        PsiUtilCore.ensureValid(element);
        return new LookupElementBuilder(StringUtil.notNullize((String)element.getName()), element);
    }

    public static LookupElementBuilder createWithIcon(@NotNull PsiNamedElement element) {
        if (element == null) {
            LookupElementBuilder.$$$reportNull$$$0(11);
        }
        PsiUtilCore.ensureValid(element);
        return LookupElementBuilder.create(element).withIcon(element.getIcon(0));
    }

    public static LookupElementBuilder create(@NotNull Object lookupObject, @NotNull String lookupString) {
        if (lookupObject == null) {
            LookupElementBuilder.$$$reportNull$$$0(12);
        }
        if (lookupString == null) {
            LookupElementBuilder.$$$reportNull$$$0(13);
        }
        if (lookupObject instanceof PsiElement) {
            PsiUtilCore.ensureValid((PsiElement)lookupObject);
        }
        return new LookupElementBuilder(lookupString, lookupObject);
    }

    @Contract(pure=true)
    public LookupElementBuilder setInsertHandler(@Nullable InsertHandler<LookupElement> insertHandler) {
        return this.withInsertHandler(insertHandler);
    }

    @Contract(pure=true)
    public LookupElementBuilder withInsertHandler(@Nullable InsertHandler<LookupElement> insertHandler) {
        return new LookupElementBuilder(this.myLookupString, this.myObject, insertHandler, this.myRenderer, this.myHardcodedPresentation, this.myPsiElement, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @Contract(pure=true)
    public LookupElementBuilder setRenderer(@Nullable LookupElementRenderer<LookupElement> renderer) {
        return this.withRenderer(renderer);
    }

    @Contract(pure=true)
    public LookupElementBuilder withRenderer(@Nullable LookupElementRenderer<LookupElement> renderer) {
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, renderer, this.myHardcodedPresentation, this.myPsiElement, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @Override
    @NotNull
    public Set<String> getAllLookupStrings() {
        Set<String> set = this.myAllLookupStrings;
        if (set == null) {
            LookupElementBuilder.$$$reportNull$$$0(14);
        }
        return set;
    }

    @Contract(pure=true)
    public LookupElementBuilder setIcon(@Nullable Icon icon) {
        return this.withIcon(icon);
    }

    @Contract(pure=true)
    public LookupElementBuilder withIcon(@Nullable Icon icon) {
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setIcon(icon);
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, null, presentation, this.myPsiElement, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @NotNull
    private LookupElementPresentation copyPresentation() {
        LookupElementPresentation presentation = new LookupElementPresentation();
        if (this.myHardcodedPresentation != null) {
            presentation.copyFrom(this.myHardcodedPresentation);
        } else {
            presentation.setItemText(this.myLookupString);
        }
        LookupElementPresentation lookupElementPresentation = presentation;
        if (lookupElementPresentation == null) {
            LookupElementBuilder.$$$reportNull$$$0(15);
        }
        return lookupElementPresentation;
    }

    @Contract(pure=true)
    public LookupElementBuilder addLookupString(@NotNull String another) {
        if (another == null) {
            LookupElementBuilder.$$$reportNull$$$0(16);
        }
        return this.withLookupString(another);
    }

    @Contract(pure=true)
    public LookupElementBuilder withLookupString(@NotNull String another) {
        if (another == null) {
            LookupElementBuilder.$$$reportNull$$$0(17);
        }
        THashSet set = new THashSet(this.myAllLookupStrings);
        set.add((Object)another);
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, this.myRenderer, this.myHardcodedPresentation, this.myPsiElement, Collections.unmodifiableSet(set), this.myCaseSensitive);
    }

    @Override
    public boolean isCaseSensitive() {
        return this.myCaseSensitive;
    }

    @Contract(pure=true)
    public LookupElementBuilder setCaseSensitive(boolean caseSensitive) {
        return this.withCaseSensitivity(caseSensitive);
    }

    @Contract(pure=true)
    public LookupElementBuilder withCaseSensitivity(boolean caseSensitive) {
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, this.myRenderer, this.myHardcodedPresentation, this.myPsiElement, this.myAllLookupStrings, caseSensitive);
    }

    @Contract(pure=true)
    public LookupElementBuilder withPsiElement(@Nullable PsiElement psi) {
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, this.myRenderer, this.myHardcodedPresentation, psi == null ? null : SmartPointerManager.createPointer(psi), this.myAllLookupStrings, this.myCaseSensitive);
    }

    @Contract(pure=true)
    public LookupElementBuilder setItemTextForeground(@NotNull Color itemTextForeground) {
        if (itemTextForeground == null) {
            LookupElementBuilder.$$$reportNull$$$0(18);
        }
        return this.withItemTextForeground(itemTextForeground);
    }

    @Contract(pure=true)
    public LookupElementBuilder withItemTextForeground(@NotNull Color itemTextForeground) {
        if (itemTextForeground == null) {
            LookupElementBuilder.$$$reportNull$$$0(19);
        }
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setItemTextForeground(itemTextForeground);
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, null, presentation, this.myPsiElement, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @Contract(pure=true)
    public LookupElementBuilder setItemTextUnderlined(boolean underlined) {
        return this.withItemTextUnderlined(underlined);
    }

    @Contract(pure=true)
    public LookupElementBuilder withItemTextUnderlined(boolean underlined) {
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setItemTextUnderlined(underlined);
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, null, presentation, this.myPsiElement, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @Contract(pure=true)
    public LookupElementBuilder setTypeText(@Nullable String typeText) {
        return this.withTypeText(typeText);
    }

    @Contract(pure=true)
    public LookupElementBuilder withTypeText(@Nullable String typeText) {
        return this.withTypeText(typeText, false);
    }

    @Contract(pure=true)
    public LookupElementBuilder setTypeText(@Nullable String typeText, boolean grayed) {
        return this.withTypeText(typeText, grayed);
    }

    @Contract(pure=true)
    public LookupElementBuilder withTypeText(@Nullable String typeText, boolean grayed) {
        return this.withTypeText(typeText, null, grayed);
    }

    @Contract(pure=true)
    public LookupElementBuilder withTypeText(@Nullable String typeText, @Nullable Icon typeIcon, boolean grayed) {
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setTypeText(typeText, typeIcon);
        presentation.setTypeGrayed(grayed);
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, null, presentation, this.myPsiElement, this.myAllLookupStrings, this.myCaseSensitive);
    }

    public LookupElementBuilder withTypeIconRightAligned(boolean typeIconRightAligned) {
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setTypeIconRightAligned(typeIconRightAligned);
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, null, presentation, this.myPsiElement, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @Contract(pure=true)
    public LookupElementBuilder setPresentableText(@NotNull String presentableText) {
        if (presentableText == null) {
            LookupElementBuilder.$$$reportNull$$$0(20);
        }
        return this.withPresentableText(presentableText);
    }

    @Contract(pure=true)
    public LookupElementBuilder withPresentableText(@NotNull String presentableText) {
        if (presentableText == null) {
            LookupElementBuilder.$$$reportNull$$$0(21);
        }
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setItemText(presentableText);
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, null, presentation, this.myPsiElement, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @Contract(pure=true)
    public LookupElementBuilder setBold() {
        return this.bold();
    }

    @Contract(pure=true)
    public LookupElementBuilder bold() {
        return this.withBoldness(true);
    }

    @Contract(pure=true)
    public LookupElementBuilder setBold(boolean bold) {
        return this.withBoldness(bold);
    }

    @Contract(pure=true)
    public LookupElementBuilder withBoldness(boolean bold) {
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setItemTextBold(bold);
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, null, presentation, this.myPsiElement, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @Contract(pure=true)
    public LookupElementBuilder setStrikeout() {
        return this.strikeout();
    }

    @Contract(pure=true)
    public LookupElementBuilder strikeout() {
        return this.withStrikeoutness(true);
    }

    @Contract(pure=true)
    public LookupElementBuilder setStrikeout(boolean strikeout) {
        return this.withStrikeoutness(strikeout);
    }

    @Contract(pure=true)
    public LookupElementBuilder withStrikeoutness(boolean strikeout) {
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setStrikeout(strikeout);
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, null, presentation, this.myPsiElement, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @Contract(pure=true)
    public LookupElementBuilder setTailText(@Nullable String tailText) {
        return this.withTailText(tailText);
    }

    @Contract(pure=true)
    public LookupElementBuilder withTailText(@Nullable String tailText) {
        return this.withTailText(tailText, false);
    }

    @Contract(pure=true)
    public LookupElementBuilder setTailText(@Nullable String tailText, boolean grayed) {
        return this.withTailText(tailText, grayed);
    }

    @Contract(pure=true)
    public LookupElementBuilder withTailText(@Nullable String tailText, boolean grayed) {
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setTailText(tailText, grayed);
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, null, presentation, this.myPsiElement, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @Contract(pure=true)
    public LookupElementBuilder appendTailText(@NotNull String tailText, boolean grayed) {
        if (tailText == null) {
            LookupElementBuilder.$$$reportNull$$$0(22);
        }
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.appendTailText(tailText, grayed);
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, null, presentation, this.myPsiElement, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @Contract(pure=true)
    public LookupElement withAutoCompletionPolicy(AutoCompletionPolicy policy) {
        return policy.applyPolicy(this);
    }

    @Override
    @NotNull
    public String getLookupString() {
        String string = this.myLookupString;
        if (string == null) {
            LookupElementBuilder.$$$reportNull$$$0(23);
        }
        return string;
    }

    @Nullable
    public InsertHandler<LookupElement> getInsertHandler() {
        return this.myInsertHandler;
    }

    @Override
    @NotNull
    public Object getObject() {
        Object object = this.myObject;
        if (object == null) {
            LookupElementBuilder.$$$reportNull$$$0(24);
        }
        return object;
    }

    @Override
    @Nullable
    public PsiElement getPsiElement() {
        if (this.myPsiElement != null) {
            return this.myPsiElement.getElement();
        }
        return super.getPsiElement();
    }

    @Override
    public void handleInsert(InsertionContext context) {
        if (this.myInsertHandler != null) {
            this.myInsertHandler.handleInsert(context, this);
        }
    }

    @Override
    public void renderElement(LookupElementPresentation presentation) {
        if (this.myRenderer != null) {
            this.myRenderer.renderElement(this, presentation);
        } else if (this.myHardcodedPresentation != null) {
            presentation.copyFrom(this.myHardcodedPresentation);
        } else {
            presentation.setItemText(this.myLookupString);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        LookupElementBuilder that = (LookupElementBuilder)((Object)o);
        InsertHandler<LookupElement> insertHandler = that.myInsertHandler;
        if (this.myInsertHandler != null && insertHandler != null ? !this.myInsertHandler.getClass().equals(insertHandler.getClass()) : this.myInsertHandler != insertHandler) {
            return false;
        }
        if (!this.myLookupString.equals(that.myLookupString)) {
            return false;
        }
        if (!this.myObject.equals(that.myObject)) {
            return false;
        }
        LookupElementRenderer<LookupElement> renderer = that.myRenderer;
        return !(this.myRenderer != null && renderer != null ? !this.myRenderer.getClass().equals(renderer.getClass()) : this.myRenderer != renderer);
    }

    @Override
    public String toString() {
        return "LookupElementBuilder: string=" + this.getLookupString() + "; handler=" + this.myInsertHandler;
    }

    public int hashCode() {
        int result2 = 0;
        result2 = 31 * result2 + (this.myInsertHandler != null ? this.myInsertHandler.getClass().hashCode() : 0);
        result2 = 31 * result2 + this.myLookupString.hashCode();
        result2 = 31 * result2 + this.myObject.hashCode();
        result2 = 31 * result2 + (this.myRenderer != null ? this.myRenderer.getClass().hashCode() : 0);
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 14: 
            case 15: 
            case 23: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 14: 
            case 15: 
            case 23: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupString";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allLookupStrings";
                break;
            }
            case 6: 
            case 14: 
            case 15: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/lookup/LookupElementBuilder";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupObject";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "another";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemTextForeground";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableText";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tailText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/lookup/LookupElementBuilder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllLookupStrings";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "copyPresentation";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupString";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 6: 
            case 14: 
            case 15: 
            case 23: 
            case 24: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createWithSmartPointer";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createWithIcon";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addLookupString";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "withLookupString";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setItemTextForeground";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "withItemTextForeground";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setPresentableText";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "withPresentableText";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "appendTailText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 14: 
            case 15: 
            case 23: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

