/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyle {
    private CodeStyle() {
    }

    @NotNull
    public static CodeStyleSettings getDefaultSettings() {
        CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getInstance().getCurrentSettings();
        if (codeStyleSettings == null) {
            CodeStyle.$$$reportNull$$$0(0);
        }
        return codeStyleSettings;
    }

    @NotNull
    public static CodeStyleSettings getSettings(@NotNull Project project) {
        if (project == null) {
            CodeStyle.$$$reportNull$$$0(1);
        }
        CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getInstance(project).getCurrentSettings();
        if (codeStyleSettings == null) {
            CodeStyle.$$$reportNull$$$0(2);
        }
        return codeStyleSettings;
    }

    @NotNull
    public static CodeStyleSettings getProjectOrDefaultSettings(@Nullable Project project) {
        CodeStyleSettings codeStyleSettings = project != null ? CodeStyle.getSettings(project) : CodeStyle.getDefaultSettings();
        if (codeStyleSettings == null) {
            CodeStyle.$$$reportNull$$$0(3);
        }
        return codeStyleSettings;
    }

    @NotNull
    public static CodeStyleSettings getSettings(@NotNull PsiFile file) {
        if (file == null) {
            CodeStyle.$$$reportNull$$$0(4);
        }
        if (file.isValid()) {
            Project project = file.getProject();
            CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getInstance(project).getCurrentSettings();
            if (codeStyleSettings == null) {
                CodeStyle.$$$reportNull$$$0(5);
            }
            return codeStyleSettings;
        }
        CodeStyleSettings codeStyleSettings = CodeStyle.getDefaultSettings();
        if (codeStyleSettings == null) {
            CodeStyle.$$$reportNull$$$0(6);
        }
        return codeStyleSettings;
    }

    public static CodeStyleSettings getSettings(@NotNull Editor editor) {
        Project project;
        if (editor == null) {
            CodeStyle.$$$reportNull$$$0(7);
        }
        if ((project = editor.getProject()) != null) {
            PsiFile file = PsiDocumentManager.getInstance(project).getPsiFile(editor.getDocument());
            if (file != null) {
                return CodeStyle.getSettings(file);
            }
            return CodeStyle.getSettings(project);
        }
        return CodeStyle.getDefaultSettings();
    }

    @Nullable
    public static CommonCodeStyleSettings getLanguageSettings(@NotNull Editor editor) {
        PsiFile file;
        Project project;
        if (editor == null) {
            CodeStyle.$$$reportNull$$$0(8);
        }
        if ((project = editor.getProject()) != null && (file = PsiDocumentManager.getInstance(project).getPsiFile(editor.getDocument())) != null) {
            return CodeStyle.getLanguageSettings(file);
        }
        return null;
    }

    @NotNull
    public static <T extends CustomCodeStyleSettings> T getCustomSettings(@NotNull PsiFile file, Class<T> customSettingsClass) {
        if (file == null) {
            CodeStyle.$$$reportNull$$$0(9);
        }
        CodeStyleSettings rootSettings = CodeStyle.getSettings(file);
        T t = rootSettings.getCustomSettings(customSettingsClass);
        if (t == null) {
            CodeStyle.$$$reportNull$$$0(10);
        }
        return t;
    }

    @NotNull
    public static CommonCodeStyleSettings getLanguageSettings(@NotNull PsiFile file) {
        if (file == null) {
            CodeStyle.$$$reportNull$$$0(11);
        }
        CodeStyleSettings rootSettings = CodeStyle.getSettings(file);
        CommonCodeStyleSettings commonCodeStyleSettings = rootSettings.getCommonSettings(file.getLanguage());
        if (commonCodeStyleSettings == null) {
            CodeStyle.$$$reportNull$$$0(12);
        }
        return commonCodeStyleSettings;
    }

    @NotNull
    public static CommonCodeStyleSettings getLanguageSettings(@NotNull PsiFile file, @NotNull Language language) {
        if (file == null) {
            CodeStyle.$$$reportNull$$$0(13);
        }
        if (language == null) {
            CodeStyle.$$$reportNull$$$0(14);
        }
        CodeStyleSettings rootSettings = CodeStyle.getSettings(file);
        CommonCodeStyleSettings commonCodeStyleSettings = rootSettings.getCommonSettings(language);
        if (commonCodeStyleSettings == null) {
            CodeStyle.$$$reportNull$$$0(15);
        }
        return commonCodeStyleSettings;
    }

    @NotNull
    public static CommonCodeStyleSettings.IndentOptions getIndentOptions(@NotNull PsiFile file) {
        if (file == null) {
            CodeStyle.$$$reportNull$$$0(16);
        }
        CodeStyleSettings rootSettings = CodeStyle.getSettings(file);
        CommonCodeStyleSettings.IndentOptions indentOptions = rootSettings.getIndentOptionsByFile(file);
        if (indentOptions == null) {
            CodeStyle.$$$reportNull$$$0(17);
        }
        return indentOptions;
    }

    @NotNull
    public static CommonCodeStyleSettings.IndentOptions getIndentOptionsByFileType(@NotNull PsiFile file) {
        if (file == null) {
            CodeStyle.$$$reportNull$$$0(18);
        }
        CommonCodeStyleSettings.IndentOptions indentOptions = CodeStyle.getSettings(file).getIndentOptions(file.getFileType());
        if (indentOptions == null) {
            CodeStyle.$$$reportNull$$$0(19);
        }
        return indentOptions;
    }

    @NotNull
    public static CommonCodeStyleSettings.IndentOptions getIndentOptions(@NotNull Project project, @NotNull Document document) {
        PsiFile file;
        if (project == null) {
            CodeStyle.$$$reportNull$$$0(20);
        }
        if (document == null) {
            CodeStyle.$$$reportNull$$$0(21);
        }
        if ((file = PsiDocumentManager.getInstance(project).getPsiFile(document)) != null) {
            CommonCodeStyleSettings.IndentOptions indentOptions = CodeStyle.getIndentOptions(file);
            if (indentOptions == null) {
                CodeStyle.$$$reportNull$$$0(22);
            }
            return indentOptions;
        }
        CommonCodeStyleSettings.IndentOptions indentOptions = CodeStyle.getSettings(project).getIndentOptions((FileType)null);
        if (indentOptions == null) {
            CodeStyle.$$$reportNull$$$0(23);
        }
        return indentOptions;
    }

    public static int getIndentSize(@NotNull PsiFile file) {
        if (file == null) {
            CodeStyle.$$$reportNull$$$0(24);
        }
        return CodeStyle.getIndentOptions((PsiFile)file).INDENT_SIZE;
    }

    public static void setTemporarySettings(@NotNull Project project, @NotNull CodeStyleSettings settings) {
        if (project == null) {
            CodeStyle.$$$reportNull$$$0(25);
        }
        if (settings == null) {
            CodeStyle.$$$reportNull$$$0(26);
        }
        CodeStyleSettingsManager.getInstance(project).setTemporarySettings(settings);
    }

    public static void dropTemporarySettings(@NotNull Project project) {
        if (project == null) {
            CodeStyle.$$$reportNull$$$0(27);
        }
        CodeStyleSettingsManager.getInstance(project).dropTemporarySettings();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/CodeStyle";
                break;
            }
            case 1: 
            case 20: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 18: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSettings";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/CodeStyle";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectOrDefaultSettings";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomSettings";
                break;
            }
            case 12: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageSettings";
                break;
            }
            case 17: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndentOptions";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndentOptionsByFileType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSettings";
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageSettings";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCustomSettings";
                break;
            }
            case 16: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getIndentOptions";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getIndentOptionsByFileType";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getIndentSize";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setTemporarySettings";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "dropTemporarySettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

