/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.impl;

import com.intellij.database.remote.jdbc.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import com.intellij.database.remote.jdbc.impl.ReflectionHelper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.Postgres;
import org.jetbrains.dekaf.Rdbms;

public class PostgresHelper {
    private static final String JSON = "json";
    private static final String JSONB = "jsonb";
    private static final String VARBIT = "varbit";
    private static final String BIT = "bit";
    private static final String TX_SNAPSHOT = "txid_snapshot";
    private static final Set<String> CUSTOM_OPERATOR_TYPES = PostgresHelper.set("point", "polygon");
    private static final Set<String> NATIVE_TYPES = PostgresHelper.union(CUSTOM_OPERATOR_TYPES, ContainerUtil.set((Object[])new String[]{"json", "jsonb", "varbit", "bit", "txid_snapshot", "line", "lseg", "box", "path", "circle", "hstore"}));
    private static final Set<String> EDITABLE_TYPES = PostgresHelper.union(NATIVE_TYPES, ContainerUtil.set((Object[])new String[]{"pg_lsn", "tsquery", "tsvector"}));

    public static Object convertValue(@NotNull String className, @NotNull Object o) {
        if (className == null) {
            PostgresHelper.$$$reportNull$$$0(0);
        }
        if (o == null) {
            PostgresHelper.$$$reportNull$$$0(1);
        }
        if (ArrayUtil.contains((String)className, (String[])new String[]{"org.postgresql.jdbc4.Jdbc4SQLXML", "org.postgresql.jdbc.PgSQLXML"})) {
            return JdbcNativeUtil.tryGetString(o);
        }
        return null;
    }

    public static boolean isCustomOperatorType(@NotNull String typeName) {
        if (typeName == null) {
            PostgresHelper.$$$reportNull$$$0(2);
        }
        return CUSTOM_OPERATOR_TYPES.contains(typeName);
    }

    public static boolean setNative(@NotNull Rdbms rdbms, @NotNull String value, @NotNull String typeName, @NotNull RemotePreparedStatement statement, int jdbcType, int idx) {
        if (rdbms == null) {
            PostgresHelper.$$$reportNull$$$0(3);
        }
        if (value == null) {
            PostgresHelper.$$$reportNull$$$0(4);
        }
        if (typeName == null) {
            PostgresHelper.$$$reportNull$$$0(5);
        }
        if (statement == null) {
            PostgresHelper.$$$reportNull$$$0(6);
        }
        if (!PostgresHelper.isSupportedNativeType(rdbms, typeName, jdbcType)) {
            return false;
        }
        try {
            Object pgObject;
            Class<?> aClass = Class.forName("org.postgresql.util.PGobject");
            Object v0 = pgObject = aClass == null ? null : aClass.newInstance();
            if (pgObject == null) {
                return false;
            }
            ReflectionHelper.tryInvokeMethod(pgObject, "setType", (Class[])ContainerUtil.ar((Object[])new Class[]{String.class}), ContainerUtil.ar((Object[])new String[]{typeName}));
            ReflectionHelper.tryInvokeMethod(pgObject, "setValue", (Class[])ContainerUtil.ar((Object[])new Class[]{String.class}), ContainerUtil.ar((Object[])new String[]{value}));
            statement.setObject(idx, pgObject);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isPgBitColumn(@NotNull Rdbms rdbms, @NotNull String name) {
        if (rdbms == null) {
            PostgresHelper.$$$reportNull$$$0(7);
        }
        if (name == null) {
            PostgresHelper.$$$reportNull$$$0(8);
        }
        return rdbms == Postgres.RDBMS && StringUtil.findIgnoreCase((String)name, (String[])new String[]{VARBIT, BIT});
    }

    public static boolean canCompare(@NotNull String typeName) {
        if (typeName == null) {
            PostgresHelper.$$$reportNull$$$0(9);
        }
        return !StringUtil.findIgnoreCase((String)typeName, (String[])new String[]{JSON, JSONB, TX_SNAPSHOT});
    }

    public static boolean isEditableType(@NotNull String typeName, int type) {
        if (typeName == null) {
            PostgresHelper.$$$reportNull$$$0(10);
        }
        return EDITABLE_TYPES.contains(typeName) || type == 2002;
    }

    private static boolean isSupportedNativeType(@NotNull Rdbms rdbms, @NotNull String typeName, int type) {
        if (rdbms == null) {
            PostgresHelper.$$$reportNull$$$0(11);
        }
        if (typeName == null) {
            PostgresHelper.$$$reportNull$$$0(12);
        }
        return rdbms == Postgres.RDBMS && (NATIVE_TYPES.contains(typeName) || type == 2002);
    }

    @NotNull
    private static Set<String> set(String ... elements) {
        if (elements == null) {
            PostgresHelper.$$$reportNull$$$0(13);
        }
        THashSet tHashSet = ContainerUtil.newTroveSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE, (Object[])elements);
        if (tHashSet == null) {
            PostgresHelper.$$$reportNull$$$0(14);
        }
        return tHashSet;
    }

    @NotNull
    private static Set<String> union(Set<String> ... elements) {
        if (elements == null) {
            PostgresHelper.$$$reportNull$$$0(15);
        }
        THashSet set = ContainerUtil.newTroveSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        for (Set<String> element : elements) {
            set.addAll(element);
        }
        THashSet tHashSet = set;
        if (tHashSet == null) {
            PostgresHelper.$$$reportNull$$$0(16);
        }
        return tHashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 3: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rdbms";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdbc/impl/PostgresHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdbc/impl/PostgresHelper";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "set";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "union";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertValue";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isCustomOperatorType";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setNative";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isPgBitColumn";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "canCompare";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isEditableType";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedNativeType";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "set";
                break;
            }
            case 14: 
            case 16: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "union";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

