/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.netty;

import com.github.dockerjava.netty.ChannelProvider;
import com.github.dockerjava.netty.InvocationBuilder;
import com.github.dockerjava.netty.WebTarget;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.intellij.docker.agent.netty.InvocationBuilderFixed;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WebTargetFixed
extends WebTarget {
    private final ChannelProvider channelProvider;
    private final List<String> path;
    private final Map<String, String> queryParams;
    private static final String PATH_SEPARATOR = "/";

    public WebTargetFixed(ChannelProvider channelProvider) {
        this(channelProvider, Collections.emptyList());
    }

    public WebTargetFixed(ChannelProvider channelProvider, List<String> path) {
        this(channelProvider, path, Collections.emptyMap());
    }

    public WebTargetFixed(ChannelProvider channelProvider, List<String> path, Map<String, String> queryParams) {
        super(channelProvider);
        this.channelProvider = channelProvider;
        this.path = new ArrayList<String>(path);
        this.queryParams = new HashMap<String, String>(queryParams);
    }

    public WebTargetFixed path(String ... components) {
        ArrayList<String> targetPath = new ArrayList<String>(this.path);
        for (String component : components) {
            Iterables.addAll(targetPath, (Iterable)Splitter.on((String)PATH_SEPARATOR).omitEmptyStrings().split((CharSequence)component));
        }
        return new WebTargetFixed(this.channelProvider, targetPath, this.queryParams);
    }

    public InvocationBuilder request() {
        String resource = PATH_SEPARATOR + Joiner.on((String)PATH_SEPARATOR).join(this.path);
        ArrayList<String> params = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.queryParams.entrySet()) {
            params.add(entry.getKey() + "=" + entry.getValue());
        }
        if (!params.isEmpty()) {
            resource = resource + "?" + Joiner.on((String)"&").join(params);
        }
        return new InvocationBuilderFixed(this.channelProvider, resource);
    }

    public WebTargetFixed resolveTemplate(String name, Object value) {
        ArrayList<String> newPath = new ArrayList<String>();
        for (String component : this.path) {
            component = component.replaceAll("\\{" + name + "\\}", value.toString());
            newPath.add(component);
        }
        return new WebTargetFixed(this.channelProvider, newPath, this.queryParams);
    }

    public WebTargetFixed queryParam(String name, Object value) {
        HashMap<String, String> newQueryParams = new HashMap<String, String>(this.queryParams);
        if (value != null) {
            newQueryParams.put(name, value.toString());
        }
        return new WebTargetFixed(this.channelProvider, this.path, newQueryParams);
    }
}

