/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.fix;

import com.github.dockerjava.api.exception.DockerClientException;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.AuthConfigurations;
import com.github.dockerjava.core.NameParser;
import com.github.dockerjava.core.SSLConfig;
import com.intellij.docker.agent.fix.DefaultDockerClientConfig;
import com.intellij.docker.agent.fix.FixedAuthConfigFile;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Properties;

public class FixedDefaultDockerClientConfig
extends DefaultDockerClientConfig {
    FixedDefaultDockerClientConfig(URI dockerHost, String dockerConfig, String apiVersion, String registryUrl, String registryUsername, String registryPassword, String registryEmail, SSLConfig sslConfig) {
        super(dockerHost, dockerConfig, apiVersion, registryUrl, registryUsername, registryPassword, registryEmail, sslConfig);
    }

    @Override
    public AuthConfig effectiveAuthConfig(String imageName) {
        AuthConfig otherAuthConfig;
        AuthConfig authConfig = null;
        File dockerCfgFile = this.getDockerConfigFile();
        if (dockerCfgFile != null) {
            FixedAuthConfigFile authConfigFile;
            try {
                authConfigFile = FixedAuthConfigFile.fixedLoadConfig(dockerCfgFile);
            }
            catch (IOException e) {
                throw new DockerClientException("Failed to parse dockerCfgFile", (Throwable)e);
            }
            NameParser.ReposTag reposTag = NameParser.parseRepositoryTag((String)imageName);
            NameParser.HostnameReposName hostnameReposName = NameParser.resolveRepositoryName((String)reposTag.repos);
            authConfig = authConfigFile.resolveAuthConfig(hostnameReposName.hostname);
        }
        if ((otherAuthConfig = this.getAuthConfig()) != null) {
            authConfig = otherAuthConfig;
        }
        return authConfig;
    }

    @Override
    public AuthConfigurations getAuthConfigurations() {
        File dockerCfgFile = this.getDockerConfigFile();
        if (dockerCfgFile != null) {
            FixedAuthConfigFile authConfigFile;
            try {
                authConfigFile = FixedAuthConfigFile.fixedLoadConfig(dockerCfgFile);
            }
            catch (IOException e) {
                throw new DockerClientException("Failed to parse dockerCfgFile: " + dockerCfgFile.getAbsolutePath(), (Throwable)e);
            }
            return authConfigFile.getAuthConfigurations();
        }
        return new AuthConfigurations();
    }

    public static DefaultDockerClientConfig.Builder createDefaultConfigBuilder() {
        return FixedDefaultDockerClientConfig.createDefaultConfigBuilder(System.getenv(), (Properties)System.getProperties().clone());
    }

    static DefaultDockerClientConfig.Builder createDefaultConfigBuilder(Map<String, String> env, Properties systemProperties) {
        Properties properties = FixedDefaultDockerClientConfig.loadIncludedDockerProperties(systemProperties);
        properties = FixedDefaultDockerClientConfig.overrideDockerPropertiesWithSettingsFromUserHome(properties, systemProperties);
        properties = FixedDefaultDockerClientConfig.overrideDockerPropertiesWithEnv(properties, env);
        properties = FixedDefaultDockerClientConfig.overrideDockerPropertiesWithSystemProperties(properties, systemProperties);
        return new FixedBuilder().withProperties(properties);
    }

    private static class FixedBuilder
    extends DefaultDockerClientConfig.Builder {
        private FixedBuilder() {
        }

        @Override
        public FixedDefaultDockerClientConfig build() {
            DefaultDockerClientConfig superResult = super.build();
            String stringApiVersion = superResult.getApiVersion() == null ? null : superResult.getApiVersion().getVersion();
            return new FixedDefaultDockerClientConfig(superResult.getDockerHost(), superResult.getDockerConfig(), stringApiVersion, superResult.getRegistryUrl(), superResult.getRegistryUsername(), superResult.getRegistryPassword(), superResult.getRegistryEmail(), superResult.getSSLConfig());
        }
    }
}

