/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.BuildImageCmd;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.command.StartContainerCmd;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.BuildResponseItem;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.Image;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.api.model.ResponseItem;
import com.intellij.docker.agent.ApiTaskBase;
import com.intellij.docker.agent.ApiTaskException;
import com.intellij.docker.agent.CreateContainerCmdConfig;
import com.intellij.docker.agent.CreateContainerCmdConfigJsonReader;
import com.intellij.docker.agent.CreateContainerCmdValueTransfers;
import com.intellij.docker.agent.DockerAgentApplicationBase;
import com.intellij.docker.agent.DockerAgentContainerConfigImpl;
import com.intellij.docker.agent.DockerAgentContext;
import com.intellij.docker.agent.DockerAgentDeployment;
import com.intellij.docker.agent.DockerAgentDeploymentConfig;
import com.intellij.docker.agent.DockerAgentPathMapper;
import com.intellij.docker.agent.DockerAgentProgressCallback;
import com.intellij.docker.agent.DockerAgentRepositoryConfig;
import com.intellij.docker.agent.DockerAgentSourceType;
import com.intellij.docker.agent.DockerAuthConfig;
import com.intellij.docker.agent.DockerCliParser;
import com.intellij.docker.agent.DockerRepoTag;
import com.intellij.docker.agent.OngoingProcess;
import com.intellij.docker.agent.VolumeMapper;
import com.intellij.docker.agent.settings.DockerAgentContainerConfig;
import com.intellij.docker.agent.settings.DockerEnvVar;
import com.intellij.remoteServer.agent.util.CloudAgentLoggingHandler;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class DockerAgentDeploymentImpl
extends DockerAgentApplicationBase
implements DockerAgentDeployment {
    private static final String[] NO_TAGS = new String[0];
    private final DockerAgentDeploymentConfig myConfig;
    private final CloudAgentLoggingHandler myLoggingHandler;
    private final VolumeMapper myVolumeMapper;
    private volatile String myImageId;
    private volatile String myImageTag;

    public DockerAgentDeploymentImpl(DockerAgentContext context, DockerAgentDeploymentConfig config, CloudAgentLoggingHandler loggingHandler, DockerAgentPathMapper pathMapper) {
        super(context);
        this.myConfig = config;
        this.myLoggingHandler = loggingHandler;
        this.myVolumeMapper = new VolumeMapper(pathMapper);
    }

    public void deploy() {
        new ApiTaskBase(this.getErrorHandler()){

            @Override
            protected Object doPerform() throws IOException, ApiTaskException {
                DockerAgentSourceType sourceType = DockerAgentSourceType.valueOf((String)DockerAgentDeploymentImpl.this.myConfig.sourceType());
                new SingleDeployTask(sourceType).deploy();
                return null;
            }
        }.perform();
    }

    @Override
    protected Bind[] prepareBinds(Bind[] binds) {
        return this.myVolumeMapper.expandPath(binds);
    }

    private void buildImage() throws IOException, ApiTaskException {
        this.myLoggingHandler.println("Building image...");
        File file = this.myConfig.getFile();
        BuildImageCmd buildImageCmd = this.myConfig.isFileArchive() ? this.getClient().buildImageCmd((InputStream)new FileInputStream(file)) : this.getClient().buildImageCmd(file);
        String imageTag = this.myConfig.getImageTag();
        if (imageTag != null) {
            buildImageCmd.withTag(imageTag);
        }
        if (this.myConfig.getBuildArgs() != null) {
            for (DockerEnvVar next : this.myConfig.getBuildArgs()) {
                String nextName = next.getName();
                if (nextName == null || nextName.length() == 0) continue;
                buildImageCmd.withBuildArg(nextName, next.getValue());
            }
        }
        this.execBuildImage(buildImageCmd);
    }

    private void execBuildImage(BuildImageCmd buildImageCmd) throws ApiTaskException {
        BuildCallback buildCallback = (BuildCallback)buildImageCmd.exec((ResultCallback)new BuildCallback());
        buildCallback.waitFor();
        if (this.myImageId == null) {
            throw new ApiTaskException("Can't retrieve image ID from build stream");
        }
    }

    @Override
    public void showLog(CloudAgentLoggingHandler loggingHandler) {
        super.showLog(this.myLoggingHandler);
    }

    @Override
    public void inspect2log(CloudAgentLoggingHandler loggingHandler) {
        super.inspect2log(this.myLoggingHandler);
    }

    @Override
    public void showProcesses(CloudAgentLoggingHandler loggingHandler) {
        super.showProcesses(this.myLoggingHandler);
    }

    @Override
    public void attach(CloudAgentLoggingHandler loggingHandler) {
        super.attach(this.myLoggingHandler);
    }

    @Override
    public OngoingProcess exec(CloudAgentLoggingHandler loggingHandler, String[] command, String logName) {
        return super.exec(this.myLoggingHandler, command, logName);
    }

    public String getContainerName() {
        return null;
    }

    public String getImageId() {
        return this.myImageId;
    }

    public String[] getImageRepoTags() {
        String[] stringArray;
        if (this.myImageTag == null) {
            stringArray = NO_TAGS;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.myImageTag;
        }
        return stringArray;
    }

    public String[] getContainerNames() {
        return null;
    }

    public String getImageParentId() {
        return null;
    }

    public String getName() {
        throw new UnsupportedOperationException();
    }

    public String getContainerStatus() {
        return null;
    }

    @Override
    protected void setupContainerConfig(CreateContainerCmd target) {
        super.setupContainerConfig(target);
        if (this.myImageId != null) {
            target.withImage(this.myImageId);
        }
    }

    private static Predicate<Image> idStartsWith(@NotNull String idOrTag) {
        if (idOrTag == null) {
            DockerAgentDeploymentImpl.$$$reportNull$$$0(0);
        }
        return img -> {
            if (idOrTag == null) {
                DockerAgentDeploymentImpl.$$$reportNull$$$0(2);
            }
            return img.getId() != null && DockerAgentDeploymentImpl.trimShaPrefix(img.getId()).startsWith(DockerAgentDeploymentImpl.trimShaPrefix(idOrTag));
        };
    }

    private static String trimShaPrefix(@NotNull String imageId) {
        if (imageId == null) {
            DockerAgentDeploymentImpl.$$$reportNull$$$0(1);
        }
        return imageId.startsWith("sha256:") ? imageId.substring("sha256:".length()) : imageId;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idOrTag";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageId";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/agent/DockerAgentDeploymentImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "idStartsWith";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "trimShaPrefix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$idStartsWith$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class SingleDeployTask
    extends DeployTask {
        private CreateContainerCmdConfig myContainerCmdConfig;
        private final DockerAgentSourceType mySourceType;

        public SingleDeployTask(DockerAgentSourceType sourceType) {
            this.mySourceType = sourceType;
        }

        @Override
        protected String doPrepareDeploy() throws IOException, ApiTaskException {
            String configJSON = DockerAgentDeploymentImpl.this.myConfig.getJSON();
            CreateContainerCmdConfig cmdConfig = configJSON == null ? new CreateContainerCmdConfig() : new CreateContainerCmdConfigJsonReader().readFromFile(new File(configJSON));
            this.applyParsedCliOptions((CreateContainerCmd)cmdConfig);
            this.myContainerCmdConfig = cmdConfig;
            if (this.mySourceType == DockerAgentSourceType.IMAGE) {
                DockerAgentDeploymentImpl.this.myImageId = this.pullImageIfNeeded();
            } else {
                DockerAgentDeploymentImpl.this.buildImage();
            }
            return DockerAgentDeploymentImpl.this.myConfig.getContainerName();
        }

        private void applyParsedCliOptions(CreateContainerCmd cmd) throws ApiTaskException {
            String[] cliOptions = DockerAgentDeploymentImpl.this.myConfig.getCustomCliOptions();
            if (cliOptions == null) {
                return;
            }
            DockerCliParser parser = new DockerCliParser();
            if (DockerAgentDeploymentImpl.this.myConfig.getFile() != null) {
                parser.setContextFolder(DockerAgentDeploymentImpl.this.myConfig.getFile().getParentFile());
            }
            parser.parse(cmd, cliOptions);
        }

        @Override
        protected CreateContainerCmdConfig getContainerCmdConfig() {
            return this.myContainerCmdConfig;
        }

        @Override
        protected DockerAgentContainerConfigImpl getPriorityConfig() {
            return new DockerAgentContainerConfigImpl((DockerAgentContainerConfig)DockerAgentDeploymentImpl.this.myConfig);
        }

        @Override
        protected void setContainerId(String containerId) {
            DockerAgentDeploymentImpl.this.setContainerId(containerId);
        }

        private String pullImageIfNeeded() throws ApiTaskException {
            DockerRepoTag tag;
            String imageTagOrId = DockerAgentDeploymentImpl.this.myConfig.getImageTag();
            Predicate<Image> filter = DockerAgentDeploymentImpl.idStartsWith(imageTagOrId);
            if (imageTagOrId.startsWith("sha256:")) {
                tag = null;
            } else {
                tag = DockerRepoTag.fromString((String)imageTagOrId);
                filter = filter.or(img -> tag.matchesOneOfRepoTags(img.getRepoTags()));
            }
            Image localImage = this.findImageLocally(filter);
            if (localImage != null) {
                return localImage.getId();
            }
            if (tag == null) {
                return imageTagOrId;
            }
            DockerAgentDeploymentImpl.this.myLoggingHandler.println(MessageFormat.format("Unable to find image ''{0}'' locally", tag.getFullyQualifiedReference()));
            DockerAgentRepositoryConfig endpoint = new DockerAgentRepositoryConfig(){

                public DockerAuthConfig getAuthConfig() {
                    return null;
                }

                @NotNull
                public String getQualifiedRepository() {
                    String string = tag.getQualifiedRepository();
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                public String getTag() {
                    return tag.getTagNotNull();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/agent/DockerAgentDeploymentImpl$SingleDeployTask$1", "getQualifiedRepository"));
                }
            };
            class PullCallback
            implements DockerAgentProgressCallback {
                private volatile String myErrorMessage;

                PullCallback() {
                }

                public void step(String status, long current, long total) {
                    if (total != 0L) {
                        DockerAgentDeploymentImpl.this.myLoggingHandler.println(status + " " + current + "/" + total);
                    } else {
                        DockerAgentDeploymentImpl.this.myLoggingHandler.println(status);
                    }
                }

                public void succeeded(String message) {
                    DockerAgentDeploymentImpl.this.myLoggingHandler.println(message);
                }

                public void failed(String message) {
                    this.myErrorMessage = message;
                    DockerAgentDeploymentImpl.this.myLoggingHandler.println(message);
                }

                public void rethrowError() throws ApiTaskException {
                    if (this.myErrorMessage != null) {
                        throw new ApiTaskException(this.myErrorMessage);
                    }
                }
            }
            PullCallback callback = new PullCallback();
            OngoingProcess process = DockerAgentDeploymentImpl.this.getAgent().pullImage(endpoint, (DockerAgentProgressCallback)callback);
            process.await();
            callback.rethrowError();
            localImage = this.findImageLocally(filter);
            if (localImage == null) {
                throw new ApiTaskException("No such image " + tag.getFullyQualifiedReference());
            }
            return localImage.getId();
        }

        private Image findImageLocally(Predicate<Image> filter) {
            List images = (List)DockerAgentDeploymentImpl.this.getClient().listImagesCmd().withShowAll(Boolean.valueOf(true)).exec();
            if (images == null || images.isEmpty()) {
                return null;
            }
            return images.stream().filter(filter).findAny().orElse(null);
        }
    }

    private abstract class DeployTask {
        private DeployTask() {
        }

        public void deploy() throws IOException, ApiTaskException {
            InspectContainerResponse inspectResponse;
            String containerName = this.doPrepareDeploy();
            if (DockerAgentDeploymentImpl.this.myConfig.isBuildImageOnly()) {
                return;
            }
            DockerAgentDeploymentImpl.this.myLoggingHandler.println("Creating container...");
            CreateContainerCmd createContainerCmd = DockerAgentDeploymentImpl.this.getClient().createContainerCmd(DockerAgentDeploymentImpl.this.myImageId);
            if (containerName != null) {
                for (Container container : (List)DockerAgentDeploymentImpl.this.getClient().listContainersCmd().withShowAll(Boolean.valueOf(true)).exec()) {
                    String[] containerNames = container.getNames();
                    if (containerNames == null || !Arrays.asList(containerNames).contains("/" + containerName)) continue;
                    DockerAgentDeploymentImpl.this.getClient().removeContainerCmd(container.getId()).withForce(Boolean.valueOf(true)).exec();
                    break;
                }
                createContainerCmd.withName(containerName);
            }
            CreateContainerCmdConfig cmdConfig = this.getContainerCmdConfig();
            CreateContainerCmdValueTransfers.createMergeForDeploy(binds -> DockerAgentDeploymentImpl.this.prepareBinds((Bind[])binds)).mergeWithPriority(this.getPriorityConfig(), cmdConfig, createContainerCmd);
            DockerAgentDeploymentImpl.this.setupContainerConfig(createContainerCmd);
            this.exposeAllBoundPorts(createContainerCmd);
            if (DockerAgentDeploymentImpl.this.myLoggingHandler.isTtySupported()) {
                createContainerCmd.withTty(Boolean.valueOf(true));
            }
            CreateContainerResponse createContainerResponse = createContainerCmd.exec();
            String containerId = createContainerResponse.getId();
            this.setContainerId(containerId);
            String[] warnings = createContainerResponse.getWarnings();
            if (warnings != null) {
                for (String warning : warnings) {
                    DockerAgentDeploymentImpl.this.myLoggingHandler.println("Warning: " + warning);
                }
            }
            if (DockerAgentDeploymentImpl.this.myConfig.isCreateContainerOnly()) {
                return;
            }
            DockerAgentDeploymentImpl.this.myLoggingHandler.println("Container Id: " + containerId);
            if ((containerName == null || containerName.isEmpty()) && (inspectResponse = DockerAgentDeploymentImpl.this.getClient().inspectContainerCmd(containerId).exec()) != null && inspectResponse.getName() != null) {
                containerName = inspectResponse.getName();
            }
            String containerMessageSuffix = this.safeQuote(containerName);
            DockerAgentDeploymentImpl.this.myLoggingHandler.println("Container name: " + containerMessageSuffix);
            if (cmdConfig.isAttachStdin().booleanValue() && cmdConfig.isStdinOpen().booleanValue()) {
                DockerAgentDeploymentImpl.this.myLoggingHandler.println("Attaching to container " + containerMessageSuffix + "...");
                DockerAgentDeploymentImpl.this.doAttach(containerId, DockerAgentDeploymentImpl.this.myLoggingHandler);
            } else {
                DockerAgentDeploymentImpl.this.doShowLog(containerId, DockerAgentDeploymentImpl.this.myLoggingHandler);
            }
            DockerAgentDeploymentImpl.this.myLoggingHandler.println("Starting container " + containerMessageSuffix);
            StartContainerCmd startContainerCmd = DockerAgentDeploymentImpl.this.getClient().startContainerCmd(containerId);
            startContainerCmd.exec();
        }

        protected abstract void setContainerId(String var1);

        protected abstract String doPrepareDeploy() throws IOException, ApiTaskException;

        protected abstract CreateContainerCmdConfig getContainerCmdConfig();

        protected abstract DockerAgentContainerConfigImpl getPriorityConfig();

        private String safeQuote(String text) {
            return text == null ? "" : "'" + text + "'";
        }

        private void exposeAllBoundPorts(CreateContainerCmd cmd) {
            ExposedPort[] allExposed = Optional.ofNullable(cmd.getExposedPorts()).orElseGet(() -> new ExposedPort[0]);
            Map exposedByPort = Stream.of(allExposed).collect(Collectors.toMap(p -> p.getPort(), Function.identity(), (oldValue, newValue) -> newValue, LinkedHashMap::new));
            List notExposedWithBindings = Optional.ofNullable(cmd.getPortBindings()).map(Ports::getBindings).orElse(Collections.emptyMap()).keySet().stream().filter(ep -> !exposedByPort.containsKey(ep.getPort())).collect(Collectors.toList());
            if (notExposedWithBindings.isEmpty()) {
                return;
            }
            ArrayList<Object> fixedExposed = new ArrayList<Object>();
            fixedExposed.addAll(exposedByPort.values());
            fixedExposed.addAll(notExposedWithBindings);
            cmd.withExposedPorts(fixedExposed);
        }
    }

    private class BuildCallback
    implements ResultCallback<BuildResponseItem> {
        private final Object myMutex = new Object();
        private String myError;
        private boolean myClosed = false;

        private BuildCallback() {
        }

        public void onStart(Closeable closeable) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(BuildResponseItem item) {
            Object object = this.myMutex;
            synchronized (object) {
                String progress;
                String imageTag;
                String imageId = item.getImageId();
                if (imageId != null) {
                    DockerAgentDeploymentImpl.this.myImageId = imageId;
                }
                if ((imageTag = this.getImageTag(item)) != null) {
                    DockerAgentDeploymentImpl.this.myImageTag = imageTag;
                }
                String error = item.getError();
                String stream = item.getStream();
                String status = item.getStatus();
                if (error != null) {
                    this.myError = error;
                    String errorMessage = error;
                    ResponseItem.ErrorDetail errorDetail = item.getErrorDetail();
                    if (errorDetail != null) {
                        errorMessage = errorDetail.toString();
                    }
                    DockerAgentDeploymentImpl.this.myLoggingHandler.println("Error: " + errorMessage);
                }
                if (stream != null) {
                    DockerAgentDeploymentImpl.this.myLoggingHandler.println(stream);
                }
                StringBuilder statusLine = new StringBuilder();
                if (status != null) {
                    statusLine.append("Status: ");
                    statusLine.append(status);
                }
                if ((progress = item.getProgress()) != null) {
                    statusLine.append(" Progress: ");
                    statusLine.append(progress);
                }
                if (statusLine.length() != 0) {
                    DockerAgentDeploymentImpl.this.myLoggingHandler.println(statusLine.toString());
                }
            }
        }

        private String getImageTag(BuildResponseItem item) {
            if (item.isErrorIndicated()) {
                return null;
            }
            String TAGGED_MESSAGE = "Successfully tagged";
            return Optional.ofNullable(item.getStream()).filter(s -> s.contains("Successfully tagged")).map(s -> s.replace("Successfully tagged", "")).map(String::trim).orElse(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onError(Throwable throwable) {
            Object object = this.myMutex;
            synchronized (object) {
                this.myError = throwable.getMessage();
                this.doClose();
            }
        }

        public void onComplete() {
            this.doClose();
        }

        public void close() throws IOException {
            this.doClose();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doClose() {
            Object object = this.myMutex;
            synchronized (object) {
                this.myClosed = true;
                this.myMutex.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitFor() throws ApiTaskException {
            Object object = this.myMutex;
            synchronized (object) {
                try {
                    while (!this.myClosed) {
                        this.myMutex.wait();
                    }
                }
                catch (InterruptedException e) {
                    DockerAgentDeploymentImpl.this.getLogger().debugEx((Exception)e);
                }
                if (this.myError != null) {
                    throw new ApiTaskException(this.myError);
                }
            }
        }
    }
}

