/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.AttachContainerCmd;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.ExecCreateCmd;
import com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.github.dockerjava.api.command.ExecStartCmd;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.command.LogContainerCmd;
import com.github.dockerjava.api.command.PushImageCmd;
import com.github.dockerjava.api.command.StartContainerCmd;
import com.github.dockerjava.api.command.TagImageCmd;
import com.github.dockerjava.api.command.TopContainerResponse;
import com.github.dockerjava.api.exception.NotModifiedException;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.api.model.StreamType;
import com.github.dockerjava.core.command.AttachContainerResultCallback;
import com.github.dockerjava.core.command.ExecStartResultCallback;
import com.github.dockerjava.core.command.WaitContainerResultCallback;
import com.intellij.docker.agent.ApiTaskBase;
import com.intellij.docker.agent.ApiTaskException;
import com.intellij.docker.agent.AuthConfigEx;
import com.intellij.docker.agent.CreateContainerCmdConfig;
import com.intellij.docker.agent.CreateContainerCmdInspection;
import com.intellij.docker.agent.CreateContainerCmdValueTransfers;
import com.intellij.docker.agent.DockerAgent;
import com.intellij.docker.agent.DockerAgentApplication;
import com.intellij.docker.agent.DockerAgentContainerConfigImpl;
import com.intellij.docker.agent.DockerAgentContainerInspectionImpl;
import com.intellij.docker.agent.DockerAgentContext;
import com.intellij.docker.agent.DockerAgentProgressCallback;
import com.intellij.docker.agent.DockerAgentRepositoryConfig;
import com.intellij.docker.agent.DockerAuthConfig;
import com.intellij.docker.agent.DockerUtil;
import com.intellij.docker.agent.OngoingProcess;
import com.intellij.docker.agent.OngoingProcessBase;
import com.intellij.docker.agent.PushImageResultCallbackImpl;
import com.intellij.docker.agent.StreamCallbackBase;
import com.intellij.docker.agent.settings.DockerAgentContainerConfig;
import com.intellij.docker.agent.settings.DockerAgentContainerInspection;
import com.intellij.remoteServer.agent.util.CloudAgentErrorHandler;
import com.intellij.remoteServer.agent.util.CloudAgentLogger;
import com.intellij.remoteServer.agent.util.CloudAgentLoggingHandler;
import com.intellij.remoteServer.agent.util.log.LogListener;
import com.intellij.remoteServer.agent.util.log.LogPipe;
import com.intellij.remoteServer.agent.util.log.LogPipeBase;
import com.intellij.remoteServer.agent.util.log.LogPipeProvider;
import com.intellij.remoteServer.agent.util.log.TerminalPipe;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public abstract class DockerAgentApplicationBase
implements DockerAgentApplication {
    private final DockerAgentContext myContext;
    private String myContainerId;
    private Map<String, String> myContainerLabels;

    public DockerAgentApplicationBase(DockerAgentContext context) {
        this.myContext = context;
    }

    protected final DockerClient getClient() {
        return this.myContext.getClient();
    }

    protected final CloudAgentErrorHandler getErrorHandler() {
        return this.myContext.getErrorHandler();
    }

    protected final CloudAgentLogger getLogger() {
        return this.myContext.getLogger();
    }

    protected final DockerAgent getAgent() {
        return this.myContext.getAgent();
    }

    public String getContainerId() {
        return this.myContainerId;
    }

    protected void setContainerId(String containerId) {
        this.myContainerId = containerId;
    }

    public final Map<String, String> getContainerLabels() {
        return this.myContainerLabels;
    }

    protected void setContainerLabels(@Nullable Map<String, String> containerLabels) {
        this.myContainerLabels = containerLabels == null ? null : new HashMap<String, String>(containerLabels);
    }

    public void startContainer() {
        new StateChangeTaskBase(this.getErrorHandler()){

            @Override
            protected void doPerformStateChange() throws IOException, ApiTaskException {
                DockerAgentApplicationBase.this.getClient().startContainerCmd(DockerAgentApplicationBase.this.getContainerId()).exec();
            }
        }.perform();
    }

    public void stopContainer() {
        this.stopContainerImmediate(this.getErrorHandler());
    }

    public void stopContainerImmediate(CloudAgentErrorHandler errorHandler) {
        new StateChangeTaskBase(errorHandler){

            @Override
            protected void doPerformStateChange() throws IOException, ApiTaskException {
                DockerAgentApplicationBase.this.getClient().stopContainerCmd(DockerAgentApplicationBase.this.getContainerId()).exec();
            }
        }.perform();
    }

    public void deleteContainer() {
        new ApiTaskBase(this.getErrorHandler()){

            @Override
            protected Object doPerform() throws IOException, ApiTaskException {
                DockerAgentApplicationBase.this.getClient().removeContainerCmd(DockerAgentApplicationBase.this.getContainerId()).withForce(Boolean.valueOf(true)).exec();
                return null;
            }
        }.perform();
    }

    public void deleteContainerWithVolumes() {
        new ApiTaskBase(this.getErrorHandler()){

            @Override
            protected Object doPerform() throws IOException, ApiTaskException {
                DockerAgentApplicationBase.this.getClient().removeContainerCmd(DockerAgentApplicationBase.this.getContainerId()).withForce(Boolean.valueOf(true)).withRemoveVolumes(Boolean.valueOf(true)).exec();
                return null;
            }
        }.perform();
    }

    public void deleteImage() {
        new ApiTaskBase(this.getErrorHandler()){

            @Override
            protected Object doPerform() throws IOException, ApiTaskException {
                DockerAgentApplicationBase.this.getClient().removeImageCmd(DockerAgentApplicationBase.this.getImageId()).withForce(Boolean.valueOf(true)).exec();
                return null;
            }
        }.perform();
    }

    public String createContainer() {
        return (String)new ApiTaskBase<String>(this.getErrorHandler()){

            @Override
            protected String doPerform() throws IOException, ApiTaskException {
                CreateContainerCmd createContainerCmd = DockerAgentApplicationBase.this.getClient().createContainerCmd(DockerAgentApplicationBase.this.getImageId());
                CreateContainerResponse createContainerResponse = createContainerCmd.exec();
                String containerId = createContainerResponse.getId();
                StartContainerCmd startContainerCmd = DockerAgentApplicationBase.this.getClient().startContainerCmd(containerId);
                startContainerCmd.exec();
                return containerId;
            }
        }.perform();
    }

    public String getWebUrl() {
        throw new UnsupportedOperationException();
    }

    public void showLog(final CloudAgentLoggingHandler loggingHandler) {
        new ApiTaskBase<Object>(this.getErrorHandler()){

            @Override
            protected Object doPerform() throws IOException, ApiTaskException {
                DockerAgentApplicationBase.this.doShowLog(DockerAgentApplicationBase.this.getContainerId(), loggingHandler);
                return null;
            }
        }.perform();
    }

    protected void doShowLog(String containerId, CloudAgentLoggingHandler loggingHandler) throws IOException, ApiTaskException {
        final DockerLogPipe logPipe = new DockerLogPipe(containerId, loggingHandler);
        this.myContext.getLogManager().startListeningLog(containerId, new LogPipeProvider(){

            public List<? extends LogPipe> createLogPipes(String deploymentName) {
                return Collections.singletonList(logPipe);
            }
        });
    }

    public void inspect2log(final CloudAgentLoggingHandler loggingHandler) {
        new ApiTaskBase(this.getErrorHandler()){

            @Override
            protected Object doPerform() throws IOException, ApiTaskException {
                LogListener logListener = loggingHandler.getOrCreateEmptyLogListener("Inspection");
                InspectContainerResponse response = DockerAgentApplicationBase.this.getClient().inspectContainerCmd(DockerAgentApplicationBase.this.getContainerId()).exec();
                ObjectMapper objectMapper = new ObjectMapper();
                String responseString = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)response);
                logListener.lineLogged(responseString);
                return null;
            }
        }.perform();
    }

    public DockerAgentContainerInspection inspect() {
        return (DockerAgentContainerInspection)new ApiTaskBase<DockerAgentContainerInspection>(this.getErrorHandler()){

            @Override
            protected DockerAgentContainerInspection doPerform() throws IOException, ApiTaskException {
                InspectContainerResponse inspectResponse = DockerAgentApplicationBase.this.getClient().inspectContainerCmd(DockerAgentApplicationBase.this.getContainerId()).exec();
                CreateContainerCmdInspection inspection = new CreateContainerCmdInspection(inspectResponse);
                CreateContainerCmdConfig cmdConfig = new CreateContainerCmdConfig();
                String containerName = inspectResponse.getName();
                if (containerName != null) {
                    cmdConfig.withName(containerName);
                }
                CreateContainerCmdValueTransfers.createContainerCmdValueTransfer(binds -> DockerAgentApplicationBase.this.prepareBinds((Bind[])binds)).transferFromTo(inspection, (CreateContainerCmd)cmdConfig);
                return new DockerAgentContainerInspectionImpl((CreateContainerCmd)cmdConfig, inspectResponse.getState().getRunning());
            }
        }.perform();
    }

    public void showProcesses(final CloudAgentLoggingHandler loggingHandler) {
        new ApiTaskBase(this.getErrorHandler()){

            @Override
            protected Object doPerform() throws IOException, ApiTaskException {
                LogListener logListener = loggingHandler.getOrCreateEmptyLogListener("Processes");
                TopContainerResponse response = DockerAgentApplicationBase.this.getClient().topContainerCmd(DockerAgentApplicationBase.this.getContainerId()).exec();
                ObjectMapper objectMapper = new ObjectMapper();
                String responseString = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)response);
                logListener.lineLogged(responseString);
                return null;
            }
        }.perform();
    }

    public void attach(final CloudAgentLoggingHandler loggingHandler) {
        new ApiTaskBase<Object>(this.getErrorHandler()){

            @Override
            protected Object doPerform() throws IOException, ApiTaskException {
                DockerAgentApplicationBase.this.doAttach(DockerAgentApplicationBase.this.getContainerId(), loggingHandler);
                return null;
            }
        }.perform();
    }

    protected void doAttach(String containerId, CloudAgentLoggingHandler loggingHandler) throws IOException, ApiTaskException {
        this.doAttachPipe(containerId, (LogPipeBase)new DocketAttachHijackPipe(containerId, loggingHandler));
    }

    private void doAttachPipe(String containerId, final LogPipeBase attachPipe) throws IOException, ApiTaskException {
        this.myContext.getLogManager().startListeningLog(containerId + " attach", new LogPipeProvider(){

            public List<? extends LogPipeBase> createLogPipes(String deploymentName) {
                return Collections.singletonList(attachPipe);
            }
        });
    }

    public OngoingProcess exec(final CloudAgentLoggingHandler loggingHandler, final String[] command, final String logName) {
        return (OngoingProcess)new ApiTaskBase<OngoingProcess>(this.getErrorHandler()){

            @Override
            protected OngoingProcess doPerform() throws IOException, ApiTaskException {
                return DockerAgentApplicationBase.this.doExec(loggingHandler, command, logName);
            }
        }.perform();
    }

    protected OngoingProcess doExec(CloudAgentLoggingHandler loggingHandler, String[] command, String logName) throws IOException, ApiTaskException {
        final DockerExecPipe execPipe = new DockerExecPipe(loggingHandler, command, logName);
        StringBuilder id = new StringBuilder();
        id.append(this.getContainerId());
        id.append(" exec");
        for (String commandPart : command) {
            id.append(" ");
            id.append(commandPart);
        }
        this.myContext.getLogManager().startListeningLog(id.toString(), new LogPipeProvider(){

            public List<? extends LogPipeBase> createLogPipes(String deploymentName) {
                return Collections.singletonList(execPipe);
            }
        });
        return new OngoingProcessBase(this.getLogger()){

            public void cancel() {
                DockerAgentApplicationBase.this.stopContainerImmediate(this.getErrorHandler());
            }

            public void await() {
                DockerAgentApplicationBase.this.waitForExitImmediate(this.getErrorHandler());
            }
        };
    }

    public OngoingProcess pushImage(final DockerAgentRepositoryConfig repositoryConfig, final DockerAgentProgressCallback progressCallback) {
        return (OngoingProcess)new ApiTaskBase<OngoingProcess>(this.getErrorHandler()){

            @Override
            protected OngoingProcess doPerform() throws IOException, ApiTaskException {
                String repository = repositoryConfig.getQualifiedRepository();
                String tag = repositoryConfig.getTag();
                if (!this.hasImageTag()) {
                    TagImageCmd tagImageCmd = DockerAgentApplicationBase.this.getClient().tagImageCmd(DockerAgentApplicationBase.this.getImageId(), repository, tag);
                    tagImageCmd.exec();
                }
                PushImageCmd pushImageCmd = DockerAgentApplicationBase.this.getClient().pushImageCmd(repository);
                DockerAuthConfig customAuthConfig = repositoryConfig.getAuthConfig();
                if (customAuthConfig != null) {
                    pushImageCmd.withAuthConfig((AuthConfig)new AuthConfigEx(customAuthConfig));
                }
                if (tag != null) {
                    pushImageCmd.withTag(tag);
                }
                return (OngoingProcess)pushImageCmd.exec((ResultCallback)new PushImageResultCallbackImpl(progressCallback, DockerAgentApplicationBase.this.getLogger(), repositoryConfig.getQualifiedTag()));
            }

            private boolean hasImageTag() {
                return Arrays.asList(DockerAgentApplicationBase.this.getImageRepoTags()).contains(repositoryConfig.getQualifiedTag());
            }
        }.perform();
    }

    public void updateContainer(final DockerAgentContainerConfig config) {
        new ApiTaskBase(this.getErrorHandler()){

            @Override
            protected Object doPerform() throws IOException, ApiTaskException {
                InspectContainerResponse inspectResponse = DockerAgentApplicationBase.this.getClient().inspectContainerCmd(DockerAgentApplicationBase.this.getContainerId()).exec();
                DockerAgentApplicationBase.this.getClient().removeContainerCmd(DockerAgentApplicationBase.this.getContainerId()).withForce(Boolean.valueOf(true)).exec();
                CreateContainerCmdInspection inspection = new CreateContainerCmdInspection(inspectResponse);
                CreateContainerCmd createContainerCmd = DockerAgentApplicationBase.this.getClient().createContainerCmd(DockerAgentApplicationBase.this.getImageId());
                String containerName = inspectResponse.getName();
                if (containerName != null) {
                    createContainerCmd.withName(containerName);
                }
                CreateContainerCmdValueTransfers.createMergeForUpdate(binds -> DockerAgentApplicationBase.this.prepareBinds((Bind[])binds)).mergeWithPriority(new DockerAgentContainerConfigImpl(config), inspection, createContainerCmd);
                DockerAgentApplicationBase.this.setupContainerConfig(createContainerCmd);
                CreateContainerResponse createContainerResponse = createContainerCmd.exec();
                String containerId = createContainerResponse.getId();
                DockerAgentApplicationBase.this.setContainerId(containerId);
                if (!DockerUtil.isStoppedStatus((String)DockerAgentApplicationBase.this.getContainerStatus())) {
                    DockerAgentApplicationBase.this.getClient().startContainerCmd(containerId).exec();
                }
                return null;
            }
        }.perform();
    }

    protected void setupContainerConfig(CreateContainerCmd target) {
        if (target.getHostConfig() != null && target.getHostConfig().getOomScoreAdj() != null) {
            target.getHostConfig().withOomScoreAdj(null);
        }
    }

    protected Bind[] prepareBinds(Bind[] binds) {
        return binds;
    }

    public String getImageUser() {
        return (String)new ApiTaskBase<String>(this.getErrorHandler()){

            @Override
            protected String doPerform() throws IOException, ApiTaskException {
                return DockerAgentApplicationBase.this.getClient().inspectImageCmd(DockerAgentApplicationBase.this.getImageId()).exec().getConfig().getUser();
            }
        }.perform();
    }

    public InputStream copyArchiveFromContainer(final String sourceDirPath) {
        return (InputStream)new ApiTaskBase<InputStream>(this.getErrorHandler()){

            @Override
            protected InputStream doPerform() throws IOException, ApiTaskException {
                return DockerAgentApplicationBase.this.getClient().copyArchiveFromContainerCmd(DockerAgentApplicationBase.this.getContainerId(), sourceDirPath).exec();
            }
        }.perform();
    }

    public int waitForExit() {
        return this.waitForExitImmediate(this.getErrorHandler());
    }

    public int waitForExitImmediate(CloudAgentErrorHandler errorHandler) {
        return (Integer)new ApiTaskBase<Integer>(errorHandler){

            @Override
            protected Integer doPerform() throws IOException, ApiTaskException {
                return ((WaitContainerResultCallback)DockerAgentApplicationBase.this.getClient().waitContainerCmd(DockerAgentApplicationBase.this.myContainerId).exec((ResultCallback)new WaitContainerResultCallback())).awaitStatusCode();
            }
        }.perform();
    }

    private static class MyPipedInputStream
    extends PipedInputStream {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized int read(byte[] b, int off, int len) throws IOException {
            try {
                int n = super.read(b, off, len);
                return n;
            }
            finally {
                this.notifyAll();
            }
        }
    }

    private abstract class TerminalPipeBase
    extends TerminalPipe {
        private final PipedInputStream myInputStream;
        private final PipedOutputStream myReversedInputStream;
        private final OutputStream myOutputStream;
        private final PipedInputStream myReversedOutputStream;
        private final PipedInputStream myStderr;
        private final PipedOutputStream myReversedStderr;

        public TerminalPipeBase(String logPipeName, CloudAgentLoggingHandler loggingHandler) throws IOException {
            super(logPipeName, loggingHandler);
            this.myReversedOutputStream = new MyPipedInputStream();
            this.myOutputStream = new PipedOutputStream(this.myReversedOutputStream);
            this.myInputStream = new MyPipedInputStream();
            this.myReversedInputStream = new PipedOutputStream(this.myInputStream);
            this.myStderr = new MyPipedInputStream();
            this.myReversedStderr = new PipedOutputStream(this.myStderr);
        }

        protected PipedOutputStream getReversedInputStream() {
            return this.myReversedInputStream;
        }

        protected PipedInputStream getReversedOutputStream() {
            return this.myReversedOutputStream;
        }

        protected PipedOutputStream getReversedStderr() {
            return this.myReversedStderr;
        }

        public void close() {
            try {
                this.myOutputStream.close();
                this.myReversedInputStream.close();
                this.myReversedStderr.close();
            }
            catch (IOException e) {
                DockerAgentApplicationBase.this.getLogger().debugEx((Exception)e);
            }
            super.close();
        }

        protected OutputStream getOutputStream() {
            return this.myOutputStream;
        }

        protected InputStream getInputStream() {
            return this.myInputStream;
        }

        protected InputStream getStderr() {
            return this.myStderr;
        }
    }

    private class DockerExecPipe
    extends TerminalPipeBase {
        public DockerExecPipe(CloudAgentLoggingHandler loggingHandler, String[] command, String logName) throws IOException, ApiTaskException {
            super(logName, loggingHandler);
            ExecCreateCmd execCreateCmd = DockerAgentApplicationBase.this.getClient().execCreateCmd(DockerAgentApplicationBase.this.getContainerId()).withAttachStdout(Boolean.valueOf(true)).withAttachStdin(Boolean.valueOf(true)).withAttachStderr(Boolean.valueOf(true)).withTty(Boolean.valueOf(true)).withCmd(command);
            String execId = ((ExecCreateCmdResponse)execCreateCmd.exec()).getId();
            ExecStartCmd execStartCmd = DockerAgentApplicationBase.this.getClient().execStartCmd(execId).withDetach(Boolean.valueOf(false)).withStdIn((InputStream)this.getReversedOutputStream());
            execStartCmd.exec((ResultCallback)new ExecStartResultCallback(this.getReversedInputStream(), this.getReversedStderr()){

                public void close() throws IOException {
                    DockerExecPipe.this.close();
                    super.close();
                }
            });
        }
    }

    private static abstract class StateChangeTaskBase
    extends ApiTaskBase {
        public StateChangeTaskBase(CloudAgentErrorHandler errorHandler) {
            super(errorHandler);
        }

        @Override
        protected Object doPerform() throws IOException, ApiTaskException {
            try {
                this.doPerformStateChange();
            }
            catch (NotModifiedException e) {
                String message = e.getMessage();
                throw new NotModifiedException(message == null ? "Possibly, container is in the target state already" : message, (Throwable)e);
            }
            return null;
        }

        protected abstract void doPerformStateChange() throws IOException, ApiTaskException;
    }

    public class DocketAttachHijackPipe
    extends TerminalPipeBase {
        public DocketAttachHijackPipe(String containerId, CloudAgentLoggingHandler loggingHandler) throws IOException, ApiTaskException {
            super("Attached console", loggingHandler);
            AttachContainerCmd attachContainerCmd = DockerAgentApplicationBase.this.getClient().attachContainerCmd(containerId).withFollowStream(Boolean.valueOf(true)).withStdErr(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).withStdIn((InputStream)this.getReversedOutputStream());
            attachContainerCmd.exec((ResultCallback)new AttachContainerResultCallback(){

                public void close() throws IOException {
                    DocketAttachHijackPipe.this.close();
                    super.close();
                }

                public void onNext(Frame item) {
                    try {
                        PipedOutputStream stream = item.getStreamType() == StreamType.STDERR ? DocketAttachHijackPipe.this.getReversedStderr() : DocketAttachHijackPipe.this.getReversedInputStream();
                        stream.write(item.getPayload());
                    }
                    catch (IOException e) {
                        DockerAgentApplicationBase.this.getLogger().debugEx((Exception)e);
                    }
                }
            });
        }
    }

    private class DockerLogPipe
    extends LogPipe {
        private final StreamCallbackBase<Frame> myStreamCallback;

        public DockerLogPipe(String containerId, CloudAgentLoggingHandler loggingHandler) throws IOException {
            super(containerId, "Log", DockerAgentApplicationBase.this.getLogger(), loggingHandler);
            LogContainerCmd logContainerCmd = DockerAgentApplicationBase.this.getClient().logContainerCmd(DockerAgentApplicationBase.this.getContainerId()).withFollowStream(Boolean.valueOf(true)).withStdErr(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).withTimestamps(Boolean.valueOf(false));
            this.myStreamCallback = new StreamCallbackBase<Frame>(DockerAgentApplicationBase.this.getLogger()){

                @Override
                protected void onNextWrite(Frame packet) throws IOException {
                    PipedOutputStream reverseOfInputStream = this.getReverseOfInputStream();
                    reverseOfInputStream.write(packet.getPayload());
                    reverseOfInputStream.flush();
                }

                @Override
                public void close() throws IOException {
                    super.close();
                    DockerLogPipe.this.close();
                }
            };
            logContainerCmd.exec(this.myStreamCallback);
        }

        protected InputStream createInputStream(String containerId) {
            return this.myStreamCallback.getInputStream();
        }
    }
}

