/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.django;

import com.google.common.collect.ImmutableMap;
import com.intellij.database.autoconfig.DataSourceConfiguration;
import com.intellij.database.autoconfig.DataSourceDetector;
import com.intellij.database.autoconfig.JdbcDriversMappings;
import com.intellij.database.django.PyDataSourceConfiguration;
import com.intellij.database.util.DbUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.text.UniqueNameGenerator;
import com.jetbrains.django.codeInsight.DjangoSettingsPy;
import com.jetbrains.django.util.DjangoUtil;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPathEvaluator;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DjangoDataSourceDetector
extends DataSourceDetector {
    private static final Map<String, JdbcDriversMappings.JdbcMapping> ourEngineMappings = ImmutableMap.builder().put((Object)"postgresql", (Object)JdbcDriversMappings.POSTGRES).put((Object)"postgresql_psycopg2", (Object)JdbcDriversMappings.POSTGRES).put((Object)"mysql", (Object)JdbcDriversMappings.MYSQL).put((Object)"sqlite3", (Object)JdbcDriversMappings.SQLITE).build();

    public void collectDataSources(@NotNull Project project, @NotNull DataSourceDetector.Builder builder) {
        if (project == null) {
            DjangoDataSourceDetector.$$$reportNull$$$0(0);
        }
        if (builder == null) {
            DjangoDataSourceDetector.$$$reportNull$$$0(1);
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            DjangoDataSourceDetector.collectDataSourcesInner(module, builder, true);
        }
    }

    public void collectDataSources(@NotNull Module module, @NotNull DataSourceDetector.Builder builder, boolean onTheFly) {
        if (module == null) {
            DjangoDataSourceDetector.$$$reportNull$$$0(2);
        }
        if (builder == null) {
            DjangoDataSourceDetector.$$$reportNull$$$0(3);
        }
        DjangoDataSourceDetector.collectDataSourcesInner(module, builder, false);
    }

    private static void collectDataSourcesInner(Module module, DataSourceDetector.Builder result, boolean uniqueNames) {
        final PyFile settingsFile = DjangoSettingsPy.getSettingsFile((Module)module);
        if (settingsFile == null) {
            return;
        }
        PyTargetExpression attribute = PyPsiUtils.getAttribute((PyFile)settingsFile, (String)"DATABASES");
        Set existingDataSourceNames = DbUtil.getExistingDataSourceNames((Project)module.getProject());
        if (attribute != null) {
            PyExpression value = attribute.findAssignedValue();
            if (value instanceof PyDictLiteralExpression) {
                PyKeyValueExpression[] elements;
                for (PyKeyValueExpression element : elements = ((PyDictLiteralExpression)value).getElements()) {
                    String name = "Django " + PyPsiUtils.strValue((PyExpression)element.getKey());
                    String dsName = uniqueNames ? UniqueNameGenerator.generateUniqueName((String)name, (Collection)existingDataSourceNames) : name;
                    DjangoDataSourceDetector.createDataSource(dsName, element.getValue(), result);
                }
            }
        } else {
            PyTargetExpression engine = settingsFile.findTopLevelAttribute("DATABASE_ENGINE");
            String engineName = PyPsiUtils.strValue((PyExpression)(engine == null ? null : engine.findAssignedValue()));
            JdbcDriversMappings.JdbcMapping mapping = DjangoDataSourceDetector.mappingForEngine(engineName);
            if (mapping != null) {
                PsiDirectory root = DjangoUtil.getProjectRoot((PsiFileSystemItem)settingsFile);
                PyDataSourceConfiguration configuration = new PyDataSourceConfiguration(root){

                    @Override
                    public String getOption(String name) {
                        PyTargetExpression expression = settingsFile.findTopLevelAttribute("DATABASE_" + name);
                        return expression == null ? null : PyPathEvaluator.evaluatePath((PyExpression)expression.findAssignedValue());
                    }
                };
                String name = "Django Default";
                String dsName = uniqueNames ? UniqueNameGenerator.generateUniqueName((String)"Django Default", (Collection)existingDataSourceNames) : "Django Default";
                mapping.createDataSource((PsiElement)engine, "Django", dsName, (DataSourceConfiguration)configuration, result);
            }
        }
    }

    private static void createDataSource(String name, PyExpression value, DataSourceDetector.Builder builder) {
        if (!(value instanceof PyDictLiteralExpression)) {
            return;
        }
        final Map map = PyUtil.dictValue((PyDictLiteralExpression)((PyDictLiteralExpression)value));
        String engineName = PyPsiUtils.strValue((PyExpression)((PyExpression)map.get("ENGINE")));
        JdbcDriversMappings.JdbcMapping mapping = DjangoDataSourceDetector.mappingForEngine(engineName);
        if (mapping != null) {
            PsiDirectory root = DjangoUtil.getProjectRoot((PsiElement)value);
            PyDataSourceConfiguration configuration = new PyDataSourceConfiguration(root){

                @Override
                public String getOption(String name) {
                    return PyPathEvaluator.evaluatePath((PyExpression)((PyExpression)map.get(name)));
                }
            };
            mapping.createDataSource((PsiElement)value, "Django", name, (DataSourceConfiguration)configuration, builder);
        }
    }

    private static JdbcDriversMappings.JdbcMapping mappingForEngine(String engineName) {
        if (engineName == null) {
            return null;
        }
        engineName = StringUtil.trimStart((String)engineName, (String)"django.db.backends.");
        return ourEngineMappings.get(engineName);
    }

    public boolean isRelevantFile(@NotNull PsiFile file) {
        if (file == null) {
            DjangoDataSourceDetector.$$$reportNull$$$0(4);
        }
        PyPsiUtils.assertValid((PsiElement)file);
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module != null) {
            return Comparing.equal((Object)file.getVirtualFile(), (Object)DjangoUtil.getSettingsFile((Module)module));
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/django/DjangoDataSourceDetector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectDataSources";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isRelevantFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

