/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.control;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ConstantIfStatementJSInspection
extends JavaScriptInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("constant.if.statement.display.name", new Object[0]);
        if (string == null) {
            ConstantIfStatementJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.CONTROL_FLOW_GROUP_NAME;
        if (string == null) {
            ConstantIfStatementJSInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... args) {
        String string = InspectionJSBundle.message("constant.if.statement.problem.descriptor", new Object[0]);
        if (string == null) {
            ConstantIfStatementJSInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConstantIfStatementVisitor();
    }

    @Override
    public InspectionJSFix buildFix(PsiElement location) {
        return new ConstantIfStatementFix();
    }

    protected static void replaceStatementOrRemove(JSStatement statement, @NonNls String newStatement) throws IncorrectOperationException {
        ASTNode fromText = StringUtil.isEmptyOrSpaces((String)newStatement) ? null : JSChangeUtil.createJSTreeFromTextWithContext(newStatement, (PsiElement)statement);
        PsiElement statementToAdd = fromText != null ? fromText.getPsi() : null;
        JSStatement anchor = statement;
        PsiElement parent = anchor.getParent();
        while (statementToAdd != null) {
            anchor = parent.addAfter(statementToAdd, (PsiElement)anchor);
            statementToAdd = PsiTreeUtil.getNextSiblingOfType((PsiElement)statementToAdd, JSStatement.class);
        }
        statement.delete();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/sixrr/inspectjs/control/ConstantIfStatementJSInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ConstantIfStatementVisitor
    extends BaseInspectionVisitor {
        private ConstantIfStatementVisitor() {
        }

        public void visitJSIfStatement(JSIfStatement statement) {
            super.visitJSIfStatement(statement);
            JSExpression condition = statement.getCondition();
            if (condition == null) {
                return;
            }
            JSStatement thenBranch = statement.getThen();
            if (thenBranch == null) {
                return;
            }
            if (ControlFlowUtils.isTrue(condition) || ControlFlowUtils.isFalse(condition)) {
                this.registerStatementError((JSStatement)statement, new Object[0]);
            }
        }
    }

    public static class ConstantIfStatementFix
    extends InspectionJSFix {
        @NotNull
        public String getFamilyName() {
            String string = InspectionJSBundle.message("constant.conditional.expression.simplify.quickfix", new Object[0]);
            if (string == null) {
                ConstantIfStatementFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            PsiElement ifKeyword = descriptor2.getPsiElement();
            JSIfStatement statement = (JSIfStatement)ifKeyword.getParent();
            assert (statement != null);
            ConstantIfStatementFix.simplifyConstantIf(statement);
        }

        public static void simplifyConstantIf(@NotNull JSIfStatement statement) {
            if (statement == null) {
                ConstantIfStatementFix.$$$reportNull$$$0(1);
            }
            JSStatement thenBranch = statement.getThen();
            JSStatement elseBranch = statement.getElse();
            JSExpression condition = statement.getCondition();
            if (ControlFlowUtils.isFalse(condition)) {
                if (elseBranch != null) {
                    ConstantIfStatementFix.replaceStatementWithUnwrapping(elseBranch, statement);
                } else {
                    ConstantIfStatementFix.deleteElement((PsiElement)statement);
                }
            } else {
                ConstantIfStatementFix.replaceStatementWithUnwrapping(thenBranch, statement);
            }
        }

        private static void replaceStatementWithUnwrapping(JSStatement branch, JSIfStatement statement) throws IncorrectOperationException {
            String branchText = branch.getText();
            if (branchText.startsWith("{") && branchText.endsWith("}")) {
                branchText = branchText.substring(1, branchText.length() - 1).trim();
            }
            ConstantIfStatementJSInspection.replaceStatementOrRemove((JSStatement)statement, branchText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/sixrr/inspectjs/control/ConstantIfStatementJSInspection$ConstantIfStatementFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/sixrr/inspectjs/control/ConstantIfStatementJSInspection$ConstantIfStatementFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "simplifyConstantIf";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

