/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.sixrr.inspectjs.BaseInspection;
import com.sixrr.inspectjs.InspectionJSFix;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class BaseInspectionVisitor
extends JSElementVisitor {
    private BaseInspection inspection = null;
    protected ProblemsHolder problemsHolder = null;
    private boolean onTheFly = false;
    private final List<ProblemDescriptor> errors = null;

    public void setInspection(BaseInspection inspection) {
        this.inspection = inspection;
    }

    public void setProblemsHolder(ProblemsHolder problemsHolder) {
        this.problemsHolder = problemsHolder;
    }

    public void setOnTheFly(boolean onTheFly) {
        this.onTheFly = onTheFly;
    }

    protected void registerFunctionCallError(JSCallExpression expression) {
        JSExpression methodExpression = expression.getMethodExpression();
        Object errorLocation = null;
        if (methodExpression instanceof JSReferenceExpression) {
            errorLocation = ((JSReferenceExpression)methodExpression).getReferenceNameElement();
        } else if (methodExpression instanceof JSFunction) {
            ASTNode node = ((JSFunction)methodExpression).findNameIdentifier();
            errorLocation = node != null ? node.getPsi() : methodExpression;
        }
        this.registerError((PsiElement)errorLocation);
    }

    protected void registerStatementError(JSStatement statement, Object ... args) {
        PsiElement statementToken = statement.getFirstChild();
        if (statementToken != null && statementToken.getTextLength() == 0) {
            statementToken = statementToken.getNextSibling();
        }
        this.registerError(statementToken, args);
    }

    protected void registerFunctionError(JSFunction function) {
        ASTNode identifier = function.findNameIdentifier();
        if (identifier == null || !PsiTreeUtil.isAncestor((PsiElement)function, (PsiElement)identifier.getPsi(), (boolean)true)) {
            PsiElement childForTarget = function.getFirstChild();
            if (childForTarget instanceof JSAttributeList) {
                childForTarget = JSPsiImplUtils.findNextCodeElement(childForTarget);
            }
            this.registerError(childForTarget);
        } else {
            this.registerError(identifier.getPsi());
        }
    }

    protected void registerVariableError(JSVariable variable) {
        PsiElement nameIdentifier = variable.getNameIdentifier();
        this.registerError(nameIdentifier);
    }

    protected void registerError(PsiElement location) {
        if (location == null) {
            return;
        }
        LocalQuickFix[] fix = this.createFixes(location);
        String description = this.inspection.buildErrorString(location);
        this.registerError(location, description, fix);
    }

    private void registerError(PsiElement location, String description, LocalQuickFix[] fixes) {
        this.problemsHolder.registerProblem(location, description, this.getProblemHighlightType(location), fixes);
    }

    protected ProblemHighlightType getProblemHighlightType(PsiElement location) {
        return ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
    }

    protected void registerError(PsiElement location, Object ... args) {
        LocalQuickFix[] fix = this.createFixes(location);
        String description = this.inspection.buildErrorString(args);
        this.registerError(location, description, fix);
    }

    @Nullable
    private LocalQuickFix[] createFixes(PsiElement location) {
        if (!this.onTheFly && this.inspection.buildQuickFixesOnlyForOnTheFlyErrors()) {
            return null;
        }
        LocalQuickFix[] fixes = this.inspection.buildFixes(location, this.onTheFly);
        if (fixes != null) {
            return fixes;
        }
        InspectionJSFix fix = this.inspection.buildFix(location);
        if (fix == null) {
            return null;
        }
        return new InspectionJSFix[]{fix};
    }

    @Nullable
    public ProblemDescriptor[] getErrors() {
        if (this.errors == null) {
            return null;
        }
        int numErrors = this.errors.size();
        return this.errors.toArray(new ProblemDescriptor[numErrors]);
    }

    public void visitWhiteSpace(PsiWhiteSpace space) {
    }

    public static PsiElement findValidEditorLocation(PsiElement location) {
        PsiElement editorErrorLocation = PsiTreeUtil.lastChild((PsiElement)location);
        while (editorErrorLocation instanceof PsiErrorElement || editorErrorLocation != null && editorErrorLocation.getTextLength() == 0) {
            editorErrorLocation = PsiTreeUtil.prevLeaf((PsiElement)editorErrorLocation);
        }
        return editorErrorLocation;
    }
}

