/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig.graph;

import com.intellij.ProjectTopics;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileImportsImpl;
import com.intellij.lang.typescript.tsconfig.graph.TypeScriptImportGraph;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptConfigGraphCache
implements Disposable {
    private static final Logger LOG = Logger.getInstance(TypeScriptConfigGraphCache.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final ConcurrentMap<String, TypeScriptImportGraph> myCache;
    @NotNull
    private final Set<VirtualFile> myFilesToRecalculateEdges;

    public TypeScriptConfigGraphCache(@NotNull Project project) {
        if (project == null) {
            TypeScriptConfigGraphCache.$$$reportNull$$$0(0);
        }
        this.myCache = new ConcurrentHashMap<String, TypeScriptImportGraph>();
        this.myFilesToRecalculateEdges = ContainerUtil.newConcurrentSet();
        this.myProject = project;
        project.getMessageBus().connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (VFileEvent vFileEvent : events) {
                    if (!TypeScriptConfigGraphCache.isAcceptableEvent(vFileEvent)) continue;
                    if (vFileEvent instanceof VFileContentChangeEvent || vFileEvent instanceof VFilePropertyChangeEvent && !TypeScriptConfigGraphCache.isFileNameChange((VFilePropertyChangeEvent)vFileEvent)) {
                        TypeScriptConfigGraphCache.this.addToRecalculateQueue(vFileEvent.getFile());
                        continue;
                    }
                    TypeScriptConfigGraphCache.this.reset();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/lang/typescript/tsconfig/graph/TypeScriptConfigGraphCache$1", "after"));
            }
        });
        project.getMessageBus().connect().subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(ModuleRootEvent event) {
                TypeScriptConfigGraphCache.this.reset();
            }
        });
    }

    private static boolean isFileNameChange(@NotNull VFilePropertyChangeEvent event) {
        if (event == null) {
            TypeScriptConfigGraphCache.$$$reportNull$$$0(1);
        }
        return "name".equals(event.getPropertyName());
    }

    private static boolean isAcceptableEvent(@NotNull VFileEvent event) {
        VirtualFile file2;
        if (event == null) {
            TypeScriptConfigGraphCache.$$$reportNull$$$0(2);
        }
        return (file2 = event.getFile()) != null && TypeScriptUtil.TYPESCRIPT_FILE_TYPES.contains(file2.getFileType());
    }

    @NotNull
    public final TypeScriptImportGraph getGraph(@NotNull TypeScriptConfig config2) {
        if (config2 == null) {
            TypeScriptConfigGraphCache.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.processFilesToRecalculate();
        String configPath = config2.getConfigFile().getPath();
        TypeScriptFileImportsImpl references = new TypeScriptFileImportsImpl(this.myProject, config2);
        TypeScriptImportGraph graph = (TypeScriptImportGraph)this.myCache.get(configPath);
        if (graph != null && !graph.getFileImports().equals(references)) {
            ProgressManager.checkCanceled();
            this.myCache.computeIfPresent(configPath, (key, current) -> {
                if (current == graph) {
                    return this.createValue(configPath, references, true);
                }
                return current;
            });
            TypeScriptImportGraph typeScriptImportGraph = (TypeScriptImportGraph)this.myCache.get(configPath);
            if (typeScriptImportGraph == null) {
                TypeScriptConfigGraphCache.$$$reportNull$$$0(4);
            }
            return typeScriptImportGraph;
        }
        if (graph == null) {
            ProgressManager.checkCanceled();
            this.myCache.computeIfAbsent(configPath, el -> this.createValue(configPath, references, false));
            TypeScriptImportGraph typeScriptImportGraph = (TypeScriptImportGraph)this.myCache.get(configPath);
            if (typeScriptImportGraph == null) {
                TypeScriptConfigGraphCache.$$$reportNull$$$0(5);
            }
            return typeScriptImportGraph;
        }
        TypeScriptImportGraph typeScriptImportGraph = graph;
        if (typeScriptImportGraph == null) {
            TypeScriptConfigGraphCache.$$$reportNull$$$0(6);
        }
        return typeScriptImportGraph;
    }

    @NotNull
    public TypeScriptImportGraph createValue(@NotNull String configPath, @NotNull TypeScriptFileImportsImpl references, boolean rebuild) {
        if (configPath == null) {
            TypeScriptConfigGraphCache.$$$reportNull$$$0(7);
        }
        if (references == null) {
            TypeScriptConfigGraphCache.$$$reportNull$$$0(8);
        }
        ProgressManager.checkCanceled();
        TypeScriptConfigGraphCache.logStartGraphBuilding(configPath, references, rebuild);
        TypeScriptImportGraph calculatedGraph = new TypeScriptImportGraph(references);
        TypeScriptConfigGraphCache.logEndGraphBuilding(calculatedGraph);
        TypeScriptImportGraph typeScriptImportGraph = calculatedGraph;
        if (typeScriptImportGraph == null) {
            TypeScriptConfigGraphCache.$$$reportNull$$$0(9);
        }
        return typeScriptImportGraph;
    }

    private synchronized void processFilesToRecalculate() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ProgressManager.checkCanceled();
        if (this.myFilesToRecalculateEdges.size() == 0) {
            return;
        }
        ArrayList toRemove = ContainerUtil.newArrayList();
        for (VirtualFile file2 : this.myFilesToRecalculateEdges) {
            toRemove.add(file2);
            this.myCache.values().forEach(graph -> {
                if (graph.containsFile(file2)) {
                    TypeScriptConfigGraphCache.logStartGraphUpdating(graph, file2);
                    graph.recalculateEdges(file2);
                    TypeScriptConfigGraphCache.logEndGraphUpdating(graph);
                }
            });
        }
        this.myFilesToRecalculateEdges.removeAll(toRemove);
    }

    private void addToRecalculateQueue(@Nullable VirtualFile file2) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (file2 == null) {
            return;
        }
        for (TypeScriptImportGraph graph : this.myCache.values()) {
            if (!graph.containsFile(file2)) continue;
            this.myFilesToRecalculateEdges.add(file2);
            break;
        }
    }

    public void addToRecalculateQueue(@NotNull PsiFile file2) {
        if (file2 == null) {
            TypeScriptConfigGraphCache.$$$reportNull$$$0(10);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        this.addToRecalculateQueue(virtualFile);
    }

    public final boolean isConfigInclude(@NotNull VirtualFile file2, @NotNull TypeScriptConfig config2) {
        if (file2 == null) {
            TypeScriptConfigGraphCache.$$$reportNull$$$0(11);
        }
        if (config2 == null) {
            TypeScriptConfigGraphCache.$$$reportNull$$$0(12);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (DumbService.isDumb((Project)this.myProject)) {
            return false;
        }
        TypeScriptImportGraph graph = this.getGraph(config2);
        return graph.containsFile(file2);
    }

    private void reset() {
        this.myCache.clear();
        this.myFilesToRecalculateEdges.clear();
    }

    public void dispose() {
        this.reset();
    }

    private static void logStartGraphUpdating(@NotNull TypeScriptImportGraph graph, @NotNull VirtualFile file2) {
        if (graph == null) {
            TypeScriptConfigGraphCache.$$$reportNull$$$0(13);
        }
        if (file2 == null) {
            TypeScriptConfigGraphCache.$$$reportNull$$$0(14);
        }
        if (!LOG.isDebugEnabled()) {
            return;
        }
        LOG.debug("Start updating tsconfig graph. Source: " + file2.getName() + ". Nodes: " + graph.getNodes().size());
    }

    private static void logEndGraphUpdating(@NotNull TypeScriptImportGraph graph) {
        if (graph == null) {
            TypeScriptConfigGraphCache.$$$reportNull$$$0(15);
        }
        if (!LOG.isDebugEnabled()) {
            return;
        }
        LOG.debug("End updating tsconfig graph");
        TypeScriptConfigGraphCache.logGraphState(graph);
    }

    private static void logEndGraphBuilding(@NotNull TypeScriptImportGraph graph) {
        if (graph == null) {
            TypeScriptConfigGraphCache.$$$reportNull$$$0(16);
        }
        if (!LOG.isDebugEnabled()) {
            return;
        }
        LOG.debug("End building tsconfig graph");
        TypeScriptConfigGraphCache.logGraphState(graph);
    }

    private static void logGraphState(@NotNull TypeScriptImportGraph graph) {
        if (graph == null) {
            TypeScriptConfigGraphCache.$$$reportNull$$$0(17);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Graph roots: " + graph.getRoots().size() + ", nodes: " + graph.getNodes().size() + ", available from roots: " + graph.getAvailableFromRoots().size());
        }
    }

    private static void logStartGraphBuilding(@NotNull String configPath, TypeScriptFileImportsImpl references, boolean rebuild) {
        if (configPath == null) {
            TypeScriptConfigGraphCache.$$$reportNull$$$0(18);
        }
        if (!LOG.isTraceEnabled()) {
            return;
        }
        LOG.debug("Start " + (rebuild ? "rebuilding" : "building") + " tsconfig graph. File " + configPath + ", refs: " + references.hashCode());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/tsconfig/graph/TypeScriptConfigGraphCache";
                break;
            }
            case 7: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configPath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
            case 10: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/tsconfig/graph/TypeScriptConfigGraphCache";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraph";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isFileNameChange";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableEvent";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getGraph";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createValue";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addToRecalculateQueue";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isConfigInclude";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "logStartGraphUpdating";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "logEndGraphUpdating";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "logEndGraphBuilding";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "logGraphState";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "logStartGraphBuilding";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

