/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig;

import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingsUtil;
import com.intellij.lang.typescript.TypeScriptSettings;
import com.intellij.lang.typescript.intentions.TypeScriptLibraryUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class TypeScriptConfigLibraryUpdater {
    private static final String LIBRARY_NAME = "tsconfig$roots";
    private static final int UPDATE_TIME = (int)TimeUnit.SECONDS.toMillis(6L);
    @NotNull
    private final Project myProject;
    @NotNull
    private final MergingUpdateQueue myQueue;

    public TypeScriptConfigLibraryUpdater(@NotNull Project project) {
        if (project == null) {
            TypeScriptConfigLibraryUpdater.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myQueue = new MergingUpdateQueue("Update typescript config additional roots/paths", UPDATE_TIME, true, null, (Disposable)this.myProject, null, Alarm.ThreadToUse.POOLED_THREAD);
        this.myQueue.setRestartTimerOnAdd(true);
    }

    public void queueToUpdate() {
        TypeScriptSettings settings = TypeScriptSettings.getSettings(this.myProject);
        if (settings == null || !settings.isAutoIncludeConfigPaths() || ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        this.myQueue.queue(new Update(this){

            public void run() {
                TypeScriptConfigLibraryUpdater.this.update();
            }
        });
    }

    private void update() {
        ApplicationManager.getApplication().runReadAction(() -> {
            Collection<TypeScriptConfig> files = TypeScriptConfigService.Provider.getConfigFiles(this.myProject);
            if (files.isEmpty()) {
                return;
            }
            for (TypeScriptConfig file2 : files) {
                if (!file2.hasErrors()) continue;
                return;
            }
            this.processConfigs(files);
        });
    }

    private void processConfigs(@NotNull Collection<TypeScriptConfig> configs) {
        if (configs == null) {
            TypeScriptConfigLibraryUpdater.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Collection<VirtualFile> libraryFiles = this.getFilesToUpdate(configs);
        this.updateFiles(configs, libraryFiles);
    }

    private void updateFiles(@NotNull Collection<TypeScriptConfig> configs, @NotNull Collection<VirtualFile> possibleLibraryFiles) {
        if (configs == null) {
            TypeScriptConfigLibraryUpdater.$$$reportNull$$$0(2);
        }
        if (possibleLibraryFiles == null) {
            TypeScriptConfigLibraryUpdater.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)this.myProject);
        ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)this.myProject);
        List fileOutOfProjectScope = ContainerUtil.filter(possibleLibraryFiles, file2 -> !scope.accept(file2) && fileIndex.getContentRootForFile(file2, false) == null);
        if (!TypeScriptLibraryUtil.checkNeedUpdate(this.myProject, LIBRARY_NAME, fileOutOfProjectScope)) {
            return;
        }
        TypeScriptConfigService service = TypeScriptConfigService.Provider.get(this.myProject);
        assert (service != null);
        ModificationTracker tracker = service.getTracker();
        long count = tracker.getModificationCount();
        ApplicationManager.getApplication().invokeLater(() -> {
            if (configs == null) {
                TypeScriptConfigLibraryUpdater.$$$reportNull$$$0(15);
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (configs == null) {
                    TypeScriptConfigLibraryUpdater.$$$reportNull$$$0(16);
                }
                TypeScriptLibraryUtil.updateLibrary(this.myProject, this.getModules(configs), LIBRARY_NAME, fileOutOfProjectScope, true);
            });
        }, o -> count != tracker.getModificationCount());
    }

    private Collection<Module> getModules(@NotNull Collection<TypeScriptConfig> configs) {
        if (configs == null) {
            TypeScriptConfigLibraryUpdater.$$$reportNull$$$0(4);
        }
        return TypeScriptLibraryUtil.getModules(this.myProject, ContainerUtil.map(configs, TypeScriptConfig::getConfigFile));
    }

    @NotNull
    private Collection<VirtualFile> getFilesToUpdate(@NotNull Collection<TypeScriptConfig> configs) {
        if (configs == null) {
            TypeScriptConfigLibraryUpdater.$$$reportNull$$$0(5);
        }
        if (configs.isEmpty()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptConfigLibraryUpdater.$$$reportNull$$$0(6);
            }
            return list;
        }
        HashSet toUpdate = ContainerUtil.newHashSet();
        for (TypeScriptConfig config2 : configs) {
            Collection<PsiFileSystemItem> dirs = config2.getRootDirs();
            for (PsiFileSystemItem dir : dirs) {
                String path;
                VirtualFile file2 = dir.getVirtualFile();
                if (file2 == null || (path = file2.getCanonicalPath()) == null || path.length() <= 2) continue;
                toUpdate.add(file2);
            }
            toUpdate.addAll(this.getBaseUrlRelatedFiles(config2));
        }
        HashSet hashSet = toUpdate;
        if (hashSet == null) {
            TypeScriptConfigLibraryUpdater.$$$reportNull$$$0(7);
        }
        return hashSet;
    }

    @NotNull
    protected Collection<VirtualFile> getBaseUrlRelatedFiles(@NotNull TypeScriptConfig config2) {
        VirtualFile baseUrl;
        if (config2 == null) {
            TypeScriptConfigLibraryUpdater.$$$reportNull$$$0(8);
        }
        if ((baseUrl = config2.getBaseUrl()) == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptConfigLibraryUpdater.$$$reportNull$$$0(9);
            }
            return list;
        }
        Collection<JSModulePathSubstitution> paths = config2.getPaths();
        if (paths.isEmpty()) {
            List<VirtualFile> list = TypeScriptConfigLibraryUpdater.getBaseUrlFile(baseUrl);
            if (list == null) {
                TypeScriptConfigLibraryUpdater.$$$reportNull$$$0(10);
            }
            return list;
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        for (JSModulePathSubstitution substitution : paths) {
            for (String path : substitution.getMappings()) {
                String canonicalPath;
                if (!TypeScriptConfigLibraryUpdater.pathCanBeProcessed(path)) {
                    List<VirtualFile> list = TypeScriptConfigLibraryUpdater.getBaseUrlFile(baseUrl);
                    if (list == null) {
                        TypeScriptConfigLibraryUpdater.$$$reportNull$$$0(11);
                    }
                    return list;
                }
                boolean endsWithStar = path.contains("*");
                String normalizedPath = endsWithStar ? path.substring(0, path.indexOf("*")) : path;
                VirtualFile pathUrl = JSPathMappingsUtil.getPathRelativeBaseUrlOrSelfIfAbsolute(baseUrl, normalizedPath);
                if (!endsWithStar && pathUrl == null) {
                    for (String extension : TypeScriptUtil.TYPESCRIPT_EXTENSIONS) {
                        pathUrl = JSPathMappingsUtil.getPathRelativeBaseUrlOrSelfIfAbsolute(baseUrl, normalizedPath + extension);
                        if (pathUrl != null) break;
                    }
                }
                if (pathUrl == null || (canonicalPath = pathUrl.getCanonicalPath()) == null || canonicalPath.length() <= 2) continue;
                result2.add(pathUrl);
            }
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            TypeScriptConfigLibraryUpdater.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @NotNull
    private static List<VirtualFile> getBaseUrlFile(@NotNull VirtualFile baseUrl) {
        String path;
        if (baseUrl == null) {
            TypeScriptConfigLibraryUpdater.$$$reportNull$$$0(13);
        }
        List list = (path = baseUrl.getCanonicalPath()) == null || path.length() <= 2 ? ContainerUtil.emptyList() : ContainerUtil.createMaybeSingletonList((Object)baseUrl);
        if (list == null) {
            TypeScriptConfigLibraryUpdater.$$$reportNull$$$0(14);
        }
        return list;
    }

    private static boolean pathCanBeProcessed(String pattern) {
        return JSPathMappingsUtil.isPatternOrMappingEndsWithStar(pattern) || pattern.contains("/*") || !pattern.contains("*");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configs";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleLibraryFiles";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigLibraryUpdater";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigLibraryUpdater";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesToUpdate";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseUrlRelatedFiles";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseUrlFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processConfigs";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateFiles";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getModules";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFilesToUpdate";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getBaseUrlRelatedFiles";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getBaseUrlFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updateFiles$3";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

