/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.settings.exclude;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="TypeScriptGeneratedFilesManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class TypeScriptGeneratedFilesManager
implements PersistentStateComponent<State> {
    private static final int VERSION = 1;
    private final Project myProject;
    private volatile State myState = new State();

    public TypeScriptGeneratedFilesManager(Project project) {
        this.myProject = project;
    }

    @Nullable
    public static TypeScriptGeneratedFilesManager getInstance(@NotNull Project project) {
        if (project == null) {
            TypeScriptGeneratedFilesManager.$$$reportNull$$$0(0);
        }
        return (TypeScriptGeneratedFilesManager)ServiceManager.getService((Project)project, TypeScriptGeneratedFilesManager.class);
    }

    public boolean isExcludeDeclarationFiles() {
        return this.myState.excludeDeclarationFiles;
    }

    public void setExcludeDeclarationFiles(boolean excludeDefinitionFiles) {
        this.myState.excludeDeclarationFiles = excludeDefinitionFiles;
    }

    public boolean isExcludeGeneratedFiles() {
        return this.myState.excludeGeneratedFiles;
    }

    public Collection<VirtualFile> getExcludedPlainFiles() {
        Collection<String> files = this.getExcludedPaths();
        if (files.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        LinkedHashSet filteredFiles = files.stream().map(el -> localFileSystem.findFileByPath(el)).filter(el -> el != null).collect(Collectors.toCollection(ContainerUtil::newLinkedHashSet));
        if (filteredFiles.size() != files.size()) {
            this.updateList(filteredFiles);
        }
        return filteredFiles;
    }

    @NotNull
    public Collection<String> getExcludedPaths() {
        Collection<String> collection = this.myState.exactExcludedFiles;
        if (collection == null) {
            TypeScriptGeneratedFilesManager.$$$reportNull$$$0(1);
        }
        return collection;
    }

    private synchronized void updateList(Collection<VirtualFile> files) {
        this.myState.exactExcludedFiles = TypeScriptGeneratedFilesManager.mapToStrings(files);
    }

    public int getVersion() {
        return this.myState.version;
    }

    @Nullable
    public State getState() {
        return this.myState;
    }

    public boolean isProjectProcessed() {
        return this.myState.version == 1;
    }

    public void updateVersion() {
        this.myState.version = 1;
    }

    public void addFiles(Collection<VirtualFile> files) {
        ArrayList result2 = ContainerUtil.newArrayList(this.getExcludedPaths());
        result2.addAll(TypeScriptGeneratedFilesManager.mapToStrings(files));
        this.myState.exactExcludedFiles = result2;
    }

    @NotNull
    private static List<String> mapToStrings(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            TypeScriptGeneratedFilesManager.$$$reportNull$$$0(2);
        }
        List list = ContainerUtil.mapNotNull(files, el -> el.getCanonicalPath());
        if (list == null) {
            TypeScriptGeneratedFilesManager.$$$reportNull$$$0(3);
        }
        return list;
    }

    public void setFiles(Collection<VirtualFile> files) {
        this.myState.exactExcludedFiles = TypeScriptGeneratedFilesManager.mapToStrings(files);
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            TypeScriptGeneratedFilesManager.$$$reportNull$$$0(4);
        }
        this.myState = state;
    }

    public void updateProject() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        WriteAction.run(() -> ProjectRootManagerEx.getInstanceEx((Project)this.myProject).makeRootsChange(EmptyRunnable.getInstance(), false, true));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/settings/exclude/TypeScriptGeneratedFilesManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/settings/exclude/TypeScriptGeneratedFilesManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedPaths";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "mapToStrings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "mapToStrings";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class State {
        public int version = 0;
        public boolean excludeDeclarationFiles = true;
        public boolean excludeGeneratedFiles = true;
        @NotNull
        public Collection<String> exactExcludedFiles = new SmartList();
    }
}

