/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.settings.exclude;

import com.intellij.lang.typescript.settings.exclude.TypeScriptGeneratedFilesManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptGeneratedFilesExcludePolicy
implements DirectoryIndexExcludePolicy {
    private final TypeScriptGeneratedFilesManager myManager;

    public TypeScriptGeneratedFilesExcludePolicy(@Nullable TypeScriptGeneratedFilesManager manager) {
        this.myManager = manager;
    }

    @NotNull
    public VirtualFile[] getExcludeRootsForProject() {
        if (this.myManager == null) {
            if (VirtualFile.EMPTY_ARRAY == null) {
                TypeScriptGeneratedFilesExcludePolicy.$$$reportNull$$$0(0);
            }
            return VirtualFile.EMPTY_ARRAY;
        }
        if (!this.myManager.isExcludeGeneratedFiles() || ApplicationManager.getApplication().isUnitTestMode()) {
            if (VirtualFile.EMPTY_ARRAY == null) {
                TypeScriptGeneratedFilesExcludePolicy.$$$reportNull$$$0(1);
            }
            return VirtualFile.EMPTY_ARRAY;
        }
        List result2 = ContainerUtil.newSmartList();
        ReadAction.run(() -> {
            Collection<VirtualFile> files = this.filterFilesToExclude(this.myManager.getExcludedPlainFiles());
            result2.addAll(files);
        });
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray((Collection)result2);
        if (virtualFileArray == null) {
            TypeScriptGeneratedFilesExcludePolicy.$$$reportNull$$$0(2);
        }
        return virtualFileArray;
    }

    private Collection<VirtualFile> filterFilesToExclude(@NotNull Collection<VirtualFile> allFiles) {
        if (allFiles == null) {
            TypeScriptGeneratedFilesExcludePolicy.$$$reportNull$$$0(3);
        }
        assert (this.myManager != null);
        return this.myManager.isExcludeDeclarationFiles() ? allFiles : (Collection)allFiles.stream().filter(el -> !el.getName().endsWith(".d.ts")).collect(Collectors.toList());
    }

    @NotNull
    public VirtualFilePointer[] getExcludeRootsForModule(@NotNull ModuleRootModel rootModel) {
        if (rootModel == null) {
            TypeScriptGeneratedFilesExcludePolicy.$$$reportNull$$$0(4);
        }
        if (VirtualFilePointer.EMPTY_ARRAY == null) {
            TypeScriptGeneratedFilesExcludePolicy.$$$reportNull$$$0(5);
        }
        return VirtualFilePointer.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/settings/exclude/TypeScriptGeneratedFilesExcludePolicy";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allFiles";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludeRootsForProject";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/settings/exclude/TypeScriptGeneratedFilesExcludePolicy";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludeRootsForModule";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "filterFilesToExclude";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getExcludeRootsForModule";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

