/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.refactoring;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElement;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameHandler;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class TypeScriptProxyImplicitMemberRenameHandler
implements RenameHandler {
    public boolean isAvailableOnDataContext(DataContext dataContext) {
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiFile file2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (editor == null || file2 == null) {
            return false;
        }
        if (!(file2 instanceof JSFile) || !DialectDetector.isTypeScript((PsiElement)file2)) {
            return false;
        }
        ResolveResult[] elements = TypeScriptProxyImplicitMemberRenameHandler.getElements(editor);
        return elements.length >= 1 && Arrays.stream(elements).map(e -> e.getElement()).allMatch(e -> e instanceof TypeScriptProxyImplicitElement);
    }

    private static ResolveResult[] getElements(Editor editor) {
        PsiReference reference = TargetElementUtil.findReference((Editor)editor);
        JSReferenceExpression contextParent = JSPsiImplUtils.findReferenceOfClass(reference, JSReferenceExpression.class);
        if (contextParent != null) {
            return contextParent.multiResolve(false);
        }
        return ResolveResult.EMPTY_ARRAY;
    }

    public boolean isRenaming(DataContext dataContext) {
        return this.isAvailableOnDataContext(dataContext);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2, DataContext dataContext) {
        if (project == null) {
            TypeScriptProxyImplicitMemberRenameHandler.$$$reportNull$$$0(0);
        }
        ResolveResult[] elements = TypeScriptProxyImplicitMemberRenameHandler.getElements(editor);
        assert (elements.length > 0);
        PsiElement nameSuggestionContext = InjectedLanguageUtil.findElementAtNoCommit((PsiFile)file2, (int)editor.getCaretModel().getOffset());
        PsiElement initialElement = elements[0].getElement();
        assert (initialElement instanceof TypeScriptProxyImplicitElement);
        PsiElement element = initialElement.getParent();
        PsiElementRenameHandler.invoke((PsiElement)element, (Project)project, (PsiElement)(nameSuggestionContext == null ? element : nameSuggestionContext), (Editor)editor);
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            TypeScriptProxyImplicitMemberRenameHandler.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            TypeScriptProxyImplicitMemberRenameHandler.$$$reportNull$$$0(2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "elements";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/typescript/refactoring/TypeScriptProxyImplicitMemberRenameHandler";
        objectArray[2] = "invoke";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

