/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.psi;

import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptVariable;
import com.intellij.lang.javascript.psi.types.JSEvaluableTypeBase;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptComparingUtil {
    private static int getCommonParameterLength(@NotNull JSParameterListElement[] original, @NotNull JSParameterListElement[] candidate, boolean isTypeScriptFunctions) {
        if (original == null) {
            TypeScriptComparingUtil.$$$reportNull$$$0(0);
        }
        if (candidate == null) {
            TypeScriptComparingUtil.$$$reportNull$$$0(1);
        }
        if (original.length == candidate.length) {
            return original.length;
        }
        if (candidate.length == 0 || original.length == 0 || isTypeScriptFunctions) {
            return -1;
        }
        int lastNotVarArgs = original[original.length - 1].isRest() ? original.length - 1 : original.length;
        int lastNotVarArgsCandidate = candidate[candidate.length - 1].isRest() ? candidate.length - 1 : candidate.length;
        return lastNotVarArgs == lastNotVarArgsCandidate ? lastNotVarArgs : -1;
    }

    public static boolean areFunctionsSimilar(@NotNull JSFunction function, @NotNull JSFunction candidateFunction) {
        boolean isTypeScriptFunctions;
        JSParameterListElement[] parametersCandidate;
        JSParameterListElement[] parameters;
        int toCount;
        if (function == null) {
            TypeScriptComparingUtil.$$$reportNull$$$0(2);
        }
        if (candidateFunction == null) {
            TypeScriptComparingUtil.$$$reportNull$$$0(3);
        }
        if ((toCount = TypeScriptComparingUtil.getCommonParameterLength(parameters = function.getParameters(), parametersCandidate = candidateFunction.getParameters(), isTypeScriptFunctions = function instanceof TypeScriptFunction && candidateFunction instanceof TypeScriptFunction)) == -1) {
            return false;
        }
        for (int i = 0; i < toCount; ++i) {
            JSType candidateType;
            JSParameterListElement parameter = parameters[i];
            JSParameterListElement candidateParameter = parametersCandidate[i];
            if (!StringUtil.equals((CharSequence)parameter.getName(), (CharSequence)candidateParameter.getName())) {
                return false;
            }
            if (!isTypeScriptFunctions) continue;
            if (parameter.isOptional() != candidateParameter.isOptional()) {
                return false;
            }
            if (parameter.isRest() != candidateParameter.isRest()) {
                return false;
            }
            JSType type = parameter.getType();
            if (TypeScriptComparingUtil.skipType(type) || TypeScriptComparingUtil.skipType(candidateType = candidateParameter.getType()) || TypeScriptComparingUtil.areTypeTextEqual(type, candidateType)) continue;
            return false;
        }
        if (isTypeScriptFunctions) {
            int candidateTypeParametersLength;
            TypeScriptFunction tsFunction = (TypeScriptFunction)function;
            TypeScriptFunction tsCandidateFunction = (TypeScriptFunction)candidateFunction;
            if (tsFunction.isOverloadImplementation() != tsCandidateFunction.isOverloadImplementation()) {
                return false;
            }
            TypeScriptTypeParameterList typeParameterList = tsFunction.getTypeParameterList();
            TypeScriptTypeParameterList candidateTypeParameterList = tsFunction.getTypeParameterList();
            int typeParametersLength = typeParameterList == null ? 0 : typeParameterList.getTypeParameters().length;
            int n = candidateTypeParametersLength = candidateTypeParameterList == null ? 0 : candidateTypeParameterList.getTypeParameters().length;
            if (typeParametersLength != candidateTypeParametersLength) {
                return false;
            }
            JSType type = function.getReturnType();
            JSType candidateType = candidateFunction.getReturnType();
            if (!TypeScriptComparingUtil.skipType(type) && !TypeScriptComparingUtil.skipType(candidateType)) {
                return TypeScriptComparingUtil.areTypeTextEqual(type, candidateType);
            }
        }
        return true;
    }

    public static boolean areTypeTextEqual(@NotNull JSType type, @NotNull JSType candidateType) {
        if (type == null) {
            TypeScriptComparingUtil.$$$reportNull$$$0(4);
        }
        if (candidateType == null) {
            TypeScriptComparingUtil.$$$reportNull$$$0(5);
        }
        String typeText = type.getTypeText(JSType.TypeTextFormat.SIMPLE);
        String candidateText = candidateType.getTypeText(JSType.TypeTextFormat.SIMPLE);
        return typeText.equals(candidateText);
    }

    @Contract(value="null -> true")
    public static boolean skipType(@Nullable JSType candidateType) {
        return candidateType == null || candidateType instanceof JSEvaluableTypeBase;
    }

    public static boolean areVariablesSimilar(@NotNull JSFieldVariable original, @NotNull JSFieldVariable candidate) {
        boolean areTypeScriptFields;
        if (original == null) {
            TypeScriptComparingUtil.$$$reportNull$$$0(6);
        }
        if (candidate == null) {
            TypeScriptComparingUtil.$$$reportNull$$$0(7);
        }
        boolean areTypeScriptVariables = original instanceof TypeScriptVariable && candidate instanceof TypeScriptVariable;
        boolean bl = areTypeScriptFields = original instanceof TypeScriptField && candidate instanceof TypeScriptField;
        if (areTypeScriptVariables) {
            TypeScriptVariable originalVariable = (TypeScriptVariable)original;
            TypeScriptVariable candidateVariable = (TypeScriptVariable)candidate;
            if (originalVariable.isConst() != candidateVariable.isConst() || originalVariable.hasBlockScope() != candidateVariable.hasBlockScope()) {
                return false;
            }
        }
        if (areTypeScriptVariables || areTypeScriptFields) {
            JSType type = original.getType();
            JSType rType = candidate.getType();
            if (TypeScriptComparingUtil.skipType(type) || TypeScriptComparingUtil.skipType(rType)) {
                return true;
            }
            return TypeScriptComparingUtil.areTypeTextEqual(type, rType);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateFunction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateType";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/typescript/psi/TypeScriptComparingUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getCommonParameterLength";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "areFunctionsSimilar";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "areTypeTextEqual";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "areVariablesSimilar";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

