/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.modules.JSImportPlaceInfo;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCompileTimeType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.resolve.accessibility.TypeScriptModuleAccessibilityChecker;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.lang.typescript.intentions.TypeScriptAddImportStatementFix;
import com.intellij.lang.typescript.psi.TypeScriptAddImportExecutor;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptAutoImportUtil {
    public static final TokenSet EXPORT_ASSIGNMENTS = TokenSet.create((IElementType[])new IElementType[]{ES6ElementTypes.EXPORT_DEFAULT_ASSIGNMENT, TypeScriptElementTypes.EXPORT_ASSIGNMENT});
    public static final String[] NODE_MODULES = new String[]{"node_modules"};

    public static boolean isAvailableForImport(@NotNull PsiElement elementToImport, @NotNull JSImportPlaceInfo placeInfo) {
        if (elementToImport == null) {
            TypeScriptAutoImportUtil.$$$reportNull$$$0(0);
        }
        if (placeInfo == null) {
            TypeScriptAutoImportUtil.$$$reportNull$$$0(1);
        }
        if (elementToImport instanceof ES6ExportSpecifier) {
            return true;
        }
        if (!ES6PsiUtil.isElementCanBeExported(elementToImport)) {
            return false;
        }
        assert (DialectDetector.isTypeScript(elementToImport));
        if (!TypeScriptAutoImportUtil.isContextAcceptable(elementToImport, placeInfo)) {
            return false;
        }
        return TypeScriptAutoImportUtil.isExportedElement(elementToImport, placeInfo);
    }

    public static boolean isExportedElement(PsiElement elementToImport, JSImportPlaceInfo placeInfo) {
        TypeScriptModule tsModule;
        PsiElement parent = elementToImport.getContext();
        if (parent instanceof JSVarStatement) {
            parent = parent.getContext();
        }
        if (parent instanceof ES6ExportDefaultAssignment) {
            return true;
        }
        if (!TypeScriptPsiUtil.isTopLevelContainer(parent) || parent instanceof JSFile && !((JSFile)parent).isCommonJSModule() || parent.isEquivalentTo(placeInfo.getContainer())) {
            return false;
        }
        if (parent instanceof TypeScriptModule && (tsModule = (TypeScriptModule)parent).isAugmentation() && !TypeScriptAutoImportUtil.isAugmentationAcceptable(tsModule)) {
            return false;
        }
        TypeScriptModuleAccessibilityChecker checker = TypeScriptModuleAccessibilityChecker.INSTANCE;
        if (checker.check(placeInfo.getPlace(), elementToImport) != null) {
            return false;
        }
        return ES6ImportHandler.isExported(elementToImport) || elementToImport instanceof JSElementBase && ((JSElementBase)elementToImport).isExportedWithDefault();
    }

    private static boolean isAugmentationAcceptable(@NotNull TypeScriptModule tsModule) {
        PsiElement parent;
        if (tsModule == null) {
            TypeScriptAutoImportUtil.$$$reportNull$$$0(2);
        }
        if (!ES6PsiUtil.isExternalModule(parent = tsModule.getParent())) {
            return false;
        }
        JSExportAssignment assignment = TypeScriptAutoImportUtil.getExportAssignment(parent);
        return assignment instanceof TypeScriptExportAssignment;
    }

    public static boolean isContextAcceptable(@NotNull PsiElement elementToImport, @NotNull JSImportPlaceInfo placeInfo) {
        boolean isClassType;
        if (elementToImport == null) {
            TypeScriptAutoImportUtil.$$$reportNull$$$0(3);
        }
        if (placeInfo == null) {
            TypeScriptAutoImportUtil.$$$reportNull$$$0(4);
        }
        if (!(placeInfo.getPlace() instanceof JSReferenceExpression)) {
            return true;
        }
        boolean bl = isClassType = elementToImport instanceof JSClass || elementToImport instanceof TypeScriptModule;
        if (elementToImport instanceof TypeScriptModule) {
            if (!((TypeScriptModule)elementToImport).isInternal()) {
                return false;
            }
            PsiElement module = ES6PsiUtil.findExternalModule(elementToImport);
            if (module == null) {
                return false;
            }
        }
        if (placeInfo.isStrictTypeContext() && !isClassType) {
            return false;
        }
        return TypeScriptAutoImportUtil.isElementCanBeUsedInContext(elementToImport, placeInfo, isClassType);
    }

    private static boolean isElementCanBeUsedInContext(@NotNull PsiElement elementToImport, @NotNull JSImportPlaceInfo placeInfo, boolean isClassType) {
        if (elementToImport == null) {
            TypeScriptAutoImportUtil.$$$reportNull$$$0(5);
        }
        if (placeInfo == null) {
            TypeScriptAutoImportUtil.$$$reportNull$$$0(6);
        }
        PsiElement parentContext = placeInfo.getParentElement();
        boolean isNewContext = parentContext instanceof JSNewExpression;
        boolean isCallContext = parentContext instanceof JSCallExpression;
        if (!isClassType && isNewContext) {
            return false;
        }
        if (isClassType && isCallContext && !isNewContext) {
            return false;
        }
        return !(elementToImport instanceof TypeScriptCompileTimeType) || !isCallContext;
    }

    public static void addImportStatement(@Nullable Editor editor, @NotNull String name, @NotNull JSElement elementToImport, @NotNull PsiElement place) {
        if (name == null) {
            TypeScriptAutoImportUtil.$$$reportNull$$$0(7);
        }
        if (elementToImport == null) {
            TypeScriptAutoImportUtil.$$$reportNull$$$0(8);
        }
        if (place == null) {
            TypeScriptAutoImportUtil.$$$reportNull$$$0(9);
        }
        new TypeScriptAddImportExecutor(name, editor, place).execute(elementToImport);
    }

    public static void showError(Project project, @Nullable Editor editor) {
        if (editor == null) {
            return;
        }
        String name = TypeScriptAddImportStatementFix.getActionName();
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)"Cannot find module for import", (String)name, null);
    }

    static boolean isSelfExportedAugmentationModule(@NotNull TypeScriptModule container) {
        String reference;
        PsiElement parent;
        JSExportAssignment assignment;
        if (container == null) {
            TypeScriptAutoImportUtil.$$$reportNull$$$0(10);
        }
        if ((assignment = TypeScriptAutoImportUtil.getExportAssignment(parent = container.getParent())) != null && (reference = assignment.getInitializerReference()) != null) {
            JSTypeResolveResult result2 = TypeScriptImportHandler.getInstance().resolveName(reference, (PsiElement)assignment);
            return result2.getElements().contains(container);
        }
        return false;
    }

    public static TypeScriptImportStatement createTypeScriptImport(@NotNull PsiElement place, @NotNull ES6ImportPsiUtil.CreateImportExportInfo info, @NotNull String moduleName) {
        if (place == null) {
            TypeScriptAutoImportUtil.$$$reportNull$$$0(11);
        }
        if (info == null) {
            TypeScriptAutoImportUtil.$$$reportNull$$$0(12);
        }
        if (moduleName == null) {
            TypeScriptAutoImportUtil.$$$reportNull$$$0(13);
        }
        ES6ImportPsiUtil.ImportExportType importType = info.getImportType();
        String name = info.getImportedName();
        StringBuilder builder = new StringBuilder("import ");
        if (importType == ES6ImportPsiUtil.ImportExportType.TS_REQUIRE_IMPORT) {
            builder.append(name).append(" = require(").append(moduleName).append(')');
        } else {
            builder.append(name).append(" = ").append(moduleName);
        }
        builder.append(JSCodeStyleSettings.getSemicolon((PsiElement)place.getContainingFile()));
        ASTNode importNode = JSChangeUtil.createStatementFromTextWithContext(builder.toString(), place);
        if (importNode == null || importNode.getElementType() != TypeScriptElementTypes.IMPORT_STATEMENT) {
            return null;
        }
        return (TypeScriptImportStatement)importNode.getPsi(TypeScriptImportStatement.class);
    }

    @Nullable
    static JSExportAssignment getExportAssignment(@Nullable PsiElement module) {
        if (module == null) {
            return null;
        }
        Object[] children = JSResolveUtil.getStubbedChildren(module, EXPORT_ASSIGNMENTS);
        PsiElement element = (PsiElement)ArrayUtil.getFirstElement((Object[])children);
        return element instanceof JSExportAssignment ? (JSExportAssignment)element : null;
    }

    @NotNull
    public static GlobalSearchScope createSymbolToImportSearchScope(final @NotNull Project project, @NotNull PsiElement context) {
        VirtualFile file2;
        if (project == null) {
            TypeScriptAutoImportUtil.$$$reportNull$$$0(14);
        }
        if (context == null) {
            TypeScriptAutoImportUtil.$$$reportNull$$$0(15);
        }
        final List configs = (file2 = context.getContainingFile().getOriginalFile().getVirtualFile()) == null ? ContainerUtil.emptyList() : TypeScriptConfigService.Provider.getConfigInclude(project, file2);
        DelegatingGlobalSearchScope delegatingGlobalSearchScope = new DelegatingGlobalSearchScope(JSResolveUtil.getResolveScope(context)){

            public boolean contains(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!super.contains(file2) || !TypeScriptUtil.TYPESCRIPT_FILE_TYPES.contains(file2.getFileType())) {
                    return false;
                }
                if (!TypeScriptUtil.isUnderNodeModules(file2, project) || TypeScriptUtil.isDefinitionFile(file2)) {
                    return true;
                }
                if (configs.isEmpty()) {
                    return false;
                }
                for (TypeScriptConfig config2 : configs) {
                    if (!config2.isIncludedFile(file2, false) && !config2.isFromFileList(file2)) continue;
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil$1", "contains"));
            }
        };
        if (delegatingGlobalSearchScope == null) {
            TypeScriptAutoImportUtil.$$$reportNull$$$0(16);
        }
        return delegatingGlobalSearchScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToImport";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeInfo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tsModule";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/psi/TypeScriptAutoImportUtil";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createSymbolToImportSearchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableForImport";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAugmentationAcceptable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isContextAcceptable";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isElementCanBeUsedInContext";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addImportStatement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isSelfExportedAugmentationModule";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createTypeScriptImport";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createSymbolToImportSearchScope";
                break;
            }
            case 16: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

