/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.modules;

import com.intellij.javascript.JSModuleBaseReference;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.modules.JSModuleFileReferenceSet;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.typescript.library.download.TypeScriptDefinitionFilesDirectory;
import com.intellij.lang.typescript.modules.TypeScriptFileModuleReference;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileImportsResolver;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptModuleFileReferenceSet
extends FileReferenceSet {
    @NotNull
    public static Condition<PsiFileSystemItem> createFileFilter(@Nullable PsiElement host) {
        if (host == null || !host.isValid()) {
            Condition condition = Conditions.alwaysTrue();
            if (condition == null) {
                TypeScriptModuleFileReferenceSet.$$$reportNull$$$0(0);
            }
            return condition;
        }
        if (host instanceof ES6ImportDeclaration && ((ES6ImportDeclaration)host).getImportModuleText() != null) {
            Condition condition = Conditions.alwaysTrue();
            if (condition == null) {
                TypeScriptModuleFileReferenceSet.$$$reportNull$$$0(1);
            }
            return condition;
        }
        PsiFile file2 = host.getContainingFile().getOriginalFile();
        Collection<TypeScriptConfig> files = TypeScriptConfigService.Provider.getConfigFiles(host.getProject());
        boolean hasJs = files.stream().anyMatch(TypeScriptConfig::allowJs);
        Condition condition = item -> {
            if (!(item instanceof PsiFile)) {
                return true;
            }
            PsiFile psiFile = (PsiFile)item;
            if (psiFile.isEquivalentTo((PsiElement)file2)) {
                return false;
            }
            String name = psiFile.getName();
            for (String extension : hasJs ? TypeScriptFileImportsResolver.TYPESCRIPT_AND_JS_EXTENSIONS_FIXED_ORDER : TypeScriptFileImportsResolver.TS_EXTENSIONS) {
                if (!StringUtil.endsWithIgnoreCase((String)name, (String)extension)) continue;
                return true;
            }
            return false;
        };
        if (condition == null) {
            TypeScriptModuleFileReferenceSet.$$$reportNull$$$0(2);
        }
        return condition;
    }

    public TypeScriptModuleFileReferenceSet(String reference, @NotNull PsiElement element, int startInElement, @Nullable PsiReferenceProvider provider2, @Nullable FileType[] suitableFileTypes) {
        if (element == null) {
            TypeScriptModuleFileReferenceSet.$$$reportNull$$$0(3);
        }
        super(reference, element, startInElement, provider2, false, false, suitableFileTypes);
    }

    protected boolean useIncludingFileAsContext() {
        return false;
    }

    @NotNull
    public Collection<PsiFileSystemItem> computeDefaultContexts() {
        PsiElement host = this.getElement();
        String requiredModuleName = this.getPathString();
        boolean isRelative = requiredModuleName.startsWith(".");
        Project project = host.getProject();
        PsiFile file2 = host.getContainingFile().getOriginalFile();
        LinkedHashSet altResolveModules = ContainerUtil.newLinkedHashSet();
        if (!isRelative) {
            TypeScriptConfig config2 = TypeScriptConfigUtil.getConfigForPsiFile(file2);
            TypeScriptModuleFileReferenceSet.addBaseUrlContext(config2, file2, altResolveModules);
            JSModuleFileReferenceSet.addNodeModulesDirContexts(project, host, altResolveModules, this);
            TypeScriptModuleFileReferenceSet.addTypeNodeModules(config2, host, altResolveModules);
            TypeScriptModuleFileReferenceSet.addGlobalTypesContexts(altResolveModules, file2);
            if (TypeScriptModuleFileReferenceSet.addParentPathContexts(file2, requiredModuleName, altResolveModules)) {
                LinkedHashSet linkedHashSet = altResolveModules;
                if (linkedHashSet == null) {
                    TypeScriptModuleFileReferenceSet.$$$reportNull$$$0(4);
                }
                return linkedHashSet;
            }
        }
        altResolveModules.addAll(super.computeDefaultContexts());
        LinkedHashSet linkedHashSet = altResolveModules;
        if (linkedHashSet == null) {
            TypeScriptModuleFileReferenceSet.$$$reportNull$$$0(5);
        }
        return linkedHashSet;
    }

    private static void addGlobalTypesContexts(@NotNull Collection<PsiFileSystemItem> modules, @NotNull PsiFile file2) {
        PsiDirectory psiDirectory;
        VirtualFile directory;
        if (modules == null) {
            TypeScriptModuleFileReferenceSet.$$$reportNull$$$0(6);
        }
        if (file2 == null) {
            TypeScriptModuleFileReferenceSet.$$$reportNull$$$0(7);
        }
        if ((directory = TypeScriptDefinitionFilesDirectory.getGlobalTypesDirectory()) == null) {
            return;
        }
        VirtualFile currentFile = file2.getVirtualFile();
        if (VfsUtilCore.isAncestor((VirtualFile)directory, (VirtualFile)currentFile, (boolean)true) && (psiDirectory = file2.getManager().findDirectory(directory)) != null) {
            modules.add((PsiFileSystemItem)psiDirectory);
        }
    }

    public static boolean addParentPathContexts(@NotNull PsiFile file2, @NotNull String refPath, @NotNull Collection<PsiFileSystemItem> contexts) {
        VirtualFile path;
        if (file2 == null) {
            TypeScriptModuleFileReferenceSet.$$$reportNull$$$0(8);
        }
        if (refPath == null) {
            TypeScriptModuleFileReferenceSet.$$$reportNull$$$0(9);
        }
        if (contexts == null) {
            TypeScriptModuleFileReferenceSet.$$$reportNull$$$0(10);
        }
        if ((path = TypeScriptUtil.findFileByReferencePath(file2, refPath, file2.getProject())) != null) {
            String s = refPath.replace('/', '\\');
            for (int i = StringUtil.countChars((CharSequence)s, (char)'\\'); i > 0; --i) {
                path = path.getParent();
            }
            PsiDirectory directory = file2.getManager().findDirectory(path.getParent());
            if (directory != null) {
                contexts.add((PsiFileSystemItem)directory);
                return true;
            }
        }
        return false;
    }

    private static void addBaseUrlContext(TypeScriptConfig config2, PsiFile file2, Collection<PsiFileSystemItem> altResolveModules) {
        PsiDirectory urlPsiFile;
        VirtualFile url;
        if (config2 != null && (url = config2.getBaseUrl()) != null && (urlPsiFile = file2.getManager().findDirectory(url)) != null) {
            altResolveModules.add((PsiFileSystemItem)urlPsiFile);
        }
    }

    public FileReference createFileReference(TextRange textRange, int i, String text) {
        return new TypeScriptFileModuleReference(text, i, textRange, (FileReferenceSet)this, JSModuleBaseReference.ModuleTypes.DEFAULT);
    }

    protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
        return TypeScriptModuleFileReferenceSet.createFileFilter(this.getElement());
    }

    private static void addTypeNodeModules(@Nullable TypeScriptConfig configForPsiFile, PsiElement context, Collection<PsiFileSystemItem> altResolveModules) {
        VirtualFile toSearchDir = null;
        if (configForPsiFile != null) {
            toSearchDir = configForPsiFile.getConfigDirectory();
        }
        if (toSearchDir != null) {
            VirtualFile nodeModulesFile = toSearchDir.findChild("node_modules");
            if (nodeModulesFile == null) {
                nodeModulesFile = NodeModuleUtil.findUpClosestNodeModulesResolveRoot(toSearchDir);
            }
            JSModuleFileReferenceSet.addTypesForNodeModulesDir(context, altResolveModules, nodeModulesFile);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/modules/TypeScriptModuleFileReferenceSet";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refPath";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contexts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileFilter";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/modules/TypeScriptModuleFileReferenceSet";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDefaultContexts";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addGlobalTypesContexts";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addParentPathContexts";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

