/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.inspection;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.EnumConstantValue;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardChecker;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuspiciousTypeOfGuardInspection
extends JSInspection {
    public static final String SHORT_NAME = SuspiciousTypeOfGuardInspection.calcShortNameFromClass(SuspiciousTypeOfGuardInspection.class);

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        if (!DialectDetector.isTypeScript((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                SuspiciousTypeOfGuardInspection.$$$reportNull$$$0(0);
            }
            return psiElementVisitor;
        }
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSBinaryExpression(JSBinaryExpression expression) {
                JSPrefixExpression rightTypeOf;
                IElementType sign = expression.getOperationSign();
                if (sign != JSTokenTypes.EQEQ && sign != JSTokenTypes.NE && sign != JSTokenTypes.NEQEQ && sign != JSTokenTypes.EQEQEQ) {
                    return;
                }
                JSExpression left = JSTypeGuardChecker.getReferenceCandidate(expression.getLOperand());
                JSExpression right = JSTypeGuardChecker.getReferenceCandidate(expression.getROperand());
                if (left == null || right == null) {
                    return;
                }
                JSPrefixExpression leftTypeOf = JSTypeGuardChecker.getTypeOfPrefixExpression(left);
                if (leftTypeOf != null && JSTypeGuardChecker.isStringLiteralExpression(right)) {
                    this.checkTypeof(leftTypeOf, (JSLiteralExpression)right, sign);
                }
                if ((rightTypeOf = JSTypeGuardChecker.getTypeOfPrefixExpression(right)) != null && JSTypeGuardChecker.isStringLiteralExpression(left)) {
                    this.checkTypeof(rightTypeOf, (JSLiteralExpression)left, sign);
                }
            }

            private void checkTypeof(@NotNull JSPrefixExpression typeOfExpr, @NotNull JSLiteralExpression literal, IElementType sign) {
                JSExpression target;
                if (typeOfExpr == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (literal == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!((target = JSTypeGuardChecker.getReferenceCandidate(typeOfExpr.getExpression())) instanceof JSReferenceExpression)) {
                    return;
                }
                JSType expressionJSType = JSResolveUtil.getExpressionJSType(target);
                if ((expressionJSType = JSTypeGuardChecker.getExactType(expressionJSType)) == null) {
                    return;
                }
                expressionJSType = expressionJSType.transformTypeHierarchy(t -> SuspiciousTypeOfGuardInspection.getGenericConstraintSelfOrAny(t));
                if ((expressionJSType = JSCompositeTypeImpl.optimizeTypeIfComposite(expressionJSType)) instanceof JSAnyType) {
                    return;
                }
                String value = literal.getStringValue();
                if (StringUtil.isEmpty((String)value)) {
                    return;
                }
                if (!("string".equals(value) || "number".equals(value) || "boolean".equals(value))) {
                    return;
                }
                this.validateTypeOfType(expressionJSType, value, literal, (JSReferenceExpression)target, sign);
            }

            private boolean isRedundantTypeOf(@Nullable JSType expressionJSType, @NotNull String value) {
                if (value == null) {
                    1.$$$reportNull$$$0(2);
                }
                switch (value) {
                    case "string": {
                        return expressionJSType instanceof JSStringType || expressionJSType instanceof JSCompositeTypeImpl && ((JSCompositeTypeImpl)expressionJSType).getTypes().stream().allMatch(t -> t instanceof JSStringType);
                    }
                    case "number": {
                        return expressionJSType instanceof JSNumberType || expressionJSType instanceof JSCompositeTypeImpl && ((JSCompositeTypeImpl)expressionJSType).getTypes().stream().allMatch(t -> t instanceof JSNumberType);
                    }
                    case "boolean": {
                        return expressionJSType instanceof JSBooleanType || expressionJSType instanceof JSCompositeTypeImpl && ((JSCompositeTypeImpl)expressionJSType).getTypes().stream().allMatch(t -> t instanceof JSBooleanType);
                    }
                }
                return false;
            }

            private void validateTypeOfType(@NotNull JSType expressionJSType, @NotNull String value, @NotNull JSLiteralExpression literal, @NotNull JSReferenceExpression target, @NotNull IElementType sign) {
                if (expressionJSType == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (value == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (literal == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (target == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (sign == null) {
                    1.$$$reportNull$$$0(7);
                }
                if (this.isRedundantTypeOf(expressionJSType, value)) {
                    boolean isNegative = sign == JSTokenTypes.NEQEQ || sign == JSTokenTypes.NE;
                    holder.registerProblem((PsiElement)literal, JSBundle.message((String)(isNegative ? "typescript.falsy.typeof.guard" : "typescript.redundant.typeof.guard"), (Object[])new Object[]{target.getReferenceName(), value}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                    return;
                }
                Ref hadOurType = Ref.create((Object)false);
                JSTypeUtils.processExpandedType((Processor<JSType>)((Processor)t -> {
                    if (value == null) {
                        1.$$$reportNull$$$0(8);
                    }
                    switch (value) {
                        case "string": {
                            EnumConstantValue value1;
                            TypeScriptEnumField field;
                            JSResolvedTypeInfo info;
                            if (t instanceof JSStringType) {
                                hadOurType.set((Object)true);
                            }
                            if (!(t instanceof JSResolvableType) || (info = ((JSResolvableType)t).resolveType()) == null || !info.isEnumLiteral() || (field = info.getDeclarationOfType(TypeScriptEnumField.class)) == null || (value1 = field.getConstantValue()).getStringValue() == null) break;
                            hadOurType.set((Object)true);
                            break;
                        }
                        case "number": {
                            JSResolvedTypeInfo info;
                            if (t instanceof JSNumberType) {
                                hadOurType.set((Object)true);
                            }
                            if (t instanceof JSResolvableType && (info = ((JSResolvableType)t).resolveType()) != null) {
                                EnumConstantValue value1;
                                TypeScriptEnumField field;
                                if (info.isEnum()) {
                                    hadOurType.set((Object)true);
                                }
                                if (info.isEnumLiteral() && (field = info.getDeclarationOfType(TypeScriptEnumField.class)) != null && (value1 = field.getConstantValue()).getNumericValue() != null) {
                                    hadOurType.set((Object)true);
                                }
                            }
                        }
                        case "boolean": {
                            if (!(t instanceof JSBooleanType)) break;
                            hadOurType.set((Object)true);
                        }
                    }
                    return true;
                }), expressionJSType, false, true, true);
                if (!((Boolean)hadOurType.get()).booleanValue()) {
                    holder.registerProblem((PsiElement)literal, JSBundle.message((String)"typescript.suspicious.typeof.guard", (Object[])new Object[]{target.getReferenceName(), value}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "typeOfExpr";
                        break;
                    }
                    case 1: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "literal";
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expressionJSType";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "target";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "sign";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/typescript/inspection/SuspiciousTypeOfGuardInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkTypeof";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isRedundantTypeOf";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "validateTypeOfType";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$validateTypeOfType$4";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (jSElementVisitor == null) {
            SuspiciousTypeOfGuardInspection.$$$reportNull$$$0(1);
        }
        return jSElementVisitor;
    }

    @NotNull
    static JSType getGenericConstraintSelfOrAny(@Nullable JSType t) {
        if (!(t instanceof JSGenericParameterImpl)) {
            JSType jSType = t == null ? JSAnyType.get(JSTypeSource.EMPTY_TS) : t;
            if (jSType == null) {
                SuspiciousTypeOfGuardInspection.$$$reportNull$$$0(2);
            }
            return jSType;
        }
        JSType constraintType = ((JSGenericParameterImpl)t).getConstraintType();
        JSType jSType = constraintType == null ? JSAnyType.get(t.getSource()) : constraintType;
        if (jSType == null) {
            SuspiciousTypeOfGuardInspection.$$$reportNull$$$0(3);
        }
        return jSType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/typescript/inspection/SuspiciousTypeOfGuardInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenericConstraintSelfOrAny";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

