/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptServerState
implements Disposable {
    private static final int TIME_TO_MERGE_COMPILE_EVENTS_MILLS = 2500;
    private static final int TIME_TO_MERGE_PROJECT_EVENTS_MILLS = 2500;
    private static final int TIME_TO_REMOVE_USELESS_EVENTS = 10000;
    @NotNull
    private final MergingUpdateQueue myCompileQueue;
    @NotNull
    private final MergingUpdateQueue myProjectErrorsQueue;
    @NotNull
    private final ConcurrentMap<String, Consumer<JSLanguageServiceAnswer>> myEventCollector;
    @NotNull
    private final ConcurrentMap<String, JSLanguageServiceAnswer> myConfigDiagnostics = ContainerUtil.newConcurrentMap();
    @NotNull
    private final MergingUpdateQueue myVfsChangedFilesQueue;
    @NotNull
    private final Set<VirtualFile> myVfsChangedFiles;

    public TypeScriptServerState() {
        this.myEventCollector = ContainerUtil.newConcurrentMap();
        this.myCompileQueue = new MergingUpdateQueue("TypeScript service compile queue", 2500, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
        this.myProjectErrorsQueue = new MergingUpdateQueue("TypeScript service project errors queue", 2500, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
        this.myVfsChangedFilesQueue = new MergingUpdateQueue("TypeScript service files to reload", 10000, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
        this.myVfsChangedFilesQueue.setRestartTimerOnAdd(true);
        this.myVfsChangedFilesQueue.setPassThrough(false);
        this.myVfsChangedFiles = ContainerUtil.newConcurrentSet();
        this.registerEventTracker("configFileDiag", (Consumer<JSLanguageServiceAnswer>)((Consumer)el -> {
            JsonObject element = el.getElement();
            JsonObject body = element.getAsJsonObject("body");
            JsonElement file2 = body.get("configFile");
            if (file2 != null && file2.isJsonPrimitive()) {
                String string = file2.getAsString();
                this.myConfigDiagnostics.put(string, (JSLanguageServiceAnswer)el);
                JSLanguageServiceQueue.LOGGER.debug("Updated config diagnostics: " + el.getElement());
            }
        }));
    }

    void registerEventTracker(@NotNull String eventName, @NotNull Consumer<JSLanguageServiceAnswer> tracker) {
        if (eventName == null) {
            TypeScriptServerState.$$$reportNull$$$0(0);
        }
        if (tracker == null) {
            TypeScriptServerState.$$$reportNull$$$0(1);
        }
        this.myEventCollector.put(eventName, tracker);
    }

    boolean removeEventTracker(@NotNull String eventName, @NotNull Consumer<JSLanguageServiceAnswer> tracker) {
        if (eventName == null) {
            TypeScriptServerState.$$$reportNull$$$0(2);
        }
        if (tracker == null) {
            TypeScriptServerState.$$$reportNull$$$0(3);
        }
        return this.myEventCollector.remove(eventName, tracker);
    }

    void addToCompileQueue(@NotNull Update update) {
        if (update == null) {
            TypeScriptServerState.$$$reportNull$$$0(4);
        }
        this.myCompileQueue.queue(update);
    }

    void addToProjectErrorsQueue(@NotNull Update update) {
        if (update == null) {
            TypeScriptServerState.$$$reportNull$$$0(5);
        }
        this.myProjectErrorsQueue.queue(update);
    }

    void processEvent(@NotNull JSLanguageServiceAnswer el) {
        String type;
        if (el == null) {
            TypeScriptServerState.$$$reportNull$$$0(6);
        }
        if ((type = el.getProperty("event")) == null) {
            return;
        }
        Consumer consumer = (Consumer)this.myEventCollector.get(type);
        if (consumer != null) {
            consumer.consume((Object)el);
        } else {
            JSLanguageServiceQueue.LOGGER.debug("Unprocessed event: " + el.getElement());
        }
    }

    @Nullable
    JSLanguageServiceAnswer getConfigDiagnostics(@NotNull String config2) {
        if (config2 == null) {
            TypeScriptServerState.$$$reportNull$$$0(7);
        }
        return (JSLanguageServiceAnswer)this.myConfigDiagnostics.get(config2);
    }

    void flushCompileQueue() {
        this.myCompileQueue.flush();
    }

    void flushProjectErrorsQueue() {
        this.myProjectErrorsQueue.flush();
    }

    void addFileToVfsQueue(final @NotNull VirtualFile file2) {
        if (file2 == null) {
            TypeScriptServerState.$$$reportNull$$$0(8);
        }
        this.myVfsChangedFiles.add(file2);
        this.myVfsChangedFilesQueue.queue(new Update(file2){

            public void run() {
                TypeScriptServerState.this.myVfsChangedFiles.remove(file2);
            }
        });
    }

    @NotNull
    public Set<VirtualFile> getVfsChangedFiles() {
        HashSet hashSet = ContainerUtil.newHashSet(this.myVfsChangedFiles);
        if (hashSet == null) {
            TypeScriptServerState.$$$reportNull$$$0(9);
        }
        return hashSet;
    }

    public void dispose() {
        this.myCompileQueue.cancelAllUpdates();
        this.myProjectErrorsQueue.cancelAllUpdates();
        this.myVfsChangedFiles.clear();
        this.myVfsChangedFilesQueue.cancelAllUpdates();
        this.myEventCollector.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventName";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracker";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "update";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerState";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getVfsChangedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerEventTracker";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeEventTracker";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addToCompileQueue";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addToProjectErrorsQueue";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processEvent";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getConfigDiagnostics";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addFileToVfsQueue";
                break;
            }
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

