/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.validation.fixes.BaseCreateFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JSRemoveInitializerQuickFix
implements LocalQuickFix {
    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"js.remove.redundant.initializer.fix", (Object[])new Object[0]);
        if (string == null) {
            JSRemoveInitializerQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        JSType type;
        JSVariable parent;
        JSExpression initializer;
        if (project == null) {
            JSRemoveInitializerQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor2 == null) {
            JSRemoveInitializerQuickFix.$$$reportNull$$$0(2);
        }
        JSExpression jSExpression = initializer = (parent = (JSVariable)ObjectUtils.tryCast((Object)descriptor2.getStartElement().getParent(), JSVariable.class)) != null ? parent.getInitializer() : null;
        if (initializer == null) {
            return;
        }
        PsiElement eq = JSPsiImplUtils.getPrevSiblingIgnoreWhitespace((PsiElement)initializer);
        if (eq == null || eq.getNode().getElementType() != JSTokenTypes.EQ) {
            return;
        }
        DialectOptionHolder dialectOptionHolder = DialectDetector.dialectOfElement((PsiElement)initializer);
        if (dialectOptionHolder != null && dialectOptionHolder.isTypeScript && (type = JSResolveUtil.getExpressionJSType(initializer)) != null && parent.getTypeElement() == null) {
            JSRefactoringUtil.setType((JSElement)parent, BaseCreateFix.getTypeText(type, (PsiElement)initializer));
        }
        eq.delete();
        initializer.delete();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/JSRemoveInitializerQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/JSRemoveInitializerQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

