/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.highlighting.JSMethodToImplement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.validation.fixes.BaseCreateMembersFix;
import com.intellij.lang.javascript.validation.fixes.CreateJSFunctionIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ImplementJSDocMethodsFix
extends BaseCreateMembersFix<JSElement>
implements LocalQuickFix {
    final String myClassName;
    final Map<JSMethodToImplement.MethodKey, JSMethodToImplement> myNonImplemented;

    public ImplementJSDocMethodsFix(@NotNull String className, Map<JSMethodToImplement.MethodKey, JSMethodToImplement> nonImplemented) {
        if (className == null) {
            ImplementJSDocMethodsFix.$$$reportNull$$$0(0);
        }
        super(null);
        this.myClassName = className;
        this.myNonImplemented = nonImplemented;
    }

    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"javascript.fix.implement.methods", (Object[])new Object[0]);
        if (string == null) {
            ImplementJSDocMethodsFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            ImplementJSDocMethodsFix.$$$reportNull$$$0(2);
        }
        PsiElement element = file2.findElementAt(editor.getCaretModel().getOffset());
        JSSourceElement declarationOwner = (JSSourceElement)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{JSSourceElement.class});
        if (declarationOwner == null) {
            return;
        }
        this.doImplement(project, declarationOwner, true);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        JSSourceElement declarationOwner;
        if (project == null) {
            ImplementJSDocMethodsFix.$$$reportNull$$$0(3);
        }
        if (descriptor2 == null) {
            ImplementJSDocMethodsFix.$$$reportNull$$$0(4);
        }
        if ((declarationOwner = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)descriptor2.getPsiElement(), JSSourceElement.class, (boolean)false)) == null) {
            return;
        }
        this.doImplement(project, declarationOwner, false);
    }

    private static String getPrefix(JSMethodToImplement methodToImplement) {
        if (methodToImplement.isGetAccessor()) {
            return "get ";
        }
        if (methodToImplement.isSetAccessor()) {
            return "set ";
        }
        String prefix = "";
        if (methodToImplement.isAsync()) {
            prefix = prefix + "async ";
        }
        if (methodToImplement.isGenerator()) {
            prefix = prefix + "*";
        }
        return prefix;
    }

    private void doImplement(@NotNull Project project, JSSourceElement declarationOwner, boolean filterElements) {
        if (project == null) {
            ImplementJSDocMethodsFix.$$$reportNull$$$0(5);
        }
        Set elementsToProcess = filterElements ? this.getElementsToProcess() : null;
        Set names = elementsToProcess == null ? null : elementsToProcess.stream().map(e -> JSMethodToImplement.MethodKey.create(e)).collect(Collectors.toSet());
        Set<Map.Entry<JSMethodToImplement.MethodKey, JSMethodToImplement>> entries = this.myNonImplemented.entrySet();
        ArrayList sortedEntries = ContainerUtil.newArrayList(entries);
        sortedEntries.sort(Comparator.comparing(e -> ((JSMethodToImplement.MethodKey)e.getKey()).getName()));
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        if (declarationOwner instanceof JSClass) {
            for (Map.Entry method : sortedEntries) {
                if (names != null && !names.contains(method.getKey())) continue;
                JSMethodToImplement value = (JSMethodToImplement)method.getValue();
                String declaration = String.format("%s%s %s \n{\n  %s}", ImplementJSDocMethodsFix.getPrefix(value), value.getName(), value.getParameterList(), CreateJSFunctionIntentionAction.getImplementedFunctionBodyText(false, project, false, value.getReturnType(), value.getName()));
                JSSourceElement methodImplementation = JSChangeUtil.createClassMemberPsiFromTextWithContext(declaration, (PsiElement)declarationOwner, JSSourceElement.class);
                if (methodImplementation == null) {
                    return;
                }
                methodImplementation = (JSSourceElement)JSRefactoringUtil.addMemberToTargetClass((JSClass)declarationOwner, (PsiElement)methodImplementation);
                FormatFixer.create((PsiElement)methodImplementation, FormatFixer.Mode.Reformat).fixFormat();
                documentManager.commitAllDocuments();
            }
        } else {
            Collections.reverse(sortedEntries);
            for (Map.Entry method : sortedEntries) {
                if (names != null && !names.contains(method.getKey())) continue;
                JSMethodToImplement value = (JSMethodToImplement)method.getValue();
                String builder = String.format("%s.prototype.%s = function%s{%s};", this.myClassName, method.getKey(), value.getParameterList(), CreateJSFunctionIntentionAction.getImplementedFunctionBodyText(false, project, false, value.getReturnType(), value.getName()));
                PsiElement methodImplementation = JSChangeUtil.createJSTreeFromTextWithContext(builder, (PsiElement)declarationOwner).getPsi();
                declarationOwner.getParent().addAfter(methodImplementation, (PsiElement)declarationOwner);
                documentManager.commitAllDocuments();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/ImplementJSDocMethodsFix";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/ImplementJSDocMethodsFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doImplement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

