/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.ecmascript6.JSInsertThisFix;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.validation.fixes.BaseCreateFix;
import com.intellij.lang.javascript.validation.fixes.BaseCreateJSVariableIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CreateJSVariableIntentionAction
extends BaseCreateJSVariableIntentionAction {
    @NonNls
    protected static final String VAR_STATEMENT_START = "var ";
    @NonNls
    private static final String CONSTANT_STATEMENT_START = "const ";
    private final boolean isField;
    private final boolean isConstant;
    private final boolean myIsModuleScope;

    public CreateJSVariableIntentionAction(String referencedName, boolean isField, boolean isConstant, boolean isModuleScope) {
        super(referencedName);
        this.isField = isField;
        this.isConstant = isConstant;
        this.myIsModuleScope = isModuleScope;
    }

    @NotNull
    public String getName() {
        String string = JSBundle.message((String)(this.isField && !this.myIsModuleScope ? (this.isConstant ? "javascript.create.constant.field.intention.name" : "javascript.create.property.intention.name") : (this.isConstant ? "javascript.create.constant.intention.name" : "javascript.create.variable.intention.name")), (Object[])new Object[]{this.myReferencedName});
        if (string == null) {
            CreateJSVariableIntentionAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected boolean produceDeclarationOnClassLevel(PsiElement element) {
        return this.isField;
    }

    @Override
    @NotNull
    protected Pair<JSReferenceExpression, PsiElement> calculateAnchors(PsiElement psiElement) {
        ES6Decorator decorator = (ES6Decorator)PsiTreeUtil.getParentOfType((PsiElement)psiElement, ES6Decorator.class);
        JSReferenceExpression referenceExpression = (JSReferenceExpression)PsiTreeUtil.getNonStrictParentOfType((PsiElement)psiElement, (Class[])new Class[]{JSReferenceExpression.class});
        if (decorator != null) {
            if (this.isField) {
                Pair pair = Pair.create((Object)referenceExpression, (Object)decorator.getOwner().getLastChild());
                if (pair == null) {
                    CreateJSVariableIntentionAction.$$$reportNull$$$0(1);
                }
                return pair;
            }
            Pair pair = Pair.create((Object)referenceExpression, (Object)decorator.getOwner());
            if (pair == null) {
                CreateJSVariableIntentionAction.$$$reportNull$$$0(2);
            }
            return pair;
        }
        Pair<JSReferenceExpression, PsiElement> pair = super.calculateAnchors(psiElement);
        if (pair == null) {
            CreateJSVariableIntentionAction.$$$reportNull$$$0(3);
        }
        return pair;
    }

    @Override
    protected void buildTemplate(Template template, JSReferenceExpression referenceExpression, boolean isStaticContext, PsiFile file2, PsiElement anchorParent) {
        boolean hasTypes;
        String refText;
        boolean creatingInDifferentFile;
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)(file2 instanceof JSFile || referenceExpression == null ? file2 : referenceExpression));
        boolean isActionScript = holder != null && holder.isECMA4;
        boolean isES6ClassImplementation = JSClassUtils.isES6ClassImplementation(holder);
        PsiElement contextClass = CreateJSVariableIntentionAction.findClass(anchorParent);
        JSExpression qualifier = referenceExpression.getQualifier();
        if (contextClass instanceof JSClass) {
            this.addAccessModifier(template, referenceExpression, file2, isStaticContext, (JSClass)contextClass);
        }
        boolean bl = creatingInDifferentFile = qualifier != null && referenceExpression.getContainingFile() != file2;
        if (isActionScript) {
            template.addTextSegment(this.isConstant ? CONSTANT_STATEMENT_START : VAR_STATEMENT_START);
        } else if (qualifier == null && (!this.isField || !isES6ClassImplementation) || creatingInDifferentFile || anchorParent instanceof TypeScriptModule) {
            if (creatingInDifferentFile && (anchorParent == null || anchorParent instanceof JSFile) || this.myIsModuleScope) {
                template.addTextSegment("export ");
            }
            if (!creatingInDifferentFile || anchorParent == null || anchorParent instanceof JSFile) {
                template.addTextSegment(this.isConstant ? CONSTANT_STATEMENT_START : VAR_STATEMENT_START);
            }
        }
        if (JSUtils.isPrivateFieldSharpAccessContext((PsiElement)referenceExpression)) {
            template.addTextSegment("#");
        }
        String string = refText = isActionScript || isES6ClassImplementation ? referenceExpression.getReferenceName() : referenceExpression.getText();
        if (refText != null) {
            template.addTextSegment(refText);
        }
        template.addEndVariable();
        boolean isEnumContext = contextClass instanceof TypeScriptEnum;
        boolean bl2 = hasTypes = holder != null && holder.hasFeature(JSLanguageFeature.TYPES);
        if (isActionScript || (contextClass != null && !isEnumContext || this.myIsModuleScope) && hasTypes) {
            template.addTextSegment(":");
            this.guessTypeAndAddTemplateVariable(template, (JSExpression)referenceExpression, file2, false);
            if (this.isConstant) {
                template.addTextSegment(" = ");
                this.addCompletionVar(template);
            }
        } else if (qualifier != null && contextClass == null) {
            template.addTextSegment(" = ");
            BaseCreateFix.MyExpression expression = new BaseCreateFix.MyExpression("undefined");
            template.addVariable("__type" + referenceExpression.getText(), (Expression)expression, (Expression)expression, true);
        }
        if (!isEnumContext) {
            this.addSemicolonSegment(template, file2);
        } else {
            TypeScriptEnum classEnum = (TypeScriptEnum)contextClass;
            if (classEnum.getFields().length > 0) {
                template.addTextSegment(",");
            }
        }
    }

    @Override
    protected JSReferenceExpression beforeStartTemplateAction(JSReferenceExpression referenceExpression, Editor editor, PsiElement anchor, boolean isStaticContext) {
        JSReferenceExpression expression = super.beforeStartTemplateAction(referenceExpression, editor, anchor, isStaticContext);
        if (expression == null) {
            return null;
        }
        if (JSClassUtils.isES6ClassImplementation((PsiElement)expression) && expression.getQualifier() == null && this.isField) {
            return (JSReferenceExpression)JSInsertThisFix.insertThisQualifier((JSExpression)expression, editor);
        }
        return expression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/javascript/validation/fixes/CreateJSVariableIntentionAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateAnchors";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

