/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.Language;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.inspections.JSValidateTypesInspection;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCommonTypeNames;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeComparingCacheService;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.lang.javascript.validation.JSAnnotatorProblemReporter;
import com.intellij.lang.javascript.validation.JSTypeChecker;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValidateTypesUtil {
    @NonNls
    public static final String FLASH_UTILS_DICTIONARY = "flash.utils.Dictionary";

    static void checkNumericTypesInUnaryOperation(IElementType operationSign, JSExpression expression, JSTypeChecker typeChecker) {
        PsiFile containingFile;
        if (expression != null && (JSTokenTypes.PLUSPLUS == operationSign || JSTokenTypes.MINUSMINUS == operationSign || JSTokenTypes.PLUS == operationSign || JSTokenTypes.MINUS == operationSign) && (containingFile = expression.getContainingFile()).getLanguage().isKindOf((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4)) {
            JSType numberType = JSNamedType.createType("Number", JSTypeSourceFactory.createTypeSource((PsiElement)expression, true), JSContext.INSTANCE);
            typeChecker.checkExpressionIsAssignableToType(expression, numberType, "javascript.expression.type.implicitly.coerced.to.unrelated.type", null, false);
        }
    }

    static void checkTypesInConditionalExpr(JSConditionalExpression node, JSTypeChecker typeChecker) {
        JSType expectedType;
        PsiFile containingFile;
        JSExpression thenBranch = node.getThen();
        JSExpression elseBranch = node.getElse();
        if (thenBranch != null && elseBranch != null && (containingFile = node.getContainingFile()).getLanguage().isKindOf((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4) && (expectedType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)node)) != null) {
            if ("String".equals(expectedType.getTypeText()) && ValidateTypesUtil.isInStringConcatenation(node)) {
                return;
            }
            typeChecker.checkExpressionIsAssignableToType(elseBranch, expectedType, "javascript.expression.type.implicitly.coerced.to.unrelated.type", null, false);
            typeChecker.checkExpressionIsAssignableToType(thenBranch, expectedType, "javascript.expression.type.implicitly.coerced.to.unrelated.type", null, false);
        }
    }

    private static boolean isInStringConcatenation(JSConditionalExpression node) {
        String type;
        IElementType sign;
        PsiElement parent = node.getParent();
        while (parent instanceof JSParenthesizedExpression) {
            parent = parent.getParent();
        }
        if (parent instanceof JSConditionalExpression) {
            return ValidateTypesUtil.isInStringConcatenation((JSConditionalExpression)parent);
        }
        return parent instanceof JSBinaryExpression && (sign = ((JSBinaryExpression)parent).getOperationSign()) == JSTokenTypes.PLUS && "String".equals(type = JSResolveUtil.getQualifiedExpressionType(((JSBinaryExpression)parent).getLOperand(), node.getContainingFile()));
    }

    public static void checkTypesInAssignment(JSAssignmentExpression node, JSTypeChecker typeChecker) {
        ValidateTypesUtil.checkAssignableTypesInBinaryExpression((JSBinaryExpression)node, typeChecker, "javascript.assigned.expression.type.mismatch");
    }

    private static void checkAssignableTypesInBinaryExpression(JSBinaryExpression node, JSTypeChecker typeChecker, String problemKey) {
        JSType expressionJSType;
        JSType type;
        JSExpression innerExpression;
        JSExpression lOperand = node.getLOperand();
        if (lOperand == null) {
            return;
        }
        JSExpression rOperand = node.getROperand();
        if (rOperand == null) {
            return;
        }
        if (lOperand instanceof JSDefinitionExpression && (innerExpression = ((JSDefinitionExpression)lOperand).getExpression()) instanceof JSReferenceExpression && ((JSReferenceExpression)innerExpression).resolve() == lOperand && ((type = ((JSDefinitionExpression)lOperand).getType()) == null || !type.getSource().isExplicitlyDeclared())) {
            return;
        }
        JSType jsType = JSResolveUtil.getExpressionJSType(lOperand);
        JSType jSType = expressionJSType = DialectDetector.isTypeScript((PsiElement)lOperand) ? JSTypeUtils.getValuableType(jsType) : jsType;
        if (expressionJSType == null) {
            return;
        }
        if ((expressionJSType instanceof JSStringType || "XMLList".equals(expressionJSType.getTypeText())) && node.getOperationSign() == JSTokenTypes.PLUSEQ) {
            return;
        }
        JSTypeSource source = expressionJSType.getSource();
        if (source.isStrict()) {
            JSVariable variableToFixTypeOf = source.getSourceElement() instanceof JSVariable ? (JSVariable)source.getSourceElement() : null;
            typeChecker.checkExpressionIsAssignableToType(rOperand, expressionJSType, problemKey, (PsiElement)variableToFixTypeOf, false);
        }
    }

    private static void checkTypeIs(PsiElement type, PsiElement node, JSAnnotatorProblemReporter reporter, String typeName, String key) {
        if (type instanceof JSReferenceExpression) {
            ValidateTypesUtil.checkTypeIs((JSExpression)type, node, reporter, typeName, key);
        } else if (type != null) {
            reporter.registerProblem(node, JSBundle.message((String)key, (Object[])new Object[]{typeName, type.getText()}), ValidateTypesUtil.getHighlightTypeForTypeOrSignatureProblem(node), JSValidateTypesInspection.SHORT_NAME, new LocalQuickFix[0]);
        }
    }

    public static void checkTypeIs(JSExpression rOperand, PsiElement node, JSAnnotatorProblemReporter reporter, String typeName, String key) {
        String expressionType = JSResolveUtil.getQualifiedExpressionType(rOperand, rOperand.getContainingFile());
        if (!typeName.equals(expressionType) && !"*".equals(expressionType)) {
            reporter.registerProblem(node, JSBundle.message((String)key, (Object[])new Object[]{typeName, expressionType}), ValidateTypesUtil.getHighlightTypeForTypeOrSignatureProblem(node), JSValidateTypesInspection.SHORT_NAME, new LocalQuickFix[0]);
        }
    }

    public static PsiElement getPlaceForSignatureProblem(JSCallExpression node, @Nullable JSArgumentList argumentList) {
        if (argumentList != null && !argumentList.textContains('\n')) {
            return argumentList;
        }
        JSExpression expression = node.getMethodExpression();
        if (expression != null) {
            return PsiTreeUtil.lastChild((PsiElement)expression);
        }
        return PsiTreeUtil.firstChild((PsiElement)node);
    }

    public static Trinity<Integer, Integer, Boolean> getMinMaxParameters(JSParameterItem[] parameters) {
        boolean hasRest = false;
        boolean hasOptional = false;
        int minParameterLength = 0;
        int maxParameterLength = parameters.length;
        HashSet<JSDestructuringObject> destructingObjectParams = new HashSet<JSDestructuringObject>();
        int paramInsideObjectCount = 0;
        for (JSParameterItem parameter : parameters) {
            PsiElement parent;
            if (parameter instanceof JSParameter && (parent = PsiTreeUtil.getParentOfType((PsiElement)((JSParameter)parameter), (Class[])new Class[]{JSDestructuringObject.class, JSParameterList.class})) instanceof JSDestructuringObject) {
                destructingObjectParams.add((JSDestructuringObject)parent);
                ++paramInsideObjectCount;
            }
            hasOptional |= parameter.isOptional();
            if (parameter.getTypeDecorator().isRest()) {
                hasRest = true;
                maxParameterLength = Integer.MAX_VALUE;
                continue;
            }
            if (hasOptional) continue;
            ++minParameterLength;
        }
        return Trinity.create((Object)(minParameterLength -= paramInsideObjectCount - destructingObjectParams.size()), (Object)maxParameterLength, (Object)hasRest);
    }

    public static LocalQuickFix jsInsertCastFix(String type, @NotNull DialectOptionHolder holder) {
        if (holder == null) {
            ValidateTypesUtil.$$$reportNull$$$0(0);
        }
        return JSFixFactory.getInstance().jsInsertCastFix(type, holder);
    }

    public static LocalQuickFix changeSignatureFix(JSFunction function, Function<JSParameterListElement, String> typeProvider, String overriddenReturnType) {
        return JSFixFactory.getInstance().changeSignatureFix(function, typeProvider, overriddenReturnType);
    }

    protected static LocalQuickFix changeTypeFix(JSNamedElement var, String expressionType, String nameKey) {
        return JSFixFactory.getInstance().changeTypeFix(var, expressionType, nameKey);
    }

    @Nullable
    public static LocalQuickFix tryCreateInheritanceFix(String expectedType, String actualType, PsiElement context) {
        if (ArrayUtil.contains((String)expectedType, (String[])JSCommonTypeNames.ALL)) {
            return null;
        }
        PsiElement expectedClass = JSResolveUtil.findType(expectedType, context, true);
        if (!(expectedClass instanceof JSClass)) {
            return null;
        }
        PsiElement actualClass = JSResolveUtil.findType(actualType, context, true);
        if (!(actualClass instanceof JSClass)) {
            return null;
        }
        if (JSProjectUtil.isInLibrary(actualClass)) {
            return null;
        }
        JSAttributeList attributeList = ((JSClass)expectedClass).getAttributeList();
        if (attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.FINAL)) {
            return null;
        }
        if (!((JSClass)expectedClass).isInterface() && ((JSClass)actualClass).getSuperClasses().length > 0 && !JSResolveUtil.isObjectClass(((JSClass)actualClass).getSuperClasses()[0])) {
            return null;
        }
        if (!((JSClass)expectedClass).isInterface() && ((JSClass)actualClass).isInterface()) {
            return null;
        }
        return ValidateTypesUtil.createInheritanceFix((JSClass)expectedClass, actualClass);
    }

    private static LocalQuickFix createInheritanceFix(JSClass expectedClass, PsiElement actualClass) {
        return JSFixFactory.getInstance().createInheritanceFix(expectedClass, actualClass);
    }

    public static boolean checkIfNullIsAssignedToNumeric(JSExpression expr, String type, String expressionType) {
        return "*".equals(expressionType) && expr instanceof JSLiteralExpression && expr.getFirstChild().getNode().getElementType() == JSTokenTypes.NULL_KEYWORD && ("Number".equals(type) || "int".equals(type) || "uint".equals(type));
    }

    private static boolean isParameterTypeValidityCheck(@NotNull JSType lOpType, @NotNull JSType rOpType) {
        if (lOpType == null) {
            ValidateTypesUtil.$$$reportNull$$$0(1);
        }
        if (rOpType == null) {
            ValidateTypesUtil.$$$reportNull$$$0(2);
        }
        JSTypeSource lOpTypeSource = lOpType.getSource();
        JSTypeSource rOpTypeSource = rOpType.getSource();
        return lOpTypeSource.getLanguage() == JSTypeSource.SourceLanguage.JS && lOpTypeSource.getSourceElement() instanceof JSParameter && (rOpType instanceof JSNullType || rOpType instanceof JSUndefinedType) || rOpTypeSource.getLanguage() == JSTypeSource.SourceLanguage.JS && rOpTypeSource.getSourceElement() instanceof JSParameter && (lOpType instanceof JSNullType || lOpType instanceof JSUndefinedType);
    }

    @Nullable
    public static ProblemHighlightType getHighlightTypeForTypeOrSignatureProblem(@NotNull PsiElement node) {
        Language language;
        if (node == null) {
            ValidateTypesUtil.$$$reportNull$$$0(3);
        }
        if ((language = node.getContainingFile().getLanguage()) == JavaScriptSupportLoader.ECMA_SCRIPT_L4) {
            return ProblemHighlightType.GENERIC_ERROR;
        }
        if (DialectDetector.isTypeScript(node)) {
            if (!(node.getContainingFile() instanceof JSFile)) {
                return null;
            }
            return ProblemHighlightType.GENERIC_ERROR;
        }
        return null;
    }

    public static void checkTypesInForIn(JSForInStatement node, JSAnnotatorProblemReporter reporter) {
        JSVarStatement statement;
        if (!node.isForEach() && (statement = node.getDeclarationStatement()) != null) {
            PsiFile containingFile = node.getContainingFile();
            JSExpression collectionExpression = node.getCollectionExpression();
            String expressionType = JSResolveUtil.getQualifiedExpressionType(collectionExpression, containingFile);
            if (JSResolveUtil.isAssignableType(FLASH_UTILS_DICTIONARY, expressionType, (PsiElement)containingFile)) {
                return;
            }
            for (JSVariable var : statement.getVariables()) {
                String typeElementText;
                PsiElement typeElement = var.getTypeElement();
                String string = typeElementText = typeElement == null ? null : typeElement.getText();
                if (typeElementText != null && ValidateTypesUtil.isValidArrayIndexType(typeElementText) && JSResolveUtil.isAssignableType("Array", expressionType, (PsiElement)containingFile)) continue;
                if (typeElement != null && ("Object".equals(typeElementText) || "*".equals(typeElementText) || "Object".equals(expressionType) && !"String".equals(typeElementText))) {
                    reporter.registerProblem(typeElement, JSBundle.message((String)"javascript.incorrect.array.type.in.for-in", (Object[])new Object[0]), ProblemHighlightType.WEAK_WARNING, JSValidateTypesInspection.SHORT_NAME, new LocalQuickFix[0]);
                    continue;
                }
                ValidateTypesUtil.checkTypeIs(typeElement, typeElement, reporter, "XMLList".equals(expressionType) ? "XML" : "String", "javascript.incorrect.variable.type.mismatch");
            }
        }
    }

    private static boolean isValidArrayIndexType(String type) {
        return "String".equals(type) || "int".equals(type) || "uint".equals(type) || "Number".equals(type);
    }

    public static LocalQuickFix removeASTNodeFix(PsiElement expression, String propKey) {
        return JSFixFactory.getInstance().removeASTNodeFix(propKey, expression.getNode());
    }

    public static void checkTypesInBinaryExpression(@NotNull JSBinaryExpression node, @NotNull JSTypeChecker checker) {
        if (node == null) {
            ValidateTypesUtil.$$$reportNull$$$0(4);
        }
        if (checker == null) {
            ValidateTypesUtil.$$$reportNull$$$0(5);
        }
        IElementType sign = node.getOperationSign();
        JSExpression lOperand = node.getLOperand();
        if (lOperand == null) {
            return;
        }
        JSExpression rOperand = node.getROperand();
        if (rOperand == null) {
            return;
        }
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)node);
        boolean ecma = holder != null && holder.isECMA4;
        ProcessingContext context = JSTypeComparingCacheService.getProcessingContextWithCache((PsiElement)node);
        if ((JSTokenTypes.MULTIPLICATIVE_OPERATIONS.contains(sign) || JSTokenTypes.SHIFT_OPERATIONS.contains(sign) || sign == JSTokenTypes.MINUS) && ecma) {
            JSType numberType = JSNamedType.createType("Number", JSTypeSourceFactory.createTypeSource((PsiElement)lOperand, true), JSContext.INSTANCE);
            checker.checkExpressionIsAssignableToType(lOperand, numberType, "javascript.expression.type.implicitly.coerced.to.unrelated.type", null, false);
            checker.checkExpressionIsAssignableToType(rOperand, numberType, "javascript.expression.type.implicitly.coerced.to.unrelated.type", null, false);
            return;
        }
        if (sign != JSTokenTypes.EQEQ && sign != JSTokenTypes.NE && sign != JSTokenTypes.EQEQEQ && sign != JSTokenTypes.NEQEQ) {
            return;
        }
        JSType lOpType = JSResolveUtil.getExpressionJSType(lOperand);
        if (lOpType == null || lOpType instanceof JSAnyType) {
            return;
        }
        JSType rOpType = JSResolveUtil.getExpressionJSType(rOperand);
        if (rOpType == null) {
            return;
        }
        JSTypeSource lOpTypeSource = lOpType.getSource();
        JSTypeSource rOpTypeSource = rOpType.getSource();
        if (lOpTypeSource.isStrict() && rOpTypeSource.isStrict() && !JSResolveUtil.isAssignableJSType(lOpType, rOpType, context)) {
            LocalQuickFix[] localQuickFixArray;
            boolean strictComparison;
            if (rOpType instanceof JSBooleanType) {
                return;
            }
            if (ValidateTypesUtil.isParameterTypeValidityCheck(lOpType, rOpType)) {
                return;
            }
            boolean bl = strictComparison = sign == JSTokenTypes.EQEQEQ || sign == JSTokenTypes.NEQEQ;
            if (!strictComparison && ValidateTypesUtil.isSkippableForNonStrictBinaryComparison(lOpType) && ValidateTypesUtil.isSkippableForNonStrictBinaryComparison(rOpType)) {
                return;
            }
            if (ecma) {
                JSClass rOpTypeClass = rOpType.resolveClass();
                if (rOpTypeClass != null && rOpTypeClass.isInterface()) {
                    return;
                }
                JSClass lOpTypeClass = lOpType.resolveClass();
                if (lOpTypeClass != null && lOpTypeClass.isInterface()) {
                    return;
                }
            }
            JSType rExpanded = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(rOpType);
            JSType lExpanded = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(lOpType);
            if (lExpanded instanceof JSUnionType && rExpanded instanceof JSUnionType) {
                return;
            }
            if (JSResolveUtil.isAssignableJSType(rOpType, lOpType, context)) {
                return;
            }
            if (rExpanded instanceof JSPrimitiveType ? ValidateTypesUtil.checkPrimitiveTypeCompatibility((JSPrimitiveType)rExpanded, lExpanded, context) : lExpanded instanceof JSPrimitiveType && ValidateTypesUtil.checkPrimitiveTypeCompatibility((JSPrimitiveType)lExpanded, rExpanded, context)) {
                return;
            }
            if (ecma) {
                LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                localQuickFixArray = localQuickFixArray2;
                localQuickFixArray2[0] = ValidateTypesUtil.jsInsertCastFix(lOpType.getTypeText(), holder);
            } else {
                localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
            }
            LocalQuickFix[] fixes = localQuickFixArray;
            String message = JSBundle.message((String)"javascript.binary.operand.type.mismatch", (Object[])new Object[]{lOpType.getTypeText(JSType.TypeTextFormat.PRESENTABLE), rOpType.getTypeText(JSType.TypeTextFormat.PRESENTABLE)});
            checker.registerProblem(node.getNode().findChildByType(sign).getPsi(), message, ValidateTypesUtil.getHighlightTypeForTypeOrSignatureProblem((PsiElement)node), fixes);
        } else if (ecma && ValidateTypesUtil.checkIfNullIsAssignedToNumeric(rOperand, lOpType.getTypeText(), rOpType.getTypeText())) {
            String message = JSBundle.message((String)"javascript.expression.type.implicitly.coerced.to.unrelated.type", (Object[])new Object[]{lOpType.getTypeText(JSType.TypeTextFormat.PRESENTABLE), rOpType.getTypeText(JSType.TypeTextFormat.PRESENTABLE)});
            checker.registerProblem((PsiElement)rOperand, message, ValidateTypesUtil.getHighlightTypeForTypeOrSignatureProblem((PsiElement)lOperand), new LocalQuickFix[0]);
        }
    }

    @Contract(value="null -> false")
    private static boolean isSkippableForNonStrictBinaryComparison(@Nullable JSType lOpType) {
        return lOpType instanceof JSObjectType || lOpType instanceof JSStringType || lOpType instanceof JSNumberType || lOpType instanceof JSNullType || lOpType instanceof JSUndefinedType || lOpType instanceof JSUnionType && ((JSUnionType)lOpType).getTypes().stream().allMatch(ValidateTypesUtil::isSkippableForNonStrictBinaryComparison);
    }

    private static boolean checkPrimitiveTypeCompatibility(@NotNull JSPrimitiveType primitiveType, @NotNull JSType toCompare, @NotNull ProcessingContext context) {
        if (primitiveType == null) {
            ValidateTypesUtil.$$$reportNull$$$0(6);
        }
        if (toCompare == null) {
            ValidateTypesUtil.$$$reportNull$$$0(7);
        }
        if (context == null) {
            ValidateTypesUtil.$$$reportNull$$$0(8);
        }
        Ref result2 = Ref.create((Object)false);
        JSTypeUtils.processExpandedType((Processor<JSType>)((Processor)type -> {
            if (primitiveType == null) {
                ValidateTypesUtil.$$$reportNull$$$0(11);
            }
            if (context == null) {
                ValidateTypesUtil.$$$reportNull$$$0(12);
            }
            if (((Boolean)result2.get()).booleanValue()) {
                return false;
            }
            if (type instanceof JSPrimitiveType) {
                result2.set((Object)(JSResolveUtil.isAssignableJSType(type, primitiveType, context) || JSResolveUtil.isAssignableJSType(primitiveType, type, context) ? 1 : 0));
            }
            return true;
        }), toCompare, false, true, true);
        return (Boolean)result2.get();
    }

    public static boolean hasRequiredParameters(JSFunction method) {
        for (JSParameterListElement p : method.getParameters()) {
            if (p.isRest() || p.hasInitializer()) continue;
            return true;
        }
        return false;
    }

    public static boolean emptyReturnIsAcceptable(@NotNull JSFunction function, @NotNull JSType type) {
        JSCompositeTypeImpl compositeType;
        JSType componentType;
        if (function == null) {
            ValidateTypesUtil.$$$reportNull$$$0(9);
        }
        if (type == null) {
            ValidateTypesUtil.$$$reportNull$$$0(10);
        }
        if (DialectDetector.isTypeScript((PsiElement)function)) {
            return true;
        }
        if (ES6PsiUtil.isAsyncContext(function) && JSTypeUtils.isPromiseType(type)) {
            JSType componentType2 = JSTypeUtils.getPromiseComponentTypeOrNull(JSTypeUtils.getValuableType(type));
            if (componentType2 == null) {
                return true;
            }
            return ValidateTypesUtil.emptyReturnIsAcceptable(function, componentType2);
        }
        if (ES6PsiUtil.isGeneratorContext(function) && (componentType = JSTypeUtils.getIterableComponentType(type)) != null) {
            return ValidateTypesUtil.emptyReturnIsAcceptable(function, componentType);
        }
        JSUndefinedType undefinedType = new JSUndefinedType(JSTypeSourceFactory.createTypeSource((PsiElement)function));
        JSCompositeTypeImpl jSCompositeTypeImpl = compositeType = type instanceof JSCompositeTypeImpl ? (JSCompositeTypeImpl)type : null;
        if (compositeType != null) {
            List<JSType> components = compositeType.getTypes();
            for (JSType component : components) {
                if (!ValidateTypesUtil.emptyReturnIsAcceptable(function, component)) continue;
                return true;
            }
        }
        return type instanceof JSAnyType || type instanceof JSVoidType || !(type instanceof JSObjectType) && type.isDirectlyAssignableType((JSType)undefinedType, new ProcessingContext()) && JSTypeUtils.typeCanBeAssignedWithoutCoercion(type, undefinedType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lOpType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rOpType";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checker";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "primitiveType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toCompare";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/validation/ValidateTypesUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "jsInsertCastFix";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isParameterTypeValidityCheck";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getHighlightTypeForTypeOrSignatureProblem";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkTypesInBinaryExpression";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "checkPrimitiveTypeCompatibility";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "emptyReturnIsAcceptable";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$checkPrimitiveTypeCompatibility$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

