/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.ecmascript6.JSInsertThisFix;
import com.intellij.lang.javascript.ecmascript6.TypeScriptTypeGuardFixHelper;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.validation.JSReferenceInspectionProblemReporter;
import com.intellij.lang.javascript.validation.TypedJSReferenceChecker;
import com.intellij.lang.typescript.psi.TypeScriptEntityName;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptReferenceChecker
extends TypedJSReferenceChecker {
    public TypeScriptReferenceChecker(@NotNull JSReferenceInspectionProblemReporter reporter) {
        if (reporter == null) {
            TypeScriptReferenceChecker.$$$reportNull$$$0(0);
        }
        super(reporter);
    }

    @Override
    protected boolean processExpressionResolveResult(@Nullable JSExpression expression, @Nullable PsiElement resolved) {
        JSFunction function;
        JSAttributeList list;
        if (expression instanceof JSReferenceExpression && ((JSReferenceExpression)expression).getQualifier() instanceof JSSuperExpression && resolved instanceof JSFunction && (list = (function = (JSFunction)resolved).getAttributeList()) != null && list.hasModifier(JSAttributeList.ModifierType.ABSTRACT)) {
            String message = JSBundle.message((String)"typescript.validation.message.abstract.member.access.super", (Object[])new Object[]{function.getName()});
            this.myReporter.reportUnresolvedFunctionError((PsiElement)expression, this.getUnresolvedReferenceHighlightType((JSReferenceExpression)expression), message, null);
            return true;
        }
        return false;
    }

    @Override
    protected void addCreateFromUsageFixesForCall(@NotNull JSCallExpression node, @NotNull JSReferenceExpression referenceExpression, @NotNull ResolveResult[] resolveResults, @NotNull List<LocalQuickFix> quickFixes) {
        if (node == null) {
            TypeScriptReferenceChecker.$$$reportNull$$$0(1);
        }
        if (referenceExpression == null) {
            TypeScriptReferenceChecker.$$$reportNull$$$0(2);
        }
        if (resolveResults == null) {
            TypeScriptReferenceChecker.$$$reportNull$$$0(3);
        }
        if (quickFixes == null) {
            TypeScriptReferenceChecker.$$$reportNull$$$0(4);
        }
        if (referenceExpression.getQualifier() == null && resolveResults.length == 0) {
            quickFixes.add(JSFixFactory.getInstance().typeScriptAddImportStatementFix(referenceExpression.getReferenceName(), (PsiElement)referenceExpression));
        }
        super.addCreateFromUsageFixesForCall(node, referenceExpression, resolveResults, quickFixes);
    }

    @Override
    protected boolean addCreateFromUsageFixes(JSReferenceExpression node, ResolveResult[] resolveResults, List<LocalQuickFix> fixes, boolean inTypeContext, boolean ecma) {
        String referenceName;
        JSField fieldByName;
        JSClass context;
        if (!inTypeContext && node.getQualifier() == null && (context = JSResolveUtil.getClassOfContext((PsiElement)node)) != null && (fieldByName = context.findFieldByName(referenceName = node.getReferenceName())) != null) {
            fixes.add(new JSInsertThisFix((JSExpression)node));
            fixes.add(this.createJSVariableIntentionAction(referenceName, false, false, false));
            TypeScriptReferenceChecker.addCreateParameterFix(node.getParent(), fixes, referenceName);
            return false;
        }
        if (node.getQualifier() == null && resolveResults.length == 0) {
            fixes.add(JSFixFactory.getInstance().typeScriptAddImportStatementFix(node.getReferenceName(), (PsiElement)node));
        }
        return super.addCreateFromUsageFixes(node, resolveResults, fixes, inTypeContext, ecma);
    }

    @Override
    protected void addSurroundWithTypeGuardFix(@NotNull JSExpression qualifier, @NotNull List<LocalQuickFix> fixes, @NotNull String name) {
        if (qualifier == null) {
            TypeScriptReferenceChecker.$$$reportNull$$$0(5);
        }
        if (fixes == null) {
            TypeScriptReferenceChecker.$$$reportNull$$$0(6);
        }
        if (name == null) {
            TypeScriptReferenceChecker.$$$reportNull$$$0(7);
        }
        TypeScriptTypeGuardFixHelper.addTypeGuardFixes(qualifier, fixes, name);
    }

    @Override
    protected void modifyUnresolvedErrorMessage(@NotNull Ref<String> message, @NotNull ResolveResult[] results, @Nullable JSExpression qualifier, @NotNull JSReferenceExpression node, boolean inTypeContext) {
        JSType type;
        JSTypeCastUtil.NullableState nullableState;
        if (message == null) {
            TypeScriptReferenceChecker.$$$reportNull$$$0(8);
        }
        if (results == null) {
            TypeScriptReferenceChecker.$$$reportNull$$$0(9);
        }
        if (node == null) {
            TypeScriptReferenceChecker.$$$reportNull$$$0(10);
        }
        if (results.length == 0 && !inTypeContext && qualifier != null && (nullableState = JSTypeCastUtil.getNullableState(type = JSResolveUtil.getExpressionJSType(qualifier), true)) != JSTypeCastUtil.NullableState.NOT_NULLABLE) {
            JSType typeWithoutNull = JSCompositeTypeImpl.optimizeTypeIfComposite(type, true, JSCompositeTypeImpl.OptimizedKind.OPTIMIZED_REMOVED_NULL_UNDEFINED);
            String referenceName = node.getReferenceName();
            if (typeWithoutNull != type && typeWithoutNull.asRecordType().hasProperty(referenceName)) {
                if (nullableState == JSTypeCastUtil.NullableState.HAS_NULL_AND_UNDEFINED) {
                    message.set((Object)JSBundle.message((String)"javascript.unresolved.variable.null.or.undefined.qualifier.message", (Object[])new Object[]{referenceName}));
                } else if (nullableState == JSTypeCastUtil.NullableState.HAS_NULL) {
                    message.set((Object)JSBundle.message((String)"javascript.unresolved.variable.null.qualifier.message", (Object[])new Object[]{referenceName}));
                } else {
                    message.set((Object)JSBundle.message((String)"javascript.unresolved.variable.undefined.qualifier.message", (Object[])new Object[]{referenceName}));
                }
            }
        }
    }

    @Override
    @Nullable
    public ProblemHighlightType getUnresolvedReferenceHighlightType(@NotNull JSReferenceExpression node) {
        JSExpression qualifier;
        if (node == null) {
            TypeScriptReferenceChecker.$$$reportNull$$$0(11);
        }
        if (node instanceof TypeScriptEntityName && (qualifier = node.getQualifier()) instanceof TypeScriptEntityName && this.isErrorReported((JSReferenceExpression)qualifier)) {
            return ProblemHighlightType.INFORMATION;
        }
        if (TypeScriptUtil.resolveIsStrict(node)) {
            return ProblemHighlightType.ERROR;
        }
        return super.getUnresolvedReferenceHighlightType(node);
    }

    @Override
    protected void addFixesForDistinctResolveProblem(JSReferenceExpression node, List<LocalQuickFix> fixes, String resolveProblemKey, PsiElement element) {
        if (resolveProblemKey == "javascript.element.need.to.be.included.to.config") {
            fixes.addAll(JSFixFactory.getInstance().typeScriptConfigFixes((JSElement)node, element));
        }
        if ((resolveProblemKey == "javascript.element.is.not.accessible.message" || resolveProblemKey == "javascript.element.need.to.be.exported") && element instanceof TypeScriptImportStatement && node.getQualifier() == null) {
            fixes.add(JSFixFactory.getInstance().typeScriptAddImportStatementFix(node.getReferenceName(), (PsiElement)node));
        }
        super.addFixesForDistinctResolveProblem(node, fixes, resolveProblemKey, element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 1: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResults";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFixes";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/validation/TypeScriptReferenceChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addCreateFromUsageFixesForCall";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "addSurroundWithTypeGuardFix";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "modifyUnresolvedErrorMessage";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getUnresolvedReferenceHighlightType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

