/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.javascript.validation.HighlightSeverityHolder;
import com.intellij.lang.javascript.validation.JSReferenceInspectionProblemReporter;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSReferenceInspectionProblemReporterAdapter
implements JSReferenceInspectionProblemReporter {
    @NotNull
    protected final ProblemsHolder myHolder;

    public JSReferenceInspectionProblemReporterAdapter(@NotNull ProblemsHolder holder) {
        if (holder == null) {
            JSReferenceInspectionProblemReporterAdapter.$$$reportNull$$$0(0);
        }
        this.myHolder = holder;
    }

    @Override
    public void reportAccessibilityError(@NotNull PsiElement identifier, ProblemHighlightType highlightType, String message, @NotNull List<LocalQuickFix> fixes) {
        if (identifier == null) {
            JSReferenceInspectionProblemReporterAdapter.$$$reportNull$$$0(1);
        }
        if (fixes == null) {
            JSReferenceInspectionProblemReporterAdapter.$$$reportNull$$$0(2);
        }
    }

    @Override
    public void reportUnresolvedFunctionError(@NotNull PsiElement referenceNameElement, @Nullable ProblemHighlightType problemHighlightType, @NotNull String message, @Nullable List<LocalQuickFix> quickFixes) {
        if (referenceNameElement == null) {
            JSReferenceInspectionProblemReporterAdapter.$$$reportNull$$$0(3);
        }
        if (message == null) {
            JSReferenceInspectionProblemReporterAdapter.$$$reportNull$$$0(4);
        }
    }

    @Override
    public void reportUnresolvedVariableError(@NotNull PsiElement referenceNameElement, @Nullable ProblemHighlightType problemHighlightType, @NotNull String message, @Nullable List<LocalQuickFix> quickFixes) {
        if (referenceNameElement == null) {
            JSReferenceInspectionProblemReporterAdapter.$$$reportNull$$$0(5);
        }
        if (message == null) {
            JSReferenceInspectionProblemReporterAdapter.$$$reportNull$$$0(6);
        }
    }

    protected void reportUnresolvedRefProblem(@Nullable ProblemHighlightType highlightType, @Nullable List<LocalQuickFix> quickFixes, @NotNull PsiElement referenceNameElement, @NotNull String message) {
        if (referenceNameElement == null) {
            JSReferenceInspectionProblemReporterAdapter.$$$reportNull$$$0(7);
        }
        if (message == null) {
            JSReferenceInspectionProblemReporterAdapter.$$$reportNull$$$0(8);
        }
        if (highlightType == null && referenceNameElement instanceof HighlightSeverityHolder) {
            highlightType = HighlightInfo.convertSeverityToProblemHighlight((HighlightSeverity)((HighlightSeverityHolder)referenceNameElement).getUnresolvedReferenceSeverity());
        }
        if (highlightType == null) {
            highlightType = ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
        }
        LocalQuickFix[] fixes = this.registerFixes(referenceNameElement, quickFixes);
        this.myHolder.registerProblem(referenceNameElement, message, highlightType, null, fixes);
    }

    @NotNull
    protected LocalQuickFix[] registerFixes(@NotNull PsiElement referenceNameElement, @Nullable List<LocalQuickFix> quickFixes) {
        if (referenceNameElement == null) {
            JSReferenceInspectionProblemReporterAdapter.$$$reportNull$$$0(9);
        }
        LocalQuickFix[] fixes = quickFixes != null ? quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY) : LocalQuickFix.EMPTY_ARRAY;
        JSReferenceInspectionProblemReporterAdapter.registerFixes(referenceNameElement, fixes);
        if (fixes == null) {
            JSReferenceInspectionProblemReporterAdapter.$$$reportNull$$$0(10);
        }
        return fixes;
    }

    public static void registerFixes(@NotNull PsiElement referenceNameElement, LocalQuickFix[] fixes) {
        if (referenceNameElement == null) {
            JSReferenceInspectionProblemReporterAdapter.$$$reportNull$$$0(11);
        }
        SmartPsiElementPointer pointer = null;
        for (LocalQuickFix l : fixes) {
            if (!(l instanceof FixAndIntentionAction)) continue;
            pointer = ((FixAndIntentionAction)l).registerElementRefForFix(referenceNameElement, pointer);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceNameElement";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/JSReferenceInspectionProblemReporterAdapter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/JSReferenceInspectionProblemReporterAdapter";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "registerFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "reportAccessibilityError";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "reportUnresolvedFunctionError";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "reportUnresolvedVariableError";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "reportUnresolvedRefProblem";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "registerFixes";
                break;
            }
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

