/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6NamespaceImportExport;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionProperty;
import com.intellij.lang.javascript.psi.JSGeneratorExpression;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public class JSKeywordHighlighterVisitor
extends JSRecursiveWalkingElementVisitor {
    @NotNull
    protected final AnnotationHolder myHolder;
    @NotNull
    protected final JSHighlighter myHighlighter;

    public JSKeywordHighlighterVisitor(@NotNull AnnotationHolder holder) {
        if (holder == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(0);
        }
        this(holder, new JSHighlighter(JavascriptLanguage.DIALECT_OPTION_HOLDER));
    }

    protected JSKeywordHighlighterVisitor(@NotNull AnnotationHolder holder, @NotNull JSHighlighter highlighter) {
        if (holder == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(1);
        }
        if (highlighter == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(2);
        }
        this.myHolder = holder;
        this.myHighlighter = highlighter;
    }

    public void visitJSGeneratorExpression(JSGeneratorExpression element) {
        this.highlightChildKeywordOfType((PsiElement)element, JSTokenTypes.EACH_KEYWORD);
        super.visitJSGeneratorExpression(element);
    }

    public void visitJSForInStatement(JSForInStatement element) {
        this.highlightChildKeywordOfType((PsiElement)element, JSTokenTypes.EACH_KEYWORD);
        super.visitJSForInStatement(element);
    }

    public void visitJSFunctionExpression(@NotNull JSFunctionExpression function) {
        if (function == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(3);
        }
        this.highlightKeywordGetterAndSetter((JSFunction)function);
        super.visitJSFunctionExpression(function);
    }

    public void visitJSFunctionProperty(JSFunctionProperty function) {
        this.highlightKeywordGetterAndSetter((JSFunction)function);
        super.visitJSFunctionProperty(function);
    }

    public void visitJSFunctionDeclaration(@NotNull JSFunction function) {
        if (function == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(4);
        }
        this.highlightKeywordGetterAndSetter(function);
        super.visitJSFunctionDeclaration(function);
    }

    public void visitES6FromClause(ES6FromClause element) {
        this.highlightChildKeywordOfType((PsiElement)element, JSTokenTypes.FROM_KEYWORD);
        super.visitES6FromClause(element);
    }

    public void visitES6NamespaceImportExport(ES6NamespaceImportExport element) {
        this.highlightChildKeywordOfType((PsiElement)element, JSTokenTypes.AS_KEYWORD);
        super.visitES6NamespaceImportExport(element);
    }

    public void visitES6ImportSpecifierAlias(ES6ImportSpecifierAlias specifierAlias) {
        this.highlightChildKeywordOfType((PsiElement)specifierAlias, JSTokenTypes.AS_KEYWORD);
        super.visitES6ImportSpecifierAlias(specifierAlias);
    }

    protected void highlightKeywordGetterAndSetter(@NotNull JSFunction function) {
        PsiElement nameIdentifier;
        if (function == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(5);
        }
        if ((nameIdentifier = function.getNameIdentifier()) == null) {
            return;
        }
        JSAttributeList list = function.getAttributeList();
        if (list != null) {
            PsiElement element = list.findModifierElement(JSAttributeList.ModifierType.GET);
            if (element != null) {
                JSKeywordHighlighterVisitor.highlightKeyword(element.getNode(), this.myHolder, this.myHighlighter);
                return;
            }
            element = list.findModifierElement(JSAttributeList.ModifierType.SET);
            if (element != null) {
                JSKeywordHighlighterVisitor.highlightKeyword(element.getNode(), this.myHolder, this.myHighlighter);
            }
        }
    }

    public static void highlightKeyword(@NotNull ASTNode keyword, @NotNull AnnotationHolder holder, JSHighlighter highlighter) {
        if (keyword == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(6);
        }
        if (holder == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(7);
        }
        Annotation anno = holder.createAnnotation(HighlightInfoType.SYMBOL_TYPE_SEVERITY, keyword.getTextRange(), null);
        anno.setTextAttributes(highlighter.getMappedKey(JSHighlighter.JS_KEYWORD));
    }

    protected void highlightChildKeywordOfTypes(@NotNull PsiElement parent, @NotNull TokenSet types) {
        ASTNode keyword;
        if (parent == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(8);
        }
        if (types == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(9);
        }
        if ((keyword = parent.getNode().findChildByType(types)) != null) {
            JSKeywordHighlighterVisitor.highlightKeyword(keyword, this.myHolder, this.myHighlighter);
        }
    }

    protected void highlightChildKeywordOfType(@NotNull PsiElement parent, @NotNull IElementType type) {
        ASTNode keyword;
        if (parent == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(10);
        }
        if (type == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(11);
        }
        if ((keyword = parent.getNode().findChildByType(type)) != null) {
            JSKeywordHighlighterVisitor.highlightKeyword(keyword, this.myHolder, this.myHighlighter);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyword";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/validation/JSKeywordHighlighterVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSFunctionExpression";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSFunctionDeclaration";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightKeywordGetterAndSetter";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightKeyword";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightChildKeywordOfTypes";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightChildKeywordOfType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

