/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.surroundWith;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.surroundWith.JSStatementSurrounder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSWithIfSurrounder
extends JSStatementSurrounder {
    private boolean processingCondition;

    public String getTemplateDescription() {
        return JSBundle.message((String)"javascript.surround.with.if", (Object[])new Object[0]);
    }

    @Override
    @Nullable
    public TextRange surroundElements(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement[] elements) throws IncorrectOperationException {
        if (project == null) {
            JSWithIfSurrounder.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            JSWithIfSurrounder.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            JSWithIfSurrounder.$$$reportNull$$$0(2);
        }
        this.setProcessCondition(elements[0]);
        return super.surroundElements(project, editor, elements);
    }

    @Override
    @NonNls
    protected String getStatementTemplate(Project project, PsiElement context) {
        return this.willWrapExpression() ? this.getStatementTemplateWhenWrappingBody() : this.getStatementTemplateWhenWrappingCondition();
    }

    private void setProcessCondition(PsiElement context) {
        if (context instanceof JSExpression && JSResolveUtil.getExpressionJSType((JSExpression)context) instanceof JSBooleanType) {
            this.processingCondition = true;
            return;
        }
        this.processingCondition = false;
    }

    protected String getStatementTemplateWhenWrappingBody() {
        return "if(a) { }";
    }

    protected String getStatementTemplateWhenWrappingCondition() {
        return "if() { a }";
    }

    @Override
    protected ASTNode getInsertBeforeNode(ASTNode statementNode) {
        JSIfStatement stmt = (JSIfStatement)statementNode.getPsi();
        return this.willWrapExpression() ? stmt.getThen().getNode().getLastChildNode() : stmt.getNode().findChildByType(JSTokenTypes.RPAR);
    }

    @Override
    protected TextRange getSurroundSelectionRange(ASTNode statementNode) {
        int offset;
        JSIfStatement stmt = (JSIfStatement)statementNode.getPsi();
        if (this.willWrapExpression()) {
            ASTNode conditionNode = stmt.getCondition().getNode();
            offset = conditionNode.getStartOffset();
            stmt.getNode().removeChild(conditionNode);
        } else {
            Document document = stmt.getContainingFile().getViewProvider().getDocument();
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)stmt.getContainingFile().getProject());
            assert (document != null);
            documentManager.doPostponedOperationsAndUnblockDocument(document);
            PsiElement element = PsiTreeUtil.getChildOfType((PsiElement)stmt.getThen(), JSExpressionStatement.class);
            assert (element != null);
            offset = element.getTextOffset();
            ASTNode astNode = element.getNode();
            astNode.getTreeParent().removeChild(astNode);
        }
        return new TextRange(offset, offset);
    }

    @Override
    protected ASTNode cleanup(ASTNode node) {
        if (!this.willWrapExpression()) {
            ASTNode parent;
            ASTNode errorNode = node.findChildByType(TokenType.ERROR_ELEMENT);
            if (errorNode != null) {
                node.removeChild(errorNode);
            }
            if ((parent = node.getTreeParent()).getElementType() == JSElementTypes.EXPRESSION_STATEMENT) {
                ASTNode grandParent = parent.getTreeParent();
                ASTNode newNode = node.copyElement();
                grandParent.replaceChild(parent, newNode);
                return newNode;
            }
        }
        return node;
    }

    @Override
    protected boolean willWrapExpression() {
        return !this.processingCondition;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "elements";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/surroundWith/JSWithIfSurrounder";
        objectArray[2] = "surroundElements";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

