/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.google.gson.Gson;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.service.JSLanguageServiceCacheableCommand;
import com.intellij.lang.javascript.service.JSLanguageServiceCacheableCommandProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceCommandProcessor;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.util.Consumer;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface JSLanguageServiceQueue
extends Disposable {
    public static final Logger LOGGER = Logger.getInstance((String)"#com.intellij.lang.javascript.service.JSLanguageServiceQueue");
    public static final Gson GSON = new Gson();
    public static final Key<Boolean> GENERATED_FILE_MARKER = new Key("JS.Language.External.Compiler.Generated.File");
    public static final String DEFAULT_NAME = "Language";
    public static final ServiceInfoReporter DEFAULT_REPORTER = new ServiceInfoReporter(){

        @Override
        @NotNull
        public String getServiceName() {
            if (JSLanguageServiceQueue.DEFAULT_NAME == null) {
                1.$$$reportNull$$$0(0);
            }
            return JSLanguageServiceQueue.DEFAULT_NAME;
        }

        @Override
        public void logError(@NotNull String error) {
            if (error == null) {
                1.$$$reportNull$$$0(1);
            }
            LOGGER.info(this.getServiceName() + ": " + error);
        }

        @Override
        public void logCurrentErrors(@NotNull List<JSAnnotationError> results) {
            if (results == null) {
                1.$$$reportNull$$$0(2);
            }
        }

        @Override
        public void setProcess(@Nullable String text) {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/service/JSLanguageServiceQueue$1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "error";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "results";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getServiceName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/service/JSLanguageServiceQueue$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "logError";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "logCurrentErrors";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };

    public String getStartErrorMessage();

    @NotNull
    public State getState();

    public void resetCaches();

    public boolean isValid();

    @Nullable
    public <T> CompletableFuture<T> executeWithCache(@NotNull JSLanguageServiceCacheableCommand var1, @NotNull JSLanguageServiceCacheableCommandProcessor<T> var2);

    public <T> CompletableFuture<T> execute(@NotNull JSLanguageServiceCommand var1, @NotNull JSLanguageServiceCommandProcessor<T> var2);

    public void executeNoBlocking(@NotNull JSLanguageServiceCommand var1, @Nullable Consumer<JSLanguageServiceAnswer> var2, @Nullable Consumer<JSLanguageServiceObject> var3);

    public void executeNoBlocking(@NotNull JSLanguageServiceCommand var1, @Nullable Consumer<JSLanguageServiceAnswer> var2);

    public static interface ServiceInfoReporter {
        @NotNull
        public String getServiceName();

        public void logError(@NotNull String var1);

        public void setProcess(@Nullable String var1);

        public void logCurrentErrors(@NotNull List<JSAnnotationError> var1);
    }

    public static interface ProcessConnector {
        public void connectToProcessHandler(@NotNull ProcessHandler var1);

        public void disconnectFromProcessHandler(boolean var1);

        public boolean isConnected();
    }

    public static enum State {
        STARTING,
        STARTED,
        ERROR_OR_TIMEOUT,
        DISPOSED;

    }
}

