/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.search;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSSymbolIndex2;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.search.JSClassSearch;
import com.intellij.lang.javascript.search.JSMembersSearch;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.AbstractQuery;
import com.intellij.util.InstanceofQuery;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class JSDefinitionsSearchExecutor
implements QueryExecutor<PsiElement, PsiElement> {
    public boolean execute(@NotNull PsiElement _sourceElement, @NotNull Processor<PsiElement> consumer) {
        if (_sourceElement == null) {
            JSDefinitionsSearchExecutor.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            JSDefinitionsSearchExecutor.$$$reportNull$$$0(1);
        }
        return (Boolean)ReadAction.compute(() -> {
            if (_sourceElement == null) {
                JSDefinitionsSearchExecutor.$$$reportNull$$$0(14);
            }
            if (consumer == null) {
                JSDefinitionsSearchExecutor.$$$reportNull$$$0(15);
            }
            return JSDefinitionsSearchExecutor.doExecute(_sourceElement, consumer);
        });
    }

    @NotNull
    public static <T extends PsiElement> Query<T> query(final @NotNull PsiElement sourceElement, @NotNull Class<T> elementClass) {
        if (sourceElement == null) {
            JSDefinitionsSearchExecutor.$$$reportNull$$$0(2);
        }
        if (elementClass == null) {
            JSDefinitionsSearchExecutor.$$$reportNull$$$0(3);
        }
        InstanceofQuery instanceofQuery = new InstanceofQuery((Query)new AbstractQuery<PsiElement>(){

            protected boolean processResults(@NotNull Processor<PsiElement> consumer) {
                if (consumer == null) {
                    1.$$$reportNull$$$0(0);
                }
                return JSDefinitionsSearchExecutor.doExecute(sourceElement, (Processor<PsiElement>)consumer);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/javascript/search/JSDefinitionsSearchExecutor$1", "processResults"));
            }
        }, new Class[]{elementClass});
        if (instanceofQuery == null) {
            JSDefinitionsSearchExecutor.$$$reportNull$$$0(4);
        }
        return instanceofQuery;
    }

    private static boolean doExecute(@NotNull PsiElement sourceElement, @NotNull Processor<PsiElement> consumer) {
        if (sourceElement == null) {
            JSDefinitionsSearchExecutor.$$$reportNull$$$0(5);
        }
        if (consumer == null) {
            JSDefinitionsSearchExecutor.$$$reportNull$$$0(6);
        }
        if (!JSDefinitionsSearchExecutor.isJSDerivedLanguage(sourceElement)) {
            return true;
        }
        if (sourceElement instanceof PsiNamedElement) {
            if (sourceElement instanceof JSClass) {
                JSClass clazz = (JSClass)sourceElement;
                Processor delegatingProcessor = jsClass -> {
                    if (consumer == null) {
                        JSDefinitionsSearchExecutor.$$$reportNull$$$0(13);
                    }
                    JSClass e = jsClass instanceof XmlBackedJSClass ? jsClass : jsClass.getNavigationElement();
                    return consumer.process((Object)e);
                };
                JSClassSearch.searchClassInheritors(clazz, true).forEach(delegatingProcessor);
                if (clazz.isInterface()) {
                    JSClassSearch.searchInterfaceImplementations(clazz, true).forEach(delegatingProcessor);
                }
                if (DialectDetector.isJavaScript((PsiElement)clazz)) {
                    JSDefinitionsSearchExecutor.findJSImplementations((JSPsiElementBase)clazz, consumer);
                }
            } else if (sourceElement instanceof JSPsiElementBase && sourceElement instanceof JSAttributeListOwner && JSInheritanceUtil.canBeSuperMember((JSAttributeListOwner)sourceElement)) {
                JSPsiElementBase baseMember = (JSPsiElementBase)sourceElement;
                Processor delegatingProcessor = member -> {
                    if (consumer == null) {
                        JSDefinitionsSearchExecutor.$$$reportNull$$$0(12);
                    }
                    return consumer.process((Object)member.getNavigationElement());
                };
                JSMembersSearch.searchOverridingMembers(baseMember, true).forEach(delegatingProcessor);
                JSClass parent = JSUtils.getMemberContainingClass(sourceElement);
                if (parent != null && JSClassUtils.isAllowImplementation(parent, sourceElement)) {
                    JSMembersSearch.searchImplementingMembers(baseMember, true).forEach(delegatingProcessor);
                }
                if (DialectDetector.isJavaScript(sourceElement)) {
                    JSDefinitionsSearchExecutor.findJSImplementations((JSPsiElementBase)sourceElement, consumer);
                }
            } else if ((!(sourceElement instanceof JSFunction) || ((JSFunction)sourceElement).isConstructor()) && sourceElement instanceof JSPsiElementBase && DialectDetector.isJavaScript(sourceElement) && JSUtils.getMemberContainingClass(sourceElement) == null) {
                JSDefinitionsSearchExecutor.findJSImplementations((JSPsiElementBase)sourceElement, consumer);
            }
        }
        if (sourceElement instanceof TypeScriptTypeMember) {
            JSDefinitionsSearchExecutor.processAnonymousImplementations((TypeScriptTypeMember)sourceElement, consumer);
        }
        if (DialectDetector.isActionScript(sourceElement) && JSDefinitionsSearchExecutor.isStaticVariableWithInitializer(sourceElement)) {
            ReferencesSearch.search((PsiElement)sourceElement).forEach(psiReference -> {
                JSExpression[] arguments;
                JSExpression methodExpression;
                PsiElement grandParent;
                PsiElement elt;
                PsiElement parent;
                if (consumer == null) {
                    JSDefinitionsSearchExecutor.$$$reportNull$$$0(11);
                }
                if ((parent = (elt = psiReference.getElement()).getParent()) instanceof JSArgumentList && (grandParent = parent.getParent()) instanceof JSCallExpression && (methodExpression = ((JSCallExpression)grandParent).getMethodExpression()) instanceof JSReferenceExpression && "addEventListener".equals(((JSReferenceExpression)methodExpression).getReferenceName()) && (arguments = ((JSArgumentList)parent).getArguments())[0] == elt && arguments.length > 1) {
                    PsiElement resolve;
                    JSExpression argument = arguments[1];
                    if (argument instanceof JSReferenceExpression && (resolve = ((JSReferenceExpression)argument).resolve()) instanceof JSFunction) {
                        argument = resolve;
                    }
                    if (argument instanceof JSFunction) {
                        return consumer.process((Object)argument);
                    }
                }
                return true;
            });
        }
        return true;
    }

    private static void findJSImplementations(@NotNull JSPsiElementBase sourceElement, @NotNull Processor<PsiElement> consumer) {
        if (sourceElement == null) {
            JSDefinitionsSearchExecutor.$$$reportNull$$$0(7);
        }
        if (consumer == null) {
            JSDefinitionsSearchExecutor.$$$reportNull$$$0(8);
        }
        JSResolveUtil.findOverridingFunctionsByNamespaces(sourceElement).forEach(arg_0 -> consumer.process(arg_0));
    }

    private static void processAnonymousImplementations(@NotNull TypeScriptTypeMember element, @NotNull Processor<PsiElement> consumer) {
        if (element == null) {
            JSDefinitionsSearchExecutor.$$$reportNull$$$0(9);
        }
        if (consumer == null) {
            JSDefinitionsSearchExecutor.$$$reportNull$$$0(10);
        }
        if (StringUtil.isEmpty((String)element.getName())) {
            return;
        }
        GlobalSearchScope searchScope = GlobalSearchScopeUtil.toGlobalSearchScope((SearchScope)element.getUseScope(), (Project)element.getProject());
        HashSet candidates = ContainerUtil.newHashSet();
        Processor processor = e -> {
            if (e instanceof JSProperty && DialectDetector.isTypeScript((PsiElement)e)) {
                candidates.add((JSProperty)e);
            }
            return true;
        };
        StubIndex.getInstance().processElements(JSSymbolIndex2.KEY, (Object)element.getName(), element.getProject(), searchScope, JSElement.class, processor);
        for (JSProperty candidate : candidates) {
            PsiPolyVariantReference reference = candidate.getPropertyNameReference();
            if (reference == null || !reference.isReferenceTo((PsiElement)element)) continue;
            consumer.process((Object)candidate);
        }
    }

    private static boolean isStaticVariableWithInitializer(PsiElement _sourceElement) {
        return _sourceElement instanceof JSVariable && JSDefinitionsSearchExecutor.isStatic((JSVariable)_sourceElement) && ((JSVariable)_sourceElement).hasInitializer();
    }

    private static boolean isStatic(JSVariable _sourceElement) {
        JSAttributeList attrList = _sourceElement.getAttributeList();
        return attrList != null && attrList.hasModifier(JSAttributeList.ModifierType.STATIC);
    }

    private static boolean isJSDerivedLanguage(PsiElement _sourceElement) {
        return _sourceElement.getLanguage().isKindOf(Language.findInstance(JavascriptLanguage.class));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_sourceElement";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/search/JSDefinitionsSearchExecutor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/search/JSDefinitionsSearchExecutor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "query";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "query";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doExecute";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findJSImplementations";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processAnonymousImplementations";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doExecute$3";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doExecute$2";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doExecute$1";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$execute$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

