/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.rename;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSRenameWrongRefHandler
implements RenameHandler {
    @NonNls
    private static final String INPUT_VARIABLE_NAME = "INPUTVAR";
    @NonNls
    private static final String OTHER_VARIABLE_NAME = "OTHERVAR";

    public final boolean isAvailableOnDataContext(DataContext dataContext) {
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiFile file2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (editor == null || file2 == null || project == null) {
            return false;
        }
        return JSRenameWrongRefHandler.isAvailable(editor);
    }

    private static boolean isAvailable(Editor editor) {
        ResolveResult[] results;
        PsiReference reference = TargetElementUtil.findReference((Editor)editor);
        if (!(reference instanceof JSReferenceExpression)) {
            return false;
        }
        for (ResolveResult result2 : results = ((JSReferenceExpression)reference).multiResolve(true)) {
            if (!result2.isValidResult()) continue;
            return false;
        }
        return true;
    }

    public final boolean isRenaming(DataContext dataContext) {
        return this.isAvailableOnDataContext(dataContext);
    }

    public void invoke(final @NotNull Project project, final Editor editor, final PsiFile file2, @Nullable DataContext dataContext) {
        PsiReference reference;
        JSReferenceExpression refExpr;
        if (project == null) {
            JSRenameWrongRefHandler.$$$reportNull$$$0(0);
        }
        if ((refExpr = JSPsiImplUtils.findReferenceOfClass(reference = TargetElementUtil.findReference((Editor)editor), JSReferenceExpression.class)) == null) {
            Logger.getInstance(JSRenameWrongRefHandler.class).error("JSReferenceExpression was not found");
            return;
        }
        new WriteCommandAction(project, new PsiFile[0]){

            protected void run(@NotNull Result result2) throws Throwable {
                if (result2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
                    return;
                }
                PsiElement scope = PsiTreeUtil.getParentOfType((PsiElement)refExpr, (Class[])new Class[]{JSFunction.class, JSFile.class, JSEmbeddedContent.class});
                if (scope == null) {
                    return;
                }
                ArrayList declarations = new ArrayList();
                JSReferenceExpression[] refs = JSRenameWrongRefHandler.collectSimilarReferencesAndDeclarations(refExpr, scope, declarations);
                Expression expression = JSRenameWrongRefHandler.createExpression(refExpr.getReferenceName(), JSRenameWrongRefHandler.filterDeclarations(refExpr, declarations));
                TemplateBuilderImpl builder = new TemplateBuilderImpl(scope);
                for (JSReferenceExpression expr : refs) {
                    if (!expr.equals(refExpr)) {
                        builder.replaceElement(expr.getReferenceNameElement(), JSRenameWrongRefHandler.OTHER_VARIABLE_NAME, JSRenameWrongRefHandler.INPUT_VARIABLE_NAME, false);
                        continue;
                    }
                    builder.replaceElement(expr.getReferenceNameElement(), JSRenameWrongRefHandler.INPUT_VARIABLE_NAME, expression, true);
                }
                float proportion = EditorUtil.calcVerticalScrollProportion((Editor)editor);
                editor.getCaretModel().moveToOffset(scope.getTextRange().getStartOffset());
                Template template = builder.buildInlineTemplate();
                editor.getCaretModel().moveToOffset(scope.getTextRange().getStartOffset());
                TemplateManager.getInstance((Project)project).startTemplate(editor, template);
                EditorUtil.setVerticalScrollProportion((Editor)editor, (float)proportion);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/refactoring/rename/JSRenameWrongRefHandler$1", "run"));
            }
        }.execute();
    }

    @NotNull
    private static List<JSNamedElement> filterDeclarations(@NotNull JSReferenceExpression expr, @NotNull List<JSNamedElement> declarations) {
        PsiElement parent;
        if (expr == null) {
            JSRenameWrongRefHandler.$$$reportNull$$$0(1);
        }
        if (declarations == null) {
            JSRenameWrongRefHandler.$$$reportNull$$$0(2);
        }
        boolean isTypeContext = (parent = JSResolveUtil.getTopReferenceParent((PsiElement)expr)) instanceof JSReferenceListMember || parent instanceof TypeScriptSingleType;
        JSClass contextClass = parent instanceof JSReferenceListMember ? (JSClass)PsiTreeUtil.getParentOfType((PsiElement)parent, JSClass.class) : null;
        List list = ContainerUtil.filter(declarations, element -> {
            if (isTypeContext) {
                if (element instanceof JSClass && element.getName() != null) {
                    boolean expectInterfaces;
                    boolean bl = expectInterfaces = contextClass != null && contextClass.isInterface();
                    if (contextClass != null && !expectInterfaces) {
                        JSReferenceList referenceList = (JSReferenceList)PsiTreeUtil.getParentOfType((PsiElement)parent, JSReferenceList.class);
                        assert (referenceList != null);
                        expectInterfaces = JSStubElementTypes.IMPLEMENTS_LIST.equals((Object)referenceList.getNode().getElementType());
                    }
                    return contextClass == null || contextClass != element && expectInterfaces == ((JSClass)element).isInterface();
                }
                return false;
            }
            return !(element instanceof JSClass);
        });
        if (list == null) {
            JSRenameWrongRefHandler.$$$reportNull$$$0(3);
        }
        return list;
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            JSRenameWrongRefHandler.$$$reportNull$$$0(4);
        }
        if (elements == null) {
            JSRenameWrongRefHandler.$$$reportNull$$$0(5);
        }
    }

    private static JSReferenceExpression[] collectSimilarReferencesAndDeclarations(final JSReferenceExpression ref, PsiElement scope, final List<JSNamedElement> declarations) {
        boolean isQualified;
        final String refName = ref.getReferenceName();
        final ArrayList<JSReferenceExpression> similarRefs = new ArrayList<JSReferenceExpression>();
        similarRefs.add(ref);
        boolean bl = isQualified = ref.getQualifier() != null;
        if (refName != null) {
            JSRecursiveElementVisitor visitor = new JSRecursiveElementVisitor(){

                public void visitJSReferenceExpression(JSReferenceExpression node) {
                    if (node == ref || !isQualified && node.getQualifier() == null && refName.equals(node.getReferenceName())) {
                        similarRefs.add(node);
                    }
                    if (node.getFirstChild() instanceof JSReferenceExpression) {
                        this.visitJSReferenceExpression((JSReferenceExpression)node.getFirstChild());
                    }
                }

                public void visitJSFunctionDeclaration(JSFunction node) {
                    declarations.add(node);
                    PsiElement identifier = node.getNameIdentifier();
                    if (identifier instanceof JSReferenceExpression) {
                        this.visitJSReferenceExpression((JSReferenceExpression)identifier);
                    }
                }

                public void visitJSFunctionExpression(JSFunctionExpression node) {
                    declarations.add(node);
                }

                public void visitJSVariable(JSVariable node) {
                    declarations.add(node);
                    super.visitJSVariable(node);
                }

                public void visitJSClass(JSClass aClass) {
                    declarations.add(aClass);
                    super.visitJSClass(aClass);
                }

                public void visitJSDefinitionExpression(JSDefinitionExpression node) {
                    declarations.add(node);
                    super.visitJSDefinitionExpression(node);
                }
            };
            visitor.visitElement(scope);
        }
        return similarRefs.toArray(new JSReferenceExpression[0]);
    }

    private static Expression createExpression(final String oldRefName, List<JSNamedElement> declarations) {
        ArrayList<LookupElementBuilder> itemsList = new ArrayList<LookupElementBuilder>(declarations.size());
        for (JSNamedElement declaration : declarations) {
            String name = declaration.getName();
            if (name == null) continue;
            itemsList.add(LookupElementBuilder.create((String)name));
        }
        final LookupElement[] myItems = new LookupElement[itemsList.size()];
        itemsList.toArray(myItems);
        return new Expression(){

            public com.intellij.codeInsight.template.Result calculateResult(ExpressionContext context) {
                return new TextResult(oldRefName);
            }

            public com.intellij.codeInsight.template.Result calculateQuickResult(ExpressionContext context) {
                return null;
            }

            public LookupElement[] calculateLookupItems(ExpressionContext context) {
                return myItems;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarations";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/rename/JSRenameWrongRefHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/rename/JSRenameWrongRefHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "filterDeclarations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "filterDeclarations";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

