/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.memberPullUp;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.refactoring.BaseJSRefactoringHandler;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.refactoring.memberPullUp.JSPullUpConflictsUtil;
import com.intellij.lang.javascript.refactoring.memberPullUp.JSPullUpDialog;
import com.intellij.lang.javascript.refactoring.memberPullUp.JSPullUpHelper;
import com.intellij.lang.javascript.refactoring.memberPullUp.JSPullUpParameters;
import com.intellij.lang.javascript.refactoring.util.JSInterfaceContainmentVerifier;
import com.intellij.lang.javascript.refactoring.util.JSMemberInfo;
import com.intellij.lang.javascript.refactoring.util.JSMemberInfoStorage;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.ui.JSFormatUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JSPullUpHandler
extends BaseJSRefactoringHandler
implements JSPullUpDialog.Validator {
    private static final Logger LOG = Logger.getInstance((String)JSPullUpHandler.class.getName());
    private final UICallback myUiCallback;
    private static final UICallback DEFAULT_UI_CALLBACK = JSPullUpHandler::showDialog;
    public static final String REFACTORING_NAME = RefactoringBundle.message((String)"pull.members.up.title");
    private static final String CANNOT_REFACTOR_REASON = RefactoringBundle.message((String)"the.caret.should.be.positioned.inside.a.class.to.pull.members.from");

    public JSPullUpHandler(@NotNull UICallback uiCallback) {
        if (uiCallback == null) {
            JSPullUpHandler.$$$reportNull$$$0(0);
        }
        super(REFACTORING_NAME, CANNOT_REFACTOR_REASON);
        this.myUiCallback = uiCallback;
    }

    public JSPullUpHandler() {
        super(REFACTORING_NAME, CANNOT_REFACTOR_REASON);
        this.myUiCallback = DEFAULT_UI_CALLBACK;
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            JSPullUpHandler.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            JSPullUpHandler.$$$reportNull$$$0(2);
        }
        if (elements.length != 1) {
            return;
        }
        PsiElement element = elements[0];
        Editor editor = dataContext != null ? (Editor)CommonDataKeys.EDITOR.getData(dataContext) : null;
        JSClass aClass = JSPullUpHandler.getClass(element);
        if (aClass == null) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)CANNOT_REFACTOR_REASON);
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, null);
            return;
        }
        ArrayList<JSClass> bases = new ArrayList<JSClass>(JSInheritanceUtil.findAllParentsForClass(aClass, false));
        if (bases.isEmpty()) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"class.does.not.have.base.classes.interfaces.in.current.project", (Object[])new Object[]{JSFormatUtil.formatClass(aClass, 2048)}));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, null);
            return;
        }
        Collections.sort(bases, Comparator.comparing(JSQualifiedNamedElement::getQualifiedName));
        JSMemberInfoStorage memberInfoStorage = new JSMemberInfoStorage(aClass, (MemberInfoBase.Filter<JSAttributeListOwner>)new MemberInfoBase.EmptyFilter());
        if (element instanceof JSElement) {
            for (JSMemberInfo memberInfo : memberInfoStorage.getClassMemberInfos((PsiElement)aClass)) {
                memberInfo.setChecked(Collections.singletonList((JSElement)element));
            }
        }
        this.myUiCallback.invoke(aClass, bases, memberInfoStorage, this, (Consumer<JSPullUpParameters>)((Consumer)JSPullUpHandler::doRefactoring));
    }

    private static void doRefactoring(JSPullUpParameters parameters) {
        WriteCommandAction.runWriteCommandAction((Project)parameters.subClass.getProject(), (String)REFACTORING_NAME, null, () -> {
            LocalHistoryAction a = LocalHistory.getInstance().startAction(JSPullUpHandler.getCommandName(parameters.subClass));
            try {
                try {
                    new JSPullUpHelper(parameters).moveMembersToBase();
                }
                finally {
                    a.finish();
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }, (PsiFile[])new PsiFile[0]);
    }

    private static String getCommandName(JSClass subClass) {
        return RefactoringBundle.message((String)"pullUp.command", (Object[])new Object[]{DescriptiveNameUtil.getDescriptiveName((PsiElement)subClass)});
    }

    @Override
    @NotNull
    public MultiMap<PsiElement, String> checkConflicts(JSPullUpParameters parameters, JSInterfaceContainmentVerifier interfaceContainmentVerifier) {
        if (!JSPullUpHandler.checkWritable(parameters.superClass, parameters.members)) {
            MultiMap multiMap = new MultiMap();
            if (multiMap == null) {
                JSPullUpHandler.$$$reportNull$$$0(3);
            }
            return multiMap;
        }
        MultiMap<PsiElement, String> multiMap = JSPullUpConflictsUtil.checkConflicts(parameters.members, parameters.subClass, parameters.superClass, interfaceContainmentVerifier, JSVisibilityUtil.DEFAULT_OPTIONS);
        if (multiMap == null) {
            JSPullUpHandler.$$$reportNull$$$0(4);
        }
        return multiMap;
    }

    private static boolean checkWritable(JSClass superClass, JSMemberInfo[] infos) {
        if (!JSRefactoringUtil.checkReadOnlyStatus((PsiElement)superClass, null, REFACTORING_NAME)) {
            return false;
        }
        for (JSMemberInfo info : infos) {
            if (info.getMember() instanceof JSClass && info.getOverrides() != null || JSRefactoringUtil.checkReadOnlyStatus(info.getMember(), null, REFACTORING_NAME)) continue;
            return false;
        }
        return true;
    }

    private static void showDialog(@NotNull JSClass subclass, @NotNull List<JSClass> superClasses, @NotNull JSMemberInfoStorage memberInfoStorage, @NotNull JSPullUpDialog.Validator validator, Consumer<JSPullUpParameters> parametersConsumer) {
        JSPullUpDialog dialog;
        if (subclass == null) {
            JSPullUpHandler.$$$reportNull$$$0(5);
        }
        if (superClasses == null) {
            JSPullUpHandler.$$$reportNull$$$0(6);
        }
        if (memberInfoStorage == null) {
            JSPullUpHandler.$$$reportNull$$$0(7);
        }
        if (validator == null) {
            JSPullUpHandler.$$$reportNull$$$0(8);
        }
        if (!(dialog = new JSPullUpDialog(subclass, superClasses, memberInfoStorage, validator)).showAndGet()) {
            return;
        }
        parametersConsumer.consume((Object)dialog.getParameters());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiCallback";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/memberPullUp/JSPullUpHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subclass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClasses";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberInfoStorage";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/memberPullUp/JSPullUpHandler";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "checkConflicts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "showDialog";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface UICallback {
        public void invoke(@NotNull JSClass var1, @NotNull List<JSClass> var2, @NotNull JSMemberInfoStorage var3, @NotNull JSPullUpDialog.Validator var4, @NotNull Consumer<JSPullUpParameters> var5);
    }
}

