/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.memberPullUp;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.refactoring.memberPullUp.JSPullUpHandler;
import com.intellij.lang.javascript.refactoring.memberPullUp.JSPullUpParameters;
import com.intellij.lang.javascript.refactoring.ui.JSClassCellRenderer;
import com.intellij.lang.javascript.refactoring.ui.JSMemberSelectionPanel;
import com.intellij.lang.javascript.refactoring.util.JSInterfaceContainmentVerifier;
import com.intellij.lang.javascript.refactoring.util.JSMemberInfo;
import com.intellij.lang.javascript.refactoring.util.JSMemberInfoStorage;
import com.intellij.lang.javascript.refactoring.util.JSUsesAndInterfacesDependencyMemberInfoModel;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.classMembers.MemberInfoChangeListener;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.ui.DocCommentPanel;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.ArrayFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSPullUpDialog
extends DialogWrapper {
    private final Validator myValidator;
    private JSMemberSelectionPanel myMemberSelectionPanel;
    private MyJSMemberInfoModel myMemberInfoModel;
    private final JSClass myClass;
    private final List<JSClass> mySuperClasses;
    private final JSMemberInfoStorage myMemberInfoStorage;
    private List<JSMemberInfo> myMemberInfos;
    @Nullable
    private DocCommentPanel myDocCommentPanel;
    private ComboBox<JSClass> myClassCombo;

    public JSPullUpDialog(@NotNull JSClass aClass, @NotNull List<JSClass> superClasses, @NotNull JSMemberInfoStorage memberInfoStorage, Validator validator) {
        if (aClass == null) {
            JSPullUpDialog.$$$reportNull$$$0(0);
        }
        if (superClasses == null) {
            JSPullUpDialog.$$$reportNull$$$0(1);
        }
        if (memberInfoStorage == null) {
            JSPullUpDialog.$$$reportNull$$$0(2);
        }
        super(aClass.getProject(), true);
        this.myClass = aClass;
        this.mySuperClasses = superClasses;
        this.myMemberInfoStorage = memberInfoStorage;
        this.myMemberInfos = new ArrayList<JSMemberInfo>(this.myMemberInfoStorage.getClassMemberInfos((PsiElement)aClass));
        JSMemberInfo.sortByOffset(this.myMemberInfos);
        this.myValidator = validator;
        this.setTitle(JSPullUpHandler.REFACTORING_NAME);
        this.init();
    }

    @NotNull
    public JSPullUpParameters getParameters() {
        JSPullUpParameters jSPullUpParameters = new JSPullUpParameters(this.getSubClass(), this.getSuperClass(), JSMemberInfo.getSelected(this.myMemberInfos, this.myClass, (Condition<JSMemberInfo>)((Condition)this.myMemberInfoModel::isMemberEnabled)), this.myDocCommentPanel != null ? this.myDocCommentPanel.getPolicy() : 2);
        if (jSPullUpParameters == null) {
            JSPullUpDialog.$$$reportNull$$$0(3);
        }
        return jSPullUpParameters;
    }

    @NotNull
    public JSClass getSubClass() {
        JSClass jSClass = this.myClass;
        if (jSClass == null) {
            JSPullUpDialog.$$$reportNull$$$0(4);
        }
        return jSClass;
    }

    @Nullable
    public JSClass getSuperClass() {
        if (this.myClassCombo != null) {
            return (JSClass)this.myClassCombo.getSelectedItem();
        }
        return null;
    }

    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = JBUI.insets((int)4, (int)8);
        gbConstraints.weighty = 1.0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridy = 0;
        gbConstraints.gridwidth = 0;
        gbConstraints.fill = 1;
        gbConstraints.anchor = 17;
        JLabel classComboLabel = new JLabel();
        panel.add((Component)classComboLabel, gbConstraints);
        this.myClassCombo = new ComboBox(ContainerUtil.toArray(this.mySuperClasses, (ArrayFactory)JSClass.ARRAY_FACTORY));
        this.myClassCombo.setRenderer((ListCellRenderer)new JSClassCellRenderer());
        classComboLabel.setText(RefactoringBundle.message((String)"pull.up.members.to", (Object[])new Object[]{UsageViewUtil.getLongName((PsiElement)this.myClass)}));
        classComboLabel.setLabelFor((Component)this.myClassCombo);
        JSClass nearestBase = JSInheritanceUtil.findNearestBaseClass(this.myClass, false);
        int indexToSelect = 0;
        if (nearestBase != null) {
            indexToSelect = this.mySuperClasses.indexOf(nearestBase);
        }
        this.myClassCombo.setSelectedIndex(indexToSelect);
        this.myClassCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    if (DialectDetector.isActionScript((PsiElement)JSPullUpDialog.this.myClass)) {
                        JSPullUpDialog.this.updateJSMemberInfo();
                    }
                    if (JSPullUpDialog.this.myMemberSelectionPanel != null) {
                        JSPullUpDialog.this.myMemberInfoModel.setSuperClass(JSPullUpDialog.this.getSuperClass());
                        JSPullUpDialog.this.myMemberSelectionPanel.getTable().setMemberInfos(JSPullUpDialog.this.myMemberInfos);
                        JSPullUpDialog.this.myMemberSelectionPanel.getTable().fireExternalDataChange();
                    }
                }
            }
        });
        ++gbConstraints.gridy;
        panel.add((Component)this.myClassCombo, gbConstraints);
        return panel;
    }

    private void updateJSMemberInfo() {
        JSClass targetClass = this.getSuperClass();
        if (targetClass == null) {
            return;
        }
        this.myMemberInfos = new ArrayList<JSMemberInfo>(this.myMemberInfoStorage.getIntermediateMemberInfosList((PsiElement)targetClass));
        JSMemberInfo.sortByOffset(this.myMemberInfos);
    }

    @Nullable
    protected String getHelpId() {
        DialectOptionHolder optionHolder = DialectDetector.dialectOfElement((PsiElement)this.myClass);
        if (optionHolder != null && optionHolder.isTypeScript) {
            return "refactoring.typescript.pull.members.up";
        }
        if (optionHolder != null && optionHolder.isECMA6) {
            return "refactoring.javascript.pull.members.up";
        }
        return super.getHelpId();
    }

    protected void doOKAction() {
        JSPullUpParameters parameters = this.getParameters();
        MultiMap<PsiElement, String> conflicts = this.myValidator.checkConflicts(parameters, JSInterfaceContainmentVerifier.create(Arrays.asList(parameters.members)));
        if (!conflicts.isEmpty()) {
            ConflictsDialog conflictsDialog = new ConflictsDialog(parameters.subClass.getProject(), conflicts);
            conflictsDialog.show();
            boolean ok = conflictsDialog.isOK();
            if (!ok && conflictsDialog.isShowConflicts()) {
                this.close(1);
            }
            if (ok) {
                this.close(0);
            }
        } else {
            this.close(0);
        }
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        boolean isJavaScript = DialectDetector.isJavaScript((PsiElement)this.myClass);
        String abstractColumnTitle = isJavaScript || this.myClass.isInterface() ? null : RefactoringBundle.message((String)"make.abstract");
        this.myMemberSelectionPanel = new JSMemberSelectionPanel(RefactoringBundle.message((String)"members.to.be.pulled.up"), this.myMemberInfos, abstractColumnTitle);
        this.myMemberInfoModel = new MyJSMemberInfoModel();
        this.myMemberInfoModel.memberInfoChanged(new MemberInfoChange(this.myMemberInfos));
        this.myMemberSelectionPanel.getTable().setMemberInfoModel((MemberInfoModel)this.myMemberInfoModel);
        this.myMemberSelectionPanel.getTable().addMemberInfoChangeListener((MemberInfoChangeListener)this.myMemberInfoModel);
        panel.add((Component)this.myMemberSelectionPanel, "Center");
        if (DialectDetector.isActionScript((PsiElement)this.myClass)) {
            this.myDocCommentPanel = new DocCommentPanel(JSBundle.message((String)"javascript.refactoring.asdoc.for.abstracts", (Object[])new Object[0]));
            UIUtil.setEnabled((Component)this.myDocCommentPanel, (!this.myClass.isInterface() ? 1 : 0) != 0, (boolean)true);
            panel.add((Component)this.myDocCommentPanel, "East");
        }
        return panel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClasses";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberInfoStorage";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/memberPullUp/JSPullUpDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/memberPullUp/JSPullUpDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyJSMemberInfoModel
    extends JSUsesAndInterfacesDependencyMemberInfoModel {
        public MyJSMemberInfoModel() {
            super(JSPullUpDialog.this.myClass, JSPullUpDialog.this.getSuperClass(), false, JSInterfaceContainmentVerifier.create(JSPullUpDialog.this.myMemberInfos));
        }

        public boolean isMemberEnabled(JSMemberInfo member) {
            JSClass currentSuperClass = JSPullUpDialog.this.getSuperClass();
            JSAttributeListOwner element = (JSAttributeListOwner)member.getMember();
            if (currentSuperClass == null || element == null) {
                return true;
            }
            if (JSPullUpDialog.this.myMemberInfoStorage.getDuplicatedMemberInfos((PsiElement)currentSuperClass).contains((Object)member)) {
                return false;
            }
            if (JSPullUpDialog.this.myMemberInfoStorage.getExtending((PsiElement)currentSuperClass).contains(element)) {
                return false;
            }
            if (element instanceof JSParameter && TypeScriptPsiUtil.isFieldParameter((JSParameter)element)) {
                return currentSuperClass.isInterface();
            }
            if (currentSuperClass.isInterface()) {
                if (element instanceof JSClass && ((JSClass)element).isInterface()) {
                    return true;
                }
                if (DialectDetector.isActionScript((PsiElement)element) && element instanceof JSVariable) {
                    return false;
                }
                if (element instanceof JSFunction) {
                    return !JSPsiImplUtils.hasModifier(element, JSAttributeList.ModifierType.STATIC);
                }
                return true;
            }
            return true;
        }

        public boolean isAbstractEnabled(JSMemberInfo member) {
            JSClass currentSuper = JSPullUpDialog.this.getSuperClass();
            if (currentSuper == null) {
                return false;
            }
            if (!(member.getMember() instanceof JSFunction)) {
                return false;
            }
            if (member.isStatic()) {
                return false;
            }
            return !DialectDetector.isActionScript((PsiElement)currentSuper) && !currentSuper.isInterface();
        }

        public boolean isAbstractWhenDisabled(JSMemberInfo member) {
            return false;
        }

        public int checkForProblems(@NotNull JSMemberInfo member) {
            if (member == null) {
                MyJSMemberInfoModel.$$$reportNull$$$0(0);
            }
            if (member.isChecked()) {
                return 0;
            }
            JSClass currentSuperClass = JSPullUpDialog.this.getSuperClass();
            if (currentSuperClass != null && currentSuperClass.isInterface()) {
                JSAttributeListOwner element = (JSAttributeListOwner)member.getMember();
                if (element != null && JSPsiImplUtils.hasModifier(element, JSAttributeList.ModifierType.STATIC)) {
                    return super.checkForProblems((MemberInfoBase)member);
                }
                return 0;
            }
            return super.checkForProblems((MemberInfoBase)member);
        }

        public Boolean isFixedAbstract(JSMemberInfo member) {
            return null;
        }

        @Override
        public void setSuperClass(JSClass superClass) {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/lang/javascript/refactoring/memberPullUp/JSPullUpDialog$MyJSMemberInfoModel", "checkForProblems"));
        }
    }

    public static interface Validator {
        public MultiMap<PsiElement, String> checkConflicts(JSPullUpParameters var1, JSInterfaceContainmentVerifier var2);
    }
}

