/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.introduceVariable;

import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseInplaceIntroducer;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceDialog;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceHandler;
import com.intellij.lang.javascript.refactoring.introduceVariable.Settings;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.Nullable;

public abstract class JSVariableInplaceIntroducerBase
extends JSBaseInplaceIntroducer<Settings> {
    protected final boolean myIntroducingExpressionStatement;

    public JSVariableInplaceIntroducerBase(Project project, Editor editor, JSExpression[] occurrences, FileType fileType, JSBaseIntroduceHandler<? extends JSElement, Settings, ? extends JSBaseIntroduceDialog> handler, JSBaseIntroduceHandler.BaseIntroduceContext<Settings> context) {
        super(project, editor, (JSExpression)context.expressionDescriptor.first, occurrences, fileType, handler, context);
        this.myIntroducingExpressionStatement = ((JSExpression)context.expressionDescriptor.first).getParent() instanceof JSExpressionStatement;
    }

    protected int getCaretOffset() {
        JSVariable variable;
        if (this.myIntroducingExpressionStatement && (variable = this.getVariable()) != null) {
            return variable.getTextOffset();
        }
        return super.getCaretOffset();
    }

    @Nullable
    public JSExpression getExpr() {
        if (this.myIntroducingExpressionStatement) {
            return null;
        }
        return (JSExpression)super.getExpr();
    }

    protected void deleteTemplateField(JSVariable psiField) {
        if (this.myIntroducingExpressionStatement) {
            JSExpression initializer = psiField.getInitializer();
            assert (initializer != null);
            JSExpressionStatement exprStatement = JSChangeUtil.createStatementPsiFromTextWithContext(initializer.getText(), (PsiElement)initializer, JSExpressionStatement.class);
            LOG.assertTrue(exprStatement != null && exprStatement.getExpression() != null, (Object)initializer.getText());
            exprStatement.getExpression().replace(initializer);
            exprStatement = (JSExpressionStatement)psiField.getParent().replace((PsiElement)exprStatement);
            this.myExpr = exprStatement.getExpression();
            this.myExprMarker = this.createMarker(this.myExpr);
            LOG.assertTrue(((JSExpression)this.myExpr).isValid());
        } else {
            psiField.delete();
        }
    }
}

