/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.inline;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.CompletionResultSink;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.refactoring.inline.InjectionQuoteHandler;
import com.intellij.lang.javascript.refactoring.inline.JSInlineHandler;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringConflictsUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FunctionInliner
implements JSInlineHandler.Inliner {
    private final PsiElement myElement;

    public FunctionInliner(PsiElement element) {
        this.myElement = element;
    }

    @Override
    public MultiMap<PsiElement, String> getConflicts(PsiReference reference, PsiElement referenced) {
        if (!referenced.getContainingFile().getLanguage().isKindOf((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4)) {
            return null;
        }
        return JSRefactoringConflictsUtil.calcAccessibilityConflicts(reference, (JSAttributeListOwner)referenced, JSVisibilityUtil.DEFAULT_OPTIONS);
    }

    @Override
    public void inlineUsage(@NotNull UsageInfo usage, @NotNull PsiElement referenced) {
        JSFunction function;
        PsiElement usageElement;
        if (usage == null) {
            FunctionInliner.$$$reportNull$$$0(0);
        }
        if (referenced == null) {
            FunctionInliner.$$$reportNull$$$0(1);
        }
        if ((usageElement = usage.getElement()) instanceof JSReferenceExpression) {
            usageElement = usageElement.getParent();
        }
        if (!(usageElement instanceof JSCallExpression)) {
            return;
        }
        JSCallExpression callSiteExpression = (JSCallExpression)usageElement;
        if (referenced instanceof JSProperty && usageElement instanceof JSProperty) {
            return;
        }
        if (!(referenced instanceof JSVariable) && (function = JSPsiImplUtils.getPossibleFunction(referenced)) != null) {
            referenced = function;
        }
        if (callSiteExpression == referenced) {
            return;
        }
        JSFunction replacementFunction = this.calculateReplacement((JSFunction)referenced, callSiteExpression);
        JSSourceElement[] body = replacementFunction.getBody();
        if (body.length == 0) {
            return;
        }
        JSStatement[] statements = ((JSBlockStatement)body[0]).getStatements();
        PsiElement usageParent = callSiteExpression.getParent();
        PsiFile file2 = callSiteExpression.getContainingFile();
        if (statements.length == 1 && (statements[0] instanceof JSReturnStatement || statements[0] instanceof JSExpressionStatement) && !(usageParent instanceof JSExpressionStatement)) {
            JSExpression expression;
            JSExpression jSExpression = expression = statements[0] instanceof JSReturnStatement ? ((JSReturnStatement)statements[0]).getExpression() : ((JSExpressionStatement)statements[0]).getExpression();
            if (expression != null) {
                expression = FunctionInliner.removeRedundantAwaitExpressions(expression, (PsiElement)callSiteExpression);
                FormatFixer fixer = FormatFixer.create((PsiElement)callSiteExpression, FormatFixer.Mode.InSpecifiedRangeMakeFormatterWorkAndLeaveWsBeforeAndAfterIntact);
                JSChangeUtil.replaceExpression((JSExpression)callSiteExpression, expression);
                fixer.fixFormat();
                Document document = PsiDocumentManager.getInstance((Project)callSiteExpression.getProject()).getDocument(file2);
                PsiDocumentManager.getInstance((Project)callSiteExpression.getProject()).commitDocument(document);
            }
        } else if (usageParent instanceof JSExpressionStatement) {
            PsiElement artificialWs = null;
            FormatFixer fixer = FormatFixer.create(usageParent, FormatFixer.Mode.InSpecifiedRangeMakeFormatterWorkAndLeaveWsBeforeAndAfterIntact);
            ASTNode[] children = body[0].getNode().getChildren(null);
            int s = 0;
            int e = children.length;
            if (children[s].getElementType() == JSTokenTypes.LBRACE) {
                ++s;
            }
            if (children[s].getElementType() == JSTokenTypes.WHITE_SPACE) {
                ++s;
            }
            if (children[e - 1].getElementType() == JSTokenTypes.RBRACE) {
                --e;
            }
            if (children[e - 1].getElementType() == JSTokenTypes.WHITE_SPACE) {
                --e;
            }
            statements = new PsiElement[s < e ? e - s : 0];
            for (int i = s; i < e; ++i) {
                statements[i - s] = children[i].getPsi();
            }
            if (statements.length > 1) {
                usageParent.getParent().addRangeBefore((PsiElement)statements[0], (PsiElement)statements[statements.length - 1], usageParent);
            } else if (statements.length == 1) {
                PsiElement nextSibling;
                PsiElement element = usageParent.getParent().addBefore((PsiElement)statements[0], usageParent);
                artificialWs = element.getNextSibling();
                PsiElement psiElement = nextSibling = artificialWs != null ? artificialWs.getNextSibling() : null;
                if (usageParent.getClass().isInstance(nextSibling)) {
                    usageParent = nextSibling;
                }
            }
            usageParent.delete();
            if (artificialWs != null) {
                artificialWs.delete();
            }
            fixer.fixFormat();
            Document document = PsiDocumentManager.getInstance((Project)callSiteExpression.getProject()).getDocument(file2);
            PsiDocumentManager.getInstance((Project)file2.getProject()).commitDocument(document);
        }
    }

    private JSFunction calculateReplacement(JSFunction referenced, JSCallExpression callExpr) {
        THashMap parameterRefs = new THashMap();
        THashMap parametersToActualMap = new THashMap();
        THashMap markersToParametersMap = new THashMap();
        JSExpression thisExpression = ((JSReferenceExpression)callExpr.getMethodExpression()).getQualifier();
        JSExpression[] expressions = callExpr.getArguments();
        int currentActualIndex = 0;
        for (JSParameter p : referenced.getParameterVariables()) {
            if (expressions.length <= currentActualIndex) continue;
            parametersToActualMap.put(p, expressions[currentActualIndex++]);
        }
        String replacementText = FunctionInliner.buildReplacement((PsiElement)referenced, (JSExpression)callExpr, (Map<JSReferenceExpression, RangeMarker>)parameterRefs, (Map<JSParameter, JSExpression>)parametersToActualMap, (Map<RangeMarker, JSParameter>)markersToParametersMap, thisExpression, true);
        DialectOptionHolder holder = DialectDetector.dialectOfElement(this.myElement);
        PsiElement psi = holder != null && !holder.isECMA4 && holder.hasFeature(JSLanguageFeature.CLASSES) && JSUtils.getMemberContainingClass((PsiElement)referenced) != null ? JSChangeUtil.createClassMemberFromText(this.myElement.getProject(), replacementText, JSUtils.getDialect(this.myElement.getContainingFile())).getPsi() : JSChangeUtil.createJSTreeFromText(this.myElement.getProject(), replacementText, JSUtils.getDialect(this.myElement.getContainingFile())).getPsi();
        if (psi instanceof JSExpressionStatement && (psi = ((JSExpressionStatement)psi).getExpression()) instanceof JSParenthesizedExpression) {
            psi = ((JSParenthesizedExpression)psi).getInnerExpression();
        }
        return (JSFunction)psi;
    }

    /*
     * WARNING - void declaration
     */
    static String buildReplacement(PsiElement referenced, JSExpression callExpr, Map<JSReferenceExpression, RangeMarker> parameterRefs, Map<JSParameter, JSExpression> parametersToActualMap, Map<RangeMarker, JSParameter> markersToParametersMap, JSExpression thisExpression, boolean escapeExpression) {
        PsiElement referencedParent;
        final int funOffset = -referenced.getTextRange().getStartOffset();
        DocumentImpl document = new DocumentImpl(referenced.getText());
        THashSet thisRefs = new THashSet();
        THashSet staticRefs = new THashSet();
        THashSet returnExprsToDrop = new THashSet();
        THashMap nonfinalParameters = new THashMap();
        InjectionQuoteHandler injectionQuoteHandler = new InjectionQuoteHandler((PsiElement)callExpr);
        Ref firstStatementMarker = Ref.create(null);
        referenced.accept((PsiElementVisitor)new JSRecursiveElementVisitor((Set)thisRefs, (Document)document, firstStatementMarker, referenced, (Map)nonfinalParameters, markersToParametersMap, parameterRefs, (Set)staticRefs, callExpr, (Set)returnExprsToDrop){
            final /* synthetic */ Set val$thisRefs;
            final /* synthetic */ Document val$document;
            final /* synthetic */ Ref val$firstStatementMarker;
            final /* synthetic */ PsiElement val$referenced;
            final /* synthetic */ Map val$nonfinalParameters;
            final /* synthetic */ Map val$markersToParametersMap;
            final /* synthetic */ Map val$parameterRefs;
            final /* synthetic */ Set val$staticRefs;
            final /* synthetic */ JSExpression val$callExpr;
            final /* synthetic */ Set val$returnExprsToDrop;
            {
                this.val$thisRefs = set;
                this.val$document = document;
                this.val$firstStatementMarker = ref;
                this.val$referenced = psiElement;
                this.val$nonfinalParameters = map;
                this.val$markersToParametersMap = map2;
                this.val$parameterRefs = map3;
                this.val$staticRefs = set2;
                this.val$callExpr = jSExpression;
                this.val$returnExprsToDrop = set3;
            }

            public void visitJSThisExpression(JSThisExpression node) {
                super.visitJSThisExpression(node);
                JSInlineHandler.doAddThisReference((PsiElement)node, (PsiElement)node, funOffset, this.val$thisRefs, this.val$document);
            }

            public void visitJSStatement(JSStatement node) {
                if (this.val$firstStatementMarker.isNull() && !(node instanceof JSBlockStatement)) {
                    this.val$firstStatementMarker.set((Object)node.getTextRange().getStartOffset());
                }
                super.visitJSStatement(node);
            }

            public void visitJSDefinitionExpression(JSDefinitionExpression node) {
                PsiElement nodeTarget;
                JSReferenceExpression refExpr;
                JSExpression qualifier;
                super.visitJSDefinitionExpression(node);
                JSExpression expression = node.getExpression();
                if (expression instanceof JSReferenceExpression && (qualifier = (refExpr = (JSReferenceExpression)expression).getQualifier()) == null && (nodeTarget = refExpr.resolve()) instanceof JSParameter && nodeTarget.getParent().getParent() == this.val$referenced) {
                    this.val$nonfinalParameters.put((JSParameter)nodeTarget, null);
                }
            }

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                JSExpression qualifier = node.getQualifier();
                if (qualifier == null) {
                    PsiElement nodeTarget = node.resolve();
                    if (nodeTarget instanceof JSParameter) {
                        if (nodeTarget.getParent().getParent() == this.val$referenced) {
                            RangeMarker rangeMarker = InjectionQuoteHandler.rangeMarker((PsiElement)node, this.val$document, funOffset);
                            this.val$markersToParametersMap.put(rangeMarker, (JSParameter)nodeTarget);
                            this.val$parameterRefs.put(node, rangeMarker);
                        }
                    } else if (node.getParent() != nodeTarget && nodeTarget != null) {
                        JSAttributeList attrList = nodeTarget instanceof JSAttributeListOwner ? ((JSAttributeListOwner)nodeTarget).getAttributeList() : null;
                        JSInlineHandler.addThisReference((PsiElement)node, (PsiElement)node.getQualifier(), nodeTarget, funOffset, attrList != null && attrList.hasModifier(JSAttributeList.ModifierType.STATIC) ? this.val$staticRefs : this.val$thisRefs, this.val$document);
                    }
                }
                super.visitJSReferenceExpression(node);
            }

            public void visitJSReturnStatement(JSReturnStatement node) {
                if (this.val$callExpr.getParent() instanceof JSExpressionStatement) {
                    JSInlineHandler.doAddThisReference(null, (PsiElement)node, funOffset, this.val$returnExprsToDrop, this.val$document);
                }
                super.visitJSReturnStatement(node);
            }
        });
        injectionQuoteHandler.fixQuotes(referenced, funOffset, (Document)document);
        if (!nonfinalParameters.isEmpty()) {
            SinkResolveProcessor<CompletionResultSink> processor = new SinkResolveProcessor<CompletionResultSink>(new CompletionResultSink(null));
            JSResolveUtil.treeWalkUp(processor, (PsiElement)callExpr, null, (PsiElement)callExpr);
            List<PsiElement> list = processor.getResults();
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            for (PsiElement psiElement : list) {
                if (!(psiElement instanceof JSNamedElement)) continue;
                arrayList.add(((JSNamedElement)psiElement).getName());
            }
            TreeSet<String> evaluatedName = new TreeSet<String>();
            for (Map.Entry entry : nonfinalParameters.entrySet()) {
                JSParameter nonfinalParameter = (JSParameter)entry.getKey();
                evaluatedName.clear();
                evaluatedName.add(JSNameSuggestionsUtil.ensureUniqueVariableName(nonfinalParameter.getName(), null, arrayList, true));
                String name = (String)evaluatedName.first();
                entry.setValue(name);
            }
        }
        for (Map.Entry entry : parameterRefs.entrySet()) {
            void var20_47;
            JSReferenceExpression jSReferenceExpression = (JSReferenceExpression)entry.getKey();
            RangeMarker rangeMarker = (RangeMarker)entry.getValue();
            JSParameter jSParameter = markersToParametersMap.get(rangeMarker);
            JSExpression jSExpression = parametersToActualMap.get(jSParameter);
            if (jSExpression == null && jSParameter != null && jSParameter.isOptional()) {
                JSExpression jSExpression2 = jSParameter.getInitializer();
            }
            ES6Property property = (ES6Property)ObjectUtils.tryCast((Object)jSReferenceExpression.getParent(), ES6Property.class);
            String introducedString = (String)ObjectUtils.coalesce(nonfinalParameters.get(jSParameter), (Object)(var20_47 != null ? var20_47.getText() : jSParameter.getName()));
            introducedString = property != null && property.isShorthanded() && !StringUtil.equals((CharSequence)property.getName(), (CharSequence)introducedString) ? String.format("%s: %s", property.getName(), introducedString) : introducedString;
            document.replaceString(rangeMarker.getStartOffset(), rangeMarker.getEndOffset(), (CharSequence)introducedString);
        }
        if (thisExpression != null) {
            String thisValue = thisExpression.getText();
            for (RangeMarker rangeMarker : thisRefs) {
                document.replaceString(rangeMarker.getStartOffset(), rangeMarker.getEndOffset(), (CharSequence)(thisValue + (rangeMarker.getStartOffset() == rangeMarker.getEndOffset() ? "." : "")));
            }
        }
        if ((referencedParent = PsiTreeUtil.getParentOfType((PsiElement)referenced, JSClass.class)) instanceof JSClass) {
            String string = ((JSClass)referencedParent).getQualifiedName();
            for (RangeMarker marker : staticRefs) {
                document.replaceString(marker.getStartOffset(), marker.getEndOffset(), (CharSequence)(string + "."));
            }
        }
        for (RangeMarker rangeMarker : returnExprsToDrop) {
            document.replaceString(rangeMarker.getStartOffset(), rangeMarker.getEndOffset(), (CharSequence)"");
        }
        for (Map.Entry entry : nonfinalParameters.entrySet()) {
            JSParameter parameter = (JSParameter)entry.getKey();
            JSExpression jSExpression = parametersToActualMap.get(parameter);
            String string = jSExpression != null ? jSExpression.getText() : null;
            StringBuilder builder = new StringBuilder(JSChangeUtil.getVariablePrefix(referenced));
            builder.append(" ");
            builder.append((String)entry.getValue());
            if (string != null) {
                builder.append(" = ");
                builder.append(jSExpression.getText());
            }
            builder.append(";\n");
            document.insertString((Integer)firstStatementMarker.get() + funOffset, (CharSequence)builder.toString());
        }
        if (escapeExpression && (referenced instanceof JSFunctionExpression || referenced instanceof JSObjectLiteralExpression)) {
            document.insertString(0, (CharSequence)"(");
            document.insertString(document.getTextLength(), (CharSequence)")");
        }
        return document.getText();
    }

    @Nullable
    public static JSInlineHandler.JSInlineSettingsBase handleFunction(@NotNull PsiElement toSearchForUsages, final @NotNull JSFunction fun, @Nullable Editor editor, boolean invokedOnReference, final NotNullLazyValue<Collection<PsiReference>> deferredUsages, boolean isSelfReference) {
        if (toSearchForUsages == null) {
            FunctionInliner.$$$reportNull$$$0(2);
        }
        if (fun == null) {
            FunctionInliner.$$$reportNull$$$0(3);
        }
        Project project = fun.getProject();
        if (JSProjectUtil.isInLibrary(fun.getContainingFile())) {
            FunctionInliner.inlineFunctionProblem(JSBundle.message((String)"javascript.refactoring.cannot.inline.function.defined.in.library", (Object[])new Object[0]), editor, project);
            return null;
        }
        if (fun.isReferencesArguments()) {
            FunctionInliner.inlineFunctionProblem(JSBundle.message((String)"javascript.refactoring.cannot.inline.function.referencing.arguments", (Object[])new Object[0]), editor, project);
            return null;
        }
        if (fun.getParent() instanceof JSClass && ((JSClass)fun.getParent()).isInterface()) {
            FunctionInliner.inlineFunctionProblem(JSBundle.message((String)"javascript.refactoring.cannot.inline.interface.method", (Object[])new Object[0]), editor, project);
            return null;
        }
        for (JSParameter p : fun.getParameterVariables()) {
            if (!p.isRest()) continue;
            FunctionInliner.inlineFunctionProblem(JSBundle.message((String)"javascript.refactoring.cannot.inline.function.referencing.rest.parameter", (Object[])new Object[0]), editor, project);
            return null;
        }
        if (JSInheritanceUtil.participatesInHierarchy(fun)) {
            FunctionInliner.inlineFunctionProblem(JSBundle.message((String)"javascript.refactoring.cannot.inline.overrided.or.overridden.method", (Object[])new Object[0]), editor, project);
            return null;
        }
        final Ref problem = new Ref();
        fun.accept((PsiElementVisitor)new JSRecursiveElementVisitor(){
            boolean nonLastStatement;
            boolean nonLastStatementCalculated;

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                if (node.getParent() != fun && node.resolve() == fun) {
                    problem.set((Object)JSBundle.message((String)"javascript.refactoring.cannot.inline.recursive.function", (Object[])new Object[0]));
                }
                super.visitJSReferenceExpression(node);
            }

            public void visitJSReturnStatement(JSReturnStatement node) {
                block4: {
                    JSSourceElement bodyBlock;
                    block3: {
                        JSFunction parentFunction;
                        bodyBlock = fun.getBody()[0];
                        if (node.getParent() == bodyBlock) break block3;
                        if (!this.nonLastStatementCalculated) {
                            this.calcNonLastStatement();
                            this.nonLastStatementCalculated = true;
                        }
                        if (!this.nonLastStatement || (parentFunction = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)node, JSFunction.class)) != fun) break block4;
                        problem.set((Object)JSBundle.message((String)"javascript.refactoring.cannot.inline.function.with.multiple.returns", (Object[])new Object[0]));
                        break block4;
                    }
                    if (((JSBlockStatement)bodyBlock).getStatements().length > 1 && node.getExpression() != null) {
                        for (PsiReference ref : (Collection)deferredUsages.getValue()) {
                            PsiElement elt = ref.getElement();
                            PsiElement eltParent = elt.getParent();
                            if (eltParent instanceof JSCallExpression && eltParent.getParent() instanceof JSExpressionStatement) continue;
                            problem.set((Object)JSBundle.message((String)"javascript.refactoring.cannot.inline.complex.expression.evaluation", (Object[])new Object[0]));
                            break;
                        }
                    }
                }
                super.visitJSReturnStatement(node);
            }

            private void calcNonLastStatement() {
                for (PsiReference ref : (Collection)deferredUsages.getValue()) {
                    PsiElement elt = ref.getElement();
                    PsiElement parent = elt.getParent();
                    if (!(parent instanceof JSCallExpression)) continue;
                    PsiElement grandParent = parent.getParent();
                    if (!(grandParent instanceof JSStatement)) {
                        this.nonLastStatement = true;
                        break;
                    }
                    PsiElement grandGrandParent = grandParent.getParent();
                    if (!(grandGrandParent instanceof JSStatement)) {
                        this.nonLastStatement = true;
                        break;
                    }
                    boolean b = ControlFlowUtils.statementCompletesWithStatement((JSStatement)grandGrandParent, (JSStatement)grandParent);
                    if (b) continue;
                    this.nonLastStatement = true;
                    break;
                }
            }
        });
        if (problem.isNull()) {
            for (PsiReference ref : (Collection)deferredUsages.getValue()) {
                PsiElement elt = ref.getElement();
                PsiElement parent = elt.getParent();
                if (parent instanceof JSNewExpression) {
                    problem.set((Object)JSBundle.message((String)"javascript.refactoring.cannot.inline.constructor", (Object[])new Object[0]));
                    break;
                }
                if (parent instanceof JSCallExpression) continue;
                problem.set((Object)JSBundle.message((String)"javascript.refactoring.cannot.inline.non.call.usage", (Object[])new Object[0]));
                break;
            }
        }
        if (!problem.isNull()) {
            FunctionInliner.inlineFunctionProblem((String)problem.get(), editor, project);
            return null;
        }
        return new JSInlineHandler.JSInlineSettingsBase(toSearchForUsages, deferredUsages, invokedOnReference, editor, isSelfReference);
    }

    static void inlineFunctionProblem(String key, @Nullable Editor editor, Project project) {
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)key, (String)JSBundle.message((String)"javascript.refactoring.inline.function.title", (Object[])new Object[0]), null);
    }

    @Nullable
    static JSExpression removeRedundantAwaitExpressions(@Nullable JSExpression toInsert, @Nullable PsiElement insertionPoint) {
        if (insertionPoint == null) {
            return toInsert;
        }
        PsiElement insertionParent = insertionPoint.getParent();
        if (ES6PsiUtil.isAwaitExpression(insertionParent)) {
            while (ES6PsiUtil.isAwaitExpression((PsiElement)toInsert)) {
                toInsert = ((JSPrefixExpression)toInsert).getExpression();
            }
            return toInsert;
        }
        return toInsert;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenced";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toSearchForUsages";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/refactoring/inline/FunctionInliner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "inlineUsage";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "handleFunction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

