/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSNamedElementKind;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.rename.RenamePsiFileProcessor;
import com.intellij.util.ui.UIUtil;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSRenamePsiFileProcessor
extends RenamePsiFileProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            JSRenamePsiFileProcessor.$$$reportNull$$$0(0);
        }
        if (!(element instanceof JSFile)) {
            return false;
        }
        DialectOptionHolder holder = DialectDetector.dialectOfFile((PsiFile)element);
        return holder == null || !holder.isECMA4;
    }

    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames) {
        String message;
        String newElementName;
        JSNamedElement declaration;
        if (element == null) {
            JSRenamePsiFileProcessor.$$$reportNull$$$0(1);
        }
        if (newName == null) {
            JSRenamePsiFileProcessor.$$$reportNull$$$0(2);
        }
        if (allRenames == null) {
            JSRenamePsiFileProcessor.$$$reportNull$$$0(3);
        }
        if ((declaration = JSRenamePsiFileProcessor.findMatchingDeclaration((JSFile)element)) != null && !StringUtil.equals((CharSequence)(newElementName = JSNameSuggestionsUtil.fileNameToElementName(declaration, newName)), (CharSequence)declaration.getName()) && Messages.showYesNoDialog((String)(message = JSBundle.message((String)"javascript.rename.related.declaration.message", (Object[])new Object[]{StringUtil.decapitalize((String)JSBundle.message((String)JSNamedElementKind.kind((PsiElement)declaration).humanReadableKey(), (Object[])new Object[0])), newElementName})), (String)"Rename File", (Icon)UIUtil.getQuestionIcon()) == 0) {
            allRenames.put((PsiElement)declaration, newElementName);
        }
        super.prepareRenaming(element, newName, allRenames);
    }

    @Nullable
    public static JSNamedElement findMatchingDeclaration(@NotNull JSFile file2) {
        if (file2 == null) {
            JSRenamePsiFileProcessor.$$$reportNull$$$0(4);
        }
        Ref result2 = new Ref();
        JSStubBasedPsiTreeUtil.processDeclarationsInScope((PsiElement)file2, (element, state) -> {
            if ((element instanceof JSVariable || element instanceof JSClass || element instanceof JSFunction) && JSNameSuggestionsUtil.matchesFileNameRelaxed((JSNamedElement)element)) {
                result2.set((Object)((JSNamedElement)element));
                return false;
            }
            return true;
        }, false);
        return (JSNamedElement)result2.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRenames";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/refactoring/JSRenamePsiFileProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canProcessElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareRenaming";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findMatchingDeclaration";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

