/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring;

import com.intellij.lang.ecmascript6.refactoring.ES6ReferenceExpressionsInfo;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.refactoring.util.JSClassMemberReferencesVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.classMembers.ClassMembersRefactoringSupport;
import com.intellij.refactoring.classMembers.DependentMembersCollectorBase;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class JSMembersRefactoringSupport
implements ClassMembersRefactoringSupport {
    public DependentMembersCollectorBase createDependentMembersCollector(Object container, Object superClass) {
        if (container instanceof JSClass) {
            return new JSClassMembersCollector((JSClass)container, (JSClass)superClass);
        }
        if (container instanceof PsiFile) {
            return new ES6DependantModuleMembersCollector((PsiFile)container);
        }
        return null;
    }

    public boolean isProperMember(MemberInfoBase member) {
        return true;
    }

    private static class ES6DependantModuleMembersCollector
    extends DependentMembersCollectorBase<JSPsiElementBase, PsiFile> {
        public ES6DependantModuleMembersCollector(PsiFile file2) {
            super((Object)file2, null);
        }

        public void collect(JSPsiElementBase member) {
            ES6ReferenceExpressionsInfo info = ES6ReferenceExpressionsInfo.getInfo(member);
            this.addDependencies(info.getLocalReferencedElements());
            this.addDependencies(info.getExportedLocalReferencedElements());
        }

        private void addDependencies(@NotNull Collection<PsiElement> elements) {
            if (elements == null) {
                ES6DependantModuleMembersCollector.$$$reportNull$$$0(0);
            }
            for (PsiElement element : elements) {
                if (!(element instanceof JSPsiElementBase)) continue;
                this.myCollection.add((JSPsiElementBase)element);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/lang/javascript/refactoring/JSMembersRefactoringSupport$ES6DependantModuleMembersCollector", "addDependencies"));
        }
    }

    private static class JSClassMembersCollector
    extends DependentMembersCollectorBase<JSElement, JSClass> {
        public JSClassMembersCollector(JSClass clazz, JSClass superClass) {
            super((Object)clazz, (Object)superClass);
        }

        public void collect(JSElement member) {
            JSFunction setter;
            JSClassMemberReferencesVisitor visitor = new JSClassMemberReferencesVisitor((JSClass)this.getClazz()){

                @Override
                protected void visitMemberReference(@NotNull JSAttributeListOwner member, @NotNull JSReferenceExpression reference) {
                    if (member == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (reference == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (!this.existsInSuperClass((JSElement)member)) {
                        myCollection.add(member);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "member";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "reference";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/lang/javascript/refactoring/JSMembersRefactoringSupport$JSClassMembersCollector$1";
                    objectArray[2] = "visitMemberReference";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            member.accept((PsiElementVisitor)visitor);
            if (member instanceof JSFunction && ((JSFunction)member).isGetProperty() && (setter = ((JSClass)this.getClazz()).findFunctionByNameAndKind(member.getName(), JSFunction.FunctionKind.SETTER)) != null) {
                setter.accept((PsiElementVisitor)visitor);
            }
        }

        private boolean existsInSuperClass(JSElement member) {
            if (this.getSuperClass() == null) {
                return false;
            }
            if (!(member instanceof JSFunction)) {
                return false;
            }
            return ((JSClass)this.getSuperClass()).findFunctionByName(member.getName()) != null;
        }
    }
}

