/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.recordImpl;

import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecordMemberSourceFactory;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.util.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PropertySignatureCommonImpl
extends JSRecordType.PropertySignature {
    @NotNull
    default public JSRecordType.PropertySignature copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform, boolean shouldCleanSourceElement) {
        if (childTransform == null) {
            PropertySignatureCommonImpl.$$$reportNull$$$0(0);
        }
        JSType oldType = this.getType();
        JSType type = JSTypeUtils.transformTypeHierarchySafe(oldType, childTransform);
        if (!shouldCleanSourceElement && oldType == type) {
            PropertySignatureCommonImpl propertySignatureCommonImpl = this;
            if (propertySignatureCommonImpl == null) {
                PropertySignatureCommonImpl.$$$reportNull$$$0(1);
            }
            return propertySignatureCommonImpl;
        }
        JSRecordType.MemberSource sourceElement = shouldCleanSourceElement ? JSRecordMemberSourceFactory.createEmptySource() : this.getMemberSource();
        JSRecordTypeImpl.PropertySignatureImpl propertySignatureImpl = new JSRecordTypeImpl.PropertySignatureImpl(this.getMemberName(), type, this.isOptional(), sourceElement);
        if (propertySignatureImpl == null) {
            PropertySignatureCommonImpl.$$$reportNull$$$0(2);
        }
        return propertySignatureImpl;
    }

    default public void appendMemberPresentation(@NotNull JSType.TypeTextFormat format, @NotNull StringBuilder builder, @NotNull String typeSeparator, char quote) {
        JSType propertyType;
        if (format == null) {
            PropertySignatureCommonImpl.$$$reportNull$$$0(3);
        }
        if (builder == null) {
            PropertySignatureCommonImpl.$$$reportNull$$$0(4);
        }
        if (typeSeparator == null) {
            PropertySignatureCommonImpl.$$$reportNull$$$0(5);
        }
        String name = this.getMemberName();
        String fixedName = JSSymbolUtil.handleSpecialPropertyNames(name, quote);
        builder.append(fixedName);
        if (this.isOptional()) {
            builder.append('?');
        }
        if ((propertyType = this.getType()) != null) {
            if (PropertySignatureCommonImpl.isFunctionMember((JSRecordType.TypeMember)this, propertyType)) {
                builder.append(((JSFunctionTypeImpl)propertyType).getTypeText(format, false));
            } else {
                boolean appendBrackets = propertyType.isJavaScript() && JSTypeUtils.isNeedWrapTypeForSerialization(propertyType);
                builder.append(typeSeparator);
                String typeText = propertyType.getTypeText(format);
                if (appendBrackets) {
                    builder.append("(");
                }
                builder.append(typeText);
                if (appendBrackets) {
                    builder.append(")");
                }
            }
        }
    }

    default public void acceptChildren(JSRecursiveTypeVisitor visitor) {
        JSType type = this.getType();
        if (type != null) {
            type.accept(visitor);
        }
    }

    public static boolean isFunctionMember(@NotNull JSRecordType.TypeMember typeMember, @Nullable JSType propertyType) {
        if (typeMember == null) {
            PropertySignatureCommonImpl.$$$reportNull$$$0(6);
        }
        return propertyType instanceof JSFunctionTypeImpl && typeMember.getMemberSource().getSingleElement() instanceof JSFunction;
    }

    default public boolean isEquivalentTo(@Nullable JSRecordType.TypeMember other, boolean allowResolve) {
        return PropertySignatureCommonImpl.arePropertySignaturesEqual(this, other, allowResolve);
    }

    public static boolean arePropertySignaturesEqual(@NotNull JSRecordType.PropertySignature first, @Nullable JSRecordType.TypeMember otherRaw, boolean allowResolve) {
        if (first == null) {
            PropertySignatureCommonImpl.$$$reportNull$$$0(7);
        }
        if (otherRaw == first) {
            return true;
        }
        if (!(otherRaw instanceof JSRecordType.PropertySignature)) {
            return false;
        }
        JSRecordType.PropertySignature other = (JSRecordType.PropertySignature)otherRaw;
        return first.getMemberName().equals(other.getMemberName()) && (first.getType() != null ? first.getType().isEquivalentTo(other.getType(), null, allowResolve) : other.getType() == null) && first.isOptional() == other.isOptional();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/recordImpl/PropertySignatureCommonImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSeparator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMember";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/recordImpl/PropertySignatureCommonImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "appendMemberPresentation";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isFunctionMember";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "arePropertySignaturesEqual";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

