/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.primitives;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSPrimitiveLiteralType;
import com.intellij.lang.javascript.psi.types.JSSpecialNamedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.util.ProcessingContext;
import java.text.CharacterIterator;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSPrimitiveType
extends JSSpecialNamedTypeImpl {
    private final boolean primitive;

    public JSPrimitiveType(boolean primitive, @NotNull JSTypeSource source, @NotNull JSTypeContext staticOrInstance) {
        if (source == null) {
            JSPrimitiveType.$$$reportNull$$$0(0);
        }
        if (staticOrInstance == null) {
            JSPrimitiveType.$$$reportNull$$$0(1);
        }
        super(source, staticOrInstance);
        this.primitive = primitive;
    }

    public JSPrimitiveType(@NotNull JSTypeSource typeSource, @NotNull CharacterIterator inputStream) {
        if (typeSource == null) {
            JSPrimitiveType.$$$reportNull$$$0(2);
        }
        if (inputStream == null) {
            JSPrimitiveType.$$$reportNull$$$0(3);
        }
        super(typeSource, inputStream);
        this.primitive = JSTypeSerializer.readBoolean(inputStream);
    }

    @Override
    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSPrimitiveType.$$$reportNull$$$0(4);
        }
        super.serialize(outputStream);
        JSTypeSerializer.writeBoolean(this.primitive, outputStream);
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    @Override
    public boolean isEquivalentToImpl(@NotNull JSType jsType, ProcessingContext processingContext, boolean allowResolve) {
        if (jsType == null) {
            JSPrimitiveType.$$$reportNull$$$0(5);
        }
        return jsType.getClass() == ((Object)((Object)this)).getClass() && (((JSPrimitiveType)jsType).isPrimitive() == this.isPrimitive() || this.isTypeScript());
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            JSPrimitiveType.$$$reportNull$$$0(6);
        }
        if (!this.isPrimitive() && elementType instanceof JSNullType) {
            return true;
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    protected int resolvedHashCodeImpl() {
        int value = Objects.hash(super.resolvedHashCodeImpl(), ((Object)((Object)this)).getClass(), this.isPrimitive());
        if (this instanceof JSPrimitiveLiteralType) {
            return Objects.hash(value, ((JSPrimitiveLiteralType)((Object)this)).getLiteral(), ((JSPrimitiveLiteralType)((Object)this)).canBeWidened());
        }
        if (this instanceof JSLiteralType) {
            return Objects.hash(value, ((JSLiteralType)((Object)this)).canBeWidened());
        }
        return value;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "staticOrInstance";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSource";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/types/primitives/JSPrimitiveType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "serialize";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isEquivalentToImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

