/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSApplyCallType;
import com.intellij.lang.javascript.psi.types.JSApplyNewType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSBooleanLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSDecoratedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSDestructuringTypeImpl;
import com.intellij.lang.javascript.psi.types.JSFreshObjectLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIterableComponentTypeImpl;
import com.intellij.lang.javascript.psi.types.JSLocalNamedType;
import com.intellij.lang.javascript.psi.types.JSMixinTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSRecordMemberSourceFactory;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSReferenceType;
import com.intellij.lang.javascript.psi.types.JSRequireCallExpressionType;
import com.intellij.lang.javascript.psi.types.JSSimpleRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTopLevelNamespace;
import com.intellij.lang.javascript.psi.types.JSTupleTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer$WhenMappings;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.types.JSUniqueSymbolTypeImpl;
import com.intellij.lang.javascript.psi.types.JSUnknownType;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSIntType;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveArrayType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveFunctionType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.JSSymbolType;
import com.intellij.lang.javascript.psi.types.primitives.JSUintType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.containers.ContainerUtil;
import java.text.CharacterIterator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0097\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b*\u0001\u001a\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002?@B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H%0\u00170\u0004\"\u0004\b\u0000\u0010%2\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H%0\u0004H\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010\u0011\u001a\u00020\u0010H\u0007J\u0010\u0010)\u001a\u00020*2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\u0010\u0010+\u001a\u00020,2\u0006\u0010\u0011\u001a\u00020\u0010H\u0007J\u0010\u0010-\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0010H\u0007J\u0010\u0010.\u001a\u00020/2\u0006\u0010\u0011\u001a\u00020\u0010H\u0007JW\u00100\u001a\u000201\"\n\b\u0000\u0010%\u0018\u0001*\u00020\u00122\u0006\u00102\u001a\u00020\n28\b\b\u00103\u001a2\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u0002H%0\u000bH\u0082\bJ`\u00100\u001a\u000201\"\b\b\u0000\u0010%*\u00020\u00122\u0006\u00102\u001a\u00020\n2\f\u00104\u001a\b\u0012\u0004\u0012\u0002H%0\u001426\u00103\u001a2\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u0002H%0\u000bH\u0002J\u001c\u00105\u001a\u0002012\u0006\u00106\u001a\u00020(2\n\u00107\u001a\u000608j\u0002`9H\u0007J\u001c\u0010:\u001a\u0002012\u0006\u00106\u001a\u00020*2\n\u00107\u001a\u000608j\u0002`9H\u0002J\u001c\u0010;\u001a\u0002012\u0006\u00106\u001a\u00020,2\n\u00107\u001a\u000608j\u0002`9H\u0007J\u001c\u0010<\u001a\u0002012\u0006\u00106\u001a\u00020\n2\n\u00107\u001a\u000608j\u0002`9H\u0007J\u001c\u0010=\u001a\u0002012\u0006\u0010>\u001a\u00020/2\n\u00107\u001a\u000608j\u0002`9H\u0007R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000RJ\u0010\b\u001a>\u0012\u0004\u0012\u00020\n\u00124\u00122\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0013\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0014\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00170\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001e\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00170\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u00170\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00120\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u001dX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/intellij/lang/javascript/psi/types/JSTypeSerializer;", "", "()V", "CALL_SIGNATURE_SERIALIZER", "Lcom/intellij/lang/javascript/psi/types/JSTypeSerializer$JSTypeStreamSerializer;", "Lcom/intellij/lang/javascript/psi/JSRecordType$CallSignature;", "INDEX_SIGNATURE_SERIALIZER", "Lcom/intellij/lang/javascript/psi/JSRecordType$IndexSignature;", "JS_TYPE_CONSTRUCTORS", "Ljava/util/HashMap;", "", "Lkotlin/Function2;", "Lcom/intellij/lang/javascript/psi/types/JSTypeSource;", "Lkotlin/ParameterName;", "name", "typeSource", "Ljava/text/CharacterIterator;", "inputStream", "Lcom/intellij/lang/javascript/psi/JSType;", "JS_TYPE_IDS", "Ljava/lang/Class;", "NULLABLE_TYPE_SERIALIZER", "PARAMETER_LIST", "", "Lcom/intellij/lang/javascript/psi/JSParameterTypeDecorator;", "PARAMETER_TYPE_DECORATOR_SERIALIZER", "com/intellij/lang/javascript/psi/types/JSTypeSerializer$PARAMETER_TYPE_DECORATOR_SERIALIZER$1", "Lcom/intellij/lang/javascript/psi/types/JSTypeSerializer$PARAMETER_TYPE_DECORATOR_SERIALIZER$1;", "SEP", "", "TYPES_SERIALIZER", "TYPE_MEMBERS_SERIALIZER", "Lcom/intellij/lang/javascript/psi/JSRecordType$TypeMember;", "TYPE_MEMBER_SERIALIZER", "TYPE_SERIALIZER", "UNIT_SEP", "createListSerializer", "T", "elementSerializer", "readBoolean", "", "readInt", "", "readSegment", "Lcom/intellij/openapi/util/Segment;", "readString", "readTypeContext", "Lcom/intellij/lang/javascript/psi/types/JSTypeContext;", "registerJSTypeClass", "", "id", "serializer", "clazz", "writeBoolean", "value", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "writeInt", "writeSegment", "writeString", "writeTypeContext", "typeContext", "JSTypeDeserializationException", "JSTypeStreamSerializer", "intellij.javascript.psi.impl"})
public final class JSTypeSerializer {
    private static final HashMap<String, Function2<JSTypeSource, CharacterIterator, JSType>> JS_TYPE_CONSTRUCTORS;
    private static final HashMap<Class<? extends JSType>, String> JS_TYPE_IDS;
    private static final char SEP = '\u001e';
    private static final char UNIT_SEP = '\u001f';
    @JvmField
    @NotNull
    public static final JSTypeStreamSerializer<JSType> TYPE_SERIALIZER;
    @JvmField
    @NotNull
    public static final JSTypeStreamSerializer<JSType> NULLABLE_TYPE_SERIALIZER;
    @JvmField
    @NotNull
    public static final JSTypeStreamSerializer<JSRecordType.TypeMember> TYPE_MEMBER_SERIALIZER;
    @JvmField
    @NotNull
    public static final JSTypeStreamSerializer<JSRecordType.IndexSignature> INDEX_SIGNATURE_SERIALIZER;
    @JvmField
    @NotNull
    public static final JSTypeStreamSerializer<JSRecordType.CallSignature> CALL_SIGNATURE_SERIALIZER;
    private static final PARAMETER_TYPE_DECORATOR_SERIALIZER.1 PARAMETER_TYPE_DECORATOR_SERIALIZER;
    @JvmField
    @NotNull
    public static final JSTypeStreamSerializer<List<JSRecordType.TypeMember>> TYPE_MEMBERS_SERIALIZER;
    @JvmField
    @NotNull
    public static final JSTypeStreamSerializer<List<JSType>> TYPES_SERIALIZER;
    @JvmField
    @NotNull
    public static final JSTypeStreamSerializer<List<JSParameterTypeDecorator>> PARAMETER_LIST;
    public static final JSTypeSerializer INSTANCE;

    private final <T extends JSType> void registerJSTypeClass(String id, Function2<? super JSTypeSource, ? super CharacterIterator, ? extends T> serializer) {
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        this.registerJSTypeClass(id, JSType.class, serializer);
    }

    private final <T extends JSType> void registerJSTypeClass(String id, Class<T> clazz, Function2<? super JSTypeSource, ? super CharacterIterator, ? extends T> serializer) {
        if (JS_TYPE_CONSTRUCTORS.containsKey(id)) {
            Logger.getInstance(JSTypeSerializer.class).error((String)id + " alreadyRegistered. " + JS_TYPE_CONSTRUCTORS.get(id) + ", " + clazz.getName());
        }
        Map map = JS_TYPE_IDS;
        Function2<? super JSTypeSource, ? super CharacterIterator, ? extends T> function2 = id;
        map.put(clazz, function2);
        map = JS_TYPE_CONSTRUCTORS;
        function2 = serializer;
        map.put(id, function2);
    }

    @JvmStatic
    @NotNull
    public static final JSTypeContext readTypeContext(@NotNull CharacterIterator inputStream) {
        Intrinsics.checkParameterIsNotNull((Object)inputStream, (String)"inputStream");
        char cur = inputStream.current();
        inputStream.next();
        switch (cur) {
            case 's': {
                return JSTypeContext.STATIC;
            }
            case 'i': {
                return JSTypeContext.INSTANCE;
            }
            case 'p': {
                return JSTypeContext.PROTOTYPE;
            }
            case 'u': {
                return JSTypeContext.UNKNOWN;
            }
        }
        throw (Throwable)new JSTypeDeserializationException(null, 1, null);
    }

    @JvmStatic
    public static final void writeTypeContext(@NotNull JSTypeContext typeContext, @NotNull StringBuilder builder) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)typeContext), (String)"typeContext");
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        switch (JSTypeSerializer$WhenMappings.$EnumSwitchMapping$0[typeContext.ordinal()]) {
            case 1: {
                builder.append('s');
                break;
            }
            case 2: {
                builder.append('i');
                break;
            }
            case 3: {
                builder.append('p');
                break;
            }
            case 4: {
                builder.append('u');
            }
        }
    }

    @JvmStatic
    public static final boolean readBoolean(@NotNull CharacterIterator inputStream) {
        Intrinsics.checkParameterIsNotNull((Object)inputStream, (String)"inputStream");
        char cur = inputStream.current();
        inputStream.next();
        switch (cur) {
            case 't': {
                return true;
            }
            case 'f': {
                return false;
            }
        }
        throw (Throwable)new JSTypeDeserializationException(null, 1, null);
    }

    @JvmStatic
    public static final void writeBoolean(boolean value, @NotNull StringBuilder builder) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        builder.append(value ? (char)'t' : 'f');
    }

    @JvmStatic
    @NotNull
    public static final String readString(@NotNull CharacterIterator inputStream) {
        Intrinsics.checkParameterIsNotNull((Object)inputStream, (String)"inputStream");
        char cur = inputStream.current();
        StringBuilder builder = new StringBuilder();
        while (cur != '\u001e') {
            if (cur == '\uffff') {
                throw (Throwable)new JSTypeDeserializationException(null, 1, null);
            }
            builder.append(cur);
            cur = inputStream.next();
        }
        inputStream.next();
        String string = builder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.toString()");
        return string;
    }

    @JvmStatic
    public static final void writeString(@NotNull String value, @NotNull StringBuilder builder) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        builder.append(value).append('\u001e');
    }

    @JvmStatic
    @NotNull
    public static final Segment readSegment(@NotNull CharacterIterator inputStream) {
        Intrinsics.checkParameterIsNotNull((Object)inputStream, (String)"inputStream");
        int startOffset = INSTANCE.readInt(inputStream);
        int endOffset = INSTANCE.readInt(inputStream);
        return (Segment)new TextRange(startOffset, endOffset);
    }

    @JvmStatic
    public static final void writeSegment(@NotNull Segment value, @NotNull StringBuilder builder) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        INSTANCE.writeInt(value.getStartOffset(), builder);
        INSTANCE.writeInt(value.getEndOffset(), builder);
    }

    private final int readInt(CharacterIterator inputStream) {
        char cur = inputStream.current();
        StringBuilder builder = new StringBuilder();
        while (cur != '\u001e') {
            if (cur == '\uffff' || !Character.isDigit(cur)) {
                throw (Throwable)new JSTypeDeserializationException(null, 1, null);
            }
            builder.append(cur);
            cur = inputStream.next();
        }
        inputStream.next();
        return Integer.parseInt(builder.toString());
    }

    private final void writeInt(int value, StringBuilder builder) {
        builder.append(value);
        builder.append('\u001e');
    }

    private final <T> JSTypeStreamSerializer<List<T>> createListSerializer(JSTypeStreamSerializer<T> elementSerializer) {
        return new JSTypeStreamSerializer<List<? extends T>>(elementSerializer){
            final /* synthetic */ JSTypeStreamSerializer $elementSerializer;

            @NotNull
            public List<T> read(@NotNull JSTypeSource typeSource, @NotNull CharacterIterator inputStream) {
                char separator;
                Intrinsics.checkParameterIsNotNull((Object)typeSource, (String)"typeSource");
                Intrinsics.checkParameterIsNotNull((Object)inputStream, (String)"inputStream");
                if (inputStream.current() == '\u001e') {
                    inputStream.next();
                    return CollectionsKt.emptyList();
                }
                List result2 = ContainerUtil.newSmartList();
                do {
                    T element = this.$elementSerializer.read(typeSource, inputStream);
                    result2.add(element);
                    separator = inputStream.current();
                    if (separator != '\u001f' && separator != '\u001e') {
                        throw (Throwable)new JSTypeDeserializationException("expected separator");
                    }
                    inputStream.next();
                } while (separator != '\u001e');
                List list = result2;
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"result");
                return list;
            }

            public void write(@NotNull List<? extends T> value, @NotNull StringBuilder outputStream) {
                Intrinsics.checkParameterIsNotNull(value, (String)"value");
                Intrinsics.checkParameterIsNotNull((Object)outputStream, (String)"outputStream");
                if (value.isEmpty()) {
                    outputStream.append('\u001e');
                    return;
                }
                boolean isFirst = true;
                for (T t : value) {
                    if (!isFirst) {
                        outputStream.append('\u001f');
                    }
                    this.$elementSerializer.write(t, outputStream);
                    isFirst = false;
                }
                outputStream.append('\u001e');
            }
            {
                this.$elementSerializer = $captured_local_variable$0;
            }
        };
    }

    private JSTypeSerializer() {
    }

    static {
        String id$iv;
        JSTypeSerializer this_$iv;
        JSTypeSerializer jSTypeSerializer;
        INSTANCE = jSTypeSerializer = new JSTypeSerializer();
        JS_TYPE_CONSTRUCTORS = new HashMap();
        JS_TYPE_IDS = new HashMap();
        TYPE_SERIALIZER = new JSTypeStreamSerializer<JSType>(){

            @NotNull
            public JSType read(@NotNull JSTypeSource typeSource, @NotNull CharacterIterator inputStream) {
                Intrinsics.checkParameterIsNotNull((Object)typeSource, (String)"typeSource");
                Intrinsics.checkParameterIsNotNull((Object)inputStream, (String)"inputStream");
                JSType type = JSTypeSerializer.NULLABLE_TYPE_SERIALIZER.read(typeSource, inputStream);
                if (type == null) {
                    Logger.getInstance(JSTypeSerializer.class).error("null type read");
                    type = JSAnyType.get(typeSource);
                }
                return type;
            }

            public void write(@NotNull JSType value, @NotNull StringBuilder outputStream) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                Intrinsics.checkParameterIsNotNull((Object)outputStream, (String)"outputStream");
                JSTypeSerializer.NULLABLE_TYPE_SERIALIZER.write(value, outputStream);
            }
        };
        NULLABLE_TYPE_SERIALIZER = new JSTypeStreamSerializer<JSType>(){

            @Nullable
            public JSType read(@NotNull JSTypeSource typeSource, @NotNull CharacterIterator inputStream) {
                Intrinsics.checkParameterIsNotNull((Object)typeSource, (String)"typeSource");
                Intrinsics.checkParameterIsNotNull((Object)inputStream, (String)"inputStream");
                if (inputStream.current() != '\u001d') {
                    throw (Throwable)new JSTypeDeserializationException(null, 1, null);
                }
                inputStream.next();
                if (inputStream.current() == '\u001e') {
                    inputStream.next();
                    return null;
                }
                String jsTypeId = JSTypeSerializer.readString(inputStream);
                Function2 function2 = (Function2)JSTypeSerializer.access$getJS_TYPE_CONSTRUCTORS$p(JSTypeSerializer.INSTANCE).get(jsTypeId);
                if (function2 == null) {
                    throw (Throwable)new JSTypeDeserializationException(null, 1, null);
                }
                Function2 constructor = function2;
                return (JSType)constructor.invoke((Object)typeSource, (Object)inputStream);
            }

            public void write(@Nullable JSType value, @NotNull StringBuilder outputStream) {
                Intrinsics.checkParameterIsNotNull((Object)outputStream, (String)"outputStream");
                outputStream.append('\u001d');
                if (value == null) {
                    outputStream.append('\u001e');
                    return;
                }
                String typeId = (String)JSTypeSerializer.access$getJS_TYPE_IDS$p(JSTypeSerializer.INSTANCE).get(value.getClass());
                if (typeId == null) {
                    Logger.getInstance(JSTypeSerializer.class).error("No serializer found for class " + value.getClass());
                    typeId = "*";
                }
                JSTypeSerializer.writeString(typeId, outputStream);
                value.serialize(outputStream);
            }
        };
        TYPE_MEMBER_SERIALIZER = new JSTypeStreamSerializer<JSRecordType.TypeMember>(){

            @NotNull
            public JSRecordType.TypeMember read(@NotNull JSTypeSource typeSource, @NotNull CharacterIterator inputStream) {
                Intrinsics.checkParameterIsNotNull((Object)typeSource, (String)"typeSource");
                Intrinsics.checkParameterIsNotNull((Object)inputStream, (String)"inputStream");
                char cur = inputStream.current();
                inputStream.next();
                switch (cur) {
                    case 'p': {
                        boolean optional;
                        String name = JSTypeSerializer.readString(inputStream);
                        boolean bl = optional = inputStream.current() == '?';
                        if (optional) {
                            inputStream.next();
                        }
                        JSType type = JSTypeSerializer.NULLABLE_TYPE_SERIALIZER.read(typeSource, inputStream);
                        return (JSRecordType.TypeMember)new JSRecordTypeImpl.PropertySignatureImpl(name, type, optional);
                    }
                    case 'c': {
                        return (JSRecordType.TypeMember)JSTypeSerializer.CALL_SIGNATURE_SERIALIZER.read(typeSource, inputStream);
                    }
                    case 'i': {
                        return (JSRecordType.TypeMember)JSTypeSerializer.INDEX_SIGNATURE_SERIALIZER.read(typeSource, inputStream);
                    }
                }
                throw (Throwable)new JSTypeDeserializationException(null, 1, null);
            }

            public void write(@NotNull JSRecordType.TypeMember value, @NotNull StringBuilder outputStream) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                Intrinsics.checkParameterIsNotNull((Object)outputStream, (String)"outputStream");
                JSRecordType.TypeMember typeMember = value;
                if (typeMember instanceof JSRecordType.PropertySignature) {
                    String fixedName;
                    outputStream.append('p');
                    String name = ((JSRecordType.PropertySignature)value).getMemberName();
                    String string = fixedName = JSSymbolUtil.handleSpecialPropertyNames(name, '\'');
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fixedName");
                    JSTypeSerializer.writeString(string, outputStream);
                    if (((JSRecordType.PropertySignature)value).isOptional()) {
                        outputStream.append('?');
                    }
                    JSTypeSerializer.NULLABLE_TYPE_SERIALIZER.write(((JSRecordType.PropertySignature)value).getType(), outputStream);
                } else if (typeMember instanceof JSRecordType.CallSignature) {
                    outputStream.append('c');
                    JSTypeSerializer.CALL_SIGNATURE_SERIALIZER.write((JSRecordType.CallSignature)value, outputStream);
                } else if (typeMember instanceof JSRecordType.IndexSignature) {
                    outputStream.append('i');
                    JSTypeSerializer.INDEX_SIGNATURE_SERIALIZER.write((JSRecordType.IndexSignature)value, outputStream);
                } else {
                    throw (Throwable)new IllegalArgumentException("Unknown TypeMember " + value.getClass());
                }
            }
        };
        INDEX_SIGNATURE_SERIALIZER = new JSTypeStreamSerializer<JSRecordType.IndexSignature>(){

            @NotNull
            public JSRecordType.IndexSignature read(@NotNull JSTypeSource typeSource, @NotNull CharacterIterator inputStream) {
                Intrinsics.checkParameterIsNotNull((Object)typeSource, (String)"typeSource");
                Intrinsics.checkParameterIsNotNull((Object)inputStream, (String)"inputStream");
                JSType typeParameter = JSTypeSerializer.NULLABLE_TYPE_SERIALIZER.read(typeSource, inputStream);
                JSType typeReturn = JSTypeSerializer.NULLABLE_TYPE_SERIALIZER.read(typeSource, inputStream);
                return new JSRecordTypeImpl.IndexSignatureImpl(typeParameter, typeReturn, JSRecordMemberSourceFactory.createEmptySource());
            }

            public void write(@NotNull JSRecordType.IndexSignature value, @NotNull StringBuilder outputStream) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                Intrinsics.checkParameterIsNotNull((Object)outputStream, (String)"outputStream");
                JSTypeSerializer.NULLABLE_TYPE_SERIALIZER.write(value.getMemberParameterType(), outputStream);
                JSTypeSerializer.NULLABLE_TYPE_SERIALIZER.write(value.getMemberType(), outputStream);
            }
        };
        CALL_SIGNATURE_SERIALIZER = new JSTypeStreamSerializer<JSRecordType.CallSignature>(){

            @NotNull
            public JSRecordType.CallSignature read(@NotNull JSTypeSource typeSource, @NotNull CharacterIterator inputStream) {
                JSFunctionType jSFunctionType;
                JSType jSType;
                Intrinsics.checkParameterIsNotNull((Object)typeSource, (String)"typeSource");
                Intrinsics.checkParameterIsNotNull((Object)inputStream, (String)"inputStream");
                boolean isNew = JSTypeSerializer.readBoolean(inputStream);
                JSType type = JSTypeSerializer.TYPE_SERIALIZER.read(typeSource, inputStream);
                if (!(type instanceof JSFunctionType)) {
                    Logger logger = Logger.getInstance(JSTypeSerializer.class);
                    Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
                    logger.error("function type expected");
                }
                if (!((jSType = type) instanceof JSFunctionType)) {
                    jSType = null;
                }
                if ((jSFunctionType = (JSFunctionType)jSType) == null) {
                    jSFunctionType = new JSFunctionTypeImpl(typeSource, CollectionsKt.emptyList(), null);
                }
                JSFunctionType functionType = jSFunctionType;
                return new JSRecordTypeImpl.CallSignatureImpl(isNew, functionType);
            }

            public void write(@NotNull JSRecordType.CallSignature value, @NotNull StringBuilder outputStream) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                Intrinsics.checkParameterIsNotNull((Object)outputStream, (String)"outputStream");
                JSTypeSerializer.writeBoolean(value.hasNew(), outputStream);
                JSFunctionType jSFunctionType = value.getFunctionType();
                Intrinsics.checkExpressionValueIsNotNull((Object)jSFunctionType, (String)"value.functionType");
                JSTypeSerializer.TYPE_SERIALIZER.write((JSType)jSFunctionType, outputStream);
            }
        };
        PARAMETER_TYPE_DECORATOR_SERIALIZER = new JSTypeStreamSerializer<JSParameterTypeDecorator>(){

            @NotNull
            public JSParameterTypeDecorator read(@NotNull JSTypeSource typeSource, @NotNull CharacterIterator inputStream) {
                Intrinsics.checkParameterIsNotNull((Object)typeSource, (String)"typeSource");
                Intrinsics.checkParameterIsNotNull((Object)inputStream, (String)"inputStream");
                boolean isOptional = JSTypeSerializer.readBoolean(inputStream);
                boolean isRest = JSTypeSerializer.readBoolean(inputStream);
                JSType jsType = JSTypeSerializer.NULLABLE_TYPE_SERIALIZER.read(typeSource, inputStream);
                return new JSParameterTypeDecoratorImpl(jsType, isOptional, isRest, true);
            }

            public void write(@NotNull JSParameterTypeDecorator value, @NotNull StringBuilder outputStream) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                Intrinsics.checkParameterIsNotNull((Object)outputStream, (String)"outputStream");
                JSTypeSerializer.writeBoolean(value.isOptional(), outputStream);
                JSTypeSerializer.writeBoolean(value.isRest(), outputStream);
                JSTypeSerializer.NULLABLE_TYPE_SERIALIZER.write(value.getType(), outputStream);
            }
        };
        JSTypeSerializer jSTypeSerializer2 = jSTypeSerializer;
        String string = "*";
        Function2 serializer$iv = 1.INSTANCE;
        this_$iv.registerJSTypeClass(id$iv, JSAnyType.class, serializer$iv);
        this_$iv = jSTypeSerializer;
        id$iv = "?";
        serializer$iv = 2.INSTANCE;
        this_$iv.registerJSTypeClass(id$iv, JSUnknownType.class, serializer$iv);
        this_$iv = jSTypeSerializer;
        id$iv = "t";
        serializer$iv = 3.INSTANCE;
        this_$iv.registerJSTypeClass(id$iv, JSTypeImpl.class, serializer$iv);
        this_$iv = jSTypeSerializer;
        id$iv = "bool";
        serializer$iv = 4.INSTANCE;
        this_$iv.registerJSTypeClass(id$iv, JSBooleanType.class, serializer$iv);
        this_$iv = jSTypeSerializer;
        id$iv = "int";
        serializer$iv = 5.INSTANCE;
        this_$iv.registerJSTypeClass(id$iv, JSIntType.class, serializer$iv);
        this_$iv = jSTypeSerializer;
        id$iv = "null";
        serializer$iv = 6.INSTANCE;
        this_$iv.registerJSTypeClass(id$iv, JSNullType.class, serializer$iv);
        this_$iv = jSTypeSerializer;
        id$iv = "num";
        serializer$iv = 7.INSTANCE;
        this_$iv.registerJSTypeClass(id$iv, JSNumberType.class, serializer$iv);
        this_$iv = jSTypeSerializer;
        id$iv = "obj";
        serializer$iv = 8.INSTANCE;
        this_$iv.registerJSTypeClass(id$iv, JSObjectType.class, serializer$iv);
        this_$iv = jSTypeSerializer;
        id$iv = "parr";
        serializer$iv = 9.INSTANCE;
        this_$iv.registerJSTypeClass(id$iv, JSPrimitiveArrayType.class, serializer$iv);
        this_$iv = jSTypeSerializer;
        id$iv = "pfun";
        serializer$iv = 10.INSTANCE;
        this_$iv.registerJSTypeClass(id$iv, JSPrimitiveFunctionType.class, serializer$iv);
        this_$iv = jSTypeSerializer;
        id$iv = "str";
        serializer$iv = 11.INSTANCE;
        this_$iv.registerJSTypeClass(id$iv, JSStringType.class, serializer$iv);
        this_$iv = jSTypeSerializer;
        id$iv = "sym";
        serializer$iv = 12.INSTANCE;
        this_$iv.registerJSTypeClass(id$iv, JSSymbolType.class, serializer$iv);
        this_$iv = jSTypeSerializer;
        id$iv = "uint";
        serializer$iv = 13.INSTANCE;
        this_$iv.registerJSTypeClass(id$iv, JSUintType.class, serializer$iv);
        this_$iv = jSTypeSerializer;
        id$iv = "undef";
        serializer$iv = 14.INSTANCE;
        this_$iv.registerJSTypeClass(id$iv, JSUndefinedType.class, serializer$iv);
        this_$iv = jSTypeSerializer;
        id$iv = "void";
        serializer$iv = 15.INSTANCE;
        this_$iv.registerJSTypeClass(id$iv, JSVoidType.class, serializer$iv);
        this_$iv = jSTypeSerializer;
        id$iv = "appcall";
        serializer$iv = 16.INSTANCE;
        this_$iv.registerJSTypeClass(id$iv, JSApplyCallType.class, serializer$iv);
        this_$iv = jSTypeSerializer;
        id$iv = "appnew";
        serializer$iv = 17.INSTANCE;
        this_$iv.registerJSTypeClass(id$iv, JSApplyNewType.class, serializer$iv);
        this_$iv = jSTypeSerializer;
        id$iv = "arr";
        serializer$iv = 18.INSTANCE;
        this_$iv.registerJSTypeClass(id$iv, JSArrayTypeImpl.class, serializer$iv);
        this_$iv = jSTypeSerializer;
        id$iv = "blit";
        serializer$iv = 19.INSTANCE;
        this_$iv.registerJSTypeClass(id$iv, JSBooleanLiteralTypeImpl.class, serializer$iv);
        this_$iv = jSTypeSerializer;
        id$iv = "comp";
        serializer$iv = 20.INSTANCE;
        this_$iv.registerJSTypeClass(id$iv, JSCompositeTypeImpl.class, serializer$iv);
        this_$iv = jSTypeSerializer;
        id$iv = "inter";
        serializer$iv = 21.INSTANCE;
        this_$iv.registerJSTypeClass(id$iv, JSIntersectionTypeImpl.class, serializer$iv);
        this_$iv = jSTypeSerializer;
        id$iv = "dec";
        serializer$iv = 22.INSTANCE;
        this_$iv.registerJSTypeClass(id$iv, JSDecoratedTypeImpl.class, serializer$iv);
        this_$iv = jSTypeSerializer;
        id$iv = "dest";
        serializer$iv = 23.INSTANCE;
        this_$iv.registerJSTypeClass(id$iv, JSDestructuringTypeImpl.class, serializer$iv);
        this_$iv = jSTypeSerializer;
        id$iv = "frec";
        serializer$iv = 24.INSTANCE;
        this_$iv.registerJSTypeClass(id$iv, JSFreshObjectLiteralTypeImpl.class, serializer$iv);
        this_$iv = jSTypeSerializer;
        id$iv = "fun";
        serializer$iv = 25.INSTANCE;
        this_$iv.registerJSTypeClass(id$iv, JSFunctionTypeImpl.class, serializer$iv);
        this_$iv = jSTypeSerializer;
        id$iv = "gpam";
        serializer$iv = 26.INSTANCE;
        this_$iv.registerJSTypeClass(id$iv, JSGenericParameterImpl.class, serializer$iv);
        this_$iv = jSTypeSerializer;
        id$iv = "gtype";
        serializer$iv = 27.INSTANCE;
        this_$iv.registerJSTypeClass(id$iv, JSGenericTypeImpl.class, serializer$iv);
        this_$iv = jSTypeSerializer;
        id$iv = "iter";
        serializer$iv = 28.INSTANCE;
        this_$iv.registerJSTypeClass(id$iv, JSIterableComponentTypeImpl.class, serializer$iv);
        this_$iv = jSTypeSerializer;
        id$iv = "loc";
        serializer$iv = 29.INSTANCE;
        this_$iv.registerJSTypeClass(id$iv, JSLocalNamedType.class, serializer$iv);
        this_$iv = jSTypeSerializer;
        id$iv = "mix";
        serializer$iv = 30.INSTANCE;
        this_$iv.registerJSTypeClass(id$iv, JSMixinTypeImpl.class, serializer$iv);
        this_$iv = jSTypeSerializer;
        id$iv = "numlit";
        serializer$iv = 31.INSTANCE;
        this_$iv.registerJSTypeClass(id$iv, JSNumberLiteralTypeImpl.class, serializer$iv);
        this_$iv = jSTypeSerializer;
        id$iv = "rec";
        serializer$iv = 32.INSTANCE;
        this_$iv.registerJSTypeClass(id$iv, JSRecordTypeImpl.class, serializer$iv);
        this_$iv = jSTypeSerializer;
        id$iv = "ref";
        serializer$iv = 33.INSTANCE;
        this_$iv.registerJSTypeClass(id$iv, JSReferenceType.class, serializer$iv);
        this_$iv = jSTypeSerializer;
        id$iv = "req";
        serializer$iv = 34.INSTANCE;
        this_$iv.registerJSTypeClass(id$iv, JSRequireCallExpressionType.class, serializer$iv);
        this_$iv = jSTypeSerializer;
        id$iv = "srec";
        serializer$iv = 35.INSTANCE;
        this_$iv.registerJSTypeClass(id$iv, JSSimpleRecordTypeImpl.class, serializer$iv);
        this_$iv = jSTypeSerializer;
        id$iv = "strlit";
        serializer$iv = 36.INSTANCE;
        this_$iv.registerJSTypeClass(id$iv, JSStringLiteralTypeImpl.class, serializer$iv);
        this_$iv = jSTypeSerializer;
        id$iv = "tup";
        serializer$iv = 37.INSTANCE;
        this_$iv.registerJSTypeClass(id$iv, JSTupleTypeImpl.class, serializer$iv);
        this_$iv = jSTypeSerializer;
        id$iv = "typeof";
        serializer$iv = 38.INSTANCE;
        this_$iv.registerJSTypeClass(id$iv, JSTypeofTypeImpl.class, serializer$iv);
        this_$iv = jSTypeSerializer;
        id$iv = "usym";
        serializer$iv = 39.INSTANCE;
        this_$iv.registerJSTypeClass(id$iv, JSUniqueSymbolTypeImpl.class, serializer$iv);
        this_$iv = jSTypeSerializer;
        id$iv = "topl";
        serializer$iv = 40.INSTANCE;
        this_$iv.registerJSTypeClass(id$iv, JSTopLevelNamespace.class, serializer$iv);
        TYPE_MEMBERS_SERIALIZER = jSTypeSerializer.createListSerializer(TYPE_MEMBER_SERIALIZER);
        TYPES_SERIALIZER = jSTypeSerializer.createListSerializer(NULLABLE_TYPE_SERIALIZER);
        PARAMETER_LIST = jSTypeSerializer.createListSerializer(PARAMETER_TYPE_DECORATOR_SERIALIZER);
    }

    @NotNull
    public static final /* synthetic */ HashMap access$getJS_TYPE_CONSTRUCTORS$p(JSTypeSerializer $this) {
        JSTypeSerializer jSTypeSerializer = $this;
        return JS_TYPE_CONSTRUCTORS;
    }

    @NotNull
    public static final /* synthetic */ HashMap access$getJS_TYPE_IDS$p(JSTypeSerializer $this) {
        JSTypeSerializer jSTypeSerializer = $this;
        return JS_TYPE_IDS;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002J\u001d\u0010\u0003\u001a\u00028\u00002\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a2\u0006\u0002\u0010\bJ!\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u00002\n\u0010\f\u001a\u00060\rj\u0002`\u000eH&\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/lang/javascript/psi/types/JSTypeSerializer$JSTypeStreamSerializer;", "T", "", "read", "typeSource", "Lcom/intellij/lang/javascript/psi/types/JSTypeSource;", "inputStream", "Ljava/text/CharacterIterator;", "(Lcom/intellij/lang/javascript/psi/types/JSTypeSource;Ljava/text/CharacterIterator;)Ljava/lang/Object;", "write", "", "value", "outputStream", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "(Ljava/lang/Object;Ljava/lang/StringBuilder;)V", "intellij.javascript.psi.impl"})
    public static interface JSTypeStreamSerializer<T> {
        public T read(@NotNull JSTypeSource var1, @NotNull CharacterIterator var2);

        public void write(T var1, @NotNull StringBuilder var2);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0011\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/lang/javascript/psi/types/JSTypeSerializer$JSTypeDeserializationException;", "Ljava/lang/IllegalArgumentException;", "Lkotlin/IllegalArgumentException;", "message", "", "(Ljava/lang/String;)V", "intellij.javascript.psi.impl"})
    public static final class JSTypeDeserializationException
    extends IllegalArgumentException {
        public JSTypeDeserializationException(@Nullable String message) {
            super(message);
        }

        public /* synthetic */ JSTypeDeserializationException(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            this(string);
        }

        public JSTypeDeserializationException() {
            this(null, 1, null);
        }
    }
}

