/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSRecursiveTypeTransformer;
import com.intellij.lang.javascript.psi.JSResolvedTypeId;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSTypeHelper;
import com.intellij.lang.javascript.psi.types.JSExoticStringLiteralType;
import com.intellij.lang.javascript.psi.types.JSFreshObjectLiteralType;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSPrimitiveLiteralType;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeUtil;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeComparingCache;
import com.intellij.lang.javascript.psi.types.JSTypeComparingCacheService;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.settings.JSSymbolPresentationProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSTypeBaseImpl
extends UserDataHolderBase
implements JSType {
    public static final Key<Boolean> CALL_ENV_KEY = Key.create((String)"js.type.is.call.env");
    private static final Key<ParameterizedCachedValue<JSType, Supplier<JSType>>> RECORD_TYPE_CACHE = Key.create((String)"js.record.type.cache.base");
    private static final Key<ParameterizedCachedValue<Integer, JSTypeBaseImpl>> TYPE_ID_CACHE = Key.create((String)"js.type.base.type.id");
    private static boolean ASSERT_ON_RECORD_TYPE_USAGE = false;
    private static final ParameterizedCachedValueProvider<JSType, Supplier<JSType>> LOCAL_TYPE_CACHE_VALUE_PROVIDER = new ParameterizedCachedValueProvider<JSType, Supplier<JSType>>(){

        @NotNull
        public CachedValueProvider.Result<JSType> compute(@NotNull Supplier<JSType> param) {
            if (param == null) {
                1.$$$reportNull$$$0(0);
            }
            CachedValueProvider.Result result2 = CachedValueProvider.Result.create((Object)param.get(), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
            if (result2 == null) {
                1.$$$reportNull$$$0(1);
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "param";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl$1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "compute";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "compute";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    private static final ParameterizedCachedValueProvider<Integer, JSTypeBaseImpl> TYPE_ID_PROVIDER = new ParameterizedCachedValueProvider<Integer, JSTypeBaseImpl>(){

        @NotNull
        public CachedValueProvider.Result<Integer> compute(@NotNull JSTypeBaseImpl param) {
            if (param == null) {
                2.$$$reportNull$$$0(0);
            }
            CachedValueProvider.Result result2 = CachedValueProvider.Result.create((Object)param.resolvedHashCodeImpl(), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
            if (result2 == null) {
                2.$$$reportNull$$$0(1);
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "param";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl$2";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl$2";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "compute";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "compute";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    @NotNull
    private final JSResolvedTypeId myResolvedKey;
    @NotNull
    private final JSTypeSource mySource;

    public static void assertOnRecordTypeUsage(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(0);
        }
        ASSERT_ON_RECORD_TYPE_USAGE = true;
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                ASSERT_ON_RECORD_TYPE_USAGE = false;
            }
        });
    }

    @NotNull
    public final JSType getLocalCachedType(@NotNull Supplier<JSType> factory, @NotNull Key<ParameterizedCachedValue<JSType, Supplier<JSType>>> cacheKey) {
        JSTypeSource source;
        PsiElement element;
        if (factory == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(1);
        }
        if (cacheKey == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(2);
        }
        if ((element = (source = this.getSource()).getSourceElement()) == null || !element.isValid()) {
            JSType jSType = factory.get();
            if (jSType == null) {
                JSTypeBaseImpl.$$$reportNull$$$0(3);
            }
            return jSType;
        }
        JSType jSType = (JSType)CachedValuesManager.getManager((Project)element.getProject()).getParameterizedCachedValue((UserDataHolder)this, cacheKey, LOCAL_TYPE_CACHE_VALUE_PROVIDER, false, factory);
        if (jSType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(4);
        }
        return jSType;
    }

    protected JSTypeBaseImpl(@NotNull JSTypeSource source) {
        if (source == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(5);
        }
        this.mySource = source;
        this.myResolvedKey = new JSResolvedTypeIdImpl();
    }

    @NotNull
    public String getTypeText() {
        String string = this.getTypeText(JSType.TypeTextFormat.SIMPLE);
        if (string == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getResolvedTypeText() {
        String string = this.getTypeText(JSType.TypeTextFormat.RESOLVED);
        if (string == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public JSTypeSource getSource() {
        JSTypeSource jSTypeSource = this.mySource;
        if (jSTypeSource == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(8);
        }
        return jSTypeSource;
    }

    public final boolean isDirectlyAssignableType(@Nullable JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType instanceof JSExoticStringLiteralType) {
            elementType = ((JSExoticStringLiteralType)((Object)elementType)).asSimpleLiteralType();
        }
        if (this.isDirectAssignableTypeSimple(elementType, processingContext)) {
            return true;
        }
        ProgressManager.checkCanceled();
        if (processingContext == null) {
            processingContext = new ProcessingContext();
        }
        JSResolvedTypeId thisId = this.getResolvedTypeId();
        JSResolvedTypeId rTypeId = elementType.getResolvedTypeId();
        ProcessingContext finalProcessingContext = processingContext;
        JSPrimitiveLiteralType<String> finalElementType = elementType;
        return JSRecursiveTypeUtil.computeWithRecursiveTypes(thisId, rTypeId, JSRecursiveTypeUtil.ASSIGNABLE_KEY, processingContext, (Getter<Boolean>)((Getter)() -> {
            JSTypeComparingCache cache = (JSTypeComparingCache)finalProcessingContext.get(JSTypeComparingCache.TYPE_COMPARATOR);
            if (cache != null) {
                JSTypeCastUtil.AssignableResult assignableResult = cache.areAssignableTypes(this, finalElementType, finalProcessingContext);
                if (assignableResult.isStrict()) {
                    if (ApplicationManager.getApplication().isUnitTestMode()) {
                        this.checkCachedValue(finalElementType, finalProcessingContext, assignableResult);
                    }
                    return assignableResult.isAssignable();
                }
                if (assignableResult != JSTypeCastUtil.AssignableResult.NO_CACHE) {
                    boolean result2 = this.calculateAssignabilityWithoutCache(finalElementType, finalProcessingContext);
                    cache.putAssignableTypes(this, finalElementType, finalProcessingContext, JSTypeCastUtil.toStrictAssignable(result2));
                    return result2;
                }
            }
            return this.calculateAssignabilityWithoutCache(finalElementType, finalProcessingContext);
        }));
    }

    @Contract(value="null,_-> true")
    public boolean isDirectAssignableTypeSimple(@Nullable JSType elementType, @Nullable ProcessingContext processingContext) {
        boolean useResolveInIsEquivalent;
        if (elementType == this || elementType == null) {
            return true;
        }
        boolean bl = useResolveInIsEquivalent = !this.isEcma() && !JSGenericTypesEvaluator.isGenericProcessingInProgress(processingContext);
        return this.isEquivalentTo(elementType, processingContext, useResolveInIsEquivalent) || this instanceof JSExoticStringLiteralType && ((JSExoticStringLiteralType)((Object)this)).asSimpleLiteralType().isEquivalentTo(elementType, processingContext, useResolveInIsEquivalent) || JSTypeCastUtil.isAlwaysAssignableType(elementType, this.isJavaScript() && elementType.isJavaScript());
    }

    private boolean calculateAssignabilityWithoutCache(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        JSFreshObjectLiteralType freshType;
        if (elementType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(9);
        }
        if (processingContext == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(10);
        }
        JSFreshObjectLiteralType jSFreshObjectLiteralType = freshType = elementType instanceof JSFreshObjectLiteralType ? (JSFreshObjectLiteralType)elementType : null;
        if (freshType != null) {
            elementType = ((JSFreshObjectLiteralType)elementType).removeFreshness();
        }
        return this.isDirectlyAssignableTypeImpl(elementType, processingContext) && (!this.isTypeScript() || freshType == null || JSTypeCastUtil.compareByExcessProperties(this, freshType));
    }

    private void checkCachedValue(@NotNull JSType elementType, @NotNull ProcessingContext processingContext, @NotNull JSTypeCastUtil.AssignableResult fromCache) {
        Key[] ids;
        if (elementType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(11);
        }
        if (processingContext == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(12);
        }
        if (fromCache == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(13);
        }
        ProcessingContext newContext = new ProcessingContext();
        for (Key id : ids = new Key[]{CALL_ENV_KEY, JSTypeComparingCache.SUBTYPING_CONTEXT, JSGenericTypesEvaluator.ourGenericArgumentsMapKey, JSGenericTypesEvaluator.ourSuspendGenericEvaluation, JSGenericTypesEvaluator.ourHadContravariantGenerics, JSTypeCastUtil.SKIP_NULL_CHECKS}) {
            Object value = processingContext.get(id);
            if (value == null) continue;
            newContext.put((Object)id, value);
        }
        boolean isAssignable = this.isDirectlyAssignableTypeImpl(elementType, newContext);
        if (fromCache.isAssignable() != isAssignable) {
            String message = String.format("checkCachedValue failed. This: %s;\nElement: %s;\nFrom cache: %s;\nIsAssignable:%s", new Object[]{this.getTypeText(), elementType.getTypeText(), fromCache, isAssignable});
            Logger.getInstance(((Object)((Object)this)).getClass()).error(message);
        }
    }

    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(14);
        }
        return this.isDirectlyAssignableTypeCommon(elementType, processingContext).isAssignable();
    }

    @NotNull
    protected JSTypeCastUtil.AssignableResult isDirectlyAssignableTypeCommon(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(15);
        }
        JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.isDirectlyAssignableTypeCommon(this, elementType, processingContext);
        if (assignableResult == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(16);
        }
        return assignableResult;
    }

    public void accept(JSRecursiveTypeVisitor visitor) {
        visitor.visitJSTypeBaseImpl((JSType)this);
    }

    public void acceptChildren(JSRecursiveTypeVisitor visitor) {
    }

    @Nullable
    public PsiFile getScope() {
        return this.mySource.getScope();
    }

    @NotNull
    protected JSTypeHelper getTypeHelper() {
        JSLanguageDialect language = null;
        switch (this.getSource().getLanguage()) {
            case TS: {
                language = JavaScriptSupportLoader.TYPESCRIPT;
                break;
            }
            case AS: {
                language = JavaScriptSupportLoader.ECMA_SCRIPT_L4;
                break;
            }
            case JS: {
                language = JavascriptLanguage.INSTANCE;
            }
        }
        JSTypeHelper jSTypeHelper = JSDialectSpecificHandlersFactory.forLanguage(language).getTypeHelper();
        if (jSTypeHelper == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(17);
        }
        return jSTypeHelper;
    }

    @Nullable
    public JSClass resolveClass() {
        return null;
    }

    @NotNull
    public final JSType transformTypeHierarchy(@NotNull Function<JSType, JSType> transformation) {
        if (transformation == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(18);
        }
        ProgressManager.checkCanceled();
        if (transformation instanceof JSRecursiveTypeTransformer) {
            JSType jSType = this.transformTypeHierarchy((JSRecursiveTypeTransformer)transformation);
            if (jSType == null) {
                JSTypeBaseImpl.$$$reportNull$$$0(19);
            }
            return jSType;
        }
        JSType jSType = this.transformTypeOrCopyWithTransformation(transformation);
        if (jSType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(20);
        }
        return jSType;
    }

    @NotNull
    public final JSType transformTypeHierarchy(@NotNull JSRecursiveTypeTransformer transformation) {
        if (transformation == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(21);
        }
        JSType jSType = transformation.transformRecursive((JSType)this, () -> {
            if (transformation == null) {
                JSTypeBaseImpl.$$$reportNull$$$0(39);
            }
            return this.transformTypeOrCopyWithTransformation((Function<JSType, JSType>)transformation);
        });
        if (jSType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(22);
        }
        return jSType;
    }

    @NotNull
    private JSType transformTypeOrCopyWithTransformation(@NotNull Function<JSType, JSType> transformation) {
        JSType transformedType;
        if (transformation == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(23);
        }
        if (this != (transformedType = (JSType)transformation.fun((Object)this))) {
            JSType jSType = transformedType;
            if (jSType == null) {
                JSTypeBaseImpl.$$$reportNull$$$0(24);
            }
            return jSType;
        }
        JSType jSType = this.copyTypeHierarchy(transformation);
        if (jSType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(25);
        }
        return jSType;
    }

    @NotNull
    protected abstract JSType copyTypeHierarchy(@NotNull Function<JSType, JSType> var1);

    @NotNull
    public JSType substitute() {
        JSTypeBaseImpl jSTypeBaseImpl = this;
        if (jSTypeBaseImpl == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(26);
        }
        return jSTypeBaseImpl;
    }

    public final boolean isEquivalentTo(@Nullable JSType type, @Nullable ProcessingContext processingContext) {
        return this.isEquivalentTo(type, processingContext, true);
    }

    public final boolean isEquivalentTo(@Nullable JSType type, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        ProgressManager.checkCanceled();
        if (this == type) {
            return true;
        }
        if (type == null) {
            return false;
        }
        if (this.isEquivalentToImpl(type, processingContext, allowResolve)) {
            return true;
        }
        return this.isEquivalentCommon(type, processingContext, allowResolve);
    }

    protected boolean isEquivalentCommon(@Nullable JSType rOperand, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        if (rOperand instanceof JSGenericParameterImpl) {
            return rOperand.isEquivalentTo((JSType)this, processingContext, allowResolve);
        }
        return false;
    }

    @NotNull
    public final JSType copyWithStrict(boolean strict) {
        JSTypeSource source = this.getSource();
        if (source.isStrict() == strict) {
            JSTypeBaseImpl jSTypeBaseImpl = this;
            if (jSTypeBaseImpl == null) {
                JSTypeBaseImpl.$$$reportNull$$$0(27);
            }
            return jSTypeBaseImpl;
        }
        JSType jSType = this.copyWithNewSource(JSTypeSourceFactory.copyTypeSource(source, strict));
        if (jSType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(28);
        }
        return jSType;
    }

    @NotNull
    protected abstract JSType copyWithNewSource(@NotNull JSTypeSource var1);

    protected abstract boolean isEquivalentToImpl(@NotNull JSType var1, @Nullable ProcessingContext var2, boolean var3);

    @NotNull
    public final JSRecordType asRecordType() {
        if (ASSERT_ON_RECORD_TYPE_USAGE) {
            throw new AssertionError((Object)"Record type must be not used");
        }
        ProgressManager.checkCanceled();
        JSRecordType value = this.useCacheForRecordType() ? this.getLocalCachedType(this::asRecordTypeNoCache, RECORD_TYPE_CACHE) : this.asRecordTypeNoCache();
        JSRecordType jSRecordType = value instanceof JSRecordType ? value : JSTypeCastUtil.NO_RECORD_TYPE;
        if (jSRecordType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(29);
        }
        return jSRecordType;
    }

    protected boolean useCacheForRecordType() {
        return false;
    }

    @NotNull
    protected JSRecordType asRecordTypeNoCache() {
        if (this.isEcma()) {
            JSRecordType jSRecordType = JSTypeCastUtil.NO_RECORD_TYPE;
            if (jSRecordType == null) {
                JSTypeBaseImpl.$$$reportNull$$$0(30);
            }
            return jSRecordType;
        }
        JSRecordType jSRecordType = JSTypeComparingCacheService.buildRecordType(this);
        if (jSRecordType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(31);
        }
        return jSRecordType;
    }

    @Contract(value="!null,_ -> !null", pure=true)
    public static JSType replaceEmptySourceRecursive(@Nullable JSType type, @NotNull JSTypeSource newSource) {
        if (newSource == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(32);
        }
        return JSTypeBaseImpl.replaceSourceRecursive(type, newSource, (Condition<JSTypeSource>)((Condition)oldSource -> oldSource == JSTypeSource.EMPTY));
    }

    @Deprecated
    public static JSType replaceSourceRecursive(@Nullable JSType type, @NotNull JSTypeSource newSource) {
        if (newSource == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(33);
        }
        return JSTypeBaseImpl.replaceSourceRecursive(type, newSource, (Condition<JSTypeSource>)((Condition)oldSource -> {
            if (newSource == null) {
                JSTypeBaseImpl.$$$reportNull$$$0(38);
            }
            return oldSource != newSource;
        }));
    }

    private static JSType replaceSourceRecursive(@Nullable JSType type, final @NotNull JSTypeSource newSource, final @NotNull Condition<JSTypeSource> replaceCondition) {
        if (newSource == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(34);
        }
        if (replaceCondition == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(35);
        }
        if (type == null) {
            return null;
        }
        Function<JSType, JSType> function = new Function<JSType, JSType>(){

            public JSType fun(JSType currentType) {
                if (currentType instanceof JSTypeBaseImpl) {
                    if (!replaceCondition.value((Object)currentType.getSource())) {
                        return currentType;
                    }
                    JSType elementResult = ((JSTypeBaseImpl)currentType).copyWithNewSource(newSource);
                    if (elementResult == currentType) {
                        return elementResult;
                    }
                    return elementResult.transformTypeHierarchy((Function)this);
                }
                assert (false);
                return currentType;
            }
        };
        return type.transformTypeHierarchy((Function)function);
    }

    protected abstract int resolvedHashCodeImpl();

    protected boolean resolvedEquals(@Nullable JSType rType) {
        return this.isEquivalentTo(rType, null, true);
    }

    protected final int getSourceHashCode() {
        PsiElement element = this.getSource().getSourceElement();
        return element != null && element.isValid() ? element.hashCode() : ((Object)((Object)this)).hashCode();
    }

    public final int resolvedHashCode() {
        PsiElement element;
        if (this.useCacheForResolvedHashCode() && (element = this.getSource().getSourceElement()) != null && element.isValid()) {
            return (Integer)CachedValuesManager.getManager((Project)element.getProject()).getParameterizedCachedValue((UserDataHolder)this, TYPE_ID_CACHE, TYPE_ID_PROVIDER, false, (Object)this);
        }
        return this.resolvedHashCodeImpl();
    }

    protected boolean useCacheForResolvedHashCode() {
        return true;
    }

    @NotNull
    public JSResolvedTypeId getResolvedTypeId() {
        JSResolvedTypeId jSResolvedTypeId = this.myResolvedKey;
        if (jSResolvedTypeId == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(36);
        }
        return jSResolvedTypeId;
    }

    @NotNull
    protected String getTypeSeparator() {
        String string = JSSymbolPresentationProvider.getDefaultTypeSeparator(this.getSource().getSourceElement());
        if (string == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(37);
        }
        return string;
    }

    public String toString() {
        return this.getTypeText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 36: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 36: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheKey";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 9: 
            case 11: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromCache";
                break;
            }
            case 18: 
            case 21: 
            case 23: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformation";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSource";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replaceCondition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalCachedType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedTypeText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSource";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeHelper";
                break;
            }
            case 19: 
            case 20: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "transformTypeHierarchy";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "transformTypeOrCopyWithTransformation";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "substitute";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithStrict";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "asRecordType";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "asRecordTypeNoCache";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedTypeId";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSeparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "assertOnRecordTypeUsage";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLocalCachedType";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 36: 
            case 37: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "calculateAssignabilityWithoutCache";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkCachedValue";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 18: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "transformTypeHierarchy";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "transformTypeOrCopyWithTransformation";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "replaceEmptySourceRecursive";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "replaceSourceRecursive";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "lambda$replaceSourceRecursive$3";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "lambda$transformTypeHierarchy$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 36: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class JSResolvedTypeIdImpl
    implements JSResolvedTypeId {
        private JSResolvedTypeIdImpl() {
        }

        public int hashCode() {
            return JSTypeBaseImpl.this.resolvedHashCode();
        }

        @NotNull
        public JSType getOwnerType() {
            JSTypeBaseImpl jSTypeBaseImpl = JSTypeBaseImpl.this;
            if (jSTypeBaseImpl == null) {
                JSResolvedTypeIdImpl.$$$reportNull$$$0(0);
            }
            return jSTypeBaseImpl;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof JSResolvedTypeId) || obj.hashCode() != this.hashCode()) {
                return false;
            }
            return JSTypeBaseImpl.this.resolvedEquals(((JSResolvedTypeId)obj).getOwnerType());
        }

        public String toString() {
            return JSTypeBaseImpl.this.getTypeText();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl$JSResolvedTypeIdImpl", "getOwnerType"));
        }
    }
}

